/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ForeachController
extends GenericController
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String INPUTVAL = "ForeachController.inputVal";
    private static final String START_INDEX = "ForeachController.startIndex";
    private static final String END_INDEX = "ForeachController.endIndex";
    private static final String RETURNVAL = "ForeachController.returnVal";
    private static final String USE_SEPARATOR = "ForeachController.useSeparator";
    private static final String INDEX_DEFAULT_VALUE = "";
    private int loopCount = 0;
    private static final String DEFAULT_SEPARATOR = "_";

    public void setStartIndex(String startIndex) {
        this.setProperty(START_INDEX, startIndex, INDEX_DEFAULT_VALUE);
    }

    private int getStartIndex() {
        return this.getPropertyAsInt(START_INDEX, 0);
    }

    public String getStartIndexAsString() {
        return this.getPropertyAsString(START_INDEX, INDEX_DEFAULT_VALUE);
    }

    public void setEndIndex(String endIndex) {
        this.setProperty(END_INDEX, endIndex, INDEX_DEFAULT_VALUE);
    }

    private int getEndIndex() {
        return this.getPropertyAsInt(END_INDEX, Integer.MAX_VALUE);
    }

    public String getEndIndexAsString() {
        return this.getPropertyAsString(END_INDEX, INDEX_DEFAULT_VALUE);
    }

    public void setInputVal(String inputValue) {
        this.setProperty((JMeterProperty)new StringProperty(INPUTVAL, inputValue));
    }

    private String getInputVal() {
        this.getProperty(INPUTVAL).recoverRunningVersion(null);
        return this.getInputValString();
    }

    public String getInputValString() {
        return this.getPropertyAsString(INPUTVAL);
    }

    public void setReturnVal(String inputValue) {
        this.setProperty((JMeterProperty)new StringProperty(RETURNVAL, inputValue));
    }

    private String getReturnVal() {
        this.getProperty(RETURNVAL).recoverRunningVersion(null);
        return this.getReturnValString();
    }

    public String getReturnValString() {
        return this.getPropertyAsString(RETURNVAL);
    }

    private String getSeparator() {
        return this.getUseSeparator() ? DEFAULT_SEPARATOR : INDEX_DEFAULT_VALUE;
    }

    public void setUseSeparator(boolean b) {
        this.setProperty((JMeterProperty)new BooleanProperty(USE_SEPARATOR, b));
    }

    public boolean getUseSeparator() {
        return this.getPropertyAsBoolean(USE_SEPARATOR, true);
    }

    public boolean isDone() {
        if (this.loopCount >= this.getEndIndex()) {
            return true;
        }
        JMeterContext context = this.getThreadContext();
        StringBuilder builder = new StringBuilder(this.getInputVal().length() + this.getSeparator().length() + 3);
        String inputVariable = builder.append(this.getInputVal()).append(this.getSeparator()).append(Integer.toString(this.loopCount + 1)).toString();
        JMeterVariables variables = context.getVariables();
        Object currentVariable = variables.getObject(inputVariable);
        if (currentVariable != null) {
            variables.putObject(this.getReturnVal(), currentVariable);
            if (log.isDebugEnabled()) {
                log.debug("ForEach resultstring isDone=" + variables.get(this.getReturnVal()));
            }
            return false;
        }
        return super.isDone();
    }

    private boolean endOfArguments() {
        JMeterContext context = this.getThreadContext();
        String inputVariable = this.getInputVal() + this.getSeparator() + (this.loopCount + 1);
        if (context.getVariables().getObject(inputVariable) != null) {
            log.debug("ForEach resultstring eofArgs= false");
            return false;
        }
        log.debug("ForEach resultstring eofArgs= true");
        return true;
    }

    public Sampler next() {
        if (this.emptyList()) {
            this.reInitialize();
            this.resetLoopCount();
            return null;
        }
        return super.next();
    }

    private boolean emptyList() {
        JMeterContext context = this.getThreadContext();
        StringBuilder builder = new StringBuilder(this.getInputVal().length() + this.getSeparator().length() + 3);
        String inputVariable = builder.append(this.getInputVal()).append(this.getSeparator()).append(Integer.toString(this.loopCount + 1)).toString();
        if (context.getVariables().getObject(inputVariable) != null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("No entries found - null first entry: " + inputVariable);
        }
        return true;
    }

    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (this.endOfArguments() || this.loopCount >= this.getEndIndex()) {
            this.resetLoopCount();
            return null;
        }
        return this.next();
    }

    protected void incrementLoopCount() {
        ++this.loopCount;
    }

    protected void resetLoopCount() {
        this.loopCount = this.getStartIndex();
    }

    protected int getIterCount() {
        return this.loopCount + 1;
    }

    protected void reInitialize() {
        this.setFirst(true);
        this.resetCurrent();
        this.incrementLoopCount();
        this.recoverRunningVersion();
    }

    public void triggerEndOfLoop() {
        super.triggerEndOfLoop();
        this.resetLoopCount();
    }

    public void initialize() {
        super.initialize();
        this.loopCount = this.getStartIndex();
    }
}

