/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.TidyException;
import org.apache.jmeter.util.XPathUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XPathExtractor
extends AbstractScopedTestElement
implements PostProcessor,
Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    private static final String MATCH_NR = "matchNr";
    private static final String XPATH_QUERY = "XPathExtractor.xpathQuery";
    private static final String REFNAME = "XPathExtractor.refname";
    private static final String DEFAULT = "XPathExtractor.default";
    private static final String TOLERANT = "XPathExtractor.tolerant";
    private static final String NAMESPACE = "XPathExtractor.namespace";
    private static final String QUIET = "XPathExtractor.quiet";
    private static final String REPORT_ERRORS = "XPathExtractor.report_errors";
    private static final String SHOW_WARNINGS = "XPathExtractor.show_warnings";
    private static final String DOWNLOAD_DTDS = "XPathExtractor.download_dtds";
    private static final String WHITESPACE = "XPathExtractor.whitespace";
    private static final String VALIDATE = "XPathExtractor.validate";
    private static final String FRAGMENT = "XPathExtractor.fragment";

    private String concat(String s1, String s2) {
        return s1 + "_" + s2;
    }

    private String concat(String s1, int i) {
        return s1 + "_" + i;
    }

    public void process() {
        JMeterContext context = this.getThreadContext();
        SampleResult previousResult = context.getPreviousResult();
        if (previousResult == null) {
            return;
        }
        JMeterVariables vars = context.getVariables();
        String refName = this.getRefName();
        vars.put(refName, this.getDefaultValue());
        String matchNR = this.concat(refName, MATCH_NR);
        int prevCount = 0;
        try {
            prevCount = Integer.parseInt(vars.get(matchNR));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        vars.put(matchNR, "0");
        vars.remove(this.concat(refName, "1"));
        ArrayList<String> matches = new ArrayList<String>();
        try {
            if (this.isScopeVariable()) {
                String inputString = vars.get(this.getVariableName());
                if (inputString != null) {
                    if (inputString.length() > 0) {
                        Document d = this.parseResponse(inputString);
                        this.getValuesForXPath(d, this.getXPathQuery(), matches);
                    }
                } else {
                    log.warn("No variable '" + this.getVariableName() + "' found to process by XPathExtractor '" + this.getName() + "', skipping processing");
                }
            } else {
                List samples = this.getSampleList(previousResult);
                for (SampleResult res : samples) {
                    Document d = this.parseResponse(res.getResponseDataAsString());
                    this.getValuesForXPath(d, this.getXPathQuery(), matches);
                }
            }
            int matchCount = matches.size();
            vars.put(matchNR, String.valueOf(matchCount));
            if (matchCount > 0) {
                String value = (String)matches.get(0);
                if (value != null) {
                    vars.put(refName, value);
                }
                for (int i = 0; i < matchCount; ++i) {
                    value = (String)matches.get(i);
                    if (value == null) continue;
                    vars.put(this.concat(refName, i + 1), (String)matches.get(i));
                }
            }
            vars.remove(this.concat(refName, matchCount + 1));
            for (int i = matchCount + 2; i <= prevCount; ++i) {
                vars.remove(this.concat(refName, i));
            }
        }
        catch (IOException e) {
            String errorMessage = "IOException on (" + this.getXPathQuery() + ")";
            log.error(errorMessage, (Throwable)e);
            AssertionResult ass = new AssertionResult(this.getName());
            ass.setError(true);
            ass.setFailureMessage("IOException: " + e.getLocalizedMessage());
            previousResult.addAssertionResult(ass);
            previousResult.setSuccessful(false);
        }
        catch (ParserConfigurationException e) {
            String errrorMessage = "ParserConfigurationException while processing (" + this.getXPathQuery() + ")";
            log.error(errrorMessage, (Throwable)e);
            throw new JMeterError(errrorMessage, (Throwable)e);
        }
        catch (SAXException e) {
            log.warn("SAXException while processing (" + this.getXPathQuery() + ") " + e.getLocalizedMessage());
            this.addAssertionFailure(previousResult, e, false);
        }
        catch (TransformerException e) {
            log.warn("TransformerException while processing (" + this.getXPathQuery() + ") " + e.getLocalizedMessage());
            this.addAssertionFailure(previousResult, e, false);
        }
        catch (TidyException e) {
            this.addAssertionFailure(previousResult, e, true);
        }
    }

    private void addAssertionFailure(SampleResult previousResult, Throwable thrown, boolean setFailed) {
        AssertionResult ass = new AssertionResult(thrown.getClass().getSimpleName());
        ass.setFailure(true);
        ass.setFailureMessage(thrown.getLocalizedMessage() + "\nSee log file for further details.");
        previousResult.addAssertionResult(ass);
        if (setFailed) {
            previousResult.setSuccessful(false);
        }
    }

    public void setXPathQuery(String val) {
        this.setProperty(XPATH_QUERY, val);
    }

    public String getXPathQuery() {
        return this.getPropertyAsString(XPATH_QUERY);
    }

    public void setRefName(String refName) {
        this.setProperty(REFNAME, refName);
    }

    public String getRefName() {
        return this.getPropertyAsString(REFNAME);
    }

    public void setDefaultValue(String val) {
        this.setProperty(DEFAULT, val);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }

    public void setTolerant(boolean val) {
        this.setProperty((JMeterProperty)new BooleanProperty(TOLERANT, val));
    }

    public boolean isTolerant() {
        return this.getPropertyAsBoolean(TOLERANT);
    }

    public void setNameSpace(boolean val) {
        this.setProperty((JMeterProperty)new BooleanProperty(NAMESPACE, val));
    }

    public boolean useNameSpace() {
        return this.getPropertyAsBoolean(NAMESPACE);
    }

    public void setReportErrors(boolean val) {
        this.setProperty(REPORT_ERRORS, val, false);
    }

    public boolean reportErrors() {
        return this.getPropertyAsBoolean(REPORT_ERRORS, false);
    }

    public void setShowWarnings(boolean val) {
        this.setProperty(SHOW_WARNINGS, val, false);
    }

    public boolean showWarnings() {
        return this.getPropertyAsBoolean(SHOW_WARNINGS, false);
    }

    public void setQuiet(boolean val) {
        this.setProperty(QUIET, val, true);
    }

    public boolean isQuiet() {
        return this.getPropertyAsBoolean(QUIET, true);
    }

    public boolean getFragment() {
        return this.getPropertyAsBoolean(FRAGMENT, false);
    }

    public void setFragment(boolean selected) {
        this.setProperty(FRAGMENT, selected, false);
    }

    private Document parseResponse(String unicodeData) throws IOException, ParserConfigurationException, SAXException, TidyException {
        byte[] utf8data = unicodeData.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream in = new ByteArrayInputStream(utf8data);
        boolean isXML = JOrphanUtils.isXML((byte[])utf8data);
        return XPathUtil.makeDocument((InputStream)in, (boolean)false, (boolean)false, (boolean)this.useNameSpace(), (boolean)this.isTolerant(), (boolean)this.isQuiet(), (boolean)this.showWarnings(), (boolean)this.reportErrors(), (boolean)isXML, (boolean)this.isDownloadDTDs());
    }

    private void getValuesForXPath(Document d, String query, List<String> matchStrings) throws TransformerException {
        XPathUtil.putValuesForXPathInList((Document)d, (String)query, matchStrings, (boolean)this.getFragment());
    }

    public void setWhitespace(boolean selected) {
        this.setProperty(WHITESPACE, selected, false);
    }

    public boolean isWhitespace() {
        return this.getPropertyAsBoolean(WHITESPACE, false);
    }

    public void setValidating(boolean selected) {
        this.setProperty(VALIDATE, selected);
    }

    public boolean isValidating() {
        return this.getPropertyAsBoolean(VALIDATE, false);
    }

    public void setDownloadDTDs(boolean selected) {
        this.setProperty(DOWNLOAD_DTDS, selected, false);
    }

    public boolean isDownloadDTDs() {
        return this.getPropertyAsBoolean(DOWNLOAD_DTDS, false);
    }
}

