/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleMonitor;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SampleTimeout
extends AbstractTestElement
implements Serializable,
ThreadListener,
SampleMonitor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private static final String TIMEOUT = "InterruptTimer.timeout";
    private ScheduledFuture<?> future;
    private final transient ScheduledExecutorService execService;
    private final boolean debug = LOG.isDebugEnabled();

    private static ScheduledExecutorService getExecutorService() {
        return TPOOLHolder.EXEC_SERVICE;
    }

    public SampleTimeout() {
        this.execService = SampleTimeout.getExecutorService();
        if (this.debug) {
            LOG.debug(this.whoAmI("InterruptTimer()", (TestElement)this));
        }
    }

    public void setTimeout(String timeout) {
        this.setProperty(TIMEOUT, timeout);
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT);
    }

    public void sampleStarting(Sampler sampler) {
        if (this.debug) {
            LOG.debug(this.whoAmI("sampleStarting()", (TestElement)this));
        }
        this.createTask(sampler);
    }

    public void sampleEnded(Sampler sampler) {
        if (this.debug) {
            LOG.debug(this.whoAmI("sampleEnded()", (TestElement)this));
        }
        this.cancelTask();
    }

    private void createTask(final Sampler samp) {
        long timeout = this.getPropertyAsLong(TIMEOUT);
        if (timeout <= 0L) {
            return;
        }
        if (!(samp instanceof Interruptible)) {
            return;
        }
        final Interruptible sampler = (Interruptible)samp;
        Callable<Object> call = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                long start = System.nanoTime();
                boolean interrupted = sampler.interrupt();
                String elapsed = Double.toString((double)(System.nanoTime() - start) / 1.0E9) + " secs";
                if (interrupted) {
                    LOG.warn("Call Done interrupting " + SampleTimeout.this.getInfo((TestElement)samp) + " took " + elapsed);
                } else if (SampleTimeout.this.debug) {
                    LOG.debug("Call Didn't interrupt: " + SampleTimeout.this.getInfo((TestElement)samp) + " took " + elapsed);
                }
                return null;
            }
        };
        this.future = this.execService.schedule(call, timeout, TimeUnit.MILLISECONDS);
        if (this.debug) {
            LOG.debug("Scheduled timer: @" + System.identityHashCode(this.future) + " " + this.getInfo((TestElement)samp));
        }
    }

    public void threadStarted() {
        if (this.debug) {
            LOG.debug(this.whoAmI("threadStarted()", (TestElement)this));
        }
    }

    public void threadFinished() {
        if (this.debug) {
            LOG.debug(this.whoAmI("threadFinished()", (TestElement)this));
        }
        this.cancelTask();
    }

    public String toString() {
        return JMeterUtils.getResString((String)"sample_timeout_memo");
    }

    private String whoAmI(String id, TestElement o) {
        return id + " @" + System.identityHashCode(o) + " '" + o.getName() + "' " + (this.debug ? Thread.currentThread().getName() : "");
    }

    private String getInfo(TestElement o) {
        return this.whoAmI(o.getClass().getSimpleName(), o);
    }

    private void cancelTask() {
        if (this.future != null) {
            if (!this.future.isDone()) {
                boolean cancelled = this.future.cancel(false);
                if (this.debug) {
                    LOG.debug("Cancelled timer: @" + System.identityHashCode(this.future) + " with result " + cancelled);
                }
            }
            this.future = null;
        }
    }

    private static class TPOOLHolder {
        static final ScheduledExecutorService EXEC_SERVICE = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });

        private TPOOLHolder() {
        }
    }
}

