/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;

public class SamplerMetric {
    private static final int SLIDING_WINDOW_SIZE = JMeterUtils.getPropDefault((String)"backend_metrics_window", (int)100);
    private DescriptiveStatistics okResponsesStats = new DescriptiveStatistics(SLIDING_WINDOW_SIZE);
    private DescriptiveStatistics koResponsesStats = new DescriptiveStatistics(SLIDING_WINDOW_SIZE);
    private DescriptiveStatistics allResponsesStats = new DescriptiveStatistics(SLIDING_WINDOW_SIZE);
    private int successes;
    private int failures;
    private int hits;

    public synchronized void add(SampleResult result) {
        if (result.isSuccessful()) {
            this.successes += result.getSampleCount() - result.getErrorCount();
        } else {
            this.failures += result.getErrorCount();
        }
        long time = result.getTime();
        this.allResponsesStats.addValue((double)time);
        if (result.isSuccessful()) {
            this.okResponsesStats.addValue((double)time);
        } else {
            this.koResponsesStats.addValue((double)time);
        }
        this.addHits(result);
    }

    private void addHits(SampleResult res) {
        SampleResult[] subResults = res.getSubResults();
        if (!TransactionController.isFromTransactionController((SampleResult)res)) {
            ++this.hits;
        }
        for (SampleResult subResult : subResults) {
            this.addHits(subResult);
        }
    }

    public synchronized void resetForTimeInterval() {
        this.successes = 0;
        this.failures = 0;
        this.hits = 0;
    }

    public int getTotal() {
        return this.successes + this.failures;
    }

    public int getSuccesses() {
        return this.successes;
    }

    public int getFailures() {
        return this.failures;
    }

    public double getOkMaxTime() {
        return this.okResponsesStats.getMax();
    }

    public double getOkMinTime() {
        return this.okResponsesStats.getMin();
    }

    public double getOkMean() {
        return this.okResponsesStats.getMean();
    }

    public double getOkPercentile(double percentile) {
        return this.okResponsesStats.getPercentile(percentile);
    }

    public double getKoMaxTime() {
        return this.koResponsesStats.getMax();
    }

    public double getKoMinTime() {
        return this.koResponsesStats.getMin();
    }

    public double getKoMean() {
        return this.koResponsesStats.getMean();
    }

    public double getKoPercentile(double percentile) {
        return this.koResponsesStats.getPercentile(percentile);
    }

    public double getAllMaxTime() {
        return this.allResponsesStats.getMax();
    }

    public double getAllMinTime() {
        return this.allResponsesStats.getMin();
    }

    public double getAllMean() {
        return this.allResponsesStats.getMean();
    }

    public double getAllPercentile(double percentile) {
        return this.allResponsesStats.getPercentile(percentile);
    }

    public int getHits() {
        return this.hits;
    }
}

