/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.assertions.MD5HexAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class MD5HexAssertionGUI
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private JTextField md5HexInput;

    public MD5HexAssertionGUI() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        HorizontalPanel md5HexPanel = new HorizontalPanel();
        md5HexPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"md5hex_assertion_md5hex_test")));
        md5HexPanel.add((Component)new JLabel(JMeterUtils.getResString((String)"md5hex_assertion_label")));
        this.md5HexInput = new JTextField(25);
        md5HexPanel.add((Component)this.md5HexInput);
        mainPanel.add((Component)md5HexPanel, "North");
        this.add(mainPanel, "Center");
    }

    public void configure(TestElement el) {
        super.configure(el);
        MD5HexAssertion assertion = (MD5HexAssertion)el;
        this.md5HexInput.setText(String.valueOf(assertion.getAllowedMD5Hex()));
    }

    public String getLabelResource() {
        return "md5hex_assertion_title";
    }

    public TestElement createTestElement() {
        MD5HexAssertion el = new MD5HexAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        String md5HexString = this.md5HexInput.getText();
        if (md5HexString == null || md5HexString.length() == 0) {
            md5HexString = "";
        }
        ((MD5HexAssertion)element).setAllowedMD5Hex(md5HexString);
    }

    public void clearGui() {
        super.clearGui();
        this.md5HexInput.setText("");
    }
}

