/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.CSVDataSetBeanInfo;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoConfigMerge;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=1)
public class CSVDataSet
extends ConfigTestElement
implements TestBean,
LoopIterationListener,
NoConfigMerge {
    private static final Logger log = LoggerFactory.getLogger(CSVDataSet.class);
    private static final long serialVersionUID = 233L;
    private static final String EOFVALUE = JMeterUtils.getPropDefault((String)"csvdataset.eofstring", (String)"<EOF>");
    private transient String filename;
    private transient String fileEncoding;
    private transient String variableNames;
    private transient String delimiter;
    private transient boolean quoted;
    private transient boolean recycle = true;
    private transient boolean stopThread;
    private transient String[] vars;
    private transient String alias;
    private transient String shareMode;
    private boolean firstLineIsNames = false;
    private boolean ignoreFirstLine = false;

    private Object readResolve() {
        this.recycle = true;
        return this;
    }

    public void setProperty(JMeterProperty property) {
        String propValue;
        String propName;
        if (property instanceof StringProperty && "shareMode".equals(propName = property.getName()) && (propValue = property.getStringValue()).contains(" ")) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(((Object)((Object)this)).getClass());
                ResourceBundle rb = (ResourceBundle)beanInfo.getBeanDescriptor().getValue("resourceBundle");
                for (String resKey : CSVDataSetBeanInfo.getShareTags()) {
                    if (!propValue.equals(rb.getString(resKey))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Converted {}={} to {} using Locale: {}", new Object[]{propName, propValue, resKey, rb.getLocale()});
                    }
                    ((StringProperty)property).setValue(resKey);
                    super.setProperty(property);
                    return;
                }
                log.warn("Could not translate {}={} using Locale: {}", new Object[]{propName, propValue, rb.getLocale()});
            }
            catch (IntrospectionException e) {
                log.error("Could not find BeanInfo; cannot translate shareMode entries", (Throwable)e);
            }
        }
        super.setProperty(property);
    }

    public void iterationStart(LoopIterationEvent iterEvent) {
        FileServer server = FileServer.getFileServer();
        JMeterContext context = this.getThreadContext();
        String delim = this.getDelimiter();
        if ("\\t".equals(delim)) {
            delim = "\t";
        } else if (delim.isEmpty()) {
            log.debug("Empty delimiter, will use ','");
            delim = ",";
        }
        if (this.vars == null) {
            String fileName = this.getFilename().trim();
            String mode = this.getShareMode();
            int modeInt = CSVDataSetBeanInfo.getShareModeAsInt(mode);
            switch (modeInt) {
                case 0: {
                    this.alias = fileName;
                    break;
                }
                case 1: {
                    this.alias = fileName + "@" + System.identityHashCode(context.getThreadGroup());
                    break;
                }
                case 2: {
                    this.alias = fileName + "@" + System.identityHashCode(context.getThread());
                    break;
                }
                default: {
                    this.alias = fileName + "@" + mode;
                }
            }
            String names = this.getVariableNames();
            if (StringUtils.isEmpty((CharSequence)names)) {
                String header = server.reserveFile(fileName, this.getFileEncoding(), this.alias, true);
                try {
                    this.vars = CSVSaveService.csvSplitString((String)header, (char)delim.charAt(0));
                    this.firstLineIsNames = true;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not split CSV header line from file:" + fileName, e);
                }
            } else {
                server.reserveFile(fileName, this.getFileEncoding(), this.alias, this.ignoreFirstLine);
                this.vars = JOrphanUtils.split((String)names, (String)",");
            }
            this.trimVarNames(this.vars);
        }
        JMeterVariables threadVars = context.getVariables();
        String[] lineValues = new String[]{};
        try {
            if (this.getQuotedData()) {
                lineValues = server.getParsedLine(this.alias, this.recycle, this.firstLineIsNames || this.ignoreFirstLine, delim.charAt(0));
            } else {
                String line = server.readLine(this.alias, this.recycle, this.firstLineIsNames || this.ignoreFirstLine);
                lineValues = JOrphanUtils.split((String)line, (String)delim, (boolean)false);
            }
            for (int a = 0; a < this.vars.length && a < lineValues.length; ++a) {
                threadVars.put(this.vars[a], lineValues[a]);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        if (lineValues.length == 0) {
            if (this.getStopThread()) {
                throw new JMeterStopThreadException("End of file:" + this.getFilename() + " detected for CSV DataSet:" + this.getName() + " configured with stopThread:" + this.getStopThread() + ", recycle:" + this.getRecycle());
            }
            for (String var : this.vars) {
                threadVars.put(var, EOFVALUE);
            }
        }
    }

    private void trimVarNames(String[] varsNames) {
        for (int i = 0; i < varsNames.length; ++i) {
            varsNames[i] = varsNames[i].trim();
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(String variableNames) {
        this.variableNames = variableNames;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean getQuotedData() {
        return this.quoted;
    }

    public void setQuotedData(boolean quoted) {
        this.quoted = quoted;
    }

    public boolean getRecycle() {
        return this.recycle;
    }

    public void setRecycle(boolean recycle) {
        this.recycle = recycle;
    }

    public boolean getStopThread() {
        return this.stopThread;
    }

    public void setStopThread(boolean value) {
        this.stopThread = value;
    }

    public String getShareMode() {
        return this.shareMode;
    }

    public void setShareMode(String value) {
        this.shareMode = value;
    }

    public boolean isIgnoreFirstLine() {
        return this.ignoreFirstLine;
    }

    public void setIgnoreFirstLine(boolean ignoreFirstLine) {
        this.ignoreFirstLine = ignoreFirstLine;
    }
}

