/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.sampler.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.sampler.TestAction;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@GUIMenuSortOrder(value=1)
public class TestActionGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 240L;
    private JComboBox<String> targetBox;
    private JRadioButton pauseButton;
    private JRadioButton stopButton;
    private JRadioButton stopNowButton;
    private JRadioButton restartNextLoopButton;
    private JTextField durationField;
    private int target = 0;
    private int action = 1;
    private final String targetLabel = JMeterUtils.getResString((String)"test_action_target");
    private final String threadTarget = JMeterUtils.getResString((String)"test_action_target_thread");
    private final String testTarget = JMeterUtils.getResString((String)"test_action_target_test");
    private final String actionLabel = JMeterUtils.getResString((String)"test_action_action");
    private final String pauseAction = JMeterUtils.getResString((String)"test_action_pause");
    private final String stopAction = JMeterUtils.getResString((String)"test_action_stop");
    private final String stopNowAction = JMeterUtils.getResString((String)"test_action_stop_now");
    private final String restartNextLoopAction = JMeterUtils.getResString((String)"test_action_restart_next_loop");
    private final String durationLabel = JMeterUtils.getResString((String)"test_action_duration");

    public TestActionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "test_action_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        TestAction ta = (TestAction)element;
        this.target = ta.getTarget();
        if (this.target == 0) {
            this.targetBox.setSelectedItem(this.threadTarget);
        } else {
            this.targetBox.setSelectedItem(this.testTarget);
        }
        this.action = ta.getAction();
        if (this.action == 1) {
            this.pauseButton.setSelected(true);
        } else if (this.action == 2) {
            this.stopNowButton.setSelected(true);
        } else if (this.action == 0) {
            this.stopButton.setSelected(true);
        } else {
            this.restartNextLoopButton.setSelected(true);
        }
        this.durationField.setText(ta.getDurationAsString());
    }

    public TestElement createTestElement() {
        TestAction ta = new TestAction();
        this.modifyTestElement((TestElement)ta);
        return ta;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        TestAction ta = (TestAction)element;
        ta.setAction(this.action);
        ta.setTarget(this.target);
        ta.setDuration(this.durationField.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.targetBox.setSelectedIndex(0);
        this.durationField.setText("0");
        this.pauseButton.setSelected(true);
        this.action = 1;
        this.target = 0;
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        HorizontalPanel targetPanel = new HorizontalPanel();
        targetPanel.add((Component)new JLabel(this.targetLabel));
        DefaultComboBoxModel<String> targetModel = new DefaultComboBoxModel<String>();
        targetModel.addElement(this.threadTarget);
        targetModel.addElement(this.testTarget);
        this.targetBox = new JComboBox(targetModel);
        this.targetBox.addActionListener(evt -> {
            this.target = ((String)this.targetBox.getSelectedItem()).equals(this.threadTarget) ? 0 : 2;
        });
        targetPanel.add(this.targetBox);
        this.add((Component)targetPanel);
        HorizontalPanel actionPanel = new HorizontalPanel();
        ButtonGroup actionButtons = new ButtonGroup();
        this.pauseButton = new JRadioButton(this.pauseAction, true);
        this.pauseButton.addChangeListener(evt -> {
            if (this.pauseButton.isSelected()) {
                this.action = 1;
                this.durationField.setEnabled(true);
                this.targetBox.setEnabled(false);
            }
        });
        this.stopButton = new JRadioButton(this.stopAction, false);
        this.stopButton.addChangeListener(evt -> {
            if (this.stopButton.isSelected()) {
                this.action = 0;
                this.durationField.setEnabled(false);
                this.targetBox.setEnabled(true);
            }
        });
        this.stopNowButton = new JRadioButton(this.stopNowAction, false);
        this.stopNowButton.addChangeListener(evt -> {
            if (this.stopNowButton.isSelected()) {
                this.action = 2;
                this.durationField.setEnabled(false);
                this.targetBox.setEnabled(true);
            }
        });
        this.restartNextLoopButton = new JRadioButton(this.restartNextLoopAction, false);
        this.restartNextLoopButton.addChangeListener(evt -> {
            if (this.restartNextLoopButton.isSelected()) {
                this.action = 3;
                this.durationField.setEnabled(false);
                this.targetBox.setSelectedIndex(0);
                this.targetBox.setEnabled(false);
            }
        });
        actionButtons.add(this.pauseButton);
        actionButtons.add(this.stopButton);
        actionButtons.add(this.stopNowButton);
        actionButtons.add(this.restartNextLoopButton);
        actionPanel.add((Component)new JLabel(this.actionLabel));
        actionPanel.add((Component)this.pauseButton);
        actionPanel.add((Component)this.stopButton);
        actionPanel.add((Component)this.stopNowButton);
        actionPanel.add((Component)this.restartNextLoopButton);
        this.add((Component)actionPanel);
        HorizontalPanel durationPanel = new HorizontalPanel();
        this.durationField = new JTextField(15);
        this.durationField.setText("");
        durationPanel.add((Component)new JLabel(this.durationLabel));
        durationPanel.add((Component)this.durationField);
        this.add((Component)durationPanel);
    }
}

