/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;

public class RenderAsRegexp
implements ResultRenderer,
ActionListener {
    private static final String REGEXP_TESTER_COMMAND = "regexp_tester";
    private JPanel regexpPane;
    private JTextArea regexpDataField;
    private JLabeledTextField regexpField;
    private JTextArea regexpResultField;
    private JTabbedPane rightSide;
    private SampleResult sampleResult = null;

    @Override
    public void clearData() {
        this.regexpDataField.setText("");
        this.regexpResultField.setText("");
    }

    @Override
    public void init() {
        this.regexpPane = this.createRegexpPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (this.sampleResult != null && REGEXP_TESTER_COMMAND.equals(command)) {
            String response = ViewResultsFullVisualizer.getResponseAsString(this.sampleResult);
            this.executeAndShowRegexpTester(response);
        }
    }

    private void executeAndShowRegexpTester(String textToParse) {
        if (textToParse != null && textToParse.length() > 0 && this.regexpField.getText().length() > 0) {
            this.regexpResultField.setText(this.process(textToParse));
            this.regexpResultField.setCaretPosition(0);
        }
    }

    private String process(String textToParse) {
        Pattern pattern;
        Perl5Matcher matcher = new Perl5Matcher();
        PatternMatcherInput input = new PatternMatcherInput(textToParse);
        PatternCacheLRU pcLRU = new PatternCacheLRU();
        try {
            pattern = pcLRU.getPattern(this.regexpField.getText(), 32768);
        }
        catch (MalformedCachePatternException e) {
            return e.toString();
        }
        LinkedList<MatchResult> matches = new LinkedList<MatchResult>();
        while (matcher.contains(input, pattern)) {
            matches.add(matcher.getMatch());
        }
        StringBuilder sb = new StringBuilder();
        int size = matches.size();
        sb.append("Match count: ").append(size).append("\n");
        for (int j = 0; j < size; ++j) {
            MatchResult mr = (MatchResult)matches.get(j);
            int groups = mr.groups();
            for (int i = 0; i < groups; ++i) {
                sb.append("Match[").append(j + 1).append("][").append(i).append("]=").append(mr.group(i)).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void renderResult(SampleResult sampleResult) {
        this.clearData();
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.regexpDataField.setText(response);
        this.regexpDataField.setCaretPosition(0);
    }

    @Override
    public void setupTabPane() {
        if (this.rightSide.indexOfTab(JMeterUtils.getResString((String)"regexp_tester_title")) < 0) {
            this.rightSide.addTab(JMeterUtils.getResString((String)"regexp_tester_title"), this.regexpPane);
        }
        this.clearData();
    }

    private JPanel createRegexpPanel() {
        this.regexpDataField = new JTextArea();
        this.regexpDataField.setEditable(false);
        this.regexpDataField.setLineWrap(true);
        this.regexpDataField.setWrapStyleWord(true);
        JScrollPane regexpDataPane = GuiUtils.makeScrollPane((Component)this.regexpDataField);
        regexpDataPane.setPreferredSize(new Dimension(0, 200));
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        JSplitPane mainSplit = new JSplitPane(0, regexpDataPane, this.createRegexpTasksPanel());
        mainSplit.setDividerLocation(0.6);
        mainSplit.setOneTouchExpandable(true);
        pane.add((Component)mainSplit, "Center");
        return pane;
    }

    private JPanel createRegexpTasksPanel() {
        JPanel regexpActionPanel = new JPanel();
        regexpActionPanel.setLayout(new BoxLayout(regexpActionPanel, 0));
        EmptyBorder margin = new EmptyBorder(5, 5, 0, 5);
        regexpActionPanel.setBorder(margin);
        this.regexpField = new JLabeledTextField(JMeterUtils.getResString((String)"regexp_tester_field"));
        regexpActionPanel.add((Component)this.regexpField, "West");
        JButton regexpTester = new JButton(JMeterUtils.getResString((String)"regexp_tester_button_test"));
        regexpTester.setActionCommand(REGEXP_TESTER_COMMAND);
        regexpTester.addActionListener(this);
        regexpActionPanel.add((Component)regexpTester, "East");
        this.regexpResultField = new JTextArea();
        this.regexpResultField.setEditable(false);
        this.regexpResultField.setLineWrap(true);
        this.regexpResultField.setWrapStyleWord(true);
        JPanel regexpTasksPanel = new JPanel(new BorderLayout(0, 5));
        regexpTasksPanel.add((Component)regexpActionPanel, "North");
        regexpTasksPanel.add((Component)GuiUtils.makeScrollPane((Component)this.regexpResultField), "Center");
        return regexpTasksPanel;
    }

    @Override
    public synchronized void setRightSide(JTabbedPane side) {
        this.rightSide = side;
    }

    @Override
    public synchronized void setSamplerResult(Object userObject) {
        if (userObject instanceof SampleResult) {
            this.sampleResult = (SampleResult)userObject;
        }
    }

    @Override
    public void setLastSelectedTab(int index) {
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"regexp_tester_title");
    }

    @Override
    public void renderImage(SampleResult sampleResult) {
        this.clearData();
        this.regexpDataField.setText(JMeterUtils.getResString((String)"regexp_render_no_text"));
    }

    @Override
    public void setBackgroundColor(Color backGround) {
    }
}

