/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeConfigsRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;

public abstract class AbstractRequest
extends AbstractRequestResponse {
    private final short version;

    public AbstractRequest(short version) {
        this.version = version;
    }

    public short version() {
        return this.version;
    }

    public Send toSend(String destination, RequestHeader header) {
        return new NetworkSend(destination, this.serialize(header));
    }

    public ByteBuffer serialize(RequestHeader header) {
        return AbstractRequest.serialize(header.toStruct(), this.toStruct());
    }

    protected abstract Struct toStruct();

    public String toString(boolean verbose) {
        return this.toStruct().toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public AbstractResponse getErrorResponse(Throwable e) {
        return this.getErrorResponse(0, e);
    }

    public abstract AbstractResponse getErrorResponse(int var1, Throwable var2);

    public static RequestAndSize getRequest(int requestId, short version, ByteBuffer buffer) {
        AbstractRequest request;
        ApiKeys apiKey = ApiKeys.forId(requestId);
        Struct struct = apiKey.parseRequest(version, buffer);
        switch (apiKey) {
            case PRODUCE: {
                request = new ProduceRequest(struct, version);
                break;
            }
            case FETCH: {
                request = new FetchRequest(struct, version);
                break;
            }
            case LIST_OFFSETS: {
                request = new ListOffsetRequest(struct, version);
                break;
            }
            case METADATA: {
                request = new MetadataRequest(struct, version);
                break;
            }
            case OFFSET_COMMIT: {
                request = new OffsetCommitRequest(struct, version);
                break;
            }
            case OFFSET_FETCH: {
                request = new OffsetFetchRequest(struct, version);
                break;
            }
            case FIND_COORDINATOR: {
                request = new FindCoordinatorRequest(struct, version);
                break;
            }
            case JOIN_GROUP: {
                request = new JoinGroupRequest(struct, version);
                break;
            }
            case HEARTBEAT: {
                request = new HeartbeatRequest(struct, version);
                break;
            }
            case LEAVE_GROUP: {
                request = new LeaveGroupRequest(struct, version);
                break;
            }
            case SYNC_GROUP: {
                request = new SyncGroupRequest(struct, version);
                break;
            }
            case STOP_REPLICA: {
                request = new StopReplicaRequest(struct, version);
                break;
            }
            case CONTROLLED_SHUTDOWN_KEY: {
                request = new ControlledShutdownRequest(struct, version);
                break;
            }
            case UPDATE_METADATA_KEY: {
                request = new UpdateMetadataRequest(struct, version);
                break;
            }
            case LEADER_AND_ISR: {
                request = new LeaderAndIsrRequest(struct, version);
                break;
            }
            case DESCRIBE_GROUPS: {
                request = new DescribeGroupsRequest(struct, version);
                break;
            }
            case LIST_GROUPS: {
                request = new ListGroupsRequest(struct, version);
                break;
            }
            case SASL_HANDSHAKE: {
                request = new SaslHandshakeRequest(struct, version);
                break;
            }
            case API_VERSIONS: {
                request = new ApiVersionsRequest(struct, version);
                break;
            }
            case CREATE_TOPICS: {
                request = new CreateTopicsRequest(struct, version);
                break;
            }
            case DELETE_TOPICS: {
                request = new DeleteTopicsRequest(struct, version);
                break;
            }
            case DELETE_RECORDS: {
                request = new DeleteRecordsRequest(struct, version);
                break;
            }
            case INIT_PRODUCER_ID: {
                request = new InitProducerIdRequest(struct, version);
                break;
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                request = new OffsetsForLeaderEpochRequest(struct, version);
                break;
            }
            case ADD_PARTITIONS_TO_TXN: {
                request = new AddPartitionsToTxnRequest(struct, version);
                break;
            }
            case ADD_OFFSETS_TO_TXN: {
                request = new AddOffsetsToTxnRequest(struct, version);
                break;
            }
            case END_TXN: {
                request = new EndTxnRequest(struct, version);
                break;
            }
            case WRITE_TXN_MARKERS: {
                request = new WriteTxnMarkersRequest(struct, version);
                break;
            }
            case TXN_OFFSET_COMMIT: {
                request = new TxnOffsetCommitRequest(struct, version);
                break;
            }
            case DESCRIBE_ACLS: {
                request = new DescribeAclsRequest(struct, version);
                break;
            }
            case CREATE_ACLS: {
                request = new CreateAclsRequest(struct, version);
                break;
            }
            case DELETE_ACLS: {
                request = new DeleteAclsRequest(struct, version);
                break;
            }
            case DESCRIBE_CONFIGS: {
                request = new DescribeConfigsRequest(struct, version);
                break;
            }
            case ALTER_CONFIGS: {
                request = new AlterConfigsRequest(struct, version);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `getRequest`, the code should be updated to do so.", new Object[]{apiKey}));
            }
        }
        return new RequestAndSize(request, struct.sizeOf());
    }

    public static abstract class Builder<T extends AbstractRequest> {
        private final ApiKeys apiKey;
        private final Short desiredVersion;

        public Builder(ApiKeys apiKey) {
            this(apiKey, null);
        }

        public Builder(ApiKeys apiKey, Short desiredVersion) {
            this.apiKey = apiKey;
            this.desiredVersion = desiredVersion;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public short desiredOrLatestVersion() {
            return this.desiredVersion == null ? this.apiKey.latestVersion() : this.desiredVersion.shortValue();
        }

        public Short desiredVersion() {
            return this.desiredVersion;
        }

        public T build() {
            return this.build(this.desiredOrLatestVersion());
        }

        public abstract T build(short var1);
    }
}

