/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.InFlightRequests;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InFlightRequestsTest {
    private InFlightRequests inFlightRequests;
    private int correlationId;
    private String dest = "dest";

    @Before
    public void setup() {
        this.inFlightRequests = new InFlightRequests(12);
        this.correlationId = 0;
    }

    @Test
    public void testCompleteLastSent() {
        int correlationId1 = this.addRequest(this.dest);
        int correlationId2 = this.addRequest(this.dest);
        Assert.assertEquals((long)2L, (long)this.inFlightRequests.count());
        Assert.assertEquals((long)correlationId2, (long)this.inFlightRequests.completeLastSent((String)this.dest).header.correlationId());
        Assert.assertEquals((long)1L, (long)this.inFlightRequests.count());
        Assert.assertEquals((long)correlationId1, (long)this.inFlightRequests.completeLastSent((String)this.dest).header.correlationId());
        Assert.assertEquals((long)0L, (long)this.inFlightRequests.count());
    }

    @Test
    public void testClearAll() {
        int correlationId1 = this.addRequest(this.dest);
        int correlationId2 = this.addRequest(this.dest);
        List clearedRequests = TestUtils.toList(this.inFlightRequests.clearAll(this.dest));
        Assert.assertEquals((long)0L, (long)this.inFlightRequests.count());
        Assert.assertEquals((long)2L, (long)clearedRequests.size());
        Assert.assertEquals((long)correlationId1, (long)((NetworkClient.InFlightRequest)clearedRequests.get((int)0)).header.correlationId());
        Assert.assertEquals((long)correlationId2, (long)((NetworkClient.InFlightRequest)clearedRequests.get((int)1)).header.correlationId());
    }

    @Test
    public void testTimedOutNodes() {
        MockTime time = new MockTime();
        this.addRequest("A", time.milliseconds(), 50);
        this.addRequest("B", time.milliseconds(), 200);
        this.addRequest("B", time.milliseconds(), 100);
        time.sleep(50L);
        Assert.assertEquals(Collections.emptyList(), (Object)this.inFlightRequests.nodesWithTimedOutRequests(time.milliseconds()));
        time.sleep(25L);
        Assert.assertEquals(Collections.singletonList("A"), (Object)this.inFlightRequests.nodesWithTimedOutRequests(time.milliseconds()));
        time.sleep(50L);
        Assert.assertEquals(Arrays.asList("A", "B"), (Object)this.inFlightRequests.nodesWithTimedOutRequests(time.milliseconds()));
    }

    @Test
    public void testCompleteNext() {
        int correlationId1 = this.addRequest(this.dest);
        int correlationId2 = this.addRequest(this.dest);
        Assert.assertEquals((long)2L, (long)this.inFlightRequests.count());
        Assert.assertEquals((long)correlationId1, (long)this.inFlightRequests.completeNext((String)this.dest).header.correlationId());
        Assert.assertEquals((long)1L, (long)this.inFlightRequests.count());
        Assert.assertEquals((long)correlationId2, (long)this.inFlightRequests.completeNext((String)this.dest).header.correlationId());
        Assert.assertEquals((long)0L, (long)this.inFlightRequests.count());
    }

    @Test(expected=IllegalStateException.class)
    public void testCompleteNextThrowsIfNoInflights() {
        this.inFlightRequests.completeNext(this.dest);
    }

    @Test(expected=IllegalStateException.class)
    public void testCompleteLastSentThrowsIfNoInFlights() {
        this.inFlightRequests.completeLastSent(this.dest);
    }

    private int addRequest(String destination) {
        return this.addRequest(destination, 0L, 10000);
    }

    private int addRequest(String destination, long sendTimeMs, int requestTimeoutMs) {
        int correlationId = this.correlationId++;
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, 0, "clientId", correlationId);
        NetworkClient.InFlightRequest ifr = new NetworkClient.InFlightRequest(requestHeader, requestTimeoutMs, 0L, destination, null, false, false, null, null, sendTimeMs);
        this.inFlightRequests.add(ifr);
        return correlationId;
    }
}

