/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigTransformer;
import org.apache.kafka.common.config.ConfigTransformerResult;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigTransformerTest {
    public static final String MY_KEY = "myKey";
    public static final String TEST_INDIRECTION = "testIndirection";
    public static final String TEST_KEY = "testKey";
    public static final String TEST_KEY_WITH_TTL = "testKeyWithTTL";
    public static final String TEST_PATH = "testPath";
    public static final String TEST_RESULT = "testResult";
    public static final String TEST_RESULT_WITH_TTL = "testResultWithTTL";
    public static final String TEST_RESULT_NO_PATH = "testResultNoPath";
    private ConfigTransformer configTransformer;

    @Before
    public void setup() {
        this.configTransformer = new ConfigTransformer(Collections.singletonMap("test", new TestConfigProvider()));
    }

    @Test
    public void testReplaceVariable() throws Exception {
        ConfigTransformerResult result = this.configTransformer.transform(Collections.singletonMap(MY_KEY, "${test:testPath:testKey}"));
        Map data = result.data();
        Map ttls = result.ttls();
        Assert.assertEquals((Object)TEST_RESULT, data.get(MY_KEY));
        Assert.assertTrue((boolean)ttls.isEmpty());
    }

    @Test
    public void testReplaceVariableWithTTL() throws Exception {
        ConfigTransformerResult result = this.configTransformer.transform(Collections.singletonMap(MY_KEY, "${test:testPath:testKeyWithTTL}"));
        Map data = result.data();
        Map ttls = result.ttls();
        Assert.assertEquals((Object)TEST_RESULT_WITH_TTL, data.get(MY_KEY));
        Assert.assertEquals((long)1L, (long)((Long)ttls.get(TEST_PATH)));
    }

    @Test
    public void testReplaceMultipleVariablesInValue() throws Exception {
        ConfigTransformerResult result = this.configTransformer.transform(Collections.singletonMap(MY_KEY, "hello, ${test:testPath:testKey}; goodbye, ${test:testPath:testKeyWithTTL}!!!"));
        Map data = result.data();
        Assert.assertEquals((Object)"hello, testResult; goodbye, testResultWithTTL!!!", data.get(MY_KEY));
    }

    @Test
    public void testNoReplacement() throws Exception {
        ConfigTransformerResult result = this.configTransformer.transform(Collections.singletonMap(MY_KEY, "${test:testPath:missingKey}"));
        Map data = result.data();
        Assert.assertEquals((Object)"${test:testPath:missingKey}", data.get(MY_KEY));
    }

    @Test
    public void testSingleLevelOfIndirection() throws Exception {
        ConfigTransformerResult result = this.configTransformer.transform(Collections.singletonMap(MY_KEY, "${test:testPath:testIndirection}"));
        Map data = result.data();
        Assert.assertEquals((Object)"${test:testPath:testResult}", data.get(MY_KEY));
    }

    @Test
    public void testReplaceVariableNoPath() throws Exception {
        ConfigTransformerResult result = this.configTransformer.transform(Collections.singletonMap(MY_KEY, "${test:testKey}"));
        Map data = result.data();
        Map ttls = result.ttls();
        Assert.assertEquals((Object)TEST_RESULT_NO_PATH, data.get(MY_KEY));
        Assert.assertTrue((boolean)ttls.isEmpty());
    }

    @Test
    public void testNullConfigValue() throws Exception {
        ConfigTransformerResult result = this.configTransformer.transform(Collections.singletonMap(MY_KEY, null));
        Map data = result.data();
        Map ttls = result.ttls();
        Assert.assertNull(data.get(MY_KEY));
        Assert.assertTrue((boolean)ttls.isEmpty());
    }

    public static class TestConfigProvider
    implements ConfigProvider {
        public void configure(Map<String, ?> configs) {
        }

        public ConfigData get(String path) {
            return null;
        }

        public ConfigData get(String path, Set<String> keys) {
            HashMap<String, String> data = new HashMap<String, String>();
            Long ttl = null;
            if (ConfigTransformerTest.TEST_PATH.equals(path)) {
                if (keys.contains(ConfigTransformerTest.TEST_KEY)) {
                    data.put(ConfigTransformerTest.TEST_KEY, ConfigTransformerTest.TEST_RESULT);
                }
                if (keys.contains(ConfigTransformerTest.TEST_KEY_WITH_TTL)) {
                    data.put(ConfigTransformerTest.TEST_KEY_WITH_TTL, ConfigTransformerTest.TEST_RESULT_WITH_TTL);
                    ttl = 1L;
                }
                if (keys.contains(ConfigTransformerTest.TEST_INDIRECTION)) {
                    data.put(ConfigTransformerTest.TEST_INDIRECTION, "${test:testPath:testResult}");
                }
            } else if (keys.contains(ConfigTransformerTest.TEST_KEY)) {
                data.put(ConfigTransformerTest.TEST_KEY, ConfigTransformerTest.TEST_RESULT_NO_PATH);
            }
            return new ConfigData(data, ttl);
        }

        public void close() {
        }
    }
}

