/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.junit.Assert;
import org.junit.Test;

public class SecurityUtilsTest {
    @Test
    public void testPrincipalNameCanContainSeparator() {
        String name = "name:with:separator:in:it";
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)("User:" + name));
        Assert.assertEquals((Object)"User", (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)name, (Object)principal.getName());
    }

    @Test
    public void testParseKafkaPrincipalWithNonUserPrincipalType() {
        String name = "foo";
        String principalType = "Group";
        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)(principalType + ":" + name));
        Assert.assertEquals((Object)principalType, (Object)principal.getPrincipalType());
        Assert.assertEquals((Object)name, (Object)principal.getName());
    }
}

