/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class FetchRequestData
implements ApiMessage {
    String clusterId;
    int replicaId;
    int maxWaitMs;
    int minBytes;
    int maxBytes;
    byte isolationLevel;
    int sessionId;
    int sessionEpoch;
    List<FetchTopic> topics;
    List<ForgottenTopic> forgottenTopicsData;
    String rackId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema SCHEMA_11;
    public static final Schema SCHEMA_12;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 12;

    public FetchRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public FetchRequestData() {
        this.clusterId = null;
        this.replicaId = 0;
        this.maxWaitMs = 0;
        this.minBytes = 0;
        this.maxBytes = Integer.MAX_VALUE;
        this.isolationLevel = 0;
        this.sessionId = 0;
        this.sessionEpoch = -1;
        this.topics = new ArrayList<FetchTopic>(0);
        this.forgottenTopicsData = new ArrayList<ForgottenTopic>(0);
        this.rackId = "";
    }

    @Override
    public short apiKey() {
        return 1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 12;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<FetchTopic> newCollection;
        int arrayLength;
        this.clusterId = null;
        this.replicaId = _readable.readInt();
        this.maxWaitMs = _readable.readInt();
        this.minBytes = _readable.readInt();
        this.maxBytes = _version >= 3 ? _readable.readInt() : Integer.MAX_VALUE;
        this.isolationLevel = _version >= 4 ? _readable.readByte() : (byte)0;
        this.sessionId = _version >= 7 ? _readable.readInt() : 0;
        this.sessionEpoch = _version >= 7 ? _readable.readInt() : -1;
        if (_version >= 12) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new FetchTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new ArrayList<FetchTopic>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new FetchTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        if (_version >= 7) {
            if (_version >= 12) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field forgottenTopicsData was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((FetchTopic)((Object)new ForgottenTopic(_readable, _version)));
                }
                this.forgottenTopicsData = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field forgottenTopicsData was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((FetchTopic)((Object)new ForgottenTopic(_readable, _version)));
                }
                this.forgottenTopicsData = newCollection;
            }
        } else {
            this.forgottenTopicsData = new ArrayList<ForgottenTopic>(0);
        }
        if (_version >= 11) {
            int length = _version >= 12 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field rackId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            }
            this.rackId = _readable.readString(length);
        } else {
            this.rackId = "";
        }
        this._unknownTaggedFields = null;
        if (_version >= 12) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block7: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int length = _readable.readUnsignedVarint() - 1;
                        if (length < 0) {
                            this.clusterId = null;
                            continue block7;
                        }
                        if (length > Short.MAX_VALUE) {
                            throw new RuntimeException("string field clusterId had invalid length " + length);
                        }
                        this.clusterId = _readable.readString(length);
                        continue block7;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 12 && this.clusterId != null) {
            ++_numTaggedFields;
        }
        _writable.writeInt(this.replicaId);
        _writable.writeInt(this.maxWaitMs);
        _writable.writeInt(this.minBytes);
        if (_version >= 3) {
            _writable.writeInt(this.maxBytes);
        }
        if (_version >= 4) {
            _writable.writeByte(this.isolationLevel);
        }
        if (_version >= 7) {
            _writable.writeInt(this.sessionId);
        }
        if (_version >= 7) {
            _writable.writeInt(this.sessionEpoch);
        }
        if (_version >= 12) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (FetchTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (FetchTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 7) {
            if (_version >= 12) {
                _writable.writeUnsignedVarint(this.forgottenTopicsData.size() + 1);
                for (ForgottenTopic forgottenTopicsDataElement : this.forgottenTopicsData) {
                    forgottenTopicsDataElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.forgottenTopicsData.size());
                for (ForgottenTopic forgottenTopicsDataElement : this.forgottenTopicsData) {
                    forgottenTopicsDataElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.forgottenTopicsData.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default forgottenTopicsData at version " + _version);
        }
        if (_version >= 11) {
            byte[] _stringBytes = _cache.getSerializedValue(this.rackId);
            if (_version >= 12) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 12) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (this.clusterId != null) {
                _writable.writeUnsignedVarint(0);
                byte[] _stringBytes = _cache.getSerializedValue(this.clusterId);
                _writable.writeUnsignedVarint(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (_version >= 12 && this.clusterId != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'clusterId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.clusterId, (byte[])_stringBytes);
            int _stringPrefixSize = ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1);
            _size.addBytes(((byte[])_stringBytes).length + _stringPrefixSize + ByteUtils.sizeOfUnsignedVarint(_stringPrefixSize + ((Object)_stringBytes).length));
        }
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(4);
        if (_version >= 3) {
            _size.addBytes(4);
        }
        if (_version >= 4) {
            _size.addBytes(1);
        }
        if (_version >= 7) {
            _size.addBytes(4);
        }
        if (_version >= 7) {
            _size.addBytes(4);
        }
        if (_version >= 12) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        } else {
            _size.addBytes(4);
        }
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            FetchTopic topicsElement = (FetchTopic)_stringBytes.next();
            topicsElement.addSize(_size, _cache, _version);
        }
        if (_version >= 7) {
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.forgottenTopicsData.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _stringBytes = this.forgottenTopicsData.iterator();
            while (_stringBytes.hasNext()) {
                ForgottenTopic forgottenTopicsDataElement = (ForgottenTopic)_stringBytes.next();
                forgottenTopicsDataElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 11) {
            _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.rackId, (byte[])_stringBytes);
            if (_version >= 12) {
                _size.addBytes(((Object)_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((Object)_stringBytes).length + 1));
            } else {
                _size.addBytes(((Object)_stringBytes).length + 2);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 12) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FetchRequestData)) {
            return false;
        }
        FetchRequestData other = (FetchRequestData)obj;
        if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
            return false;
        }
        if (this.replicaId != other.replicaId) {
            return false;
        }
        if (this.maxWaitMs != other.maxWaitMs) {
            return false;
        }
        if (this.minBytes != other.minBytes) {
            return false;
        }
        if (this.maxBytes != other.maxBytes) {
            return false;
        }
        if (this.isolationLevel != other.isolationLevel) {
            return false;
        }
        if (this.sessionId != other.sessionId) {
            return false;
        }
        if (this.sessionEpoch != other.sessionEpoch) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.forgottenTopicsData == null ? other.forgottenTopicsData != null : !this.forgottenTopicsData.equals(other.forgottenTopicsData)) {
            return false;
        }
        if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
        hashCode = 31 * hashCode + this.replicaId;
        hashCode = 31 * hashCode + this.maxWaitMs;
        hashCode = 31 * hashCode + this.minBytes;
        hashCode = 31 * hashCode + this.maxBytes;
        hashCode = 31 * hashCode + this.isolationLevel;
        hashCode = 31 * hashCode + this.sessionId;
        hashCode = 31 * hashCode + this.sessionEpoch;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.forgottenTopicsData == null ? 0 : this.forgottenTopicsData.hashCode());
        hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
        return hashCode;
    }

    @Override
    public FetchRequestData duplicate() {
        FetchRequestData _duplicate = new FetchRequestData();
        _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
        _duplicate.replicaId = this.replicaId;
        _duplicate.maxWaitMs = this.maxWaitMs;
        _duplicate.minBytes = this.minBytes;
        _duplicate.maxBytes = this.maxBytes;
        _duplicate.isolationLevel = this.isolationLevel;
        _duplicate.sessionId = this.sessionId;
        _duplicate.sessionEpoch = this.sessionEpoch;
        ArrayList<FetchTopic> newTopics = new ArrayList<FetchTopic>(this.topics.size());
        for (FetchTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        ArrayList<ForgottenTopic> newForgottenTopicsData = new ArrayList<ForgottenTopic>(this.forgottenTopicsData.size());
        for (ForgottenTopic _element : this.forgottenTopicsData) {
            newForgottenTopicsData.add(_element.duplicate());
        }
        _duplicate.forgottenTopicsData = newForgottenTopicsData;
        _duplicate.rackId = this.rackId;
        return _duplicate;
    }

    public String toString() {
        return "FetchRequestData(clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", replicaId=" + this.replicaId + ", maxWaitMs=" + this.maxWaitMs + ", minBytes=" + this.minBytes + ", maxBytes=" + this.maxBytes + ", isolationLevel=" + this.isolationLevel + ", sessionId=" + this.sessionId + ", sessionEpoch=" + this.sessionEpoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", forgottenTopicsData=" + MessageUtil.deepToString(this.forgottenTopicsData.iterator()) + ", rackId=" + (this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ")";
    }

    public String clusterId() {
        return this.clusterId;
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxWaitMs() {
        return this.maxWaitMs;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public byte isolationLevel() {
        return this.isolationLevel;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int sessionEpoch() {
        return this.sessionEpoch;
    }

    public List<FetchTopic> topics() {
        return this.topics;
    }

    public List<ForgottenTopic> forgottenTopicsData() {
        return this.forgottenTopicsData;
    }

    public String rackId() {
        return this.rackId;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public FetchRequestData setClusterId(String v) {
        this.clusterId = v;
        return this;
    }

    public FetchRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public FetchRequestData setMaxWaitMs(int v) {
        this.maxWaitMs = v;
        return this;
    }

    public FetchRequestData setMinBytes(int v) {
        this.minBytes = v;
        return this;
    }

    public FetchRequestData setMaxBytes(int v) {
        this.maxBytes = v;
        return this;
    }

    public FetchRequestData setIsolationLevel(byte v) {
        this.isolationLevel = v;
        return this;
    }

    public FetchRequestData setSessionId(int v) {
        this.sessionId = v;
        return this;
    }

    public FetchRequestData setSessionEpoch(int v) {
        this.sessionEpoch = v;
        return this;
    }

    public FetchRequestData setTopics(List<FetchTopic> v) {
        this.topics = v;
        return this;
    }

    public FetchRequestData setForgottenTopicsData(List<ForgottenTopic> v) {
        this.forgottenTopicsData = v;
        return this;
    }

    public FetchRequestData setRackId(String v) {
        this.rackId = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("topics", new ArrayOf(FetchTopic.SCHEMA_0), "The topics to fetch.")));
        SCHEMA_3 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("topics", new ArrayOf(FetchTopic.SCHEMA_0), "The topics to fetch."));
        SCHEMA_4 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", new ArrayOf(FetchTopic.SCHEMA_0), "The topics to fetch."));
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("topics", new ArrayOf(FetchTopic.SCHEMA_5), "The topics to fetch."));
        SCHEMA_8 = SCHEMA_7 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("session_id", Type.INT32, "The fetch session ID."), new Field("session_epoch", Type.INT32, "The fetch session epoch, which is used for ordering requests in a session."), new Field("topics", new ArrayOf(FetchTopic.SCHEMA_5), "The topics to fetch."), new Field("forgotten_topics_data", new ArrayOf(ForgottenTopic.SCHEMA_7), "In an incremental fetch request, the partitions to remove."));
        SCHEMA_10 = SCHEMA_9 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("session_id", Type.INT32, "The fetch session ID."), new Field("session_epoch", Type.INT32, "The fetch session epoch, which is used for ordering requests in a session."), new Field("topics", new ArrayOf(FetchTopic.SCHEMA_9), "The topics to fetch."), new Field("forgotten_topics_data", new ArrayOf(ForgottenTopic.SCHEMA_7), "In an incremental fetch request, the partitions to remove."));
        SCHEMA_11 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("session_id", Type.INT32, "The fetch session ID."), new Field("session_epoch", Type.INT32, "The fetch session epoch, which is used for ordering requests in a session."), new Field("topics", new ArrayOf(FetchTopic.SCHEMA_9), "The topics to fetch."), new Field("forgotten_topics_data", new ArrayOf(ForgottenTopic.SCHEMA_7), "In an incremental fetch request, the partitions to remove."), new Field("rack_id", Type.STRING, "Rack ID of the consumer making this request"));
        SCHEMA_12 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("max_wait_ms", Type.INT32, "The maximum time in milliseconds to wait for the response."), new Field("min_bytes", Type.INT32, "The minimum bytes to accumulate in the response."), new Field("max_bytes", Type.INT32, "The maximum bytes to fetch.  See KIP-74 for cases where this limit may not be honored."), new Field("isolation_level", Type.INT8, "This setting controls the visibility of transactional records. Using READ_UNCOMMITTED (isolation_level = 0) makes all records visible. With READ_COMMITTED (isolation_level = 1), non-transactional and COMMITTED transactional records are visible. To be more concrete, READ_COMMITTED returns all data from offsets smaller than the current LSO (last stable offset), and enables the inclusion of the list of aborted transactions in the result, which allows consumers to discard ABORTED transactional records"), new Field("session_id", Type.INT32, "The fetch session ID."), new Field("session_epoch", Type.INT32, "The fetch session epoch, which is used for ordering requests in a session."), new Field("topics", new CompactArrayOf(FetchTopic.SCHEMA_12), "The topics to fetch."), new Field("forgotten_topics_data", new CompactArrayOf(ForgottenTopic.SCHEMA_12), "In an incremental fetch request, the partitions to remove."), new Field("rack_id", Type.COMPACT_STRING, "Rack ID of the consumer making this request"), Field.TaggedFieldsSection.of(0, new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The clusterId if known. This is used to validate metadata fetches prior to broker registration.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
    }

    public static class ForgottenTopic
    implements Message {
        String topic;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 7;
        public static final short HIGHEST_SUPPORTED_VERSION = 12;

        public ForgottenTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ForgottenTopic() {
            this.topic = "";
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 12;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ForgottenTopic");
            }
            int length = _version >= 12 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            int arrayLength = _version >= 12 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 12) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ForgottenTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            if (_version >= 12) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 12) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
            } else {
                _writable.writeInt(this.partitions.size());
            }
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 12) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ForgottenTopic");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            if (_version >= 12) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ForgottenTopic)) {
                return false;
            }
            ForgottenTopic other = (ForgottenTopic)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public ForgottenTopic duplicate() {
            ForgottenTopic _duplicate = new ForgottenTopic();
            _duplicate.topic = this.topic;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ForgottenTopic(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ForgottenTopic setTopic(String v) {
            this.topic = v;
            return this;
        }

        public ForgottenTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = new Schema(new Field("topic", Type.STRING, "The partition name."), new Field("partitions", new ArrayOf(Type.INT32), "The partitions indexes to forget.")))));
            SCHEMA_12 = new Schema(new Field("topic", Type.COMPACT_STRING, "The partition name."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions indexes to forget."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
        }
    }

    public static class FetchPartition
    implements Message {
        int partition;
        int currentLeaderEpoch;
        long fetchOffset;
        int lastFetchedEpoch;
        long logStartOffset;
        int partitionMaxBytes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 12;

        public FetchPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public FetchPartition() {
            this.partition = 0;
            this.currentLeaderEpoch = -1;
            this.fetchOffset = 0L;
            this.lastFetchedEpoch = -1;
            this.logStartOffset = -1L;
            this.partitionMaxBytes = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 12;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchPartition");
            }
            this.partition = _readable.readInt();
            this.currentLeaderEpoch = _version >= 9 ? _readable.readInt() : -1;
            this.fetchOffset = _readable.readLong();
            this.lastFetchedEpoch = _version >= 12 ? _readable.readInt() : -1;
            this.logStartOffset = _version >= 5 ? _readable.readLong() : -1L;
            this.partitionMaxBytes = _readable.readInt();
            this._unknownTaggedFields = null;
            if (_version >= 12) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partition);
            if (_version >= 9) {
                _writable.writeInt(this.currentLeaderEpoch);
            }
            _writable.writeLong(this.fetchOffset);
            if (_version >= 12) {
                _writable.writeInt(this.lastFetchedEpoch);
            } else if (this.lastFetchedEpoch != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default lastFetchedEpoch at version " + _version);
            }
            if (_version >= 5) {
                _writable.writeLong(this.logStartOffset);
            }
            _writable.writeInt(this.partitionMaxBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 12) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchPartition");
            }
            _size.addBytes(4);
            if (_version >= 9) {
                _size.addBytes(4);
            }
            _size.addBytes(8);
            if (_version >= 12) {
                _size.addBytes(4);
            }
            if (_version >= 5) {
                _size.addBytes(8);
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchPartition)) {
                return false;
            }
            FetchPartition other = (FetchPartition)obj;
            if (this.partition != other.partition) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            if (this.fetchOffset != other.fetchOffset) {
                return false;
            }
            if (this.lastFetchedEpoch != other.lastFetchedEpoch) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            if (this.partitionMaxBytes != other.partitionMaxBytes) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.fetchOffset >> 32) ^ (int)this.fetchOffset);
            hashCode = 31 * hashCode + this.lastFetchedEpoch;
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + this.partitionMaxBytes;
            return hashCode;
        }

        @Override
        public FetchPartition duplicate() {
            FetchPartition _duplicate = new FetchPartition();
            _duplicate.partition = this.partition;
            _duplicate.currentLeaderEpoch = this.currentLeaderEpoch;
            _duplicate.fetchOffset = this.fetchOffset;
            _duplicate.lastFetchedEpoch = this.lastFetchedEpoch;
            _duplicate.logStartOffset = this.logStartOffset;
            _duplicate.partitionMaxBytes = this.partitionMaxBytes;
            return _duplicate;
        }

        public String toString() {
            return "FetchPartition(partition=" + this.partition + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", fetchOffset=" + this.fetchOffset + ", lastFetchedEpoch=" + this.lastFetchedEpoch + ", logStartOffset=" + this.logStartOffset + ", partitionMaxBytes=" + this.partitionMaxBytes + ")";
        }

        public int partition() {
            return this.partition;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public long fetchOffset() {
            return this.fetchOffset;
        }

        public int lastFetchedEpoch() {
            return this.lastFetchedEpoch;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public int partitionMaxBytes() {
            return this.partitionMaxBytes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchPartition setPartition(int v) {
            this.partition = v;
            return this;
        }

        public FetchPartition setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public FetchPartition setFetchOffset(long v) {
            this.fetchOffset = v;
            return this;
        }

        public FetchPartition setLastFetchedEpoch(int v) {
            this.lastFetchedEpoch = v;
            return this;
        }

        public FetchPartition setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public FetchPartition setPartitionMaxBytes(int v) {
            this.partitionMaxBytes = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("fetch_offset", Type.INT64, "The message offset."), new Field("partition_max_bytes", Type.INT32, "The maximum bytes to fetch from this partition.  See KIP-74 for cases where this limit may not be honored.")))));
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("fetch_offset", Type.INT64, "The message offset."), new Field("log_start_offset", Type.INT64, "The earliest available offset of the follower replica.  The field is only used when the request is sent by the follower."), new Field("partition_max_bytes", Type.INT32, "The maximum bytes to fetch from this partition.  See KIP-74 for cases where this limit may not be honored."))));
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("current_leader_epoch", Type.INT32, "The current leader epoch of the partition."), new Field("fetch_offset", Type.INT64, "The message offset."), new Field("log_start_offset", Type.INT64, "The earliest available offset of the follower replica.  The field is only used when the request is sent by the follower."), new Field("partition_max_bytes", Type.INT32, "The maximum bytes to fetch from this partition.  See KIP-74 for cases where this limit may not be honored.")));
            SCHEMA_12 = new Schema(new Field("partition", Type.INT32, "The partition index."), new Field("current_leader_epoch", Type.INT32, "The current leader epoch of the partition."), new Field("fetch_offset", Type.INT64, "The message offset."), new Field("last_fetched_epoch", Type.INT32, "The epoch of the last fetched record or -1 if there is none"), new Field("log_start_offset", Type.INT64, "The earliest available offset of the follower replica.  The field is only used when the request is sent by the follower."), new Field("partition_max_bytes", Type.INT32, "The maximum bytes to fetch from this partition.  See KIP-74 for cases where this limit may not be honored."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
        }
    }

    public static class FetchTopic
    implements Message {
        String topic;
        List<FetchPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 12;

        public FetchTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public FetchTopic() {
            this.topic = "";
            this.partitions = new ArrayList<FetchPartition>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 12;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<FetchPartition> newCollection;
            int arrayLength;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchTopic");
            }
            int length = _version >= 12 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            if (_version >= 12) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new FetchPartition(_readable, _version));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                newCollection = new ArrayList<FetchPartition>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new FetchPartition(_readable, _version));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 12) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.topic);
            if (_version >= 12) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 12) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    FetchPartition partitionsElement = (FetchPartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    FetchPartition partitionsElement = (FetchPartition)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 12) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchTopic");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            if (_version >= 12) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (FetchPartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchTopic)) {
                return false;
            }
            FetchTopic other = (FetchTopic)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public FetchTopic duplicate() {
            FetchTopic _duplicate = new FetchTopic();
            _duplicate.topic = this.topic;
            ArrayList<FetchPartition> newPartitions = new ArrayList<FetchPartition>(this.partitions.size());
            for (FetchPartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "FetchTopic(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<FetchPartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchTopic setTopic(String v) {
            this.topic = v;
            return this;
        }

        public FetchTopic setPartitions(List<FetchPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The name of the topic to fetch."), new Field("partitions", new ArrayOf(FetchPartition.SCHEMA_0), "The partitions to fetch.")))));
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("topic", Type.STRING, "The name of the topic to fetch."), new Field("partitions", new ArrayOf(FetchPartition.SCHEMA_5), "The partitions to fetch."))));
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = new Schema(new Field("topic", Type.STRING, "The name of the topic to fetch."), new Field("partitions", new ArrayOf(FetchPartition.SCHEMA_9), "The partitions to fetch.")));
            SCHEMA_12 = new Schema(new Field("topic", Type.COMPACT_STRING, "The name of the topic to fetch."), new Field("partitions", new CompactArrayOf(FetchPartition.SCHEMA_12), "The partitions to fetch."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
        }
    }
}

