/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.coordinator.group.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue.*;

public class ConsumerGroupMemberMetadataValueJsonConverter {
    public static ConsumerGroupMemberMetadataValue read(JsonNode _node, short _version) {
        ConsumerGroupMemberMetadataValue _object = new ConsumerGroupMemberMetadataValue();
        JsonNode _instanceIdNode = _node.get("instanceId");
        if (_instanceIdNode == null) {
            throw new RuntimeException("ConsumerGroupMemberMetadataValue: unable to locate field 'instanceId', which is mandatory in version " + _version);
        } else {
            if (_instanceIdNode.isNull()) {
                _object.instanceId = null;
            } else {
                if (!_instanceIdNode.isTextual()) {
                    throw new RuntimeException("ConsumerGroupMemberMetadataValue expected a string type, but got " + _node.getNodeType());
                }
                _object.instanceId = _instanceIdNode.asText();
            }
        }
        JsonNode _rackIdNode = _node.get("rackId");
        if (_rackIdNode == null) {
            throw new RuntimeException("ConsumerGroupMemberMetadataValue: unable to locate field 'rackId', which is mandatory in version " + _version);
        } else {
            if (_rackIdNode.isNull()) {
                _object.rackId = null;
            } else {
                if (!_rackIdNode.isTextual()) {
                    throw new RuntimeException("ConsumerGroupMemberMetadataValue expected a string type, but got " + _node.getNodeType());
                }
                _object.rackId = _rackIdNode.asText();
            }
        }
        JsonNode _clientIdNode = _node.get("clientId");
        if (_clientIdNode == null) {
            throw new RuntimeException("ConsumerGroupMemberMetadataValue: unable to locate field 'clientId', which is mandatory in version " + _version);
        } else {
            if (!_clientIdNode.isTextual()) {
                throw new RuntimeException("ConsumerGroupMemberMetadataValue expected a string type, but got " + _node.getNodeType());
            }
            _object.clientId = _clientIdNode.asText();
        }
        JsonNode _clientHostNode = _node.get("clientHost");
        if (_clientHostNode == null) {
            throw new RuntimeException("ConsumerGroupMemberMetadataValue: unable to locate field 'clientHost', which is mandatory in version " + _version);
        } else {
            if (!_clientHostNode.isTextual()) {
                throw new RuntimeException("ConsumerGroupMemberMetadataValue expected a string type, but got " + _node.getNodeType());
            }
            _object.clientHost = _clientHostNode.asText();
        }
        JsonNode _subscribedTopicNamesNode = _node.get("subscribedTopicNames");
        if (_subscribedTopicNamesNode == null) {
            throw new RuntimeException("ConsumerGroupMemberMetadataValue: unable to locate field 'subscribedTopicNames', which is mandatory in version " + _version);
        } else {
            if (!_subscribedTopicNamesNode.isArray()) {
                throw new RuntimeException("ConsumerGroupMemberMetadataValue expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<String> _collection = new ArrayList<String>(_subscribedTopicNamesNode.size());
            _object.subscribedTopicNames = _collection;
            for (JsonNode _element : _subscribedTopicNamesNode) {
                if (!_element.isTextual()) {
                    throw new RuntimeException("ConsumerGroupMemberMetadataValue element expected a string type, but got " + _node.getNodeType());
                }
                _collection.add(_element.asText());
            }
        }
        JsonNode _subscribedTopicRegexNode = _node.get("subscribedTopicRegex");
        if (_subscribedTopicRegexNode == null) {
            throw new RuntimeException("ConsumerGroupMemberMetadataValue: unable to locate field 'subscribedTopicRegex', which is mandatory in version " + _version);
        } else {
            if (_subscribedTopicRegexNode.isNull()) {
                _object.subscribedTopicRegex = null;
            } else {
                if (!_subscribedTopicRegexNode.isTextual()) {
                    throw new RuntimeException("ConsumerGroupMemberMetadataValue expected a string type, but got " + _node.getNodeType());
                }
                _object.subscribedTopicRegex = _subscribedTopicRegexNode.asText();
            }
        }
        JsonNode _rebalanceTimeoutMsNode = _node.get("rebalanceTimeoutMs");
        if (_rebalanceTimeoutMsNode == null) {
            throw new RuntimeException("ConsumerGroupMemberMetadataValue: unable to locate field 'rebalanceTimeoutMs', which is mandatory in version " + _version);
        } else {
            _object.rebalanceTimeoutMs = MessageUtil.jsonNodeToInt(_rebalanceTimeoutMsNode, "ConsumerGroupMemberMetadataValue");
        }
        JsonNode _serverAssignorNode = _node.get("serverAssignor");
        if (_serverAssignorNode == null) {
            throw new RuntimeException("ConsumerGroupMemberMetadataValue: unable to locate field 'serverAssignor', which is mandatory in version " + _version);
        } else {
            if (_serverAssignorNode.isNull()) {
                _object.serverAssignor = null;
            } else {
                if (!_serverAssignorNode.isTextual()) {
                    throw new RuntimeException("ConsumerGroupMemberMetadataValue expected a string type, but got " + _node.getNodeType());
                }
                _object.serverAssignor = _serverAssignorNode.asText();
            }
        }
        JsonNode _classicMemberMetadataNode = _node.get("classicMemberMetadata");
        if (_classicMemberMetadataNode == null) {
            _object.classicMemberMetadata = new ClassicMemberMetadata();
        } else {
            if (_classicMemberMetadataNode.isNull()) {
                _object.classicMemberMetadata = null;
            } else {
                _object.classicMemberMetadata = ClassicMemberMetadataJsonConverter.read(_classicMemberMetadataNode, _version);
            }
        }
        return _object;
    }
    public static JsonNode write(ConsumerGroupMemberMetadataValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_object.instanceId == null) {
            _node.set("instanceId", NullNode.instance);
        } else {
            _node.set("instanceId", new TextNode(_object.instanceId));
        }
        if (_object.rackId == null) {
            _node.set("rackId", NullNode.instance);
        } else {
            _node.set("rackId", new TextNode(_object.rackId));
        }
        _node.set("clientId", new TextNode(_object.clientId));
        _node.set("clientHost", new TextNode(_object.clientHost));
        ArrayNode _subscribedTopicNamesArray = new ArrayNode(JsonNodeFactory.instance);
        for (String _element : _object.subscribedTopicNames) {
            _subscribedTopicNamesArray.add(new TextNode(_element));
        }
        _node.set("subscribedTopicNames", _subscribedTopicNamesArray);
        if (_object.subscribedTopicRegex == null) {
            _node.set("subscribedTopicRegex", NullNode.instance);
        } else {
            _node.set("subscribedTopicRegex", new TextNode(_object.subscribedTopicRegex));
        }
        _node.set("rebalanceTimeoutMs", new IntNode(_object.rebalanceTimeoutMs));
        if (_object.serverAssignor == null) {
            _node.set("serverAssignor", NullNode.instance);
        } else {
            _node.set("serverAssignor", new TextNode(_object.serverAssignor));
        }
        if (_object.classicMemberMetadata == null || !_object.classicMemberMetadata.equals(new ClassicMemberMetadata())) {
            if (_object.classicMemberMetadata == null) {
                _node.set("classicMemberMetadata", NullNode.instance);
            } else {
                _node.set("classicMemberMetadata", ClassicMemberMetadataJsonConverter.write(_object.classicMemberMetadata, _version, _serializeRecords));
            }
        }
        return _node;
    }
    public static JsonNode write(ConsumerGroupMemberMetadataValue _object, short _version) {
        return write(_object, _version, true);
    }
    
    public static class ClassicMemberMetadataJsonConverter {
        public static ClassicMemberMetadata read(JsonNode _node, short _version) {
            ClassicMemberMetadata _object = new ClassicMemberMetadata();
            JsonNode _sessionTimeoutMsNode = _node.get("sessionTimeoutMs");
            if (_sessionTimeoutMsNode == null) {
                throw new RuntimeException("ClassicMemberMetadata: unable to locate field 'sessionTimeoutMs', which is mandatory in version " + _version);
            } else {
                _object.sessionTimeoutMs = MessageUtil.jsonNodeToInt(_sessionTimeoutMsNode, "ClassicMemberMetadata");
            }
            JsonNode _supportedProtocolsNode = _node.get("supportedProtocols");
            if (_supportedProtocolsNode == null) {
                throw new RuntimeException("ClassicMemberMetadata: unable to locate field 'supportedProtocols', which is mandatory in version " + _version);
            } else {
                if (!_supportedProtocolsNode.isArray()) {
                    throw new RuntimeException("ClassicMemberMetadata expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<ClassicProtocol> _collection = new ArrayList<ClassicProtocol>(_supportedProtocolsNode.size());
                _object.supportedProtocols = _collection;
                for (JsonNode _element : _supportedProtocolsNode) {
                    _collection.add(ClassicProtocolJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }
        public static JsonNode write(ClassicMemberMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("sessionTimeoutMs", new IntNode(_object.sessionTimeoutMs));
            ArrayNode _supportedProtocolsArray = new ArrayNode(JsonNodeFactory.instance);
            for (ClassicProtocol _element : _object.supportedProtocols) {
                _supportedProtocolsArray.add(ClassicProtocolJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("supportedProtocols", _supportedProtocolsArray);
            return _node;
        }
        public static JsonNode write(ClassicMemberMetadata _object, short _version) {
            return write(_object, _version, true);
        }
    }
    
    public static class ClassicProtocolJsonConverter {
        public static ClassicProtocol read(JsonNode _node, short _version) {
            ClassicProtocol _object = new ClassicProtocol();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("ClassicProtocol: unable to locate field 'name', which is mandatory in version " + _version);
            } else {
                if (!_nameNode.isTextual()) {
                    throw new RuntimeException("ClassicProtocol expected a string type, but got " + _node.getNodeType());
                }
                _object.name = _nameNode.asText();
            }
            JsonNode _metadataNode = _node.get("metadata");
            if (_metadataNode == null) {
                throw new RuntimeException("ClassicProtocol: unable to locate field 'metadata', which is mandatory in version " + _version);
            } else {
                _object.metadata = MessageUtil.jsonNodeToBinary(_metadataNode, "ClassicProtocol");
            }
            return _object;
        }
        public static JsonNode write(ClassicProtocol _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", new TextNode(_object.name));
            _node.set("metadata", new BinaryNode(Arrays.copyOf(_object.metadata, _object.metadata.length)));
            return _node;
        }
        public static JsonNode write(ClassicProtocol _object, short _version) {
            return write(_object, _version, true);
        }
    }
}
