/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.coordinator.group.generated;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.MessageUtil;

import static org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue.*;

public class ConsumerGroupPartitionMetadataValueJsonConverter {
    public static ConsumerGroupPartitionMetadataValue read(JsonNode _node, short _version) {
        ConsumerGroupPartitionMetadataValue _object = new ConsumerGroupPartitionMetadataValue();
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("ConsumerGroupPartitionMetadataValue: unable to locate field 'topics', which is mandatory in version " + _version);
        } else {
            if (!_topicsNode.isArray()) {
                throw new RuntimeException("ConsumerGroupPartitionMetadataValue expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<TopicMetadata> _collection = new ArrayList<TopicMetadata>(_topicsNode.size());
            _object.topics = _collection;
            for (JsonNode _element : _topicsNode) {
                _collection.add(TopicMetadataJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }
    public static JsonNode write(ConsumerGroupPartitionMetadataValue _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (TopicMetadata _element : _object.topics) {
            _topicsArray.add(TopicMetadataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", _topicsArray);
        return _node;
    }
    public static JsonNode write(ConsumerGroupPartitionMetadataValue _object, short _version) {
        return write(_object, _version, true);
    }
    
    public static class PartitionMetadataJsonConverter {
        public static PartitionMetadata read(JsonNode _node, short _version) {
            PartitionMetadata _object = new PartitionMetadata();
            JsonNode _partitionNode = _node.get("partition");
            if (_partitionNode == null) {
                throw new RuntimeException("PartitionMetadata: unable to locate field 'partition', which is mandatory in version " + _version);
            } else {
                _object.partition = MessageUtil.jsonNodeToInt(_partitionNode, "PartitionMetadata");
            }
            JsonNode _racksNode = _node.get("racks");
            if (_racksNode == null) {
                throw new RuntimeException("PartitionMetadata: unable to locate field 'racks', which is mandatory in version " + _version);
            } else {
                if (!_racksNode.isArray()) {
                    throw new RuntimeException("PartitionMetadata expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<String> _collection = new ArrayList<String>(_racksNode.size());
                _object.racks = _collection;
                for (JsonNode _element : _racksNode) {
                    if (!_element.isTextual()) {
                        throw new RuntimeException("PartitionMetadata element expected a string type, but got " + _node.getNodeType());
                    }
                    _collection.add(_element.asText());
                }
            }
            return _object;
        }
        public static JsonNode write(PartitionMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partition", new IntNode(_object.partition));
            ArrayNode _racksArray = new ArrayNode(JsonNodeFactory.instance);
            for (String _element : _object.racks) {
                _racksArray.add(new TextNode(_element));
            }
            _node.set("racks", _racksArray);
            return _node;
        }
        public static JsonNode write(PartitionMetadata _object, short _version) {
            return write(_object, _version, true);
        }
    }
    
    public static class TopicMetadataJsonConverter {
        public static TopicMetadata read(JsonNode _node, short _version) {
            TopicMetadata _object = new TopicMetadata();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("TopicMetadata: unable to locate field 'topicId', which is mandatory in version " + _version);
            } else {
                if (!_topicIdNode.isTextual()) {
                    throw new RuntimeException("TopicMetadata expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.topicId = Uuid.fromString(_topicIdNode.asText());
            }
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("TopicMetadata: unable to locate field 'topicName', which is mandatory in version " + _version);
            } else {
                if (!_topicNameNode.isTextual()) {
                    throw new RuntimeException("TopicMetadata expected a string type, but got " + _node.getNodeType());
                }
                _object.topicName = _topicNameNode.asText();
            }
            JsonNode _numPartitionsNode = _node.get("numPartitions");
            if (_numPartitionsNode == null) {
                throw new RuntimeException("TopicMetadata: unable to locate field 'numPartitions', which is mandatory in version " + _version);
            } else {
                _object.numPartitions = MessageUtil.jsonNodeToInt(_numPartitionsNode, "TopicMetadata");
            }
            JsonNode _partitionMetadataNode = _node.get("partitionMetadata");
            if (_partitionMetadataNode == null) {
                throw new RuntimeException("TopicMetadata: unable to locate field 'partitionMetadata', which is mandatory in version " + _version);
            } else {
                if (!_partitionMetadataNode.isArray()) {
                    throw new RuntimeException("TopicMetadata expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<PartitionMetadata> _collection = new ArrayList<PartitionMetadata>(_partitionMetadataNode.size());
                _object.partitionMetadata = _collection;
                for (JsonNode _element : _partitionMetadataNode) {
                    _collection.add(PartitionMetadataJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }
        public static JsonNode write(TopicMetadata _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", new TextNode(_object.topicId.toString()));
            _node.set("topicName", new TextNode(_object.topicName));
            _node.set("numPartitions", new IntNode(_object.numPartitions));
            ArrayNode _partitionMetadataArray = new ArrayNode(JsonNodeFactory.instance);
            for (PartitionMetadata _element : _object.partitionMetadata) {
                _partitionMetadataArray.add(PartitionMetadataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitionMetadata", _partitionMetadataArray);
            return _node;
        }
        public static JsonNode write(TopicMetadata _object, short _version) {
            return write(_object, _version, true);
        }
    }
}
