/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// THIS CODE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.

package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

import static org.apache.kafka.common.protocol.types.Field.TaggedFieldsSection;


public class ShareGroupMemberMetadataValue implements ApiMessage {
    String rackId;
    String clientId;
    String clientHost;
    List<String> subscribedTopicNames;
    private List<RawTaggedField> _unknownTaggedFields;
    
    public static final Schema SCHEMA_0 =
        new Schema(
            new Field("rack_id", Type.COMPACT_NULLABLE_STRING, "The (optional) rack id."),
            new Field("client_id", Type.COMPACT_STRING, "The client id."),
            new Field("client_host", Type.COMPACT_STRING, "The client host."),
            new Field("subscribed_topic_names", new CompactArrayOf(Type.COMPACT_STRING), "The list of subscribed topic names."),
            TaggedFieldsSection.of(
            )
        );
    
    public static final Schema[] SCHEMAS = new Schema[] {
        SCHEMA_0
    };
    
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;
    
    public ShareGroupMemberMetadataValue(Readable _readable, short _version) {
        read(_readable, _version);
    }
    
    public ShareGroupMemberMetadataValue() {
        this.rackId = "";
        this.clientId = "";
        this.clientHost = "";
        this.subscribedTopicNames = new ArrayList<String>(0);
    }
    
    @Override
    public short apiKey() {
        return -1;
    }
    
    @Override
    public short lowestSupportedVersion() {
        return 0;
    }
    
    @Override
    public short highestSupportedVersion() {
        return 0;
    }
    
    @Override
    public final void read(Readable _readable, short _version) {
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.rackId = null;
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            } else {
                this.rackId = _readable.readString(length);
            }
        }
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientId was serialized as null");
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field clientId had invalid length " + length);
            } else {
                this.clientId = _readable.readString(length);
            }
        }
        {
            int length;
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field clientHost was serialized as null");
            } else if (length > 0x7fff) {
                throw new RuntimeException("string field clientHost had invalid length " + length);
            } else {
                this.clientHost = _readable.readString(length);
            }
        }
        {
            int arrayLength;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field subscribedTopicNames was serialized as null");
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<String> newCollection = new ArrayList<>(arrayLength);
                for (int i = 0; i < arrayLength; i++) {
                    int length;
                    length = _readable.readUnsignedVarint() - 1;
                    if (length < 0) {
                        throw new RuntimeException("non-nullable field subscribedTopicNames element was serialized as null");
                    } else if (length > 0x7fff) {
                        throw new RuntimeException("string field subscribedTopicNames element had invalid length " + length);
                    } else {
                        newCollection.add(_readable.readString(length));
                    }
                }
                this.subscribedTopicNames = newCollection;
            }
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; _i++) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default:
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    break;
            }
        }
    }
    
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (rackId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue(rackId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        {
            byte[] _stringBytes = _cache.getSerializedValue(clientId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        {
            byte[] _stringBytes = _cache.getSerializedValue(clientHost);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeUnsignedVarint(subscribedTopicNames.size() + 1);
        for (String subscribedTopicNamesElement : subscribedTopicNames) {
            {
                byte[] _stringBytes = _cache.getSerializedValue(subscribedTopicNamesElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(_unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        _writable.writeUnsignedVarint(_numTaggedFields);
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }
    
    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (rackId == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = rackId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(rackId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        {
            byte[] _stringBytes = clientId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'clientId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(clientId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        {
            byte[] _stringBytes = clientHost.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > 0x7fff) {
                throw new RuntimeException("'clientHost' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(clientHost, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(subscribedTopicNames.size() + 1));
            for (String subscribedTopicNamesElement : subscribedTopicNames) {
                byte[] _stringBytes = subscribedTopicNamesElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > 0x7fff) {
                    throw new RuntimeException("'subscribedTopicNamesElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(subscribedTopicNamesElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
        }
        if (_unknownTaggedFields != null) {
            _numTaggedFields += _unknownTaggedFields.size();
            for (RawTaggedField _field : _unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ShareGroupMemberMetadataValue)) return false;
        ShareGroupMemberMetadataValue other = (ShareGroupMemberMetadataValue) obj;
        if (this.rackId == null) {
            if (other.rackId != null) return false;
        } else {
            if (!this.rackId.equals(other.rackId)) return false;
        }
        if (this.clientId == null) {
            if (other.clientId != null) return false;
        } else {
            if (!this.clientId.equals(other.clientId)) return false;
        }
        if (this.clientHost == null) {
            if (other.clientHost != null) return false;
        } else {
            if (!this.clientHost.equals(other.clientHost)) return false;
        }
        if (this.subscribedTopicNames == null) {
            if (other.subscribedTopicNames != null) return false;
        } else {
            if (!this.subscribedTopicNames.equals(other.subscribedTopicNames)) return false;
        }
        return MessageUtil.compareRawTaggedFields(_unknownTaggedFields, other._unknownTaggedFields);
    }
    
    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (rackId == null ? 0 : rackId.hashCode());
        hashCode = 31 * hashCode + (clientId == null ? 0 : clientId.hashCode());
        hashCode = 31 * hashCode + (clientHost == null ? 0 : clientHost.hashCode());
        hashCode = 31 * hashCode + (subscribedTopicNames == null ? 0 : subscribedTopicNames.hashCode());
        return hashCode;
    }
    
    @Override
    public ShareGroupMemberMetadataValue duplicate() {
        ShareGroupMemberMetadataValue _duplicate = new ShareGroupMemberMetadataValue();
        if (rackId == null) {
            _duplicate.rackId = null;
        } else {
            _duplicate.rackId = rackId;
        }
        _duplicate.clientId = clientId;
        _duplicate.clientHost = clientHost;
        ArrayList<String> newSubscribedTopicNames = new ArrayList<String>(subscribedTopicNames.size());
        for (String _element : subscribedTopicNames) {
            newSubscribedTopicNames.add(_element);
        }
        _duplicate.subscribedTopicNames = newSubscribedTopicNames;
        return _duplicate;
    }
    
    @Override
    public String toString() {
        return "ShareGroupMemberMetadataValue("
            + "rackId=" + ((rackId == null) ? "null" : "'" + rackId.toString() + "'")
            + ", clientId=" + ((clientId == null) ? "null" : "'" + clientId.toString() + "'")
            + ", clientHost=" + ((clientHost == null) ? "null" : "'" + clientHost.toString() + "'")
            + ", subscribedTopicNames=" + MessageUtil.deepToString(subscribedTopicNames.iterator())
            + ")";
    }
    
    public String rackId() {
        return this.rackId;
    }
    
    public String clientId() {
        return this.clientId;
    }
    
    public String clientHost() {
        return this.clientHost;
    }
    
    public List<String> subscribedTopicNames() {
        return this.subscribedTopicNames;
    }
    
    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (_unknownTaggedFields == null) {
            _unknownTaggedFields = new ArrayList<>(0);
        }
        return _unknownTaggedFields;
    }
    
    public ShareGroupMemberMetadataValue setRackId(String v) {
        this.rackId = v;
        return this;
    }
    
    public ShareGroupMemberMetadataValue setClientId(String v) {
        this.clientId = v;
        return this;
    }
    
    public ShareGroupMemberMetadataValue setClientHost(String v) {
        this.clientHost = v;
        return this;
    }
    
    public ShareGroupMemberMetadataValue setSubscribedTopicNames(List<String> v) {
        this.subscribedTopicNames = v;
        return this;
    }
}
