/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.RemoveFeatureLevelRecord;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.metadata.VersionRange;

public final class FeaturesDelta {
    private final FeaturesImage image;
    private final Map<String, Optional<VersionRange>> changes = new HashMap<String, Optional<VersionRange>>();

    public FeaturesDelta(FeaturesImage image) {
        this.image = image;
    }

    public Map<String, Optional<VersionRange>> changes() {
        return this.changes;
    }

    public void finishSnapshot() {
        for (String featureName : this.image.finalizedVersions().keySet()) {
            if (this.changes.containsKey(featureName)) continue;
            this.changes.put(featureName, Optional.empty());
        }
    }

    public void replay(FeatureLevelRecord record) {
        this.changes.put(record.name(), Optional.of(new VersionRange(record.minFeatureLevel(), record.maxFeatureLevel())));
    }

    public void replay(RemoveFeatureLevelRecord record) {
        this.changes.put(record.name(), Optional.empty());
    }

    public FeaturesImage apply() {
        Optional change;
        String name;
        HashMap<String, VersionRange> newFinalizedVersions = new HashMap<String, VersionRange>(this.image.finalizedVersions().size());
        for (Map.Entry<String, VersionRange> entry : this.image.finalizedVersions().entrySet()) {
            name = entry.getKey();
            change = this.changes.get(name);
            if (change == null) {
                newFinalizedVersions.put(name, entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newFinalizedVersions.put(name, (VersionRange)change.get());
        }
        for (Map.Entry<String, Object> entry : this.changes.entrySet()) {
            name = entry.getKey();
            change = (Optional)entry.getValue();
            if (newFinalizedVersions.containsKey(name) || !change.isPresent()) continue;
            newFinalizedVersions.put(name, (VersionRange)change.get());
        }
        return new FeaturesImage(newFinalizedVersions);
    }
}

