/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public final class FeaturesImage {
    public static final FeaturesImage EMPTY = new FeaturesImage(Collections.emptyMap());
    private final Map<String, VersionRange> finalizedVersions;

    public FeaturesImage(Map<String, VersionRange> finalizedVersions) {
        this.finalizedVersions = Collections.unmodifiableMap(finalizedVersions);
    }

    public boolean isEmpty() {
        return this.finalizedVersions.isEmpty();
    }

    Map<String, VersionRange> finalizedVersions() {
        return this.finalizedVersions;
    }

    private Optional<VersionRange> finalizedVersion(String feature) {
        return Optional.ofNullable(this.finalizedVersions.get(feature));
    }

    public void write(Consumer<List<ApiMessageAndVersion>> out) {
        ArrayList<ApiMessageAndVersion> batch = new ArrayList<ApiMessageAndVersion>();
        for (Map.Entry<String, VersionRange> entry : this.finalizedVersions.entrySet()) {
            batch.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(entry.getKey()).setMinFeatureLevel(entry.getValue().min()).setMaxFeatureLevel(entry.getValue().max()), MetadataRecordType.FEATURE_LEVEL_RECORD.highestSupportedVersion()));
        }
        out.accept(batch);
    }

    public int hashCode() {
        return this.finalizedVersions.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeaturesImage)) {
            return false;
        }
        FeaturesImage other = (FeaturesImage)o;
        return this.finalizedVersions.equals(other.finalizedVersions);
    }

    public String toString() {
        return this.finalizedVersions.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(", "));
    }
}

