/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.message.AssignReplicasToDirsRequestData;
import org.apache.kafka.common.message.AssignReplicasToDirsResponseData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.ControllerRegistrationRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenRequestData;
import org.apache.kafka.common.message.CreateDelegationTokenResponseData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.ExpireDelegationTokenRequestData;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.ListPartitionReassignmentsResponseData;
import org.apache.kafka.common.message.RenewDelegationTokenRequestData;
import org.apache.kafka.common.message.RenewDelegationTokenResponseData;
import org.apache.kafka.common.message.UpdateFeaturesRequestData;
import org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.metadata.BrokerHeartbeatReply;
import org.apache.kafka.metadata.BrokerRegistrationReply;
import org.apache.kafka.metadata.FinalizedControllerFeatures;
import org.apache.kafka.metadata.authorizer.AclMutator;

public interface Controller
extends AclMutator,
AutoCloseable {
    public CompletableFuture<AlterPartitionResponseData> alterPartition(ControllerRequestContext var1, AlterPartitionRequestData var2);

    public CompletableFuture<AlterUserScramCredentialsResponseData> alterUserScramCredentials(ControllerRequestContext var1, AlterUserScramCredentialsRequestData var2);

    public CompletableFuture<CreateDelegationTokenResponseData> createDelegationToken(ControllerRequestContext var1, CreateDelegationTokenRequestData var2);

    public CompletableFuture<RenewDelegationTokenResponseData> renewDelegationToken(ControllerRequestContext var1, RenewDelegationTokenRequestData var2);

    public CompletableFuture<ExpireDelegationTokenResponseData> expireDelegationToken(ControllerRequestContext var1, ExpireDelegationTokenRequestData var2);

    public CompletableFuture<CreateTopicsResponseData> createTopics(ControllerRequestContext var1, CreateTopicsRequestData var2, Set<String> var3);

    public CompletableFuture<Void> unregisterBroker(ControllerRequestContext var1, int var2);

    public CompletableFuture<Map<String, ResultOrError<Uuid>>> findTopicIds(ControllerRequestContext var1, Collection<String> var2);

    public CompletableFuture<Map<String, Uuid>> findAllTopicIds(ControllerRequestContext var1);

    public CompletableFuture<Map<Uuid, ResultOrError<String>>> findTopicNames(ControllerRequestContext var1, Collection<Uuid> var2);

    public CompletableFuture<Map<Uuid, ApiError>> deleteTopics(ControllerRequestContext var1, Collection<Uuid> var2);

    public CompletableFuture<Map<ConfigResource, ResultOrError<Map<String, String>>>> describeConfigs(ControllerRequestContext var1, Map<ConfigResource, Collection<String>> var2);

    public CompletableFuture<ElectLeadersResponseData> electLeaders(ControllerRequestContext var1, ElectLeadersRequestData var2);

    public CompletableFuture<FinalizedControllerFeatures> finalizedFeatures(ControllerRequestContext var1);

    public CompletableFuture<Map<ConfigResource, ApiError>> incrementalAlterConfigs(ControllerRequestContext var1, Map<ConfigResource, Map<String, Map.Entry<AlterConfigOp.OpType, String>>> var2, boolean var3);

    public CompletableFuture<AlterPartitionReassignmentsResponseData> alterPartitionReassignments(ControllerRequestContext var1, AlterPartitionReassignmentsRequestData var2);

    public CompletableFuture<ListPartitionReassignmentsResponseData> listPartitionReassignments(ControllerRequestContext var1, ListPartitionReassignmentsRequestData var2);

    public CompletableFuture<Map<ConfigResource, ApiError>> legacyAlterConfigs(ControllerRequestContext var1, Map<ConfigResource, Map<String, String>> var2, boolean var3);

    public CompletableFuture<BrokerHeartbeatReply> processBrokerHeartbeat(ControllerRequestContext var1, BrokerHeartbeatRequestData var2);

    public CompletableFuture<BrokerRegistrationReply> registerBroker(ControllerRequestContext var1, BrokerRegistrationRequestData var2);

    public CompletableFuture<Void> waitForReadyBrokers(int var1);

    public CompletableFuture<Map<ClientQuotaEntity, ApiError>> alterClientQuotas(ControllerRequestContext var1, Collection<ClientQuotaAlteration> var2, boolean var3);

    public CompletableFuture<AllocateProducerIdsResponseData> allocateProducerIds(ControllerRequestContext var1, AllocateProducerIdsRequestData var2);

    public CompletableFuture<UpdateFeaturesResponseData> updateFeatures(ControllerRequestContext var1, UpdateFeaturesRequestData var2);

    public CompletableFuture<List<CreatePartitionsResponseData.CreatePartitionsTopicResult>> createPartitions(ControllerRequestContext var1, List<CreatePartitionsRequestData.CreatePartitionsTopic> var2, boolean var3);

    public CompletableFuture<Void> registerController(ControllerRequestContext var1, ControllerRegistrationRequestData var2);

    public CompletableFuture<AssignReplicasToDirsResponseData> assignReplicasToDirs(ControllerRequestContext var1, AssignReplicasToDirsRequestData var2);

    public void beginShutdown();

    public int curClaimEpoch();

    default public boolean isActive() {
        return this.curClaimEpoch() != -1;
    }

    @Override
    public void close() throws InterruptedException;
}

