/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;

public final class FileRawSnapshotWriter
implements RawSnapshotWriter {
    private final Path tempSnapshotPath;
    private final FileChannel channel;
    private final OffsetAndEpoch snapshotId;
    private final Optional<ReplicatedLog> replicatedLog;
    private boolean frozen = false;

    private FileRawSnapshotWriter(Path tempSnapshotPath, FileChannel channel, OffsetAndEpoch snapshotId, Optional<ReplicatedLog> replicatedLog) {
        this.tempSnapshotPath = tempSnapshotPath;
        this.channel = channel;
        this.snapshotId = snapshotId;
        this.replicatedLog = replicatedLog;
    }

    @Override
    public OffsetAndEpoch snapshotId() {
        return this.snapshotId;
    }

    @Override
    public long sizeInBytes() {
        try {
            return this.channel.size();
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error calculating snapshot size. temp path = %s, snapshotId = %s.", this.tempSnapshotPath, this.snapshotId), e);
        }
    }

    @Override
    public void append(UnalignedMemoryRecords records) {
        try {
            this.checkIfFrozen("Append");
            Utils.writeFully((FileChannel)this.channel, (ByteBuffer)records.buffer());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error writing file snapshot, temp path = %s, snapshotId = %s.", this.tempSnapshotPath, this.snapshotId), e);
        }
    }

    @Override
    public void append(MemoryRecords records) {
        try {
            this.checkIfFrozen("Append");
            Utils.writeFully((FileChannel)this.channel, (ByteBuffer)records.buffer());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error writing file snapshot, temp path = %s, snapshotId = %s.", this.tempSnapshotPath, this.snapshotId), e);
        }
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public void freeze() {
        try {
            this.checkIfFrozen("Freeze");
            this.channel.close();
            this.frozen = true;
            if (!this.tempSnapshotPath.toFile().setReadOnly()) {
                throw new IllegalStateException(String.format("Unable to set file (%s) as read-only", this.tempSnapshotPath));
            }
            Path destination = Snapshots.moveRename(this.tempSnapshotPath, this.snapshotId);
            Utils.atomicMoveWithFallback((Path)this.tempSnapshotPath, (Path)destination);
            this.replicatedLog.ifPresent(log -> log.onSnapshotFrozen(this.snapshotId));
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error freezing file snapshot, temp path = %s, snapshotId = %s.", this.tempSnapshotPath, this.snapshotId), e);
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
            Files.deleteIfExists(this.tempSnapshotPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error closing snapshot writer, temp path = %s, snapshotId %s.", this.tempSnapshotPath, this.snapshotId), e);
        }
    }

    public String toString() {
        return String.format("FileRawSnapshotWriter(path=%s, snapshotId=%s, frozen=%s)", this.tempSnapshotPath, this.snapshotId, this.frozen);
    }

    void checkIfFrozen(String operation) {
        if (this.frozen) {
            throw new IllegalStateException(String.format("%s is not supported. Snapshot is already frozen: id = %s; temp path = %s", operation, this.snapshotId, this.tempSnapshotPath));
        }
    }

    public static FileRawSnapshotWriter create(Path logDir, OffsetAndEpoch snapshotId, Optional<ReplicatedLog> replicatedLog) {
        Path path = Snapshots.createTempFile(logDir, snapshotId);
        try {
            return new FileRawSnapshotWriter(path, FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.APPEND), snapshotId, replicatedLog);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error creating snapshot writer. path = %s, snapshotId %s.", path, snapshotId), e);
        }
    }
}

