/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.immutable.pcollections;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.server.immutable.DelegationChecker;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.immutable.pcollections.PCollectionsImmutableMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.pcollections.AbstractUnmodifiableMap;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;

public class PCollectionsImmutableMapTest {
    private static final HashPMap<Object, Object> SINGLETON_MAP = HashTreePMap.singleton((Object)new Object(), (Object)new Object());

    @Test
    public void testEmptyMap() {
        Assertions.assertEquals((Object)HashTreePMap.empty(), (Object)((PCollectionsImmutableMap)ImmutableMap.empty()).underlying());
    }

    @Test
    public void testSingletonMap() {
        Assertions.assertEquals((Object)HashTreePMap.singleton((Object)1, (Object)2), (Object)((PCollectionsImmutableMap)ImmutableMap.singleton((Object)1, (Object)2)).underlying());
    }

    @Test
    public void testUnderlying() {
        Assertions.assertSame(SINGLETON_MAP, (Object)new PCollectionsImmutableMap(SINGLETON_MAP).underlying());
    }

    @Test
    public void testDelegationOfUpdated() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.plus(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this)), SINGLETON_MAP).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.updated((Object)this, (Object)this), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfRemoved() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.minus(ArgumentMatchers.eq((Object)this)), SINGLETON_MAP).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.removed((Object)this), Function.identity()).expectWrapperToWrapMockFunctionReturnValue().doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2})
    public void testDelegationOfSize(int mockFunctionReturnValue) {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(HashPMap::size, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableMap::size, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfIsEmpty(boolean mockFunctionReturnValue) {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractMap::isEmpty, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableMap::isEmpty, Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfContainsKey(boolean mockFunctionReturnValue) {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.containsKey(ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.containsKey((Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfContainsValue(boolean mockFunctionReturnValue) {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.containsValue(ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.containsValue((Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfGet() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.get(ArgumentMatchers.eq((Object)this)), new Object()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.get((Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPut() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.put(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.put((Object)this, (Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionRemoveByKey() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.remove(ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.remove((Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPutAll() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(mock -> mock.putAll((Map)ArgumentMatchers.eq(Collections.emptyMap()))).defineWrapperVoidMethodInvocation(wrapper -> wrapper.putAll(Collections.emptyMap())).doUnsupportedVoidFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionClear() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(AbstractUnmodifiableMap::clear).defineWrapperVoidMethodInvocation(PCollectionsImmutableMap::clear).doUnsupportedVoidFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfKeySet() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractMap::keySet, Collections.emptySet()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableMap::keySet, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfValues() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractMap::values, Collections.emptySet()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableMap::values, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfEntrySet() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(HashPMap::entrySet, Collections.emptySet()).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableMap::entrySet, Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testEquals() {
        HashPMap mock = (HashPMap)Mockito.mock(HashPMap.class);
        Assertions.assertEquals((Object)new PCollectionsImmutableMap(mock), (Object)new PCollectionsImmutableMap(mock));
        HashPMap someOtherMock = (HashPMap)Mockito.mock(HashPMap.class);
        Assertions.assertNotEquals((Object)new PCollectionsImmutableMap(mock), (Object)new PCollectionsImmutableMap(someOtherMock));
    }

    @Test
    public void testHashCode() {
        HashPMap mock = (HashPMap)Mockito.mock(HashPMap.class);
        Assertions.assertEquals((int)mock.hashCode(), (int)new PCollectionsImmutableMap(mock).hashCode());
        HashPMap someOtherMock = (HashPMap)Mockito.mock(HashPMap.class);
        Assertions.assertNotEquals((int)mock.hashCode(), (int)new PCollectionsImmutableMap(someOtherMock).hashCode());
    }

    @Test
    public void testDelegationOfGetOrDefault() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.getOrDefault(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this)), this).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.getOrDefault((Object)this, (Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfForEach() {
        BiConsumer mockBiConsumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(mock -> mock.forEach((BiConsumer)ArgumentMatchers.eq((Object)mockBiConsumer))).defineWrapperVoidMethodInvocation(wrapper -> wrapper.forEach(mockBiConsumer)).doVoidMethodDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionReplaceAll() {
        BiFunction mockBiFunction = (BiFunction)Mockito.mock(BiFunction.class);
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForVoidMethodInvocation(mock -> mock.replaceAll((BiFunction)ArgumentMatchers.eq((Object)mockBiFunction))).defineWrapperVoidMethodInvocation(wrapper -> wrapper.replaceAll(mockBiFunction)).doUnsupportedVoidFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionPutIfAbsent() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.putIfAbsent(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.putIfAbsent((Object)this, (Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfUnsupportedFunctionRemoveByKeyAndValue(boolean mockFunctionReturnValue) {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.remove(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.remove((Object)this, (Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDelegationOfUnsupportedFunctionReplaceWhenMappedToSpecificValue(boolean mockFunctionReturnValue) {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(mock -> mock.replace(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this)), mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(wrapper -> wrapper.replace((Object)this, (Object)this, (Object)this), Function.identity()).doFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionReplaceWhenMappedToAnyValue() {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.replace(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.replace((Object)this, (Object)this)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionComputeIfAbsent() {
        Function mockFunction = (Function)Mockito.mock(Function.class);
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.computeIfAbsent(ArgumentMatchers.eq((Object)this), (Function)ArgumentMatchers.eq((Object)mockFunction))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.computeIfAbsent((Object)this, mockFunction)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionComputeIfPresent() {
        BiFunction mockBiFunction = (BiFunction)Mockito.mock(BiFunction.class);
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.computeIfPresent(ArgumentMatchers.eq((Object)this), (BiFunction)ArgumentMatchers.eq((Object)mockBiFunction))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.computeIfPresent((Object)this, mockBiFunction)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionCompute() {
        BiFunction mockBiFunction = (BiFunction)Mockito.mock(BiFunction.class);
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.compute(ArgumentMatchers.eq((Object)this), (BiFunction)ArgumentMatchers.eq((Object)mockBiFunction))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.compute((Object)this, mockBiFunction)).doUnsupportedFunctionDelegationCheck();
    }

    @Test
    public void testDelegationOfUnsupportedFunctionMerge() {
        BiFunction mockBiFunction = (BiFunction)Mockito.mock(BiFunction.class);
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForUnsupportedFunction(mock -> mock.merge(ArgumentMatchers.eq((Object)this), ArgumentMatchers.eq((Object)this), (BiFunction)ArgumentMatchers.eq((Object)mockBiFunction))).defineWrapperUnsupportedFunctionInvocation(wrapper -> wrapper.merge((Object)this, (Object)this, mockBiFunction)).doUnsupportedFunctionDelegationCheck();
    }

    @ParameterizedTest
    @ValueSource(strings={"a", "b"})
    public void testDelegationOfToString(String mockFunctionReturnValue) {
        new PCollectionsHashMapWrapperDelegationChecker().defineMockConfigurationForFunctionInvocation(AbstractMap::toString, mockFunctionReturnValue).defineWrapperFunctionInvocationAndMockReturnValueTransformation(PCollectionsImmutableMap::toString, text -> "PCollectionsImmutableMap{underlying=" + text + "}").doFunctionDelegationCheck();
    }

    private static final class PCollectionsHashMapWrapperDelegationChecker<R>
    extends DelegationChecker<HashPMap<Object, Object>, PCollectionsImmutableMap<Object, Object>, R> {
        public PCollectionsHashMapWrapperDelegationChecker() {
            super(Mockito.mock(HashPMap.class), PCollectionsImmutableMap::new);
        }

        @Override
        public HashPMap<Object, Object> unwrap(PCollectionsImmutableMap<Object, Object> wrapper) {
            return wrapper.underlying();
        }
    }
}

