/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.streams.kstream.internals.StreamSinkNode;
import org.apache.kafka.streams.kstream.internals.StreamsGraphNode;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamsTopologyGraph {
    private static final Logger LOG = LoggerFactory.getLogger(StreamsTopologyGraph.class);
    public static final String TOPOLOGY_ROOT = "root";
    protected final StreamsGraphNode root = new StreamsGraphNode(null, "root", false){

        @Override
        void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        }
    };
    private final AtomicInteger nodeIdCounter = new AtomicInteger(0);
    private final Map<StreamsGraphNode, Set<StreamsGraphNode>> repartitioningNodeToRepartitioned = new HashMap<StreamsGraphNode, Set<StreamsGraphNode>>();
    private final Map<StreamsGraphNode, StreamSinkNode> stateStoreNodeToSinkNodes = new HashMap<StreamsGraphNode, StreamSinkNode>();
    private final Map<String, StreamsGraphNode> nameToGraphNode = new HashMap<String, StreamsGraphNode>();
    private StreamsGraphNode previousNode;

    StreamsTopologyGraph() {
        this.nameToGraphNode.put(TOPOLOGY_ROOT, this.root);
    }

    public void addNode(StreamsGraphNode node) {
        node.setId(this.nodeIdCounter.getAndIncrement());
        if (node.parentProcessorNodeName() == null && !node.processorNodeName().equals(TOPOLOGY_ROOT)) {
            LOG.warn("Updating node {} with predecessor name {}", (Object)node, (Object)this.previousNode.processorNodeName());
            node.setParentProcessorNodeName(this.previousNode.processorNodeName());
        }
        LOG.debug("Adding node {}", (Object)node);
        StreamsGraphNode predecessorNode = this.nameToGraphNode.get(node.parentProcessorNodeName());
        if (predecessorNode == null) {
            throw new IllegalStateException("Nodes should not have a null predecessor.  Name: " + node.processorNodeName() + " Type: " + node.getClass().getSimpleName() + " predecessor name " + node.parentProcessorNodeName());
        }
        node.setParentNode(predecessorNode);
        predecessorNode.addChildNode(node);
        if (node.triggersRepartitioning()) {
            this.repartitioningNodeToRepartitioned.put(node, new HashSet());
        } else if (node.repartitionRequired()) {
            StreamsGraphNode currentNode = node;
            while (currentNode != null) {
                StreamsGraphNode parentNode = currentNode.parentNode();
                if (parentNode.triggersRepartitioning()) {
                    this.repartitioningNodeToRepartitioned.get(parentNode).add(node);
                    break;
                }
                currentNode = parentNode.parentNode();
            }
        }
        if (!this.nameToGraphNode.containsKey(node.processorNodeName())) {
            this.nameToGraphNode.put(node.processorNodeName(), node);
        }
        this.previousNode = node;
    }

    public StreamsGraphNode getRoot() {
        return this.root;
    }

    public Map<StreamsGraphNode, Set<StreamsGraphNode>> getRepartitioningNodeToRepartitioned() {
        HashMap<StreamsGraphNode, Set<StreamsGraphNode>> copy = new HashMap<StreamsGraphNode, Set<StreamsGraphNode>>(this.repartitioningNodeToRepartitioned);
        return Collections.unmodifiableMap(copy);
    }

    public Map<StreamsGraphNode, StreamSinkNode> getStateStoreNodeToSinkNodes() {
        HashMap<StreamsGraphNode, StreamSinkNode> copy = new HashMap<StreamsGraphNode, StreamSinkNode>(this.stateStoreNodeToSinkNodes);
        return Collections.unmodifiableMap(copy);
    }

    public Map<String, StreamsGraphNode> getNameToGraphNode() {
        HashMap<String, StreamsGraphNode> copy = new HashMap<String, StreamsGraphNode>(this.nameToGraphNode);
        return Collections.unmodifiableMap(copy);
    }
}

