/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class ChangeLoggingSessionBytesStore
extends WrappedStateStore.AbstractStateStore
implements SessionStore<Bytes, byte[]> {
    private final SessionStore<Bytes, byte[]> bytesStore;
    private StoreChangeLogger<Bytes, byte[]> changeLogger;

    ChangeLoggingSessionBytesStore(SessionStore<Bytes, byte[]> bytesStore) {
        super(bytesStore);
        this.bytesStore = bytesStore;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.bytesStore.init(context, root);
        String topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.bytesStore.name());
        this.changeLogger = new StoreChangeLogger(this.name(), context, new StateSerdes(topic, Serdes.Bytes(), Serdes.ByteArray()));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        return this.bytesStore.findSessions(key, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        return this.bytesStore.findSessions(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
    }

    @Override
    public void remove(Windowed<Bytes> sessionKey) {
        this.bytesStore.remove(sessionKey);
        this.changeLogger.logChange(Bytes.wrap((byte[])SessionKeySchema.toBinary(sessionKey)), null);
    }

    @Override
    public void put(Windowed<Bytes> sessionKey, byte[] aggregate) {
        this.bytesStore.put(sessionKey, aggregate);
        this.changeLogger.logChange(Bytes.wrap((byte[])SessionKeySchema.toBinary(sessionKey)), aggregate);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes key) {
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to) {
        return this.findSessions(from, to, 0L, Long.MAX_VALUE);
    }
}

