/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.util.Objects;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.internals.suppress.BufferConfigInternal;
import org.apache.kafka.streams.kstream.internals.suppress.BufferFullStrategy;

public class StrictBufferConfigImpl
extends BufferConfigInternal<Suppressed.StrictBufferConfig>
implements Suppressed.StrictBufferConfig {
    private final long maxRecords;
    private final long maxBytes;
    private final BufferFullStrategy bufferFullStrategy;

    public StrictBufferConfigImpl(long maxRecords, long maxBytes, BufferFullStrategy bufferFullStrategy) {
        this.maxRecords = maxRecords;
        this.maxBytes = maxBytes;
        this.bufferFullStrategy = bufferFullStrategy;
    }

    public StrictBufferConfigImpl() {
        this.maxRecords = Long.MAX_VALUE;
        this.maxBytes = Long.MAX_VALUE;
        this.bufferFullStrategy = BufferFullStrategy.SHUT_DOWN;
    }

    @Override
    public Suppressed.StrictBufferConfig withMaxRecords(long recordLimit) {
        return new StrictBufferConfigImpl(recordLimit, this.maxBytes, this.bufferFullStrategy);
    }

    @Override
    public Suppressed.StrictBufferConfig withMaxBytes(long byteLimit) {
        return new StrictBufferConfigImpl(this.maxRecords, byteLimit, this.bufferFullStrategy);
    }

    @Override
    public long maxRecords() {
        return this.maxRecords;
    }

    @Override
    public long maxBytes() {
        return this.maxBytes;
    }

    @Override
    public BufferFullStrategy bufferFullStrategy() {
        return this.bufferFullStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictBufferConfigImpl that = (StrictBufferConfigImpl)o;
        return this.maxRecords == that.maxRecords && this.maxBytes == that.maxBytes && this.bufferFullStrategy == that.bufferFullStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxRecords, this.maxBytes, this.bufferFullStrategy});
    }

    public String toString() {
        return "StrictBufferConfigImpl{maxKeys=" + this.maxRecords + ", maxBytes=" + this.maxBytes + ", bufferFullStrategy=" + (Object)((Object)this.bufferFullStrategy) + '}';
    }
}

