/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.processor.StreamPartitioner;

public class DefaultStreamPartitioner<K, V>
implements StreamPartitioner<K, V> {
    private final Cluster cluster;
    private final Serializer<K> keySerializer;
    private final DefaultPartitioner defaultPartitioner;

    public DefaultStreamPartitioner(Serializer<K> keySerializer, Cluster cluster) {
        this.cluster = cluster;
        this.keySerializer = keySerializer;
        this.defaultPartitioner = new DefaultPartitioner();
    }

    @Override
    public Integer partition(String topic, K key, V value, int numPartitions) {
        byte[] keyBytes = this.keySerializer.serialize(topic, key);
        return this.defaultPartitioner.partition(topic, key, keyBytes, value, null, this.cluster);
    }
}

