/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.WrappedSessionStoreIterator;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

public class RocksDBSessionStore
extends WrappedStateStore<SegmentedBytesStore, Object, Object>
implements SessionStore<Bytes, byte[]> {
    RocksDBSessionStore(SegmentedBytesStore bytesStore) {
        super(bytesStore);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).fetch(key, earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator(bytesIterator);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFindSessions(Bytes key, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).backwardFetch(key, earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator(bytesIterator);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> findSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).fetch(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator(bytesIterator);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFindSessions(Bytes keyFrom, Bytes keyTo, long earliestSessionEndTime, long latestSessionStartTime) {
        KeyValueIterator<Bytes, byte[]> bytesIterator = ((SegmentedBytesStore)this.wrapped()).backwardFetch(keyFrom, keyTo, earliestSessionEndTime, latestSessionStartTime);
        return new WrappedSessionStoreIterator(bytesIterator);
    }

    @Override
    public byte[] fetchSession(Bytes key, long startTime, long endTime) {
        return ((SegmentedBytesStore)this.wrapped()).get(SessionKeySchema.toBinary(key, startTime, endTime));
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes key) {
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes key) {
        return this.backwardFindSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to) {
        return this.findSessions(from, to, 0L, Long.MAX_VALUE);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> backwardFetch(Bytes from, Bytes to) {
        return this.backwardFindSessions(from, to, 0L, Long.MAX_VALUE);
    }

    @Override
    public void remove(Windowed<Bytes> key) {
        ((SegmentedBytesStore)this.wrapped()).remove(SessionKeySchema.toBinary(key));
    }

    @Override
    public void put(Windowed<Bytes> sessionKey, byte[] aggregate) {
        ((SegmentedBytesStore)this.wrapped()).put(SessionKeySchema.toBinary(sessionKey), aggregate);
    }
}

