/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019\u0019wN\u001c4jOV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!!\u0003A!b\u0001\n\u0003)\u0013a\u00027pO\u0012K'o]\u000b\u0002MA\u0019\u0011bJ\u0015\n\u0005!R!!B!se\u0006L\bC\u0001\u00160\u001b\u0005Y#B\u0001\u0017.\u0003\tIwNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#\u0001\u0002$jY\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\tY><G)\u001b:tA!AA\u0007\u0001BC\u0002\u0013\u0005Q'\u0001\u0003m_\u001e\u001cX#\u0001\u001c\u0011\t=9\u0014\bR\u0005\u0003qA\u0011A\u0001U8pYB\u0011!HQ\u0007\u0002w)\u0011A(P\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q$BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001eL!aQ\u001e\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011a$R\u0005\u0003\r\n\u00111\u0001T8h\u0011!A\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B&\u0002\tQLW.\u001a\t\u0003\u0019:k\u0011!\u0014\u0006\u0003#mJ!aT'\u0003\tQKW.\u001a\u0005\u0006#\u0002!\tAU\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bM#VKV,\u0011\u0005y\u0001\u0001\"B\u000eQ\u0001\u0004i\u0002\"\u0002\u0013Q\u0001\u00041\u0003\"\u0002\u001bQ\u0001\u00041\u0004b\u0002&Q!\u0003\u0005\ra\u0013\u0005\t3\u0002\u0011\r\u0011\"\u0001\u00035\u0006q1\r\\3b]\u0016\u0014X*\u00198bO\u0016\u0014X#A.\u0011\u0005ya\u0016BA/\u0003\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\u0005\u0007?\u0002\u0001\u000b\u0011B.\u0002\u001f\rdW-\u00198fe6\u000bg.Y4fe\u0002Bq!\u0019\u0001C\u0002\u0013%!-A\u0005uQJ|G\u000f\u001e7feV\t1\r\u0005\u0002\u0010I&\u0011Q\r\u0005\u0002\n)\"\u0014x\u000e\u001e;mKJDaa\u001a\u0001!\u0002\u0013\u0019\u0017A\u0003;ie>$H\u000f\\3sA!9\u0011\u000e\u0001b\u0001\n\u0013Q\u0017\u0001C2mK\u0006tWM]:\u0016\u0003-\u00042\u0001\\9t\u001b\u0005i'B\u00018p\u0003%IW.\\;uC\ndWM\u0003\u0002q\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Il'AC%oI\u0016DX\rZ*fcB\u0011A/^\u0007\u0002\u0001\u0019!a\u000f\u0001\u0003x\u00055\u0019E.Z1oKJ$\u0006N]3bIN\u0011Q\u000f\u001f\t\u0003\u001feL!A\u001f\t\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0005\tyV\u0014\t\u0011)A\u0005{\u0006AA\u000f\u001b:fC\u0012LE\r\u0005\u0002\n}&\u0011qP\u0003\u0002\u0004\u0013:$\bBB)v\t\u0003\t\u0019\u0001F\u0002t\u0003\u000bAa\u0001`A\u0001\u0001\u0004i\b\"CA\u0005k\n\u0007I\u0011IA\u0006\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'i\u0013\u0001\u00027b]\u001eLA!a\u0006\u0002\u0012\t11\u000b\u001e:j]\u001eD\u0001\"a\u0007vA\u0003%\u0011QB\u0001\fY><w-\u001a:OC6,\u0007\u0005C\u0005\u0002 U\u0014\r\u0011\"\u0001\u0002\"\u000591\r\\3b]\u0016\u0014XCAA\u0012!\rq\u0012QE\u0005\u0004\u0003O\u0011!aB\"mK\u0006tWM\u001d\u0005\t\u0003W)\b\u0015!\u0003\u0002$\u0005A1\r\\3b]\u0016\u0014\b\u0005C\u0005\u00020U\u0004\r\u0011\"\u0001\u00022\u0005IA.Y:u'R\fGo]\u000b\u0003\u0003g\u00012AHA\u001b\u0013\r\t9D\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\n\u0003w)\b\u0019!C\u0001\u0003{\tQ\u0002\\1tiN#\u0018\r^:`I\u0015\fH\u0003BA \u0003\u000b\u00022!CA!\u0013\r\t\u0019E\u0003\u0002\u0005+:LG\u000f\u0003\u0006\u0002H\u0005e\u0012\u0011!a\u0001\u0003g\t1\u0001\u001f\u00132\u0011!\tY%\u001eQ!\n\u0005M\u0012A\u00037bgR\u001cF/\u0019;tA!\"\u0011\u0011JA(!\rI\u0011\u0011K\u0005\u0004\u0003'R!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005]SO1A\u0005\n\u0005e\u0013\u0001\u00052bG.|eMZ,bSRd\u0015\r^2i+\t\tY\u0006\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002f5\nA!\u001e;jY&!\u0011\u0011NA0\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"!\u001cvA\u0003%\u00111L\u0001\u0012E\u0006\u001c7n\u00144g/\u0006LG\u000fT1uG\"\u0004\u0003bBA9k\u0012%\u00111O\u0001\nG\",7m\u001b#p]\u0016$B!a\u0010\u0002v!9\u0011qOA8\u0001\u0004I\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003w*H\u0011IA?\u0003\u0019!wnV8sWR\u0011\u0011q\b\u0005\b\u0003\u0003+H\u0011IA?\u0003!\u0019\b.\u001e;e_^t\u0007bBACk\u0012%\u0011QP\u0001\rG2,\u0017M\\(s'2,W\r\u001d\u0005\b\u0003\u0013+H\u0011AAF\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005}\u0012QRAI\u0003C\u000bY+a,\t\u000f\u0005=\u0015q\u0011a\u0001{\u0006\u0011\u0011\u000e\u001a\u0005\t\u0003'\u000b9\t1\u0001\u0002\u0016\u0006!a.Y7f!\u0011\t9*!(\u000f\u0007%\tI*C\u0002\u0002\u001c*\ta\u0001\u0015:fI\u00164\u0017\u0002BA\f\u0003?S1!a'\u000b\u0011!\t\u0019+a\"A\u0002\u0005\u0015\u0016\u0001\u00024s_6\u00042!CAT\u0013\r\tIK\u0003\u0002\u0005\u0019>tw\r\u0003\u0005\u0002.\u0006\u001d\u0005\u0019AAS\u0003\t!x\u000e\u0003\u0005\u00022\u0006\u001d\u0005\u0019AA\u001a\u0003\u0015\u0019H/\u0019;t\u0011\u001d\t)\f\u0001Q\u0001\n-\f\u0011b\u00197fC:,'o\u001d\u0011\t\u000f\u0005e\u0006\u0001\"\u0001\u0002~\u000591\u000f^1siV\u0004\bbBAA\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u007f\u0003A\u0011AAa\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011qHAb\u0011\u001d\t9(!0A\u0002eBq!a2\u0001\t\u0003\tI-A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$B!a\u0010\u0002L\"9\u0011QZAc\u0001\u0004I\u0013a\u00023bi\u0006$\u0015N\u001d\u0005\b\u0003#\u0004A\u0011AAj\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002@\u0005U\u0017q[Am\u0011\u001d\ti-a4A\u0002%Bq!a\u001e\u0002P\u0002\u0007\u0011\b\u0003\u0005\u0002\\\u0006=\u0007\u0019AAS\u0003\u0019ygMZ:fi\"9\u0011q\u001c\u0001\u0005\u0002\u0005\u0005\u0018!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u007f\t\u0019\u000fC\u0004\u0002x\u0005u\u0007\u0019A\u001d\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\u0006q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA \u0003WDq!a\u001e\u0002f\u0002\u0007\u0011\bC\u0004\u0002p\u0002!\t!!=\u0002\u0019\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3\u0015\u0011\u0005M\u0018\u0011`A~\u0003{\u00042!CA{\u0013\r\t9P\u0003\u0002\b\u0005>|G.Z1o\u0011\u001d\t9(!<A\u0002eB\u0001\"a7\u0002n\u0002\u0007\u0011Q\u0015\u0005\u000b\u0003\u007f\fi\u000f%AA\u0002\u0005\u0015\u0016!C7bq^\u000b\u0017\u000e^'t\u0011%\u0011\u0019\u0001AI\u0001\n\u0003\u0011)!\u0001\fbo\u0006LGo\u00117fC:,G\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u00119A\u000b\u0003\u0002&\n%1F\u0001B\u0006!\u0011\u0011iAa\u0006\u000e\u0005\t=!\u0002\u0002B\t\u0005'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tU!\"\u0001\u0006b]:|G/\u0019;j_:LAA!\u0007\u0003\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u0013\tu!!!A\t\u0002\t}\u0011A\u0003'pO\u000ecW-\u00198feB\u0019aD!\t\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005G\u00192A!\t\t\u0011\u001d\t&\u0011\u0005C\u0001\u0005O!\"Aa\b\t\u0015\t-\"\u0011EI\u0001\n\u0003\u0011i#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005_Q3a\u0013B\u0005\u0001")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final File[] logDirs;
    private final Pool<TopicPartition, Log> logs;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$4() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public CleanerConfig config() {
        return this.config;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$9) {
                x$9.start();
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$10) {
                x$10.shutdown();
            }
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        this.cleanerManager().resumeCleaning(topicPartition);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, (Function1)new Serializable(this, offset$1){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(long x$11) {
                return this.apply$mcZJ$sp(x$11);
            }

            public boolean apply$mcZJ$sp(long x$11) {
                return x$11 >= this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        }));
    }

    public LogCleaner(CleanerConfig config, File[] logDirs, Pool<TopicPartition, Log> logs, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.cleanerManager = new LogCleanerManager(logDirs, logs);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).map((Function1)new $anonfun$2(this), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$2) {
                        return x$2.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$3) {
                        return (double)100 * x$3.bufferUtilization();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                IndexedSeq stats = (IndexedSeq)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$4) {
                        return x$4.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$5) {
                        return x$5.bytesWritten();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$6) {
                        return x$6.bytesRead();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$7) {
                        return x$7.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$8) {
                        return x$8.elapsedSecs();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private final CountDownLatch backOffWaitLatch;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private CountDownLatch backOffWaitLatch() {
            return this.backOffWaitLatch;
        }

        public void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicPartition topicPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        @Override
        public void doWork() {
            this.cleanOrSleep();
        }

        @Override
        public void shutdown() {
            this.initiateShutdown();
            this.backOffWaitLatch().countDown();
            this.awaitShutdown();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            boolean bl;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time);
            None$ none$ = None$.MODULE$;
            Option<LogToClean> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                bl = false;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                LogToClean cleanable = (LogToClean)some.x();
                long endOffset = cleanable.firstDirtyOffset();
                try {
                    Tuple2 tuple2;
                    Tuple2<Object, CleanerStats> tuple22 = this.cleaner().clean(cleanable);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long nextDirtyOffset = tuple22._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                    long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                    CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                    endOffset = nextDirtyOffset2;
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
                }
                bl = true;
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            deletable.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CleanerThread $outer;

                public final int apply(Tuple2<TopicPartition, Log> x0$1) {
                    TopicPartition topicPartition;
                    Tuple2<TopicPartition, Log> tuple2 = x0$1;
                    if (tuple2 != null) {
                        topicPartition = (TopicPartition)tuple2._1();
                        Log log = (Log)tuple2._2();
                        int n = log.deleteOldSegments();
                        return n;
                    }
                    throw new MatchError(tuple2);
                    finally {
                        this.$outer.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting(topicPartition);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (cleaned) return;
            this.backOffWaitLatch().await(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs(), TimeUnit.MILLISECONDS);
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)new Serializable(this, stats){
                    public static final long serialVersionUID = 0L;
                    private final CleanerStats stats$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.stats$1.invalidMessagesRead())}));
                    }
                    {
                        this.stats$1 = stats$1;
                    }
                });
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw new NullPointerException();
            }
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)new CleanerThread$$anonfun$7(this));
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.backOffWaitLatch = new CountDownLatch(1);
        }
    }
}

