/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.CreateTopicMetadata;
import kafka.server.DelayedCreateTopics;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u00059!p[+uS2\u001cX#\u0001 \u0011\u0005=y\u0014B\u0001!\u0011\u0005\u001dQ6.\u0016;jYND\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAP\u0001\tu.,F/\u001b7tA!)A\t\u0001C\u0001\u000b\u00061A(\u001b8jiz\"RAR$I\u0013*\u0003\"A\b\u0001\t\u000bm\u0019\u0005\u0019A\u000f\t\u000b]\u0019\u0005\u0019A\u0013\t\u000bQ\u001a\u0005\u0019\u0001\u001c\t\u000bq\u001a\u0005\u0019\u0001 \t\u000f1\u0003!\u0019!C\u0005\u001b\u0006qAo\u001c9jGB+(oZ1u_JLX#\u0001(\u0011\u0007yy\u0015+\u0003\u0002Q\u0005\tIB)\u001a7bs\u0016$w\n]3sCRLwN\u001c)ve\u001e\fGo\u001c:z!\tq\"+\u0003\u0002T\u0005\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\u001c\u0005\u0007+\u0002\u0001\u000b\u0011\u0002(\u0002\u001fQ|\u0007/[2QkJ<\u0017\r^8ss\u0002Bqa\u0016\u0001C\u0002\u0013%\u0001,A\tde\u0016\fG/\u001a+pa&\u001c\u0007k\u001c7jGf,\u0012!\u0017\t\u0004\u0013ic\u0016BA.\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011Q,Y\u0007\u0002=*\u0011q\fY\u0001\u0007a>d\u0017nY=\u000b\u0005\rQ\u0013B\u00012_\u0005E\u0019%/Z1uKR{\u0007/[2Q_2L7-\u001f\u0005\u0007I\u0002\u0001\u000b\u0011B-\u0002%\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u0017\u0010\t\u0005\u0006M\u0002!\taZ\u0001\u001aQ\u0006\u001cH)\u001a7bs\u0016$Gk\u001c9jG>\u0003XM]1uS>t7/F\u0001i!\tI\u0011.\u0003\u0002k\u0015\t9!i\\8mK\u0006t\u0007\"\u00027\u0001\t\u0003i\u0017!\t;ss\u000e{W\u000e\u001d7fi\u0016$U\r\\1zK\u0012$v\u000e]5d\u001fB,'/\u0019;j_:\u001cHC\u00018r!\tIq.\u0003\u0002q\u0015\t!QK\\5u\u0011\u0015\u00118\u000e1\u0001t\u0003\u0015!x\u000e]5d!\t!xO\u0004\u0002\nk&\u0011aOC\u0001\u0007!J,G-\u001a4\n\u0005aL(AB*ue&twM\u0003\u0002w\u0015!)1\u0010\u0001C\u0001y\u0006a1M]3bi\u0016$v\u000e]5dgRAa.`A\u0003\u0003\u0013\t)\u0005C\u0003\u007fu\u0002\u0007q0A\u0004uS6,w.\u001e;\u0011\u0007%\t\t!C\u0002\u0002\u0004)\u00111!\u00138u\u0011\u0019\t9A\u001fa\u0001Q\u0006aa/\u00197jI\u0006$Xm\u00148ms\"9\u00111\u0002>A\u0002\u00055\u0011AC2sK\u0006$X-\u00138g_B9\u0011qBA\u000bg\u0006eQBAA\t\u0015\r\t\u0019BC\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\f\u0003#\u00111!T1q!\u0011\tY\"a\u0010\u000f\t\u0005u\u0011\u0011\b\b\u0005\u0003?\t)D\u0004\u0003\u0002\"\u0005Mb\u0002BA\u0012\u0003cqA!!\n\u000209!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,\u0019\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0018\n\u00051j\u0013BA\u0003,\u0013\tI#&C\u0002\u00028!\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003w\ti$A\nDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cHOC\u0002\u00028!JA!!\u0011\u0002D\taAk\u001c9jG\u0012+G/Y5mg*!\u00111HA\u001f\u0011\u001d\t9E\u001fa\u0001\u0003\u0013\n\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\r%\tY%a\u0014o\u0013\r\tiE\u0003\u0002\n\rVt7\r^5p]F\u0002r!a\u0004\u0002\u0016M\f\t\u0006\u0005\u0003\u0002T\u0005mc\u0002BA+\u0003/j!!!\u0010\n\t\u0005e\u0013QH\u0001\u0015\u0007J,\u0017\r^3U_BL7m\u001d*fgB|gn]3\n\t\u0005u\u0013q\f\u0002\u0006\u000bJ\u0014xN\u001d\u0006\u0005\u00033\ni\u0004C\u0004\u0002d\u0001!\t!!\u001a\u0002\u0019\u0011,G.\u001a;f)>\u0004\u0018nY:\u0015\u000f9\f9'!\u001b\u0002t!1a0!\u0019A\u0002}D\u0001\"a\u001b\u0002b\u0001\u0007\u0011QN\u0001\u0007i>\u0004\u0018nY:\u0011\u000b\u0005=\u0011qN:\n\t\u0005E\u0014\u0011\u0003\u0002\u0004'\u0016$\b\u0002CA$\u0003C\u0002\r!!\u001e\u0011\r%\tY%a\u001eo!\u001d\ty!!\u0006t\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fB\u0013\u0001\u00039s_R|7m\u001c7\n\t\u0005\r\u0015Q\u0010\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006A1\u000f[;uI><h\u000eF\u0001o\u0001")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final ZkUtils zkUtils;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final Option<CreateTopicPolicy> kafka$server$AdminManager$$createTopicPolicy;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    public Option<CreateTopicPolicy> kafka$server$AdminManager$$createTopicPolicy() {
        return this.kafka$server$AdminManager$$createTopicPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)new Serializable(this, key, completed){
            public static final long serialVersionUID = 0L;
            private final TopicKey key$1;
            private final int completed$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1.keyLabel(), BoxesRunTime.boxToInteger((int)this.completed$1)}));
            }
            {
                this.key$1 = key$1;
                this.completed$1 = completed$1;
            }
        });
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, CreateTopicsResponse.Error>, BoxedUnit> responseCallback) {
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker b) {
                return new BrokerMetadata(b.id(), b.rack());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Iterable metadata = (Iterable)createInfo.map((Function1)new Serializable(this, validateOnly, brokers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;
            private final boolean validateOnly$1;
            private final Seq brokers$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final CreateTopicMetadata apply(Tuple2<String, CreateTopicsRequest.TopicDetails> x0$1) {
                CreateTopicMetadata createTopicMetadata;
                Tuple2<String, CreateTopicsRequest.TopicDetails> tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1)new Serializable(this, configs){
                        public static final long serialVersionUID = 0L;
                        private final Properties configs$1;

                        public final Object apply(Tuple2<String, String> x0$2) {
                            Tuple2<String, String> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String key = (String)tuple2._1();
                                String value2 = (String)tuple2._2();
                                Object object = this.configs$1.setProperty(key, value2);
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.configs$1 = configs$1;
                        }
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map assignments = arguments.replicasAssignments.isEmpty() ? AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)this.brokers$1, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()) : (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Buffer<Object>> apply(Tuple2<Integer, List<Integer>> x0$3) {
                            Tuple2<Integer, List<Integer>> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Integer partitionId = (Integer)tuple2._1();
                                List replicas = (List)tuple2._2();
                                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Integer x$1) {
                                        return x$1;
                                    }
                                }, Buffer$.MODULE$.canBuildFrom()));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    this.$outer.trace((Function0<String>)new Serializable(this, topic, assignments){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final Map assignments$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.assignments$1}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.assignments$1 = assignments$1;
                        }
                    });
                    Option<CreateTopicPolicy> option = this.$outer.kafka$server$AdminManager$$createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Short replicationFactor;
                        Integer numPartitions;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.x();
                        AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                        Integer n = arguments.numPartitions == -1 ? null : (numPartitions = Predef$.MODULE$.int2Integer(arguments.numPartitions));
                        Short s = arguments.replicationFactor == -1 ? null : (replicationFactor = Predef$.MODULE$.short2Short(arguments.replicationFactor));
                        java.util.Map replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (this.validateOnly$1) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else {
                        BoxedUnit boxedUnit;
                        None$ none$ = None$.MODULE$;
                        Option<CreateTopicPolicy> option2 = option;
                        if (none$ == null) {
                            if (option2 != null) {
                                throw new MatchError(option);
                            }
                        } else if (!none$.equals(option2)) throw new MatchError(option);
                        if (this.validateOnly$1) {
                            AdminUtils$.MODULE$.validateCreateOrUpdateTopic(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.$outer.zkUtils(), topic, (Map<Object, Seq<Object>>)assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    createTopicMetadata = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)assignments, new CreateTopicsResponse.Error(Errors.NONE, null));
                    return createTopicMetadata;
                }
                catch (Throwable throwable22) {
                    CreateTopicMetadata createTopicMetadata2;
                    Throwable throwable3 = throwable22;
                    boolean bl = throwable3 instanceof PolicyViolationException ? true : throwable3 instanceof ApiException;
                    if (bl) {
                        this.$outer.info((Function0<String>)new Serializable(this, topic, arguments){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;
                            private final CreateTopicsRequest.TopicDetails arguments$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                            }
                            {
                                this.topic$1 = topic$1;
                                this.arguments$1 = arguments$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable3){
                            public static final long serialVersionUID = 0L;
                            private final Throwable x7$1;

                            public final Throwable apply() {
                                return this.x7$1;
                            }
                            {
                                this.x7$1 = x7$1;
                            }
                        });
                        createTopicMetadata2 = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), new CreateTopicsResponse.Error(Errors.forException((Throwable)throwable3), throwable3.getMessage()));
                    } else {
                        if (throwable3 == null) throw throwable22;
                        Throwable throwable4 = throwable3;
                        this.$outer.error((Function0<String>)new Serializable(this, topic, arguments){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;
                            private final CreateTopicsRequest.TopicDetails arguments$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.arguments$1}));
                            }
                            {
                                this.topic$1 = topic$1;
                                this.arguments$1 = arguments$1;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable4){
                            public static final long serialVersionUID = 0L;
                            private final Throwable x10$1;

                            public final Throwable apply() {
                                return this.x10$1;
                            }
                            {
                                this.x10$1 = x10$1;
                            }
                        });
                        createTopicMetadata2 = new CreateTopicMetadata(topic, (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), new CreateTopicsResponse.Error(Errors.forException((Throwable)throwable4), throwable4.getMessage()));
                    }
                    createTopicMetadata = createTopicMetadata2;
                }
                return createTopicMetadata;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.validateOnly$1 = validateOnly$1;
                this.brokers$1 = brokers$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout > 0 && !validateOnly && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CreateTopicMetadata x$2) {
                return x$2.error().is(Errors.NONE);
            }
        })) {
            DelayedCreateTopics delayedCreate = new DelayedCreateTopics(timeout, (Seq<CreateTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$3) {
                    return new TopicKey(x$3);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this, validateOnly){
                public static final long serialVersionUID = 0L;
                private final boolean validateOnly$1;

                public final Tuple2<String, CreateTopicsResponse.Error> apply(CreateTopicMetadata createTopicMetadata) {
                    return createTopicMetadata.error().is(Errors.NONE) && !this.validateOnly$1 ? new Tuple2((Object)createTopicMetadata.topic(), (Object)new CreateTopicsResponse.Error(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
                }
                {
                    this.validateOnly$1 = validateOnly$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final DeleteTopicMetadata apply(String topic) {
                DeleteTopicMetadata deleteTopicMetadata;
                try {
                    AdminUtils$.MODULE$.deleteTopic(this.$outer.zkUtils(), topic);
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                        }
                        {
                            this.topic$2 = topic$2;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$1;

                        public final Throwable apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.forException((Throwable)throwable));
                }
                catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                    deleteTopicMetadata = new DeleteTopicMetadata(topic, Errors.NONE);
                }
                return deleteTopicMetadata;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        if (timeout > 0 && metadata.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DeleteTopicMetadata x$4) {
                Errors errors = x$4.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !errors.equals(errors2) : errors2 != null);
            }
        })) {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
            Seq delayedDeleteKeys = ((SetLike)topics.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicKey apply(String x$5) {
                    return new TopicKey(x$5);
                }
            }, Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
        } else {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Errors> apply(DeleteTopicMetadata deleteTopicMetadata) {
                    Errors errors = deleteTopicMetadata.error();
                    Errors errors2 = Errors.NONE;
                    return !(errors != null ? !errors.equals(errors2) : errors2 != null) ? new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT) : new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
            responseCallback.apply((Object)results);
        }
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AdminManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$server$AdminManager$$createTopicPolicy().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(CreateTopicPolicy x$6) {
                        x$6.close();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, ZkUtils zkUtils) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkUtils = zkUtils;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Admin Manager on Broker ").append((Object)BoxesRunTime.boxToInteger((int)config.brokerId())).append((Object)"]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3());
        this.kafka$server$AdminManager$$createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
    }
}

