/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherManager;
import kafka.consumer.PartitionTopicInfo;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u000f\t)2i\u001c8tk6,'OR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003!\u0019wN\\:v[\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\taa]3sm\u0016\u0014\u0018BA\u0007\u000b\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0001b\u0004\u0001\u0003\u0002\u0003\u0006I\u0001E\u0001\u0005]\u0006lW\r\u0005\u0002\u0012/9\u0011!#F\u0007\u0002')\tA#A\u0003tG\u0006d\u0017-\u0003\u0002\u0017'\u00051\u0001K]3eK\u001aL!\u0001G\r\u0003\rM#(/\u001b8h\u0015\t12\u0003\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019\u0019wN\u001c4jOV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\tq1i\u001c8tk6,'oQ8oM&<\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u000f\r|gNZ5hA!AA\u0005\u0001B\u0001B\u0003%Q%\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002'S5\tqE\u0003\u0002)\t\u000591\r\\;ti\u0016\u0014\u0018B\u0001\u0016(\u0005\u0019\u0011%o\\6fe\"AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007\u000f\u0005\u0003\u0012]A2\u0014BA\u0018\u001a\u0005\ri\u0015\r\u001d\t\u0003cQj\u0011A\r\u0006\u0003g\u0011\taaY8n[>t\u0017BA\u001b3\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0003=]J!\u0001\u000f\u0002\u0003%A\u000b'\u000f^5uS>tGk\u001c9jG&sgm\u001c\u0005\tu\u0001\u0011)\u0019!C\u0001w\u000512m\u001c8tk6,'OR3uG\",'/T1oC\u001e,'/F\u0001=!\tqR(\u0003\u0002?\u0005\t12i\u001c8tk6,'OR3uG\",'/T1oC\u001e,'\u000f\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003=\u0003]\u0019wN\\:v[\u0016\u0014h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0007\t\u00163u\tS%\u0011\u0005y\u0001\u0001\"B\bB\u0001\u0004\u0001\u0002\"B\u000eB\u0001\u0004i\u0002\"\u0002\u0013B\u0001\u0004)\u0003\"\u0002\u0017B\u0001\u0004i\u0003\"\u0002\u001eB\u0001\u0004a\u0004\"B&\u0001\t\u0003a\u0015\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0003N!J;\u0006C\u0001\nO\u0013\ty5C\u0001\u0003V]&$\b\"B)K\u0001\u0004\u0001\u0014!\u0005;pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\")1K\u0013a\u0001)\u0006Ya-\u001a;dQ>3gm]3u!\t\u0011R+\u0003\u0002W'\t!Aj\u001c8h\u0011\u0015A&\n1\u0001Z\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB\u0011!,X\u0007\u00027*\u0011A\fB\u0001\u0004CBL\u0017B\u00010\\\u0005i1U\r^2i%\u0016\u001c\bo\u001c8tKB\u000b'\u000f^5uS>tG)\u0019;b\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003YA\u0017M\u001c3mK>3gm]3u\u001fV$xJ\u001a*b]\u001e,GC\u0001+c\u0011\u0015\tv\f1\u00011\u0011\u0015!\u0007\u0001\"\u0001f\u0003iA\u0017M\u001c3mKB\u000b'\u000f^5uS>t7oV5uQ\u0016\u0013(o\u001c:t)\tie\rC\u0003hG\u0002\u0007\u0001.\u0001\u0006qCJ$\u0018\u000e^5p]N\u00042![91\u001d\tQwN\u0004\u0002l]6\tAN\u0003\u0002n\r\u00051AH]8pizJ\u0011\u0001F\u0005\u0003aN\tq\u0001]1dW\u0006<W-\u0003\u0002sg\nA\u0011\n^3sC\ndWM\u0003\u0002q'\u0001")
public class ConsumerFetcherThread
extends AbstractFetcherThread {
    private final ConsumerConfig config;
    private final Map<TopicAndPartition, PartitionTopicInfo> partitionMap;
    private final ConsumerFetcherManager consumerFetcherManager;

    public ConsumerConfig config() {
        return this.config;
    }

    public ConsumerFetcherManager consumerFetcherManager() {
        return this.consumerFetcherManager;
    }

    @Override
    public void processPartitionData(TopicAndPartition topicAndPartition, long l, FetchResponsePartitionData fetchResponsePartitionData) {
        PartitionTopicInfo partitionTopicInfo = (PartitionTopicInfo)this.partitionMap.apply((Object)topicAndPartition);
        if (partitionTopicInfo.getFetchOffset() != l) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset doesn't match for partition [%s,%d] pti offset: %d fetch offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition.topic(), BoxesRunTime.boxToInteger((int)topicAndPartition.partition()), BoxesRunTime.boxToLong((long)partitionTopicInfo.getFetchOffset()), BoxesRunTime.boxToLong((long)l)})));
        }
        partitionTopicInfo.enqueue((ByteBufferMessageSet)fetchResponsePartitionData.messages());
    }

    @Override
    public long handleOffsetOutOfRange(TopicAndPartition topicAndPartition) {
        long l = 0L;
        String string = this.config().autoOffsetReset();
        String string2 = OffsetRequest$.MODULE$.SmallestTimeString();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            l = OffsetRequest$.MODULE$.EarliestTime();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = OffsetRequest$.MODULE$.LargestTimeString();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                l = OffsetRequest$.MODULE$.LatestTime();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                l = OffsetRequest$.MODULE$.LatestTime();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        long l2 = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, l, Request$.MODULE$.OrdinaryConsumerId());
        PartitionTopicInfo partitionTopicInfo = (PartitionTopicInfo)this.partitionMap.apply((Object)topicAndPartition);
        partitionTopicInfo.resetFetchOffset(l2);
        partitionTopicInfo.resetConsumeOffset(l2);
        return l2;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicAndPartition> iterable) {
        iterable.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerFetcherThread $outer;

            public final void apply(TopicAndPartition topicAndPartition) {
                this.$outer.removePartition(topicAndPartition.topic(), topicAndPartition.partition());
            }
            {
                if (consumerFetcherThread == null) {
                    throw new NullPointerException();
                }
                this.$outer = consumerFetcherThread;
            }
        });
        this.consumerFetcherManager().addPartitionsWithError(iterable);
    }

    public ConsumerFetcherThread(String string, ConsumerConfig consumerConfig, Broker broker, Map<TopicAndPartition, PartitionTopicInfo> map, ConsumerFetcherManager consumerFetcherManager) {
        this.config = consumerConfig;
        this.partitionMap = map;
        this.consumerFetcherManager = consumerFetcherManager;
        super(string, new StringBuilder().append((Object)consumerConfig.clientId()).append((Object)"-").append((Object)string).toString(), broker, consumerConfig.socketTimeoutMs(), consumerConfig.socketReceiveBufferBytes(), consumerConfig.fetchMessageMaxBytes(), Request$.MODULE$.OrdinaryConsumerId(), consumerConfig.fetchWaitMaxMs(), consumerConfig.fetchMinBytes(), true);
    }
}

