/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.producer.ConsoleProducer;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsoleProducer$ {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("topic", "REQUIRED: The topic id to produce messages to.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("broker-list", "REQUIRED: The broker list string in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("broker-list").ofType(String.class);
        OptionSpecBuilder optionSpecBuilder = optionParser.accepts("sync", "If set message send requests to the brokers are synchronously, one at a time as they arrive.");
        OptionSpecBuilder optionSpecBuilder2 = optionParser.accepts("compress", "If set, messages batches are sent compressed");
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("batch-size", "Number of messages to send in a single batch if they are not being sent synchronously.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec4 = optionParser.accepts("message-send-max-retries", "Brokers can fail receiving the message for multiple reasons, and being unavailable transiently is just one of them. This property specifies the number of retires before the producer give up and drop this message.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(3), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec5 = optionParser.accepts("retry-backoff-ms", "Before each retry, the producer refreshes the metadata of relevant topics. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.").withRequiredArg().ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(100L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec6 = optionParser.accepts("timeout", "If set and the producer is running in asynchronous mode, this gives the maximum amount of time a message will queue awaiting suffient batch size. The value is given in ms.").withRequiredArg().describedAs("timeout_ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(1000L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec7 = optionParser.accepts("queue-size", "If set and the producer is running in asynchronous mode, this gives the maximum amount of  messages will queue awaiting suffient batch size.").withRequiredArg().describedAs("queue_size").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(10000L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec8 = optionParser.accepts("queue-enqueuetimeout-ms", "Timeout for event enqueue").withRequiredArg().describedAs("queue enqueuetimeout ms").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(0L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec9 = optionParser.accepts("request-required-acks", "The required acks of the producer requests").withRequiredArg().describedAs("request required acks").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec10 = optionParser.accepts("request-timeout-ms", "The ack timeout of the producer requests. Value must be non-negative and non-zero").withRequiredArg().describedAs("request timeout ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1500), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec11 = optionParser.accepts("value-serializer", "The class name of the message encoder implementation to use for serializing values.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)StringEncoder.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec12 = optionParser.accepts("key-serializer", "The class name of the message encoder implementation to use for serializing keys.").withRequiredArg().describedAs("encoder_class").ofType(String.class).defaultsTo((Object)StringEncoder.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec13 = optionParser.accepts("line-reader", "The class name of the class to use for reading lines from standard in. By default each line is read as a separate message.").withRequiredArg().describedAs("reader_class").ofType(String.class).defaultsTo((Object)ConsoleProducer.LineMessageReader.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec14 = optionParser.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(102400), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec15 = optionParser.accepts("property", "A mechanism to pass user-defined properties in the form key=value to the message reader. This allows custom configuration for a user-defined message reader.").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSet optionSet = optionParser.parse(stringArray);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec, argumentAcceptingOptionSpec2})).foreach((Function1)new Serializable(optionParser, optionSet){
            public static final long serialVersionUID = 0L;
            private final OptionParser parser$1;
            private final OptionSet options$1;

            public final void apply(ArgumentAcceptingOptionSpec<String> argumentAcceptingOptionSpec) {
                if (!this.options$1.has(argumentAcceptingOptionSpec)) {
                    System.err.println(new StringBuilder().append((Object)"Missing required argument \"").append(argumentAcceptingOptionSpec).append((Object)"\"").toString());
                    this.parser$1.printHelpOn((OutputStream)System.err);
                    System.exit(1);
                }
            }
            {
                this.parser$1 = optionParser;
                this.options$1 = optionSet;
            }
        });
        String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec);
        String string2 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2);
        boolean bl = optionSet.has((OptionSpec)optionSpecBuilder);
        boolean bl2 = optionSet.has((OptionSpec)optionSpecBuilder2);
        Integer n = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3);
        Long l = (Long)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec6);
        Long l2 = (Long)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec7);
        Long l3 = (Long)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec8);
        Integer n2 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec9);
        Integer n3 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec10);
        String string3 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec12);
        String string4 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec11);
        String string5 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec13);
        Integer n4 = (Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec14);
        Properties properties = this.parseLineReaderArgs((Iterable<String>)JavaConversions$.MODULE$.asScalaBuffer(optionSet.valuesOf((OptionSpec)argumentAcceptingOptionSpec15)));
        ((Hashtable)properties).put("topic", string);
        Properties properties2 = new Properties();
        ((Hashtable)properties2).put("metadata.broker.list", string2);
        int n5 = bl2 ? DefaultCompressionCodec$.MODULE$.codec() : NoCompressionCodec$.MODULE$.codec();
        ((Hashtable)properties2).put("compression.codec", ((Object)BoxesRunTime.boxToInteger((int)n5)).toString());
        ((Hashtable)properties2).put("producer.type", bl ? "sync" : "async");
        Object object = optionSet.has((OptionSpec)argumentAcceptingOptionSpec3) ? ((Hashtable)properties2).put("batch.num.messages", n.toString()) : BoxedUnit.UNIT;
        ((Hashtable)properties2).put("message.send.max.retries", ((Integer)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec4)).toString());
        ((Hashtable)properties2).put("retry.backoff.ms", ((Long)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec5)).toString());
        ((Hashtable)properties2).put("queue.buffering.max.ms", l.toString());
        ((Hashtable)properties2).put("queue.buffering.max.messages", l2.toString());
        ((Hashtable)properties2).put("queue.enqueue.timeout.ms", l3.toString());
        ((Hashtable)properties2).put("request.required.acks", n2.toString());
        ((Hashtable)properties2).put("request.timeout.ms", n3.toString());
        ((Hashtable)properties2).put("key.serializer.class", string3);
        ((Hashtable)properties2).put("serializer.class", string4);
        ((Hashtable)properties2).put("send.buffer.bytes", n4.toString());
        ConsoleProducer.MessageReader messageReader = (ConsoleProducer.MessageReader)Class.forName(string5).newInstance();
        messageReader.init(System.in, properties);
        try {
            Producer producer = new Producer(new ProducerConfig(properties2));
            Runtime.getRuntime().addShutdownHook(new Thread(producer){
                private final Producer producer$1;

                public void run() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer;
                }
            });
            KeyedMessage keyedMessage = null;
            while (true) {
                if ((keyedMessage = messageReader.readMessage()) != null) {
                    producer.send(Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{keyedMessage}));
                }
                if (keyedMessage != null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public Properties parseLineReaderArgs(Iterable<String> iterable) {
        Iterable iterable2 = (Iterable)((TraversableLike)((TraversableLike)iterable.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String string) {
                return string.split("=");
            }
        }, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] stringArray) {
                return stringArray == null;
            }
        })).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] stringArray) {
                return stringArray.length == 0;
            }
        });
        if (!iterable2.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String[] stringArray) {
                return stringArray.length == 2;
            }
        })) {
            System.err.println(new StringBuilder().append((Object)"Invalid line reader properties: ").append((Object)iterable.mkString(" ")).toString());
            System.exit(1);
        }
        Properties properties = new Properties();
        iterable2.foreach((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String[] stringArray) {
                return ((Hashtable)this.props$1).put(stringArray[0], stringArray[1]);
            }
            {
                this.props$1 = properties;
            }
        });
        return properties;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

