/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleanerTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\r=g\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u00072,\u0017M\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9eSJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H-\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\t1\u0001Z5s\u0011\u00199\u0003\u0001)A\u00055\u0005!A-\u001b:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011aFH\u0001\u0005kRLG.\u0003\u00021[\tQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0002\u0001\u0015!\u0003,\u0003%awn\u001a)s_B\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u00131|wmQ8oM&<W#\u0001\u001c\u0011\u0005Y9\u0014B\u0001\u001d\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0005i&lW-F\u0001?!\ty$)D\u0001A\u0015\t\tE!A\u0003vi&d7/\u0003\u0002D\u0001\nAQj\\2l)&lW\r\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0006i&lW\r\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%!\bN]8ui2,'/F\u0001J!\ty$*\u0003\u0002L\u0001\nIA\u000b\u001b:piRdWM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0005uK\u0006\u0014Hm\\<o)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRD#A\u0014-\u0011\u0005e[V\"\u0001.\u000b\u0005-q\u0011B\u0001/[\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0003;\u0002\u0004\"!W1\n\u0005\tT&\u0001\u0002+fgRDQ\u0001\u001a\u0001\u0005\u0002A\u000bq\u0006^3tiNK'0\u001a+sS6lW\r\u001a$peB\u0013X-\u00197m_\u000e\fG/\u001a3B]\u0012\u001cu.\u001c9bGR,G\rV8qS\u000eD#a\u00191\t\u000b\u001d\u0004A\u0011\u0001)\u0002?Q,7\u000f\u001e#va2L7-\u0019;f\u0007\",7m[!gi\u0016\u00148\t\\3b]&tw\r\u000b\u0002gA\")!\u000e\u0001C\u0001!\u0006\tC/Z:u\u0005\u0006\u001c\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\fu/\u0019:f\u00072,\u0017M\\5oO\"\u0012\u0011\u000e\u0019\u0005\u0006[\u0002!\t\u0001U\u0001*i\u0016\u001cHo\u00117fC:<\u0016\u000e\u001e5Ue\u0006t7/Y2uS>t7o\u00159b]:LgnZ*fO6,g\u000e^:)\u00051\u0004\u0007\"\u00029\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cu.\\7ji6\u000b'o[3s%\u0016lwN^1mQ\ty\u0007\rC\u0003t\u0001\u0011\u0005\u0001+\u0001\u0013uKN$H)\u001a7fi\u0016$')\u0019;dQ\u0016\u001cx+\u001b;i\u001d>lUm]:bO\u0016\u001c(+Z1eQ\t\u0011\b\rC\u0003w\u0001\u0011\u0005\u0001+A\u0014uKN$8i\\7nSRl\u0015M]6feJ+G/\u001a8uS>tw+\u001b;i\u000b6\u0004H/\u001f\"bi\u000eD\u0007FA;a\u0011\u0015I\b\u0001\"\u0001Q\u0003Y!Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+Z7pm\u0006d\u0007F\u0001=a\u0011\u0015a\b\u0001\"\u0001Q\u0003\u0019\"Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+\u001a;f]RLwN\\,ji\",U\u000e\u001d;z\u0005\u0006$8\r\u001b\u0015\u0003w\u0002DQa \u0001\u0005\u0002A\u000b\u0001\u0003^3ti2\u000b'oZ3NKN\u001c\u0018mZ3)\u0005y\u0004\u0007BBA\u0003\u0001\u0011\u0005\u0001+A\u0012uKN$X*Z:tC\u001e,G*\u0019:hKJ$\u0006.\u00198NCblUm]:bO\u0016\u001c\u0016N_3)\u0007\u0005\r\u0001\r\u0003\u0004\u0002\f\u0001!\t\u0001U\u00015i\u0016\u001cH/T3tg\u0006<W\rT1sO\u0016\u0014H\u000b[1o\u001b\u0006DX*Z:tC\u001e,7+\u001b>f/&$\bnQ8seV\u0004H\u000fS3bI\u0016\u0014\bfAA\u0005A\"1\u0011\u0011\u0003\u0001\u0005\u0002A\u000ba\u0006^3ti\u000e{'O];qi6+7o]1hKNK'0\u001a'be\u001e,'\u000f\u00165b]\nKH/Z:Bm\u0006LG.\u00192mK\"\u001a\u0011q\u00021\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a\u000513M]3bi\u0016dunZ,ji\"lUm]:bO\u0016\u001cH*\u0019:hKJ$\u0006.\u00198NCb\u001c\u0016N_3\u0015\t\u0005m\u0011Q\u0006\t\b%\u0006u\u0011\u0011EA\u0014\u0013\r\tyb\u0015\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007Y\t\u0019#C\u0002\u0002&\t\u00111\u0001T8h!\r1\u0012\u0011F\u0005\u0004\u0003W\u0011!!\u0004$bW\u0016|eMZ:fi6\u000b\u0007\u000f\u0003\u0005\u00020\u0005U\u0001\u0019AA\u0019\u0003Aa\u0017M]4f\u001b\u0016\u001c8/Y4f'&TX\rE\u0002S\u0003gI1!!\u000eT\u0005\rIe\u000e\u001e\u0005\u0007\u0003s\u0001A\u0011\u0001)\u0002/Q,7\u000f^\"mK\u0006t\u0017N\\4XSRDG)\u001a7fi\u0016\u001c\bfAA\u001cA\"1\u0011q\b\u0001\u0005\u0002A\u000b1\u0003^3ti2{wm\u00117fC:,'o\u0015;biNDa!a\u0011\u0001\t\u0003\u0001\u0016!\u000b;fgRdunZ\"mK\u0006tWM\u001d*fi\u0006Lgn\u001d)s_\u0012,8-\u001a:MCN$8+Z9vK:\u001cW\rK\u0002\u0002B\u0001Da!!\u0013\u0001\t\u0003\u0001\u0016!\u000f;fgRdunZ\"mK\u0006tWM\u001d*fi\u0006Lgn\u001d'bgR\u001cV-];f]\u000e,WI^3o\u0013\u001a$&/\u00198tC\u000e$\u0018n\u001c8BE>\u0014H/\u001a3)\u0007\u0005\u001d\u0003\r\u0003\u0004\u0002P\u0001!\t\u0001U\u0001\u0018i\u0016\u001cH\u000fU1si&\fGnU3h[\u0016tGo\u00117fC:D3!!\u0014a\u0011\u0019\t)\u0006\u0001C\u0001!\u0006\u0011C/Z:u\u00072,\u0017M\\5oO^KG\u000f[+oG2,\u0017M\\1cY\u0016\u001cVm\u0019;j_:D3!a\u0015a\u0011\u0019\tY\u0006\u0001C\u0001!\u0006qA/Z:u\u0019><Gk\\\"mK\u0006t\u0007fAA-A\"1\u0011\u0011\r\u0001\u0005\u0002A\u000bA\u0005^3ti2{w\rV8DY\u0016\fgnV5uQVs7\r\\3b]\u0006\u0014G.Z*fGRLwN\u001c\u0015\u0004\u0003?\u0002\u0007BBA4\u0001\u0011\u0005\u0001+A\u0010uKN$8\t\\3b]&twmV5uQVs7.Z=fI6+7o]1hKND3!!\u001aa\u0011\u001d\ti\u0007\u0001C\u0001\u0003_\n\u0001\u0004\\1ti>3gm]3ugB+'OQ1uG\"Le\u000eT8h)\u0011\t\t(a!\u0011\r\u0005M\u0014\u0011PA?\u001b\t\t)HC\u0002\u0002xM\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY(!\u001e\u0003\u0011%#XM]1cY\u0016\u00042AUA@\u0013\r\t\ti\u0015\u0002\u0005\u0019>tw\rC\u0004\u0004\u0003W\u0002\r!!\t\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\u0006\u0011B.Y:u'\u0016\fX/\u001a8dKNLe\u000eT8h)\u0011\tY)!%\u0011\u0011\u0005M\u0014QRA?\u0003cIA!a$\u0002v\t\u0019Q*\u00199\t\u000f\r\t)\t1\u0001\u0002\"!9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0015\u0001D8gMN,Go]%o\u0019><G\u0003BA9\u00033CqaAAJ\u0001\u0004\t\t\u0003C\u0004\u0002\u001e\u0002!\t!a(\u00021Ut7.Z=fI6+7o]1hK\u000e{WO\u001c;J]2{w\r\u0006\u0003\u00022\u0005\u0005\u0006bB\u0002\u0002\u001c\u0002\u0007\u0011\u0011\u0005\u0005\b\u0003K\u0003A\u0011AAT\u00039\t'm\u001c:u\u0007\",7m\u001b#p]\u0016$2!UAU\u0011!\tY+a)A\u0002\u00055\u0016A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003_\u000bY,\u0004\u0002\u00022*!\u00111WA[\u0003\u0019\u0019w.\\7p]*\u0019Q!a.\u000b\u0007\u0005ef\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003{\u000b\tL\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r\u0005\u0005\u0007\u0001\"\u0001Q\u0003i!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo],ji\"\f%m\u001c:uQ\r\ty\f\u0019\u0005\u0007\u0003\u000f\u0004A\u0011\u0001)\u0002'Q,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4)\u0007\u0005\u0015\u0007\r\u0003\u0004\u0002N\u0002!\t\u0001U\u0001%i\u0016\u001cHoU3h[\u0016tGo\u0012:pkBLgnZ,ji\"\u001c\u0006/\u0019:tK>3gm]3ug\"\u001a\u00111\u001a1\t\r\u0005M\u0007\u0001\"\u0001Q\u0003-\"Xm\u001d;TK\u001elWM\u001c;He>,\b/\u001b8h\r>dGn\\<j]\u001edu.\u00193PMj+'o\\%oI\u0016D\bfAAiA\"9\u0011\u0011\u001c\u0001\u0005\n\u0005m\u0017!E2iK\u000e\\7+Z4nK:$xJ\u001d3feR\u0019\u0011+!8\t\u0011\u0005}\u0017q\u001ba\u0001\u0003C\faa\u001a:pkB\u001c\bCBA:\u0003G\f9/\u0003\u0003\u0002f\u0006U$aA*fcB1\u00111OAr\u0003S\u00042AFAv\u0013\r\tiO\u0001\u0002\u000b\u0019><7+Z4nK:$\bBBAy\u0001\u0011\u0005\u0001+\u0001\nuKN$()^5mI>3gm]3u\u001b\u0006\u0004\bfAAxA\"1\u0011q\u001f\u0001\u0005\u0002A\u000bQ\u0004^3tiN+w-\\3oi^KG\u000f[(gMN,Go\u0014<fe\u001adwn\u001e\u0015\u0004\u0003k\u0004\u0007BBA\u007f\u0001\u0011\u0005\u0001+\u0001\fuKN$(+Z2pm\u0016\u0014\u00180\u00114uKJ\u001c%/Y:iQ\r\tY\u0010\u0019\u0005\u0007\u0005\u0007\u0001A\u0011\u0001)\u00027Q,7\u000f\u001e\"vS2$wJ\u001a4tKRl\u0015\r\u001d$bW\u0016d\u0015M]4fQ\r\u0011\t\u0001\u0019\u0005\u0007\u0005\u0013\u0001A\u0011\u0001)\u00023Q,7\u000f\u001e\"vS2$\u0007+\u0019:uS\u0006dwJ\u001a4tKRl\u0015\r\u001d\u0015\u0004\u0005\u000f\u0001\u0007B\u0002B\b\u0001\u0011\u0005\u0001+\u0001\u000euKN$8\t\\3b]\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002\u0003\u000e\u0001DaA!\u0006\u0001\t\u0003\u0001\u0016!\n;fgR\u001cE.[3oi\"\u000bg\u000e\u001a7j]\u001e|emQ8seV\u0004H/T3tg\u0006<WmU3uQ\r\u0011\u0019\u0002\u0019\u0005\u0007\u00057\u0001A\u0011\u0001)\u0002%Q,7\u000f^\"mK\u0006tGk\\7cgR|g.\u001a\u0015\u0004\u00053\u0001\u0007b\u0002B\u0011\u0001\u0011%!1E\u0001\u000boJLG/\u001a+p\u0019><G\u0003CA9\u0005K\u00119Ca\f\t\u000f\r\u0011y\u00021\u0001\u0002\"!A!\u0011\u0006B\u0010\u0001\u0004\u0011Y#A\u0007lKf\u001c\u0018I\u001c3WC2,Xm\u001d\t\u0007\u0003g\nIH!\f\u0011\u000fI\u000bi\"!\r\u00022!A!\u0011\u0007B\u0010\u0001\u0004\t\t(A\u0005pM\u001a\u001cX\r^*fc\"9!Q\u0007\u0001\u0005\n\t]\u0012!F5om\u0006d\u0017\u000eZ\"mK\u0006tW\rZ'fgN\fw-\u001a\u000b\t\u0005s\u0011)E!\u0013\u0003LA!!1\bB!\u001b\t\u0011iD\u0003\u0003\u0003@\u0005E\u0016A\u0002:fG>\u0014H-\u0003\u0003\u0003D\tu\"!D'f[>\u0014\u0018PU3d_J$7\u000f\u0003\u0005\u0003H\tM\u0002\u0019AA?\u00035Ig.\u001b;jC2|eMZ:fi\"A!\u0011\u0006B\u001a\u0001\u0004\u0011Y\u0003\u0003\u0006\u0003N\tM\u0002\u0013!a\u0001\u0005\u001f\nQaY8eK\u000e\u0004BAa\u000f\u0003R%!!1\u000bB\u001f\u0005=\u0019u.\u001c9sKN\u001c\u0018n\u001c8UsB,\u0007b\u0002B,\u0001\u0011%!\u0011L\u0001\u0012[\u0016\u001c8/Y4f/&$\bn\u00144gg\u0016$H\u0003\u0003B\u001d\u00057\u0012YGa\u001c\t\u0011\tu#Q\u000ba\u0001\u0005?\n1a[3z!\u0015\u0011&\u0011\rB3\u0013\r\u0011\u0019g\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004%\n\u001d\u0014b\u0001B5'\n!!)\u001f;f\u0011!\u0011iG!\u0016A\u0002\t}\u0013!\u0002<bYV,\u0007\u0002\u0003B9\u0005+\u0002\r!! \u0002\r=4gm]3u\u0011\u001d\u00119\u0006\u0001C\u0005\u0005k\"\u0002B!\u000f\u0003x\te$1\u0010\u0005\t\u0005;\u0012\u0019\b1\u0001\u00022!A!Q\u000eB:\u0001\u0004\t\t\u0004\u0003\u0005\u0003r\tM\u0004\u0019AA?\u0011\u001d\u0011y\b\u0001C\u0005\u0005\u0003\u000bq!\\1lK2{w\r\u0006\u0005\u0002\"\t\r%Q\u0011BE\u0011!)#Q\u0010I\u0001\u0002\u0004Q\u0002\"\u0003BD\u0005{\u0002\n\u00111\u00017\u0003\u0019\u0019wN\u001c4jO\"Q!1\u0012B?!\u0003\u0005\r!! \u0002\u001bI,7m\u001c<fef\u0004v.\u001b8u\u0011\u001d\u0011y\t\u0001C\u0005\u0005#\u000b1\"\\1lK\u000ecW-\u00198feRA!1\u0013BM\u0005;\u00139\u000bE\u0002\u0017\u0005+K1Aa&\u0003\u0005\u001d\u0019E.Z1oKJD\u0001Ba'\u0003\u000e\u0002\u0007\u0011\u0011G\u0001\tG\u0006\u0004\u0018mY5us\"Q!q\u0014BG!\u0003\u0005\rA!)\u0002\u0013\rDWmY6E_:,\u0007C\u0002*\u0003$\u00065\u0016+C\u0002\u0003&N\u0013\u0011BR;oGRLwN\\\u0019\t\u0015\t%&Q\u0012I\u0001\u0002\u0004\t\t$\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\t\u000f\t\u0005\u0002\u0001\"\u0003\u0003.R1\u0011\u0011\u000fBX\u0005cCqa\u0001BV\u0001\u0004\t\t\u0003\u0003\u0005\u00034\n-\u0006\u0019\u0001B\u0016\u0003\r\u0019X-\u001d\u0005\b\u0005;\u0002A\u0011\u0002B\\)\u0011\u0011IL!2\u0011\t\tm&\u0011Y\u0007\u0003\u0005{S1Aa0\u001f\u0003\rq\u0017n\\\u0005\u0005\u0005\u0007\u0014iL\u0001\u0006CsR,')\u001e4gKJD\u0001Ba2\u00036\u0002\u0007\u0011QP\u0001\u0003S\u0012DqAa\u0010\u0001\t\u0013\u0011Y\r\u0006\b\u0003:\t5'q\u001aBi\u0005+\u0014yNa9\t\u0011\tu#\u0011\u001aa\u0001\u0003cA\u0001B!\u001c\u0003J\u0002\u0007\u0011\u0011\u0007\u0005\u000b\u0005'\u0014I\r%AA\u0002\u0005u\u0014A\u00039s_\u0012,8-\u001a:JI\"Q!q\u001bBe!\u0003\u0005\rA!7\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\r\u0011&1\\\u0005\u0004\u0005;\u001c&!B*i_J$\bB\u0003Bq\u0005\u0013\u0004\n\u00111\u0001\u00022\u0005A1/Z9vK:\u001cW\r\u0003\u0006\u0003f\n%\u0007\u0013!a\u0001\u0003c\tA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0007b\u0002Bu\u0001\u0011%!1^\u0001\u001cCB\u0004XM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\!t\u0019\u0016\fG-\u001a:\u0015\u0011\t5(q\u001fB}\u0005w\u0004rA\u0015BR\u0005_\u0014\t\u0010\u0005\u0004\u0002t\u0005\r\u0018\u0011\u0007\t\u0004-\tM\u0018b\u0001B{\u0005\tiAj\\4BaB,g\u000eZ%oM>Dqa\u0001Bt\u0001\u0004\t\t\u0003\u0003\u0005\u0003T\n\u001d\b\u0019AA?\u0011!\u00119Na:A\u0002\te\u0007b\u0002B\u0000\u0001\u0011%1\u0011A\u0001\u0019CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014HC\u0003Bw\u0007\u0007\u0019)aa\u0002\u0004\n!91A!@A\u0002\u0005\u0005\u0002\u0002\u0003Bj\u0005{\u0004\r!! \t\u0011\t]'Q a\u0001\u00053D!ba\u0003\u0003~B\u0005\t\u0019AB\u0007\u0003=I7\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007c\u0001*\u0004\u0010%\u00191\u0011C*\u0003\u000f\t{w\u000e\\3b]\"91Q\u0003\u0001\u0005\n\r]\u0011\u0001D2p[6LG/T1sW\u0016\u0014H\u0003\u0003B\u001d\u00073\u0019Yb!\b\t\u0011\tM71\u0003a\u0001\u0003{B\u0001Ba6\u0004\u0014\u0001\u0007!\u0011\u001c\u0005\u000b\u0007?\u0019\u0019\u0002%AA\u0002\u0005u\u0014!\u0003;j[\u0016\u001cH/Y7q\u0011\u001d\u0019\u0019\u0003\u0001C\u0005\u0007K\t1\"\u00192peRl\u0015M]6feRA!\u0011HB\u0014\u0007S\u0019Y\u0003\u0003\u0005\u0003T\u000e\u0005\u0002\u0019AA?\u0011!\u00119n!\tA\u0002\te\u0007BCB\u0010\u0007C\u0001\n\u00111\u0001\u0002~!91q\u0006\u0001\u0005\n\rE\u0012\u0001D3oIRCh.T1sW\u0016\u0014H\u0003\u0004B\u001d\u0007g\u0019)da\u000e\u0004B\r\r\u0003\u0002\u0003Bj\u0007[\u0001\r!! \t\u0011\t]7Q\u0006a\u0001\u00053D\u0001b!\u000f\u0004.\u0001\u000711H\u0001\u0012G>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007\u0003\u0002B\u001e\u0007{IAaa\u0010\u0003>\t\t2i\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\t\u0011\tE4Q\u0006a\u0001\u0003{B\u0001ba\b\u0004.\u0001\u0007\u0011Q\u0010\u0005\b\u0005\u007f\u0001A\u0011BB$)\u0019\u0011Id!\u0013\u0004L!A!QLB#\u0001\u0004\t\t\u0004\u0003\u0005\u0003n\r\u0015\u0003\u0019\u0001B0\u0011\u001d\u0019y\u0005\u0001C\u0005\u0007#\nQ\"\u001e8lKf,GMU3d_J$G\u0003\u0002B\u001d\u0007'B\u0001B!\u001c\u0004N\u0001\u0007\u0011\u0011\u0007\u0005\b\u0007/\u0002A\u0011BB-\u0003=!x.\u001c2ti>tWMU3d_J$G\u0003\u0002B\u001d\u00077B\u0001B!\u0018\u0004V\u0001\u0007\u0011\u0011\u0007\u0005\b\u0007?\u0002A\u0011BB1\u0003=\u0011XmY8wKJ\fe\u000eZ\"iK\u000e\\GCBA\u0011\u0007G\u001a)\u0007C\u0004\u0003\b\u000eu\u0003\u0019\u0001\u001c\t\u0011\r\u001d4Q\fa\u0001\u0003c\nA\"\u001a=qK\u000e$X\rZ&fsND\u0011ba\u001b\u0001#\u0003%Ia!\u001c\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u000e\u0016\u0005\u0005C\u001b\th\u000b\u0002\u0004tA!1QOB@\u001b\t\u00199H\u0003\u0003\u0004z\rm\u0014!C;oG\",7m[3e\u0015\r\u0019ihU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBA\u0007o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0019)\tAI\u0001\n\u0013\u00199)A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r%%\u0006BA\u0019\u0007cB\u0011b!$\u0001#\u0003%Iaa$\u0002#5\f7.\u001a'pO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u0012*\u001a!d!\u001d\t\u0013\rU\u0005!%A\u0005\n\r]\u0015!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u0014\u0016\u0004m\rE\u0004\"CBO\u0001E\u0005I\u0011BBP\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0007CSC!! \u0004r!I1Q\u0015\u0001\u0012\u0002\u0013%1qT\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIMB\u0011b!+\u0001#\u0003%Iaa+\u0002!I,7m\u001c:eI\u0011,g-Y;mi\u0012\"TCABWU\u0011\u0011In!\u001d\t\u0013\rE\u0006!%A\u0005\n\r\u001d\u0015\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00136\u0011%\u0019)\fAI\u0001\n\u0013\u00199)\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%m!I1\u0011\u0018\u0001\u0012\u0002\u0013%11X\u0001#CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\ru&\u0006BB\u0007\u0007cB\u0011b!1\u0001#\u0003%Iaa(\u0002+\u0005\u0014wN\u001d;NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I1Q\u0019\u0001\u0012\u0002\u0013%1qT\u0001\u0017G>lW.\u001b;NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I1\u0011\u001a\u0001\u0012\u0002\u0013%11Z\u0001 S:4\u0018\r\\5e\u00072,\u0017M\\3e\u001b\u0016\u001c8/Y4fI\u0011,g-Y;mi\u0012\u001aTCABgU\u0011\u0011ye!\u001d")
public class LogCleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$43 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$44 = this.makeLog$default$1();
        long x$45 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$44, x$43, x$45);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$1.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        Seq segments = ((TraversableOnce)log2.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log2, segments, (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(long x$2) {
                return this.apply$mcZJ$sp(x$2);
            }

            public boolean apply$mcZJ$sp(long x$2) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToLong((long)x$2));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$46 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$47 = this.makeLog$default$1();
        long x$48 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$47, x$46, x$48);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertTrue((String)"Cleaned segment file should be trimmed to its real size.", (((LogSegment)log2.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateCheckAfterCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$49 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$50 = this.makeLog$default$1();
        long x$51 = this.makeLog$default$3();
        ObjectRef log2 = ObjectRef.create((Object)this.makeLog(x$50, x$49, x$51));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log2.elem;
        long x$52 = qual$1.roll$default$1();
        qual$1.roll(x$52);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTest$.MODULE$.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log2.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log2.elem;
        long x$56 = qual$2.roll$default$1();
        qual$2.roll(x$56);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log2.elem, 0L, ((Log)log2.elem).activeSegment().baseOffset()));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTest$.MODULE$.keysInLog((Log)log2.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((Log)log2.elem));
        this.reloadLog$1(logProps, log2);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log2.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$57 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$58 = this.makeLog$default$1();
        long x$59 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$58, x$57, x$59);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, false);
        List abortedTransactions = log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)abortedTransactions, (Object)log2.collectAbortedTransactions(log2.logStartOffset(), log2.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$60 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$61 = this.makeLog$default$1();
        long x$62 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$61, x$60, x$62);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log2, pid1, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log2, pid2, producerEpoch);
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log2, pid3, producerEpoch);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log2.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log2.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log2.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, false);
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()))._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTest$.MODULE$.keysInLog(log2));
        log2.roll(log2.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, dirtyOffset, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTest$.MODULE$.keysInLog(log2));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$63 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$64 = this.makeLog$default$1();
        long x$65 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$64, x$63, x$65);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log2));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        TopicPartition tp = new TopicPartition("test", 0);
        int x$66 = Integer.MAX_VALUE;
        int x$67 = 100;
        Function1<TopicPartition, BoxedUnit> x$68 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$66, x$68, x$67);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$69 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$70 = this.makeLog$default$1();
        long x$71 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$70, x$69, x$71);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$72 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$73 = this.makeLog$default$1();
        long x$74 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$73, x$72, x$74);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.lastOffsetsPerBatchInLog(log2));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$75 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$76 = this.makeLog$default$1();
        long x$77 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$76, x$75, x$77);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log2.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
        cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$78 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$79 = this.makeLog$default$1();
        long x$80 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$79, x$78, x$80);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, 0L, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log2.roll(log2.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        this.assertAbortedTransactionIndexed$1(log2, producerId);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log2, dirtyOffset, 100L), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((long)0L, (long)log2.collectAbortedTransactions(0L, 100L).size());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$81 = Integer.MAX_VALUE;
        int x$82 = 1024;
        Function1<TopicPartition, BoxedUnit> x$83 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$81, x$83, x$82);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$84 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$85 = this.makeLog$default$1();
        long x$86 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$85, x$84, x$86);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.record((int)log2.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$2.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log2.logSegments().head()})), (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log2).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$2;

            public final boolean apply(long x$3) {
                return this.apply$mcZJ$sp(x$3);
            }

            public boolean apply$mcZJ$sp(long x$3) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToLong((long)x$3));
            }
            {
                this.keys$2 = keys$2;
            }
        });
        Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log2));
    }

    @Test
    public void testMessageLargerThanMaxMessageSize() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            int x$87 = Integer.MAX_VALUE;
            int x$88 = 1024;
            Function1<TopicPartition, BoxedUnit> x$89 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$87, x$89, x$88);
            cleaner.cleanSegments(log3, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log3.logSegments().head()})), (OffsetMap)offsetMap2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            Iterable shouldRemain = (Iterable)LogTest$.MODULE$.keysInLog(log3).filter((Function1)new Serializable(this, offsetMap2){
                public static final long serialVersionUID = 0L;
                private final FakeOffsetMap offsetMap$1;

                public final boolean apply(long k) {
                    return this.apply$mcZJ$sp(k);
                }

                public boolean apply$mcZJ$sp(long k) {
                    return !this.offsetMap$1.map().containsKey(((Object)BoxesRunTime.boxToLong((long)k)).toString());
                }
                {
                    this.offsetMap$1 = offsetMap$1;
                }
            });
            Assert.assertEquals((Object)shouldRemain, LogTest$.MODULE$.keysInLog(log3));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            RandomAccessFile file = new RandomAccessFile(((LogSegment)log3.logSegments().head()).log().file(), "rw");
            file.seek(16L);
            file.write(255);
            file.close();
            int x$90 = Integer.MAX_VALUE;
            int x$91 = 1024;
            Function1<TopicPartition, BoxedUnit> x$92 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$90, x$92, x$91);
            this.intercept((Function0)new Serializable(this, log3, offsetMap2, cleaner){
                public static final long serialVersionUID = 0L;
                private final Log log$4;
                private final FakeOffsetMap offsetMap$2;
                private final Cleaner cleaner$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.cleaner$1.cleanSegments(this.log$4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)this.log$4.logSegments().head()})), (OffsetMap)this.offsetMap$2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
                }
                {
                    this.log$4 = log$4;
                    this.offsetMap$2 = offsetMap$2;
                    this.cleaner$1 = cleaner$1;
                }
            }, ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Log log2 = (Log)tuple2._1();
            FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)log2, (Object)offsetMap);
            Log log3 = (Log)tuple23._1();
            FakeOffsetMap offsetMap2 = (FakeOffsetMap)tuple23._2();
            RandomAccessFile file = new RandomAccessFile(((LogSegment)log3.logSegments().head()).log().file(), "rw");
            file.setLength(1024L);
            file.close();
            int x$93 = Integer.MAX_VALUE;
            int x$94 = 1024;
            Function1<TopicPartition, BoxedUnit> x$95 = this.makeCleaner$default$2();
            Cleaner cleaner = this.makeCleaner(x$93, x$95, x$94);
            this.intercept((Function0)new Serializable(this, log3, offsetMap2, cleaner){
                public static final long serialVersionUID = 0L;
                private final Log log$5;
                private final FakeOffsetMap offsetMap$3;
                private final Cleaner cleaner$2;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.cleaner$2.cleanSegments(this.log$5, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)this.log$5.logSegments().head()})), (OffsetMap)this.offsetMap$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
                }
                {
                    this.log$5 = log$5;
                    this.offsetMap$3 = offsetMap$3;
                    this.cleaner$2 = cleaner$2;
                }
            }, ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
            return;
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Log, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$96 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$97 = this.makeLog$default$1();
        long x$98 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$97, x$96, x$98);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.record((int)log2.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log2);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log2.logEndOffset())), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize / 2));
        log2.config_$eq(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$3.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        return new Tuple2((Object)log2, (Object)map);
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$99 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$100 = this.makeLog$default$1();
        long x$101 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$100, x$99, x$101);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long leo = log2.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$6;

            public final LogAppendInfo apply(int key) {
                return this.log$6.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$tombstoneRecord(key), 0, this.log$6.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$6 = log$6;
            }
        });
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Set keys = LogTest$.MODULE$.keysInLog(log2).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$3;

            public final boolean apply(int x$7) {
                return this.apply$mcZI$sp(x$7);
            }

            public boolean apply$mcZI$sp(int x$7) {
                return !this.keys$3.contains((Object)BoxesRunTime.boxToLong((long)x$7));
            }
            {
                this.keys$3 = keys$3;
            }
        }));
    }

    public void testLogCleanerStats() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$102 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$103 = this.makeLog$default$1();
        long x$104 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$103, x$102, x$104);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        long initialLogSize = log2.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            long endOffset = tuple2._1$mcJ$sp();
            CleanerStats stats = (CleanerStats)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
            long endOffset2 = tuple23._1$mcJ$sp();
            CleanerStats stats2 = (CleanerStats)tuple23._2();
            Assert.assertEquals((long)5L, (long)endOffset2);
            Assert.assertEquals((long)5L, (long)stats2.messagesRead());
            Assert.assertEquals((long)initialLogSize, (long)stats2.bytesRead());
            Assert.assertEquals((long)2L, (long)stats2.messagesWritten());
            Assert.assertEquals((long)log2.size(), (long)stats2.bytesWritten());
            Assert.assertEquals((long)0L, (long)stats2.invalidMessagesRead());
            Assert.assertTrue((stats2.endTime() >= stats2.startTime() ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$105 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$106 = this.makeLog$default$1();
        long x$107 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$106, x$105, x$107);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 1, 1L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 2, 2L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 3, 3L, (short)0, 0, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, 2L, (short)0, 1, this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L)), (Object)BoxesRunTime.boxToInteger((int)0))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$108 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$109 = this.makeLog$default$1();
        long x$110 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$109, x$108, x$110);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log2, producerId, producerEpoch);
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log2.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, false);
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log2));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log2));
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId)), (Object)BoxesRunTime.boxToInteger((int)4))})), this.lastSequencesInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log2));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$111 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$112 = this.makeLog$default$1();
        long x$113 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$112, x$111, x$113);
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 3L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log2));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 4L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTest$.MODULE$.keysInLog(log2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log2));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$114 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$115 = this.makeLog$default$1();
        long x$116 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$115, x$114, x$116);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log2.numberOfSegments() <= numCleanableSegments) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long firstUncleanableOffset = log2.logEndOffset() + 1L;
        while (log2.numberOfSegments() < numTotalSegments - 1) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset() % N, (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Seq disctinctValuesBySegmentBeforeClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)this.distinctValuesBySegment$1(log2).reverse()).tail()).forall((Function1)new Serializable(this, N){
            public static final long serialVersionUID = 0L;
            private final int N$1;

            public final boolean apply(int x$9) {
                return this.apply$mcZI$sp(x$9);
            }

            public boolean apply$mcZI$sp(int x$9) {
                return x$9 > this.N$1;
            }
            {
                this.N$1 = N$1;
            }
        }));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = this.distinctValuesBySegment$1(log2);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int before = tuple2._1$mcI$sp();
                    int after = tuple2._2$mcI$sp();
                    boolean bl = after < before;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcI$sp() == x._2$mcI$sp();
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$117 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$118 = this.makeLog$default$1();
        long x$119 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$118, x$117, x$119);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$8;

            public final LogAppendInfo apply(int _) {
                return this.log$8.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecorcs$1(), 0, this.log$8.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$8 = log$8;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, log2.activeSegment().baseOffset(), log2.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log2.size() - (long)log2.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$120 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$121 = this.makeLog$default$1();
        long x$122 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$121, x$120, x$122);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$9;

            public final LogAppendInfo apply(int _) {
                return this.log$9.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$createRecords$1(), 0, this.log$9.appendAsLeader$default$3());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$9 = log$9;
            }
        });
        Seq segs = log2.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log2, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$10) {
                return x$10.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$11) {
                return x$11.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$123 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$124 = this.makeLog$default$1();
        long x$125 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$124, x$123, x$125);
        while (log2.numberOfSegments() < 2) {
            log2.appendAsLeader(this.unkeyedRecord((int)log2.logEndOffset()), 0, log2.appendAsLeader$default$3());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log2);
        long sizeWithUnkeyedMessages = log2.size();
        while (log2.numberOfSegments() < 3) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        long expectedSizeAfterCleaning = log2.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        if (tuple2 != null) {
            CleanerStats stats;
            CleanerStats cleanerStats;
            CleanerStats stats2 = cleanerStats = (stats = (CleanerStats)tuple2._2());
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log2));
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log2.size());
            Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)stats2.invalidMessagesRead());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return batch.lastOffset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(Log log2) {
        return ((TraversableOnce)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return !batch.isControlBatch() && batch.hasProducerId();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId())), (Object)BoxesRunTime.boxToInteger((int)batch.lastSequence()));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(Log log2) {
        return (Iterable)log2.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$12) {
                        return x$12.hasValue();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$13) {
                        return x$13.hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Record m) {
                        return m.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log2) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record x$14) {
                        return x$14.hasValue();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Record m) {
                        return !m.hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final void apply(TopicPartition topicPartition) {
                this.$outer.abortCheckDone(topicPartition);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$126 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$127 = this.makeLog$default$1();
        long x$128 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$127, x$126, x$128);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        }
        Iterable<Object> keys = LogTest$.MODULE$.keysInLog(log2);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$4;

            public final void apply(long k) {
                this.apply$mcVJ$sp(k);
            }

            public void apply$mcVJ$sp(long k) {
                this.map$4.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$4 = map$4;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log2, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$3;
            private final Log log$10;
            private final FakeOffsetMap map$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$3.cleanSegments(this.log$10, ((TraversableOnce)this.log$10.logSegments().take(3)).toSeq(), (OffsetMap)this.map$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$3 = cleaner$3;
                this.log$10 = log$10;
                this.map$4 = map$4;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$129 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$130 = this.makeLog$default$1();
        long x$131 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$130, x$129, x$131);
        int i = 0;
        while (log2.numberOfSegments() < 10) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), 1, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$15) {
                return x$15.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, 1, log2.logEndOffset());
        Assert.assertEquals((long)log2.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$16) {
                return x$16.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$17) {
                return x$17.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), logSize, Integer.MAX_VALUE, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$18) {
                return x$18.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log2.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$19) {
                return x$19.offsetIndex().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, indexSize, log2.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$20) {
                return x$20.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$132 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$133 = this.makeLog$default$1();
        long x$134 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$133, x$132, x$134);
        while (log2.numberOfSegments() == 1) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        }
        MemoryRecords records2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log2.appendAsFollower(records2);
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log2.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log2.numberOfSegments() < 4) {
            log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log2.appendAsLeader$default$3());
        }
        groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)(log2.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$135 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$136 = this.makeLog$default$1();
        long x$137 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$136, x$135, x$137);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log2.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log2.appendAsFollower(record2);
        log2.roll(0x3FFFFFFFL);
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log2.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log2.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log2.logEndOffset() - 1L - log2.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log2.logSegments().last()).offsetIndex().lastOffset() - log2.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log2.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log2.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$21) {
                return (Seq)x$21.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$22) {
                        return x$22.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 500;
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log2.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log2, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log2.logEndOffset(), log2, cleaner);
    }

    @Test
    public void testSegmentWithOffsetOverflow() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTest$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        LogConfig x$138 = config;
        long x$139 = Long.MAX_VALUE;
        File x$140 = this.makeLog$default$1();
        Log log2 = this.makeLog(x$140, x$138, x$139);
        LogSegment segmentWithOverflow = (LogSegment)LogTest$.MODULE$.firstOverflowSegment(log2).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final Nothing$ apply() {
                return this.$outer.fail("Failed to create log with a segment which has overflowed offsets", new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int numSegmentsInitial = log2.logSegments().size();
        List allKeys = LogTest$.MODULE$.keysInLog(log2).toList();
        MutableList expectedKeysAfterCleaning = (MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), allKeys.size()).by(2).foreach$mVc$sp((Function1)new Serializable(this, allKeys, expectedKeysAfterCleaning, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final List allKeys$1;
            private final MutableList expectedKeysAfterCleaning$1;
            private final FakeOffsetMap offsetMap$4;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.expectedKeysAfterCleaning$1.$plus$eq(this.allKeys$1.apply(k - 1));
                this.offsetMap$4.put(this.$outer.kafka$log$LogCleanerTest$$key(BoxesRunTime.unboxToLong((Object)this.allKeys$1.apply(k))), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allKeys$1 = allKeys$1;
                this.expectedKeysAfterCleaning$1 = expectedKeysAfterCleaning$1;
                this.offsetMap$4 = offsetMap$4;
            }
        });
        this.assertThrows((Function0)new Serializable(this, cleaner, log2, segmentWithOverflow, offsetMap){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$5;
            private final Log log$14;
            private final LogSegment segmentWithOverflow$1;
            private final FakeOffsetMap offsetMap$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$5.cleanSegments(this.log$14, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.segmentWithOverflow$1})), (OffsetMap)this.offsetMap$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$5 = cleaner$5;
                this.log$14 = log$14;
                this.segmentWithOverflow$1 = segmentWithOverflow$1;
                this.offsetMap$4 = offsetMap$4;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1087));
        Assert.assertEquals((long)(numSegmentsInitial + 1), (long)log2.logSegments().size());
        Assert.assertEquals((Object)allKeys, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log2));
        log2.logSegments().foreach((Function1)new Serializable(this, cleaner, log2, offsetMap){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$5;
            private final Log log$14;
            private final FakeOffsetMap offsetMap$4;

            public final void apply(LogSegment segmentToClean) {
                this.cleaner$5.cleanSegments(this.log$14, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{segmentToClean})), (OffsetMap)this.offsetMap$4, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$5 = cleaner$5;
                this.log$14 = log$14;
                this.offsetMap$4 = offsetMap$4;
            }
        });
        Assert.assertEquals((Object)expectedKeysAfterCleaning, LogTest$.MODULE$.keysInLog(log2));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log2));
        log2.close();
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$141 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$142 = this.makeLog$default$1();
        long x$143 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$142, x$141, x$143);
        int messageCount = 0;
        while (log2.numberOfSegments() < 10) {
            Log qual$3 = log2;
            MemoryRecords x$144 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$145 = 0;
            boolean x$146 = qual$3.appendAsLeader$default$3();
            qual$3.appendAsLeader(x$144, x$145, x$146);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTest$.MODULE$.keysInLog(log2);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log2 = this.recoverAndCheck(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$4 = log2;
            MemoryRecords x$147 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$148 = 0;
            boolean x$149 = qual$4.appendAsLeader$default$3();
            qual$4.appendAsLeader(x$147, x$148, x$149);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        ((LogSegment)log2.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log2 = this.recoverAndCheck(config, cleanedKeys);
        while (log2.numberOfSegments() < 10) {
            Log qual$5 = log2;
            MemoryRecords x$150 = this.kafka$log$LogCleanerTest$$record((int)log2.logEndOffset(), (int)log2.logEndOffset(), this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6());
            int x$151 = 0;
            boolean x$152 = qual$5.appendAsLeader$default$3();
            qual$5.appendAsLeader(x$150, x$151, x$152);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$5;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$5.put(this.$outer.kafka$log$LogCleanerTest$$key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetMap$5 = offsetMap$5;
            }
        });
        cleaner.cleanSegments(log2, ((TraversableOnce)log2.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log2);
        log2.close();
        log2 = this.recoverAndCheck(config, cleanedKeys);
        log2.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$153 = logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$154 = this.makeLog$default$1();
        long x$155 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$154, x$153, x$155);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(keyStart), keyEnd), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log2, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)offsetEnd, (long)map.latestOffset());
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(keyEnd - keyStart), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0L)));
        Assert.assertEquals((String)"Map should contain second value", (long)offsetEnd, (long)map.get(this.kafka$log$LogCleanerTest$$key(1L)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log2 = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(0, 0, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(1, 1, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(2, 2, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(3, 3, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.appendAsLeader(this.kafka$log$LogCleanerTest$$record(4, 4, this.kafka$log$LogCleanerTest$$record$default$3(), this.kafka$log$LogCleanerTest$$record$default$4(), this.kafka$log$LogCleanerTest$$record$default$5(), this.kafka$log$LogCleanerTest$$record$default$6()), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log2, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(0L)));
        Assert.assertEquals((long)2L, (long)map.get(this.kafka$log$LogCleanerTest$$key(2L)));
        Assert.assertEquals((long)3L, (long)map.get(this.kafka$log$LogCleanerTest$$key(3L)));
        Assert.assertEquals((long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(4L)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig x$156 = logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$157 = this.makeLog$default$1();
        long x$158 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$157, x$156, x$158);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log2.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log2.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        log2.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FileLogInputStream.FileChannelRecordBatch batch) {
                        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this, batch){
                            public static final long serialVersionUID = 0L;
                            private final FileLogInputStream.FileChannelRecordBatch batch$1;

                            public final void apply(Record record) {
                                Assert.assertTrue((boolean)record.hasMagic(this.batch$1.magic()));
                                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                                Assert.assertEquals((long)record.offset(), (long)value);
                            }
                            {
                                this.batch$1 = batch$1;
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.records()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Record logEntry) {
                long offset = logEntry.offset();
                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                Assert.assertEquals((long)offset, (long)value);
            }
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig;
        LogConfig x$159 = logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File x$160 = this.makeLog$default$1();
        long x$161 = this.makeLog$default$3();
        Log log2 = this.makeLog(x$160, x$159, x$161);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$162 = "0".getBytes();
        byte[] x$163 = "0".getBytes();
        long x$164 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$165 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$166 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$162, x$163, x$165, x$164, x$166), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 0L, log2.activeSegment().baseOffset()));
        byte[] x$167 = null;
        byte[] x$168 = "0".getBytes();
        long x$169 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$170 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$171 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$167, x$168, x$170, x$169, x$171), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 1L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$172 = "1".getBytes();
        byte[] x$173 = "1".getBytes();
        long x$174 = this.time().milliseconds();
        CompressionType x$175 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$176 = TestUtils$.MODULE$.singletonRecords$default$5();
        log2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$172, x$173, x$175, x$174, x$176), 0, log2.appendAsLeader$default$3());
        log2.roll(log2.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log2, 2L, log2.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log2.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> check$ifrefutable$1) {
                Tuple2 tuple2;
                Tuple2<Tuple2<Object, Object>, Object> tuple22 = check$ifrefutable$1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$13;

            public final long apply(Tuple2<Tuple2<Object, Object>, Object> x$23) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x$23;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        int key = tuple22._1$mcI$sp();
                        int value = tuple22._2$mcI$sp();
                        long l = this.log$13.appendAsFollower(this.$outer.kafka$log$LogCleanerTest$$messageWithOffset(key, value, offset)).lastOffset();
                        return l;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$13 = log$13;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records2 = (Iterable)keysAndValues.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LegacyRecord apply(Tuple2<Object, Object> kv) {
                return LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LegacyRecord x$24) {
                return x$24.sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$1;

            public final void apply(LegacyRecord record) {
                this.builder$1.appendUncheckedWithOffset(this.offset$1.elem, record);
                ++this.offset$1.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$1 = offset$1;
            }
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    public MemoryRecords kafka$log$LogCleanerTest$$messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        File x$33 = dir;
        LogConfig x$34 = config;
        long x$35 = 0L;
        long x$36 = recoveryPoint;
        MockScheduler x$37 = this.time().scheduler();
        MockTime x$38 = this.time();
        BrokerTopicStats x$39 = new BrokerTopicStats();
        int x$40 = 3600000;
        int x$41 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$42 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$33, x$34, x$35, x$36, (Scheduler)x$37, x$39, (Time)x$38, x$40, x$41, x$42);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(TopicPartition x$25) {
            }
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log2, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$12;

            public final long apply(Tuple2<Object, Object> x$26) {
                Tuple2<Object, Object> tuple2 = x$26;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = BoxesRunTime.unboxToLong((Object)this.log$12.appendAsLeader(this.$outer.kafka$log$LogCleanerTest$$record(key, value, this.$outer.kafka$log$LogCleanerTest$$record$default$3(), this.$outer.kafka$log$LogCleanerTest$$record$default$4(), this.$outer.kafka$log$LogCleanerTest$$record$default$5(), this.$outer.kafka$log$LogCleanerTest$$record$default$6()), 0, this.log$12.appendAsLeader$default$3()).firstOffset().get());
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$12 = log$12;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer kafka$log$LogCleanerTest$$key(long id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToLong((long)id)).toString().getBytes());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log2, long producerId, short producerEpoch) {
        return this.appendIdempotentAsLeader(log2, producerId, producerEpoch, true);
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log2, long producerId, short producerEpoch, boolean isTransactional) {
        IntRef sequence = IntRef.create((int)0);
        return new Serializable(this, log2, producerId, producerEpoch, isTransactional, sequence){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$2;
            private final long producerId$1;
            private final short producerEpoch$1;
            private final boolean isTransactional$1;
            private final IntRef sequence$1;

            public final LogAppendInfo apply(Seq<Object> keys) {
                Seq simpleRecords = (Seq)keys.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$appendIdempotentAsLeader$1 $outer;

                    public final SimpleRecord apply(int key) {
                        byte[] keyBytes = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        return new SimpleRecord(this.$outer.kafka$log$LogCleanerTest$$anonfun$$$outer().time().milliseconds(), keyBytes, keyBytes);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                MemoryRecords records2 = this.isTransactional$1 ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)this.producerId$1, (short)this.producerEpoch$1, (int)this.sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
                this.sequence$1.elem += simpleRecords.size();
                return this.log$2.appendAsLeader(records2, 0, this.log$2.appendAsLeader$default$3());
            }

            public /* synthetic */ LogCleanerTest kafka$log$LogCleanerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.producerId$1 = producerId$1;
                this.producerEpoch$1 = producerEpoch$1;
                this.isTransactional$1 = isTransactional$1;
                this.sequence$1 = sequence$1;
            }
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$177 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
        byte[] x$178 = value;
        CompressionType x$179 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$180 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$181 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$178, x$177, x$179, x$180, x$181);
    }

    public long kafka$log$LogCleanerTest$$record$default$3() {
        return -1L;
    }

    public short kafka$log$LogCleanerTest$$record$default$4() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$5() {
        return -1;
    }

    public int kafka$log$LogCleanerTest$$record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public MemoryRecords kafka$log$LogCleanerTest$$tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private Log recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTest$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler(), LogTest$.MODULE$.recoverAndCheck$default$7());
    }

    private final void reloadLog$1(Properties logProps$1, ObjectRef log$1) {
        ((Log)log$1.elem).close();
        LogConfig x$53 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$1);
        long x$54 = 0L;
        File x$55 = this.makeLog$default$1();
        log$1.elem = this.makeLog(x$55, x$53, x$54);
    }

    private final void assertAbortedTransactionIndexed$1(Log log$3, long producerId$2) {
        List abortedTxns = log$3.collectAbortedTransactions(0L, 100L);
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        Assert.assertEquals((long)producerId$2, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assert.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    private final Seq distinctValuesBySegment$1(Log log$7) {
        return ((TraversableOnce)log$7.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Record record) {
                        return TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecorcs$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public final MemoryRecords kafka$log$LogCleanerTest$$createRecords$1() {
        return TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(25, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private final void checkRange$1(FakeOffsetMap map, int start2, int end, Log log$11, Cleaner cleaner$4) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$4.buildOffsetMap(log$11, (long)start2, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$5.get(this.$outer.kafka$log$LogCleanerTest$$key(i)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$5 = map$5;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(start2 - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.kafka$log$LogCleanerTest$$key(end)));
        Assert.assertEquals((long)(end - start2), (long)stats.mapMessagesRead());
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        double x$27 = Double.MAX_VALUE;
        long x$28 = Long.MAX_VALUE;
        MockTime x$29 = this.time();
        boolean x$30 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$31 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$32 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$27, x$28, x$30, x$31, x$32, (Time)x$29);
    }
}

