/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0001\u0003\u0001%\u0011QBS:p]Z\u000bG.^3UKN$(BA\u0002\u0005\u0003\u0011Q7o\u001c8\u000b\u0005\u00151\u0011!B;uS2\u001c(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005\u0011\u0001bB\u0002\u0001\u0005\u0004%\tAF\u000b\u0002/A\u0011\u0001d\u0007\b\u0003\u0017eI!A\u0007\u0007\u0002\rA\u0013X\rZ3g\u0013\taRD\u0001\u0004TiJLgn\u001a\u0006\u000351Aaa\b\u0001!\u0002\u00139\u0012!\u00026t_:\u0004\u0003\"B\u0011\u0001\t\u0013\u0011\u0013!\u00029beN,GCA\u0012'!\t!B%\u0003\u0002&\u0005\tI!j]8o-\u0006dW/\u001a\u0005\u0006O\u0001\u0002\raF\u0001\u0002g\")\u0011\u0006\u0001C\u0005U\u0005A\u0011m]:feR$v.\u0006\u0002,oQ\u0019A\u0006\u0011\"\u0015\u00055\u0002\u0004CA\u0006/\u0013\tyCB\u0001\u0003V]&$\bbB\u0019)\u0003\u0003\u0005\u001dAM\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001\u000b4k%\u0011AG\u0001\u0002\u000b\t\u0016\u001cw\u000eZ3Kg>t\u0007C\u0001\u001c8\u0019\u0001!Q\u0001\u000f\u0015C\u0002e\u0012\u0011\u0001V\t\u0003uu\u0002\"aC\u001e\n\u0005qb!a\u0002(pi\"Lgn\u001a\t\u0003\u0017yJ!a\u0010\u0007\u0003\u0007\u0005s\u0017\u0010C\u0003BQ\u0001\u0007Q'\u0001\u0005fqB,7\r^3e\u0011\u0015\u0019\u0005\u00061\u0001E\u0003%Q7o\u001c8WC2,X\r\u0005\u0003\f\u000b\u001e\u001b\u0013B\u0001$\r\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u0015\u0011&\u0011\u0011J\u0001\u0002\u000b\u0015N|gn\u00142kK\u000e$\b\"B&\u0001\t\u0013a\u0015!D1tg\u0016\u0014H\u000fV8GC&d7/\u0006\u0002N'R\u0011a\n\u0016\u000b\u0003[=Cq\u0001\u0015&\u0002\u0002\u0003\u000f\u0011+\u0001\u0006fm&$WM\\2fII\u00022\u0001F\u001aS!\t14\u000bB\u00039\u0015\n\u0007\u0011\bC\u0003D\u0015\u0002\u0007A\tC\u0003W\u0001\u0011\u0005q+A\u0006bgN,'\u000f\u001e+ie><XC\u0001-a)\tIv\u000e\u0006\u0002.5\"91,VA\u0001\u0002\ba\u0016AC3wS\u0012,gnY3%gA\u0019\u0001$X0\n\u0005yk\"\u0001C'b]&4Wm\u001d;\u0011\u0005Y\u0002G!B1V\u0005\u0004\u0011'!A#\u0012\u0005i\u001a\u0007C\u00013m\u001d\t)'N\u0004\u0002gS6\tqM\u0003\u0002i\u0011\u00051AH]8pizJ\u0011!D\u0005\u0003W2\tq\u0001]1dW\u0006<W-\u0003\u0002n]\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003W2Aa\u0001]+\u0005\u0002\u0004\t\u0018\u0001\u00022pIf\u00042a\u0003:.\u0013\t\u0019HB\u0001\u0005=Eft\u0017-\\3?\u0011\u0015)\b\u0001\"\u0001w\u0003A!Xm\u001d;Bg*\u001bxN\\(cU\u0016\u001cG/F\u0001.Q\t!\b\u0010\u0005\u0002z}6\t!P\u0003\u0002|y\u0006)!.\u001e8ji*\tQ0A\u0002pe\u001eL!a >\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003\u0007\u0001A\u0011\u0001<\u0002-Q,7\u000f^!t\u0015N|gn\u00142kK\u000e$x\n\u001d;j_:D3!!\u0001y\u0011\u0019\tI\u0001\u0001C\u0001m\u0006yA/Z:u\u0003NT5o\u001c8BeJ\f\u0017\u0010K\u0002\u0002\baDa!a\u0004\u0001\t\u00031\u0018!\u0006;fgR\f5OS:p]\u0006\u0013(/Y=PaRLwN\u001c\u0015\u0004\u0003\u001bA\bBBA\u000b\u0001\u0011\u0005a/A\tuKN$(j]8o\u001f\nTWm\u0019;HKRD3!a\u0005y\u0011\u0019\tY\u0002\u0001C\u0001m\u0006\u0019B/Z:u\u0015N|gn\u00142kK\u000e$\u0018\t\u001d9ms\"\u001a\u0011\u0011\u0004=\t\r\u0005\u0005\u0002\u0001\"\u0001w\u0003Y!Xm\u001d;Kg>twJ\u00196fGRLE/\u001a:bi>\u0014\bfAA\u0010q\"1\u0011q\u0005\u0001\u0005\u0002Y\fQ\u0003^3ti*\u001bxN\\!se\u0006L\u0018\n^3sCR|'\u000fK\u0002\u0002&aDa!!\f\u0001\t\u00031\u0018a\u0005;fgRT5o\u001c8WC2,X-R9vC2\u001c\bfAA\u0016q\"1\u00111\u0007\u0001\u0005\u0002Y\fQ\u0003^3ti*\u001bxN\u001c,bYV,\u0007*Y:i\u0007>$W\rK\u0002\u00022aDa!!\u000f\u0001\t\u00031\u0018!\u0006;fgRT5o\u001c8WC2,X\rV8TiJLgn\u001a\u0015\u0004\u0003oA\bBBA \u0001\u0011\u0005a/A\tuKN$H)Z2pI\u0016\u0014un\u001c7fC:D3!!\u0010y\u0011\u0019\t)\u0005\u0001C\u0001m\u0006\u0001B/Z:u\t\u0016\u001cw\u000eZ3TiJLgn\u001a\u0015\u0004\u0003\u0007B\bBBA&\u0001\u0011\u0005a/A\u0007uKN$H)Z2pI\u0016Le\u000e\u001e\u0015\u0004\u0003\u0013B\bBBA)\u0001\u0011\u0005a/\u0001\buKN$H)Z2pI\u0016duN\\4)\u0007\u0005=\u0003\u0010\u0003\u0004\u0002X\u0001!\tA^\u0001\u0011i\u0016\u001cH\u000fR3d_\u0012,Gi\\;cY\u0016D3!!\u0016y\u0011\u0019\ti\u0006\u0001C\u0001m\u0006iA/Z:u\t\u0016\u001cw\u000eZ3TKFD3!a\u0017y\u0011\u0019\t\u0019\u0007\u0001C\u0001m\u0006iA/Z:u\t\u0016\u001cw\u000eZ3NCBD3!!\u0019y\u0011\u0019\tI\u0007\u0001C\u0001m\u0006\u0001B/Z:u\t\u0016\u001cw\u000eZ3PaRLwN\u001c\u0015\u0004\u0003OB\b")
public class JsonValueTest {
    private final String json = new StringOps(Predef$.MODULE$.augmentString("\n    |{\n    |  \"boolean\": false,\n    |  \"int\": 1234,\n    |  \"long\": 3000000000,\n    |  \"double\": 16.244355,\n    |  \"string\": \"string\",\n    |  \"number_as_string\": \"123\",\n    |  \"array\": [4.0, 11.1, 44.5],\n    |  \"object\": {\n    |    \"a\": true,\n    |    \"b\": false\n    |  },\n    |  \"null\": null\n    |}\n   ")).stripMargin();

    public String json() {
        return this.json;
    }

    public JsonValue kafka$utils$json$JsonValueTest$$parse(String s) {
        return (JsonValue)Json$.MODULE$.parseFull(s).getOrElse((Function0)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final String s$1;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Failed to parse json: ").append((Object)this.s$1).toString());
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    private <T> void assertTo(T expected, Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$1) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply(expected), (Object)parsed.toEither(evidence$1));
        Assert.assertEquals(expected, (Object)parsed.to(evidence$1));
    }

    private <T> void assertToFails(Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$2) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject());
        Assert.assertTrue((boolean)parsed.toEither(evidence$2).isLeft());
        this.assertThrow((Function0<BoxedUnit>)new Serializable(this, evidence$2, parsed){
            public static final long serialVersionUID = 0L;
            private final DecodeJson evidence$2$1;
            private final JsonValue parsed$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.parsed$1.to(this.evidence$2$1);
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.parsed$1 = parsed$1;
            }
        }, ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    public <E extends Throwable> void assertThrow(Function0<BoxedUnit> body, Manifest<E> evidence$3) {
        Class klass = Predef$.MODULE$.manifest(evidence$3).runtimeClass();
        Exception$.MODULE$.catchingPromiscuously((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{klass})).opt(body).foreach((Function1)new Serializable(this, klass){
            public static final long serialVersionUID = 0L;
            private final Class klass$1;

            public final void apply(BoxedUnit x$1) {
                Assert.fail((String)new StringBuilder().append((Object)"Expected `").append((Object)this.klass$1).append((Object)"` to be thrown, but no exception was thrown").toString());
            }
            {
                this.klass$1 = klass$1;
            }
        });
    }

    @Test
    public void testAsJsonObject() {
        JsonObject parsed = this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject();
        JsonValue obj = parsed.apply("object");
        Assert.assertEquals((Object)obj, (Object)obj.asJsonObject());
        this.assertThrow((Function0<BoxedUnit>)new Serializable(this, parsed){
            public static final long serialVersionUID = 0L;
            private final JsonObject parsed$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.parsed$2.apply("array").asJsonObject();
            }
            {
                this.parsed$2 = parsed$2;
            }
        }, ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testAsJsonObjectOption() {
        JsonObject parsed = this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject();
        Assert.assertTrue((boolean)parsed.apply("object").asJsonObjectOption().isDefined());
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("array").asJsonObjectOption());
    }

    @Test
    public void testAsJsonArray() {
        JsonObject parsed = this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject();
        JsonValue array = parsed.apply("array");
        Assert.assertEquals((Object)array, (Object)array.asJsonArray());
        this.assertThrow((Function0<BoxedUnit>)new Serializable(this, parsed){
            public static final long serialVersionUID = 0L;
            private final JsonObject parsed$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.parsed$3.apply("object").asJsonArray();
            }
            {
                this.parsed$3 = parsed$3;
            }
        }, ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testAsJsonArrayOption() {
        JsonObject parsed = this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject();
        Assert.assertTrue((boolean)parsed.apply("array").asJsonArrayOption().isDefined());
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("object").asJsonArrayOption());
    }

    @Test
    public void testJsonObjectGet() {
        JsonObject parsed = this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject();
        Assert.assertEquals((Object)new Some((Object)this.kafka$utils$json$JsonValueTest$$parse("{\"a\":true,\"b\":false}")), (Object)parsed.get("object"));
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.get("aaaaa"));
    }

    @Test
    public void testJsonObjectApply() {
        JsonObject parsed = this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject();
        Assert.assertEquals((Object)this.kafka$utils$json$JsonValueTest$$parse("{\"a\":true,\"b\":false}"), (Object)parsed.apply("object"));
        this.assertThrow((Function0<BoxedUnit>)new Serializable(this, parsed){
            public static final long serialVersionUID = 0L;
            private final JsonObject parsed$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.parsed$4.apply("aaaaaaaa");
            }
            {
                this.parsed$4 = parsed$4;
            }
        }, ManifestFactory$.MODULE$.classType(JsonMappingException.class));
    }

    @Test
    public void testJsonObjectIterator() {
        Assert.assertEquals((Object)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)this.kafka$utils$json$JsonValueTest$$parse("true")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)this.kafka$utils$json$JsonValueTest$$parse("false"))})), (Object)this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject().apply("object").asJsonObject().iterator().toVector());
    }

    @Test
    public void testJsonArrayIterator() {
        Assert.assertEquals((Object)((TraversableLike)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"4.0", "11.1", "44.5"}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JsonValueTest $outer;

            public final JsonValue apply(String s) {
                return this.$outer.kafka$utils$json$JsonValueTest$$parse(s);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Vector$.MODULE$.canBuildFrom()), (Object)this.kafka$utils$json$JsonValueTest$$parse(this.json()).asJsonObject().apply("array").asJsonArray().iterator().toVector());
    }

    @Test
    public void testJsonValueEquals() {
        Assert.assertEquals((Object)this.kafka$utils$json$JsonValueTest$$parse(this.json()), (Object)this.kafka$utils$json$JsonValueTest$$parse(this.json()));
        Assert.assertEquals((Object)this.kafka$utils$json$JsonValueTest$$parse("{\"blue\": true, \"red\": false}"), (Object)this.kafka$utils$json$JsonValueTest$$parse("{\"red\": false, \"blue\": true}"));
        Assert.assertNotEquals((Object)this.kafka$utils$json$JsonValueTest$$parse("{\"blue\": true, \"red\": true}"), (Object)this.kafka$utils$json$JsonValueTest$$parse("{\"red\": false, \"blue\": true}"));
        Assert.assertEquals((Object)this.kafka$utils$json$JsonValueTest$$parse("[1, 2, 3]"), (Object)this.kafka$utils$json$JsonValueTest$$parse("[1, 2, 3]"));
        Assert.assertNotEquals((Object)this.kafka$utils$json$JsonValueTest$$parse("[1, 2, 3]"), (Object)this.kafka$utils$json$JsonValueTest$$parse("[2, 1, 3]"));
        Assert.assertEquals((Object)this.kafka$utils$json$JsonValueTest$$parse("1344"), (Object)this.kafka$utils$json$JsonValueTest$$parse("1344"));
        Assert.assertNotEquals((Object)this.kafka$utils$json$JsonValueTest$$parse("1344"), (Object)this.kafka$utils$json$JsonValueTest$$parse("144"));
    }

    @Test
    public void testJsonValueHashCode() {
        Assert.assertEquals((long)new ObjectMapper().readTree(this.json()).hashCode(), (long)this.kafka$utils$json$JsonValueTest$$parse(this.json()).hashCode());
    }

    @Test
    public void testJsonValueToString() {
        String js = "{\"boolean\":false,\"int\":1234,\"array\":[4.0,11.1,44.5],\"object\":{\"a\":true,\"b\":false}}";
        Assert.assertEquals((Object)js, (Object)this.kafka$utils$json$JsonValueTest$$parse(js).toString());
    }

    @Test
    public void testDecodeBoolean() {
        this.assertTo((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$2) {
                return x$2.apply("boolean");
            }
        }, (DecodeJson)DecodeJson.DecodeBoolean$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$3) {
                return x$3.apply("int");
            }
        }, (DecodeJson)DecodeJson.DecodeBoolean$.MODULE$);
    }

    @Test
    public void testDecodeString() {
        this.assertTo((Object)"string", (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$4) {
                return x$4.apply("string");
            }
        }, (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertTo((Object)"123", (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$5) {
                return x$5.apply("number_as_string");
            }
        }, (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$6) {
                return x$6.apply("int");
            }
        }, (DecodeJson)DecodeJson.DecodeString$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$7) {
                return x$7.apply("array");
            }
        }, (DecodeJson)DecodeJson.DecodeString$.MODULE$);
    }

    @Test
    public void testDecodeInt() {
        this.assertTo((Object)BoxesRunTime.boxToInteger((int)1234), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$8) {
                return x$8.apply("int");
            }
        }, (DecodeJson)DecodeJson.DecodeInt$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$9) {
                return x$9.apply("long");
            }
        }, (DecodeJson)DecodeJson.DecodeInt$.MODULE$);
    }

    @Test
    public void testDecodeLong() {
        this.assertTo((Object)BoxesRunTime.boxToLong((long)3000000000L), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$10) {
                return x$10.apply("long");
            }
        }, (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToLong((long)1234L), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$11) {
                return x$11.apply("int");
            }
        }, (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$12) {
                return x$12.apply("string");
            }
        }, (DecodeJson)DecodeJson.DecodeLong$.MODULE$);
    }

    @Test
    public void testDecodeDouble() {
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)16.244355), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$13) {
                return x$13.apply("double");
            }
        }, (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)1234.0), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$14) {
                return x$14.apply("int");
            }
        }, (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertTo((Object)BoxesRunTime.boxToDouble((double)3.0E9), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$15) {
                return x$15.apply("long");
            }
        }, (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$16) {
                return x$16.apply("string");
            }
        }, (DecodeJson)DecodeJson.DecodeDouble$.MODULE$);
    }

    @Test
    public void testDecodeSeq() {
        this.assertTo(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 11.1, 44.5})), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$17) {
                return x$17.apply("array");
            }
        }, DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$18) {
                return x$18.apply("string");
            }
        }, DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$19) {
                return x$19.apply("object");
            }
        }, DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$20) {
                return x$20.apply("array");
            }
        }, DecodeJson$.MODULE$.decodeSeq((DecodeJson)DecodeJson.DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
    }

    @Test
    public void testDecodeMap() {
        this.assertTo(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$21) {
                return x$21.apply("object");
            }
        }, DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeBoolean$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$22) {
                return x$22.apply("object");
            }
        }, DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeInt$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$23) {
                return x$23.apply("object");
            }
        }, DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeString$.MODULE$, Map$.MODULE$.canBuildFrom()));
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$24) {
                return x$24.apply("array");
            }
        }, DecodeJson$.MODULE$.decodeMap((DecodeJson)DecodeJson.DecodeDouble$.MODULE$, Map$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDecodeOption() {
        this.assertTo(None$.MODULE$, (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$25) {
                return x$25.apply("null");
            }
        }, DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
        this.assertTo(new Some((Object)BoxesRunTime.boxToInteger((int)1234)), (Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$26) {
                return x$26.apply("int");
            }
        }, DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
        this.assertToFails((Function1<JsonObject, JsonValue>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonValue apply(JsonObject x$27) {
                return x$27.apply("int");
            }
        }, DecodeJson$.MODULE$.decodeOption((DecodeJson)DecodeJson.DecodeString$.MODULE$));
    }
}

