/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.Topic$;
import kafka.zk.AclChangeNode;
import kafka.zk.ExtendedAclStore;
import org.apache.kafka.common.resource.PatternType;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u000f\t!R\t\u001f;f]\u0012,G-Q2m'R|'/\u001a+fgRT!a\u0001\u0003\u0002\u0005i\\'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0010Y&$XM]1m%\u0016\u001cx.\u001e:dKV\ta\u0003\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005!\u0011-\u001e;i\u0015\tYB!\u0001\u0005tK\u000e,(/\u001b;z\u0013\ti\u0002D\u0001\u0005SKN|WO]2f\u0011\u0019y\u0002\u0001)A\u0005-\u0005\u0001B.\u001b;fe\u0006d'+Z:pkJ\u001cW\r\t\u0005\bC\u0001\u0011\r\u0011\"\u0003\u0016\u0003A\u0001(/\u001a4jq\u0016$'+Z:pkJ\u001cW\r\u0003\u0004$\u0001\u0001\u0006IAF\u0001\u0012aJ,g-\u001b=fIJ+7o\\;sG\u0016\u0004\u0003bB\u0013\u0001\u0005\u0004%IAJ\u0001\u0006gR|'/Z\u000b\u0002OA\u0011!\u0003K\u0005\u0003S\t\u0011\u0001#\u0012=uK:$W\rZ!dYN#xN]3\t\r-\u0002\u0001\u0015!\u0003(\u0003\u0019\u0019Ho\u001c:fA!)Q\u0006\u0001C\u0001]\u000512\u000f[8vY\u0012D\u0015M^3D_J\u0014Xm\u0019;QCRD7\u000fF\u00010!\tI\u0001'\u0003\u00022\u0015\t!QK\\5uQ\ta3\u0007\u0005\u00025s5\tQG\u0003\u00027o\u0005)!.\u001e8ji*\t\u0001(A\u0002pe\u001eL!AO\u001b\u0003\tQ+7\u000f\u001e\u0005\u0006y\u0001!\tAL\u0001\u001dg\"|W\u000f\u001c3ICZ,7i\u001c:sK\u000e$\b+\u0019;uKJtG+\u001f9fQ\tY4\u0007C\u0003@\u0001\u0011\u0005a&A\u0012tQ>,H\u000e\u001a+ie><\u0018JZ\"p]N$(/^2uK\u0012<\u0016\u000e\u001e5MSR,'/\u00197)\ty\u001a\u0014IQ\u0001\tKb\u0004Xm\u0019;fI\u000e\n1\t\u0005\u0002E\u0019:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005-S\u0011a\u00029bG.\fw-Z\u0005\u0003\u001b:\u0013\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0015\tY%\u0002C\u0003Q\u0001\u0011\u0005a&\u0001\u0010tQ>,H\u000e\u001a+ie><hI]8n\u000b:\u001cw\u000eZ3P]2KG/\u001a:bY\"\"qjM!C\u0011\u0015\u0019\u0006\u0001\"\u0001/\u0003\u0001\u001a\bn\\;mI^\u0013\u0018\u000e^3DQ\u0006tw-Z:U_RCWm\u0016:ji\u0016\u0004\u0016\r\u001e5)\u0005I\u001b\u0004\"\u0002,\u0001\t\u0003q\u0013!G:i_VdGMU8v]\u0012$&/\u001b9DQ\u0006tw-\u001a(pI\u0016D#!V\u001a")
public class ExtendedAclStoreTest {
    private final Resource literalResource = new Resource((ResourceType)Topic$.MODULE$, "some-topic", PatternType.LITERAL);
    private final Resource prefixedResource = new Resource((ResourceType)Topic$.MODULE$, "some-topic", PatternType.PREFIXED);
    private final ExtendedAclStore store = new ExtendedAclStore(PatternType.PREFIXED);

    private Resource literalResource() {
        return this.literalResource;
    }

    private Resource prefixedResource() {
        return this.prefixedResource;
    }

    private ExtendedAclStore store() {
        return this.store;
    }

    @Test
    public void shouldHaveCorrectPaths() {
        Assert.assertEquals((Object)"/kafka-acl-extended/prefixed", (Object)this.store().aclPath());
        Assert.assertEquals((Object)"/kafka-acl-extended/prefixed/Topic", (Object)this.store().path((ResourceType)Topic$.MODULE$));
        Assert.assertEquals((Object)"/kafka-acl-extended-changes", (Object)this.store().changeStore().aclChangePath());
    }

    @Test
    public void shouldHaveCorrectPatternType() {
        Assert.assertEquals((Object)PatternType.PREFIXED, (Object)this.store().patternType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfConstructedWithLiteral() {
        new ExtendedAclStore(PatternType.LITERAL);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowFromEncodeOnLiteral() {
        this.store().changeStore().createChangeNode(this.literalResource());
    }

    @Test
    public void shouldWriteChangesToTheWritePath() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        Assert.assertEquals((Object)"/kafka-acl-extended-changes/acl_changes_", (Object)changeNode.path());
    }

    @Test
    public void shouldRoundTripChangeNode() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        Resource actual = this.store().changeStore().decode(changeNode.bytes());
        Assert.assertEquals((Object)this.prefixedResource(), (Object)actual);
    }
}

