/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.charset.StandardCharsets;
import kafka.zk.ReassignPartitionsZNode$;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u000f\tY\"+Z1tg&<g\u000eU1si&$\u0018n\u001c8t5:{G-\u001a+fgRT!a\u0001\u0003\u0002\u0005i\\'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001b\u0002\u000b\u0001\u0005\u0004%I!F\u0001\u0006i>\u0004\u0018nY\u000b\u0002-A\u0011q\u0003H\u0007\u00021)\u0011\u0011DG\u0001\u0005Y\u0006twMC\u0001\u001c\u0003\u0011Q\u0017M^1\n\u0005uA\"AB*ue&tw\r\u0003\u0004 \u0001\u0001\u0006IAF\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f\u0005\u0002!\u0019!C\u0005E\u0005Q\u0001/\u0019:uSRLwN\\\u0019\u0016\u0003\r\u0002\"!\u0003\u0013\n\u0005\u0015R!aA%oi\"1q\u0005\u0001Q\u0001\n\r\n1\u0002]1si&$\u0018n\u001c82A!9\u0011\u0006\u0001b\u0001\n\u0013\u0011\u0013\u0001\u0003:fa2L7-Y\u0019\t\r-\u0002\u0001\u0015!\u0003$\u0003%\u0011X\r\u001d7jG\u0006\f\u0004\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0012\u0002\u0011I,\u0007\u000f\\5dCJBaa\f\u0001!\u0002\u0013\u0019\u0013!\u0003:fa2L7-\u0019\u001a!\u0011\u001d\t\u0004A1A\u0005\nI\nQC]3bgNLwM\u001c)beRLG/[8o\t\u0006$\u0018-F\u00014!\u0011!\u0014h\u000f$\u000e\u0003UR!AN\u001c\u0002\u0013%lW.\u001e;bE2,'B\u0001\u001d\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003uU\u00121!T1q!\taD)D\u0001>\u0015\tqt(\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0001S!!\u0011\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0015aA8sO&\u0011Q)\u0010\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\r9\u0005jI\u0007\u0002o%\u0011\u0011j\u000e\u0002\u0004'\u0016\f\bBB&\u0001A\u0003%1'\u0001\fsK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:$\u0015\r^1!\u0011\u001di\u0005A1A\u0005\nU\t\u0001C]3bgNLwM\\7f]RT5o\u001c8\t\r=\u0003\u0001\u0015!\u0003\u0017\u0003E\u0011X-Y:tS\u001etW.\u001a8u\u0015N|g\u000e\t\u0005\u0006#\u0002!\tAU\u0001\u000bi\u0016\u001cH/\u00128d_\u0012,G#A*\u0011\u0005%!\u0016BA+\u000b\u0005\u0011)f.\u001b;)\u0005A;\u0006C\u0001-\\\u001b\u0005I&B\u0001.C\u0003\u0015QWO\\5u\u0013\ta\u0016L\u0001\u0003UKN$\b\"\u00020\u0001\t\u0003\u0011\u0016!\u0006;fgR$UmY8eK&sg/\u00197jI*\u001bxN\u001c\u0015\u0003;^CQ!\u0019\u0001\u0005\u0002I\u000b1\u0003^3ti\u0012+7m\u001c3f-\u0006d\u0017\u000e\u001a&t_:D#\u0001Y,")
public class ReassignPartitionsZNodeTest {
    private final String topic;
    private final int partition1;
    private final int replica1;
    private final int replica2;
    private final scala.collection.immutable.Map<TopicPartition, Seq<Object>> reassignPartitionData = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), this.partition1())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replica1(), this.replica2()})))}));
    private final String reassignmentJson;

    private String topic() {
        return this.topic;
    }

    private int partition1() {
        return this.partition1;
    }

    private int replica1() {
        return this.replica1;
    }

    private int replica2() {
        return this.replica2;
    }

    private scala.collection.immutable.Map<TopicPartition, Seq<Object>> reassignPartitionData() {
        return this.reassignPartitionData;
    }

    private String reassignmentJson() {
        return this.reassignmentJson;
    }

    @Test
    public void testEncode() {
        String encodedJsonString = new String(ReassignPartitionsZNode$.MODULE$.encode(this.reassignPartitionData()), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)this.reassignmentJson(), (Object)encodedJsonString);
    }

    @Test
    public void testDecodeInvalidJson() {
        Either result = ReassignPartitionsZNode$.MODULE$.decode("invalid json".getBytes());
        Assert.assertTrue((boolean)result.isLeft());
        Assert.assertTrue((boolean)(result.left().get() instanceof JsonProcessingException));
    }

    @Test
    public void testDecodeValidJson() {
        Either result = ReassignPartitionsZNode$.MODULE$.decode(this.reassignmentJson().getBytes());
        Assert.assertTrue((boolean)result.isRight());
        Map assignmentMap = (Map)result.right().get();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replica1(), this.replica2()})), (Object)assignmentMap.apply((Object)new TopicPartition(this.topic(), this.partition1())));
    }

    public ReassignPartitionsZNodeTest() {
        this.topic = "foo";
        this.partition1 = 0;
        this.replica1 = 1;
        this.replica2 = 2;
        this.reassignmentJson = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2]}]}";
    }
}

