/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import javax.security.auth.login.Configuration;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZooKeeperTestHarness$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.IntegrationTest;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005Ef!B\u0001\u0003\u0003\u00039!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8O\u0003\u0002\u0004\t\u0005\u0011!p\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAqA\b\u0001C\u0002\u0013\u0005q$A\n{W\u000e{gN\\3di&|g\u000eV5nK>,H/F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\rIe\u000e\u001e\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002)i\\7i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;!\u0011\u001dI\u0003A1A\u0005\u0002}\t\u0001C_6TKN\u001c\u0018n\u001c8US6,w.\u001e;\t\r-\u0002\u0001\u0015!\u0003!\u0003EQ8nU3tg&|g\u000eV5nK>,H\u000f\t\u0005\b[\u0001\u0011\r\u0011\"\u0001 \u0003UQ8.T1y\u0013:4E.[4iiJ+\u0017/^3tiNDaa\f\u0001!\u0002\u0013\u0001\u0013A\u0006>l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\t\u000fE\u0002!\u0019!C\te\u0005i!p[!dYN,e.\u00192mK\u0012,\u0012a\r\t\u0004CQ2\u0014BA\u001b#\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011eN\u0005\u0003q\t\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004;\u0001\u0001\u0006IaM\u0001\u000fu.\f5\r\\:F]\u0006\u0014G.\u001a3!\u0011\u001da\u0004\u00011A\u0005\u0002u\n\u0001B_6DY&,g\u000e^\u000b\u0002}A\u0011AdP\u0005\u0003\u0001\n\u0011QbS1gW\u0006T6n\u00117jK:$\bb\u0002\"\u0001\u0001\u0004%\taQ\u0001\ru.\u001cE.[3oi~#S-\u001d\u000b\u0003\t\u001e\u0003\"!I#\n\u0005\u0019\u0013#\u0001B+oSRDq\u0001S!\u0002\u0002\u0003\u0007a(A\u0002yIEBaA\u0013\u0001!B\u0013q\u0014!\u0003>l\u00072LWM\u001c;!\u0011\u001da\u0005\u00011A\u0005\u00025\u000bQ\"\u00193nS:T6n\u00117jK:$X#\u0001(\u0011\u0005qy\u0015B\u0001)\u0003\u00055\tE-\\5o5.\u001cE.[3oi\"9!\u000b\u0001a\u0001\n\u0003\u0019\u0016!E1e[&t'l[\"mS\u0016tGo\u0018\u0013fcR\u0011A\t\u0016\u0005\b\u0011F\u000b\t\u00111\u0001O\u0011\u00191\u0006\u0001)Q\u0005\u001d\u0006q\u0011\rZ7j]j[7\t\\5f]R\u0004\u0003b\u0002-\u0001\u0001\u0004%\t!W\u0001\nu>|7.Z3qKJ,\u0012A\u0017\t\u00039mK!\u0001\u0018\u0002\u0003#\u0015k'-\u001a3eK\u0012Tvn\\6fKB,'\u000fC\u0004_\u0001\u0001\u0007I\u0011A0\u0002\u001bi|wn[3fa\u0016\u0014x\fJ3r)\t!\u0005\rC\u0004I;\u0006\u0005\t\u0019\u0001.\t\r\t\u0004\u0001\u0015)\u0003[\u0003)Qxn\\6fKB,'\u000f\t\u0005\u0006I\u0002!\taH\u0001\u0007u.\u0004vN\u001d;\t\u000b\u0019\u0004A\u0011A4\u0002\u0013i\\7i\u001c8oK\u000e$X#\u00015\u0011\u0005%dgBA\u0011k\u0013\tY'%\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6#\u0011\u0015\u0001\b\u0001\"\u0001r\u0003\u0015\u0019X\r^+q)\u0005!\u0005FA8t!\t!h/D\u0001v\u0015\tYa\"\u0003\u0002xk\n1!)\u001a4pe\u0016DQ!\u001f\u0001\u0005\u0002E\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003qn\u0004\"\u0001\u001e?\n\u0005u,(!B!gi\u0016\u0014\bBB@\u0001\t\u0003\t\t!A\u0016de\u0016\fG/\u001a.p_.+W\r]3s\u00072LWM\u001c;U_R\u0013\u0018nZ4feN+7o]5p]\u0016C\b/\u001b:z)\u0011\t\u0019!!\u0005\u0011\t\u0005\u0015\u0011QB\u0007\u0003\u0003\u000fQ1\u0001WA\u0005\u0015\r\tYAD\u0001\u0007CB\f7\r[3\n\t\u0005=\u0011q\u0001\u0002\n5>|7*Z3qKJDq!a\u0005\u007f\u0001\u0004\t\u0019!A\u0005{_>\\U-\u001a9fe\":\u0001!a\u0006\u0002(\u0005%\u0002\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u000bG\u0006$XmZ8sS\u0016\u001c(bAA\u0011k\u0006aQ\r\u001f9fe&lWM\u001c;bY&!\u0011QEA\u000e\u0005!\u0019\u0015\r^3h_JL\u0018!\u0002<bYV,GFAA\u0016G\t\ti\u0003\u0005\u0003\u00020\u0005]RBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\tQ,7\u000f\u001e\u0006\u0004\u000b\u0005%\u0011\u0002BA\u001d\u0003c\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0004\b\u0003{\u0011\u0001\u0012AA \u0003QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0019A$!\u0011\u0007\r\u0005\u0011\u0001\u0012AA\"'\u0019\t\t%!\u0012\u0002LA\u0019\u0011%a\u0012\n\u0007\u0005%#E\u0001\u0004B]f\u0014VM\u001a\t\u0004C\u00055\u0013bAA(E\ta1+\u001a:jC2L'0\u00192mK\"9\u0011$!\u0011\u0005\u0002\u0005MCCAA \u0011)\t9&!\u0011C\u0002\u0013\u0005\u0011\u0011L\u0001\u001a5.\u001cE.[3oi\u00163XM\u001c;UQJ,\u0017\r\u001a)sK\u001aL\u00070\u0006\u0002\u0002\\A!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014\u0001\u00027b]\u001eT!!!\u001a\u0002\t)\fg/Y\u0005\u0004[\u0006}\u0003\"CA6\u0003\u0003\u0002\u000b\u0011BA.\u0003iQ6n\u00117jK:$XI^3oiRC'/Z1e!J,g-\u001b=!\u0011)\ty'!\u0011C\u0002\u0013\u0005\u0011\u0011O\u0001\u0016k:,\u0007\u0010]3di\u0016$G\u000b\u001b:fC\u0012t\u0015-\\3t+\t\t\u0019\b\u0005\u0004\u0002v\u0005m\u00141L\u0007\u0003\u0003oR1!!\u001f#\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\n9HA\u0002TKRD\u0011\"!!\u0002B\u0001\u0006I!a\u001d\u0002-UtW\r\u001f9fGR,G\r\u00165sK\u0006$g*Y7fg\u0002Bq!!\"\u0002B\u0011\u0005\u0011/\u0001\u0006tKR,\u0006o\u00117bgNDC!a!\u0002\nB\u0019A/a#\n\u0007\u00055UOA\u0006CK\u001a|'/Z\"mCN\u001c\bbBAI\u0003\u0003\"\t!]\u0001\u000ei\u0016\f'\u000fR8x]\u000ec\u0017m]:)\t\u0005=\u0015Q\u0013\t\u0004i\u0006]\u0015bAAMk\nQ\u0011I\u001a;fe\u000ec\u0017m]:\t\u0011\u0005u\u0015\u0011\tC\u0001\u0003?\u000b\u0011D^3sS\u001aLhj\\+oKb\u0004Xm\u0019;fIRC'/Z1egR\u0019A)!)\t\u000f\u0005\r\u00161\u0014a\u0001Q\u000691m\u001c8uKb$\bBCAT\u0003\u0003\n\t\u0011\"\u0003\u0002*\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u000b\u0005\u0003\u0002^\u00055\u0016\u0002BAX\u0003?\u0012aa\u00142kK\u000e$\b")
public abstract class ZooKeeperTestHarness
extends JUnitSuite
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private final Option<Object> zkAclsEnabled;
    private KafkaZkClient zkClient;
    private AdminZkClient adminZkClient;
    private EmbeddedZookeeper zookeeper;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void verifyNoUnexpectedThreads(String string) {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads(string);
    }

    @AfterClass
    public static void tearDownClass() {
        ZooKeeperTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeClass
    public static void setUpClass() {
        ZooKeeperTestHarness$.MODULE$.setUpClass();
    }

    public static Set<String> unexpectedThreadNames() {
        return ZooKeeperTestHarness$.MODULE$.unexpectedThreadNames();
    }

    public static String ZkClientEventThreadPrefix() {
        return ZooKeeperTestHarness$.MODULE$.ZkClientEventThreadPrefix();
    }

    private Logger logger$lzycompute() {
        ZooKeeperTestHarness zooKeeperTestHarness = this;
        synchronized (zooKeeperTestHarness) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return this.zkAclsEnabled;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    public void adminZkClient_$eq(AdminZkClient x$1) {
        this.adminZkClient = x$1;
    }

    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    public int zkPort() {
        return this.zookeeper().port();
    }

    public String zkConnect() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"127.0.0.1:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    @Before
    public void setUp() {
        this.zookeeper_$eq(new EmbeddedZookeeper());
        this.zkClient_$eq(KafkaZkClient$.MODULE$.apply(this.zkConnect(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return JaasUtils.isZkSecurityEnabled();
            }
        })), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8()));
        this.adminZkClient_$eq(new AdminZkClient(this.zkClient()));
    }

    @After
    public void tearDown() {
        if (this.zkClient() != null) {
            this.zkClient().close();
        }
        if (this.zookeeper() != null) {
            CoreUtils$.MODULE$.swallow((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZooKeeperTestHarness $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.zookeeper().shutdown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        }
        Configuration.setConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(this){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assert.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public ZooKeeperTestHarness() {
        Logging.class.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 6000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.zkAclsEnabled = None$.MODULE$;
        this.zkClient = null;
        this.adminZkClient = null;
        this.zookeeper = null;
    }
}

