/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.PartitionAndReplica;
import kafka.controller.StateChangeLogger;
import kafka.controller.StopReplicaRequestInfo;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001\u0002\f\u0018\u0001qA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)\u0011\u0007\u0001C\u0001e!9a\u0007\u0001b\u0001\n\u00039\u0004BB\u001e\u0001A\u0003%\u0001\bC\u0004=\u0001\t\u0007I\u0011A\u001f\t\r\u0005\u0003\u0001\u0015!\u0003?\u0011\u001d\u0011\u0005A1A\u0005\u0002\rCaA\u0019\u0001!\u0002\u0013!\u0005bB2\u0001\u0005\u0004%\t\u0001\u001a\u0005\u0007k\u0002\u0001\u000b\u0011B3\t\u000fY\u0004!\u0019!C\u0001o\"11\u0010\u0001Q\u0001\naDq\u0001 \u0001C\u0002\u0013\u0005Q\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002@\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011q\u0003\u0001\u0005\u0002\u0005=\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!a\u001b\u0001\t\u0003\tiG\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u000b\u0005aI\u0012AC2p]R\u0014x\u000e\u001c7fe*\t!$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001i2\u0005\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0003I\u001dj\u0011!\n\u0006\u0003Me\tQ!\u001e;jYNL!\u0001K\u0013\u0003\u000f1{wmZ5oOB\u0011!fK\u0007\u0002/%\u0011Af\u0006\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0011\u0005)z\u0013B\u0001\u0019\u0018\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M\"T\u0007\u0005\u0002+\u0001!)\u0001d\u0001a\u0001S!)Qf\u0001a\u0001]\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003a\u0002\"AK\u001d\n\u0005i:\"!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\u0006\u00112m\u001c8ue>dG.\u001a:D_:$X\r\u001f;!\u00031\u0019wN\u001c;s_2dWM]%e+\u0005q\u0004C\u0001\u0010@\u0013\t\u0001uDA\u0002J]R\fQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0013A\u00067fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$X*\u00199\u0016\u0003\u0011\u0003B!\u0012&?\u00196\taI\u0003\u0002H\u0011\u00069Q.\u001e;bE2,'BA% \u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0017\u001a\u00131!T1q!\u0011)%*\u0014-\u0011\u000593V\"A(\u000b\u0005A\u000b\u0016AB2p[6|gN\u0003\u0002\u001b%*\u00111\u000bV\u0001\u0007CB\f7\r[3\u000b\u0003U\u000b1a\u001c:h\u0013\t9vJ\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005e{fB\u0001.^\u001b\u0005Y&B\u0001/P\u0003!\u0011X-];fgR\u001c\u0018B\u00010\\\u0003MaU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\u0013\t\u0001\u0017M\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\u000b\u0005y[\u0016a\u00067fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$X*\u00199!\u0003U\u0019Ho\u001c9SKBd\u0017nY1SKF,Xm\u001d;NCB,\u0012!\u001a\t\u0005\u000b*sd\rE\u0002h_Jt!\u0001[7\u000f\u0005%dW\"\u00016\u000b\u0005-\\\u0012A\u0002\u001fs_>$h(C\u0001!\u0013\tqw$A\u0004qC\u000e\\\u0017mZ3\n\u0005A\f(aA*fc*\u0011an\b\t\u0003UML!\u0001^\f\u0003-M#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f^%oM>\fac\u001d;paJ+\u0007\u000f\\5dCJ+\u0017/^3ti6\u000b\u0007\u000fI\u0001\u001fkB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0005J|7.\u001a:TKR,\u0012\u0001\u001f\t\u0004\u000bft\u0014B\u0001>G\u0005\r\u0019V\r^\u0001 kB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\u0005J|7.\u001a:TKR\u0004\u0013!J;qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e)beRLG/[8o\u0013:4w.T1q+\u0005q\b\u0003B#K\u001b~\u0004B!!\u0001\u0002\b9\u0019!,a\u0001\n\u0007\u0005\u00151,A\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\n\u0007\u0001\fIAC\u0002\u0002\u0006m\u000ba%\u001e9eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fU1si&$\u0018n\u001c8J]\u001a|W*\u00199!\u0003!qWm\u001e\"bi\u000eDGCAA\t!\rq\u00121C\u0005\u0004\u0003+y\"\u0001B+oSR\fQa\u00197fCJ\f\u0001%\u00193e\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e$pe\n\u0013xn[3sgRa\u0011\u0011CA\u000f\u0003G\t9#!\r\u00026!9\u0011q\u0004\nA\u0002\u0005\u0005\u0012!\u00032s_.,'/\u00133t!\r9wN\u0010\u0005\u0007\u0003K\u0011\u0002\u0019A'\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u0006\nA\u0002\u0005-\u0012a\u00077fC\u0012,'/S:s\u0003:$7i\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000eE\u0002+\u0003[I1!a\f\u0018\u0005maU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"9\u00111\u0007\nA\u0002\u0005\u0005\u0012\u0001\u0003:fa2L7-Y:\t\u000f\u0005]\"\u00031\u0001\u0002:\u0005)\u0011n\u001d(foB\u0019a$a\u000f\n\u0007\u0005urDA\u0004C_>dW-\u00198\u0002?\u0005$Gm\u0015;paJ+\u0007\u000f\\5dCJ+\u0017/^3ti\u001a{'O\u0011:pW\u0016\u00148\u000f\u0006\u0006\u0002\u0012\u0005\r\u0013QIA$\u0003\u0017Bq!a\b\u0014\u0001\u0004\t\t\u0003\u0003\u0004\u0002&M\u0001\r!\u0014\u0005\b\u0003\u0013\u001a\u0002\u0019AA\u001d\u0003=!W\r\\3uKB\u000b'\u000f^5uS>t\u0007bBA''\u0001\u0007\u0011qJ\u0001\tG\u0006dGNY1dWBAa$!\u0015\u0002Vy\n\t\"C\u0002\u0002T}\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0007i\u000b9&C\u0002\u0002Zm\u0013\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\u0002E\u0005$G-\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHOR8s\u0005J|7.\u001a:t)\u0019\t\t\"a\u0018\u0002b!9\u0011q\u0004\u000bA\u0002\u0005\u0005\u0002bBA2)\u0001\u0007\u0011QM\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#BA4\u0003SjU\"\u0001%\n\u0005iD\u0015!F:f]\u0012\u0014V-];fgR\u001cHk\u001c\"s_.,'o\u001d\u000b\u0005\u0003#\ty\u0007\u0003\u0004\u0002rU\u0001\rAP\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\u0002")
public class ControllerBrokerRequestBatch
implements Logging {
    private final KafkaController controller;
    private final StateChangeLogger stateChangeLogger;
    private final ControllerContext controllerContext;
    private final int controllerId;
    private final scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequest.PartitionState>> leaderAndIsrRequestMap;
    private final scala.collection.mutable.Map<Object, Seq<StopReplicaRequestInfo>> stopReplicaRequestMap;
    private final scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet;
    private final scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequest.PartitionState> updateMetadataRequestPartitionInfoMap;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ControllerBrokerRequestBatch controllerBrokerRequestBatch = this;
        synchronized (controllerBrokerRequestBatch) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public int controllerId() {
        return this.controllerId;
    }

    public scala.collection.mutable.Map<Object, scala.collection.mutable.Map<TopicPartition, LeaderAndIsrRequest.PartitionState>> leaderAndIsrRequestMap() {
        return this.leaderAndIsrRequestMap;
    }

    public scala.collection.mutable.Map<Object, Seq<StopReplicaRequestInfo>> stopReplicaRequestMap() {
        return this.stopReplicaRequestMap;
    }

    public scala.collection.mutable.Set<Object> updateMetadataRequestBrokerSet() {
        return this.updateMetadataRequestBrokerSet;
    }

    public scala.collection.mutable.Map<TopicPartition, UpdateMetadataRequest.PartitionState> updateMetadataRequestPartitionInfoMap() {
        return this.updateMetadataRequestPartitionInfoMap;
    }

    public void newBatch() {
        if (this.leaderAndIsrRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(77).append("Controller to broker state change requests batch is not empty while creating ").append(new StringBuilder(58).append("a new one. Some LeaderAndIsr state changes ").append(this.leaderAndIsrRequestMap()).append(" might be lost ").toString()).toString());
        }
        if (this.stopReplicaRequestMap().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(79).append("Controller to broker state change requests batch is not empty while creating a ").append(new StringBuilder(55).append("new one. Some StopReplica state changes ").append(this.stopReplicaRequestMap()).append(" might be lost ").toString()).toString());
        }
        if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(79).append("Controller to broker state change requests batch is not empty while creating a ").append(new StringBuilder(75).append("new one. Some UpdateMetadata state changes to brokers ").append(this.updateMetadataRequestBrokerSet()).append(" with partition info ").toString()).append(new StringBuilder(15).append(this.updateMetadataRequestPartitionInfoMap()).append(" might be lost ").toString()).toString());
        }
    }

    public void clear() {
        this.leaderAndIsrRequestMap().clear();
        this.stopReplicaRequestMap().clear();
        this.updateMetadataRequestBrokerSet().clear();
        this.updateMetadataRequestPartitionInfoMap().clear();
    }

    public void addLeaderAndIsrRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, Seq<Object> replicas, boolean isNew) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 >= 0)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> ControllerBrokerRequestBatch.$anonfun$addLeaderAndIsrRequestForBrokers$2(this, topicPartition, leaderIsrAndControllerEpoch, replicas, isNew, BoxesRunTime.unboxToInt((Object)brokerId)));
        this.addUpdateMetadataRequestForBrokers((Seq<Object>)this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), (Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
    }

    public void addStopReplicaRequestForBrokers(Seq<Object> brokerIds, TopicPartition topicPartition, boolean deletePartition, Function2<AbstractResponse, Object, BoxedUnit> callback) {
        ((IterableLike)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 >= 0)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            this.stopReplicaRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            Seq v = (Seq)this.stopReplicaRequestMap().apply((Object)BoxesRunTime.boxToInteger((int)brokerId));
            this.stopReplicaRequestMap().update((Object)BoxesRunTime.boxToInteger((int)brokerId), v.$colon$plus((Object)new StopReplicaRequestInfo(new PartitionAndReplica(topicPartition, brokerId), deletePartition, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
                callback.apply((Object)r, (Object)BoxesRunTime.boxToInteger((int)brokerId));
                return BoxedUnit.UNIT;
            }), Seq$.MODULE$.canBuildFrom()));
        });
    }

    public void addUpdateMetadataRequestForBrokers(Seq<Object> brokerIds, Set<TopicPartition> partitions) {
        this.updateMetadataRequestBrokerSet().$plus$plus$eq((TraversableOnce)brokerIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$7 -> x$7 >= 0));
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.updateMetadataRequestPartitionInfo$1(partition, this.controller.topicDeletionManager().topicsToBeDeleted().contains((Object)partition.topic()));
            return BoxedUnit.UNIT;
        });
    }

    public void sendRequestsToBrokers(int controllerEpoch) {
        try {
            StateChangeLogger stateChangeLog = this.stateChangeLogger.withControllerEpoch(controllerEpoch);
            short leaderAndIsrRequestVersion = this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)2 : (this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? (short)1 : 0);
            scala.collection.immutable.Set<Object> set = this.controllerContext().liveOrShuttingDownBrokerIds();
            this.leaderAndIsrRequestMap().filterKeys((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> set.contains((Object)BoxesRunTime.boxToInteger((int)elem))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$2(this, stateChangeLog, leaderAndIsrRequestVersion, controllerEpoch, x0$1);
                return BoxedUnit.UNIT;
            });
            this.leaderAndIsrRequestMap().clear();
            this.updateMetadataRequestPartitionInfoMap().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$9(this, stateChangeLog, x0$3);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Map partitionStates = Predef$.MODULE$.Map().empty().$plus$plus(this.updateMetadataRequestPartitionInfoMap());
            short updateMetadataRequestVersion = this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)5 : (this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_1_0_IV0$.MODULE$) ? (short)4 : (this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_2_IV0$.MODULE$) ? (short)3 : (this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV1$.MODULE$) ? (short)2 : (this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? (short)1 : 0))));
            Set liveBrokers = updateMetadataRequestVersion == 0 ? (Set)this.controllerContext().liveOrShuttingDownBrokers().map((Function1 & Serializable & scala.Serializable)broker -> {
                SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                Node node = broker.node(listenerName);
                Seq endPoints = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint(node.host(), node.port(), securityProtocol, listenerName)}));
                return new UpdateMetadataRequest.Broker(broker.id(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(endPoints).asJava(), (String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
            }, Set$.MODULE$.canBuildFrom()) : (Set)this.controllerContext().liveOrShuttingDownBrokers().map((Function1 & Serializable & scala.Serializable)broker -> {
                Seq endPoints = (Seq)broker.endPoints().map((Function1 & Serializable & scala.Serializable)endPoint -> new UpdateMetadataRequest.EndPoint(endPoint.host(), endPoint.port(), endPoint.securityProtocol(), endPoint.listenerName()), Seq$.MODULE$.canBuildFrom());
                return new UpdateMetadataRequest.Broker(broker.id(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(endPoints).asJava(), (String)broker.rack().orNull(Predef$.MODULE$.$conforms()));
            }, Set$.MODULE$.canBuildFrom());
            ((IterableLike)this.updateMetadataRequestBrokerSet().intersect(this.controllerContext().liveOrShuttingDownBrokerIds())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> {
                long brokerEpoch = BoxesRunTime.unboxToLong((Object)this.controllerContext().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
                UpdateMetadataRequest.Builder updateMetadataRequest = new UpdateMetadataRequest.Builder(updateMetadataRequestVersion, this.controllerId(), controllerEpoch, brokerEpoch, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(liveBrokers).asJava());
                $this.controller.sendRequest(broker, ApiKeys.UPDATE_METADATA, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)updateMetadataRequest, null);
            });
            this.updateMetadataRequestBrokerSet().clear();
            this.updateMetadataRequestPartitionInfoMap().clear();
            short stopReplicaRequestVersion = this.controller.config().interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV0$.MODULE$) ? (short)1 : 0;
            scala.collection.immutable.Set<Object> set2 = this.controllerContext().liveOrShuttingDownBrokerIds();
            this.stopReplicaRequestMap().filterKeys((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> set2.contains((Object)BoxesRunTime.boxToInteger((int)elem))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$16(this, stopReplicaRequestVersion, controllerEpoch, x0$4);
                return BoxedUnit.UNIT;
            });
            this.stopReplicaRequestMap().clear();
        }
        catch (Throwable e) {
            if (this.leaderAndIsrRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Haven't been able to send leader and isr requests, current state of ").append(new StringBuilder(32).append("the map is ").append(this.leaderAndIsrRequestMap()).append(". Exception message: ").append(e).toString()).toString());
            }
            if (this.updateMetadataRequestBrokerSet().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Haven't been able to send metadata update requests to brokers ").append(this.updateMetadataRequestBrokerSet()).append(", ").append(new StringBuilder(60).append("current state of the partition info is ").append(this.updateMetadataRequestPartitionInfoMap()).append(". Exception message: ").append(e).toString()).toString());
            }
            if (this.stopReplicaRequestMap().nonEmpty()) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Haven't been able to send stop replica requests, current state of ").append(new StringBuilder(32).append("the map is ").append(this.stopReplicaRequestMap()).append(". Exception message: ").append(e).toString()).toString());
            }
            throw new IllegalStateException(e);
        }
    }

    public static final /* synthetic */ Option $anonfun$addLeaderAndIsrRequestForBrokers$2(ControllerBrokerRequestBatch $this, TopicPartition topicPartition$1, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1, Seq replicas$1, boolean isNew$1, int brokerId) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)$this.leaderAndIsrRequestMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        boolean alreadyNew = result.get((Object)topicPartition$1).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isNew));
        return result.put((Object)topicPartition$1, (Object)new LeaderAndIsrRequest.PartitionState(leaderIsrAndControllerEpoch$1.controllerEpoch(), leaderIsrAndControllerEpoch$1.leaderAndIsr().leader(), leaderIsrAndControllerEpoch$1.leaderAndIsr().leaderEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderIsrAndControllerEpoch$1.leaderAndIsr().isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava(), leaderIsrAndControllerEpoch$1.leaderAndIsr().zkVersion(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas$1.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava(), isNew$1 || alreadyNew));
    }

    private final void updateMetadataRequestPartitionInfo$1(TopicPartition partition, boolean beingDeleted) {
        Some some;
        LeaderIsrAndControllerEpoch l;
        Option leaderIsrAndControllerEpochOpt = this.controllerContext().partitionLeadershipInfo().get((Object)partition);
        Option option = leaderIsrAndControllerEpochOpt;
        if (option instanceof Some && (l = (LeaderIsrAndControllerEpoch)(some = (Some)option).value()) != null) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
            LeaderAndIsr leaderAndIsr = l.leaderAndIsr();
            int controllerEpoch = l.controllerEpoch();
            Seq<Object> replicas = this.controllerContext().partitionReplicaAssignment(partition);
            Seq offlineReplicas = (Seq)replicas.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> !this.controllerContext().isReplicaOnline(x$6, partition, this.controllerContext().isReplicaOnline$default$3()));
            if (beingDeleted) {
                LeaderAndIsr leaderDuringDelete = LeaderAndIsr$.MODULE$.duringDelete(leaderAndIsr.isr());
                leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderDuringDelete, controllerEpoch);
            } else {
                leaderIsrAndControllerEpoch = l;
            }
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = leaderIsrAndControllerEpoch;
            UpdateMetadataRequest.PartitionState partitionStateInfo = new UpdateMetadataRequest.PartitionState(leaderIsrAndControllerEpoch2.controllerEpoch(), leaderIsrAndControllerEpoch2.leaderAndIsr().leader(), leaderIsrAndControllerEpoch2.leaderAndIsr().leaderEpoch(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderIsrAndControllerEpoch2.leaderAndIsr().isr().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava(), leaderIsrAndControllerEpoch2.leaderAndIsr().zkVersion(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)offlineReplicas.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
            this.updateMetadataRequestPartitionInfoMap().put((Object)partition, (Object)partitionStateInfo);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Leader not yet assigned for partition ").append(partition).append(". Skip sending UpdateMetadataRequest.").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$3(int broker$2, StateChangeLogger stateChangeLog$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        LeaderAndIsrRequest.PartitionState state = (LeaderAndIsrRequest.PartitionState)tuple2._2();
        String typeOfRequest = broker$2 == state.basePartitionState.leader ? "become-leader" : "become-follower";
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Sending ").append(typeOfRequest).append(" LeaderAndIsr request ").append(state).append(" to broker ").append(broker$2).append(" for partition ").append(topicPartition).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$8(ControllerBrokerRequestBatch $this, int broker$2, AbstractResponse r) {
        $this.controller.eventManager().put(new KafkaController.LeaderAndIsrResponseReceived($this.controller, r, broker$2));
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$2(ControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, short leaderAndIsrRequestVersion$1, int controllerEpoch$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int broker = tuple2._1$mcI$sp();
        scala.collection.mutable.Map leaderAndIsrPartitionStates = (scala.collection.mutable.Map)tuple2._2();
        leaderAndIsrPartitionStates.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$3(broker, stateChangeLog$1, x0$2);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set leaderIds = ((TraversableOnce)leaderAndIsrPartitionStates.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)((LeaderAndIsrRequest.PartitionState)x$8._2()).basePartitionState.leader), Iterable$.MODULE$.canBuildFrom())).toSet();
        Set leaders = (Set)((SetLike)$this.controllerContext().liveOrShuttingDownBrokers().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)leaderIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.node($this.controller.config().interBrokerListenerName()), Set$.MODULE$.canBuildFrom());
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        LeaderAndIsrRequest.Builder leaderAndIsrRequestBuilder = new LeaderAndIsrRequest.Builder(leaderAndIsrRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(leaderAndIsrPartitionStates).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(leaders).asJava());
        $this.controller.sendRequest(broker, ApiKeys.LEADER_AND_ISR, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)leaderAndIsrRequestBuilder, (Function1<AbstractResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)r -> {
            ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$8($this, broker, r);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$9(ControllerBrokerRequestBatch $this, StateChangeLogger stateChangeLog$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)tuple2._2();
        stateChangeLog$1.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Sending UpdateMetadata request ").append(partitionState).append(" to brokers ").append($this.updateMetadataRequestBrokerSet()).append(" ").append(new StringBuilder(14).append("for partition ").append(tp).toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$sendRequestsToBrokers$23(StopReplicaRequestInfo r) {
        return !r.deletePartition() && r.callback() == null;
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$25(ControllerBrokerRequestBatch $this, short stopReplicaRequestVersion$1, int controllerEpoch$1, long brokerEpoch$1, int broker$3, StopReplicaRequestInfo r) {
        StopReplicaRequest.Builder stopReplicaRequest = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch$1, r.deletePartition(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{r.replica().topicPartition()}))).asJava());
        $this.controller.sendRequest(broker$3, ApiKeys.STOP_REPLICA, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequest, r.callback());
    }

    public static final /* synthetic */ void $anonfun$sendRequestsToBrokers$16(ControllerBrokerRequestBatch $this, short stopReplicaRequestVersion$1, int controllerEpoch$1, Tuple2 x0$4) {
        Tuple2 tuple2;
        int broker;
        Tuple2 tuple22 = x0$4;
        if (tuple22 != null) {
            broker = tuple22._1$mcI$sp();
            Seq replicaInfoList = (Seq)tuple22._2();
            scala.collection.immutable.Set stopReplicaWithDelete = ((TraversableOnce)((TraversableLike)replicaInfoList.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.deletePartition()))).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.replica(), Seq$.MODULE$.canBuildFrom())).toSet();
            scala.collection.immutable.Set stopReplicaWithoutDelete = ((TraversableOnce)((TraversableLike)replicaInfoList.filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.deletePartition()))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.replica(), Seq$.MODULE$.canBuildFrom())).toSet();
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("The stop replica request (delete = true) sent to broker ").append(broker).append(" is ").append(stopReplicaWithDelete.mkString(",")).toString());
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("The stop replica request (delete = false) sent to broker ").append(broker).append(" is ").append(stopReplicaWithoutDelete.mkString(",")).toString());
            Tuple2 tuple23 = replicaInfoList.partition((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$23(r)));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Seq replicasToGroup = (Seq)tuple23._1();
            Seq replicasToNotGroup = (Seq)tuple23._2();
            tuple2 = new Tuple2((Object)replicasToGroup, (Object)replicasToNotGroup);
        } else {
            throw new MatchError((Object)tuple22);
        }
        Tuple2 tuple24 = tuple2;
        Seq replicasToGroup = (Seq)tuple24._1();
        Seq replicasToNotGroup = (Seq)tuple24._2();
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)$this.controllerContext().liveBrokerIdAndEpochs().apply((Object)BoxesRunTime.boxToInteger((int)broker)));
        StopReplicaRequest.Builder stopReplicaRequest = new StopReplicaRequest.Builder(stopReplicaRequestVersion$1, $this.controllerId(), controllerEpoch$1, brokerEpoch, false, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)replicasToGroup.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.replica().topicPartition(), Seq$.MODULE$.canBuildFrom())).toSet()).asJava());
        $this.controller.sendRequest(broker, ApiKeys.STOP_REPLICA, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)stopReplicaRequest, $this.controller.sendRequest$default$4());
        replicasToNotGroup.foreach((Function1 & Serializable & scala.Serializable)r -> {
            ControllerBrokerRequestBatch.$anonfun$sendRequestsToBrokers$25($this, stopReplicaRequestVersion$1, controllerEpoch$1, brokerEpoch, broker, r);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ControllerBrokerRequestBatch(KafkaController controller, StateChangeLogger stateChangeLogger) {
        this.controller = controller;
        this.stateChangeLogger = stateChangeLogger;
        Logging.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.leaderAndIsrRequestMap = Map$.MODULE$.empty();
        this.stopReplicaRequestMap = Map$.MODULE$.empty();
        this.updateMetadataRequestBrokerSet = scala.collection.mutable.Set$.MODULE$.empty();
        this.updateMetadataRequestPartitionInfoMap = Map$.MODULE$.empty();
    }
}

