/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.Assert;
import org.junit.Before;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011ee!\u00023f\u0003\u0003Q\u0007\"B9\u0001\t\u0003\u0011\bbB;\u0001\u0005\u0004%\tA\u001e\u0005\u0007{\u0002\u0001\u000b\u0011B<\t\u000by\u0004A\u0011I@\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0003\t\u0011\u0005u\u0001A1A\u0005\u0002}D\u0001\"a\b\u0001A\u0003%\u0011\u0011\u0001\u0005\n\u0003C\u0001!\u0019!C\u0001\u0003GA\u0001\"a\u000f\u0001A\u0003%\u0011Q\u0005\u0005\t\u0003{\u0001!\u0019!C\u0001\u007f\"A\u0011q\b\u0001!\u0002\u0013\t\t\u0001C\u0005\u0002B\u0001\u0011\r\u0011\"\u0001\u0002$!A\u00111\t\u0001!\u0002\u0013\t)\u0003C\u0005\u0002F\u0001\u0011\r\u0011\"\u0001\u0002\n!A\u0011q\t\u0001!\u0002\u0013\tY\u0001C\u0005\u0002J\u0001\u0011\r\u0011\"\u0001\u0002\n!A\u00111\n\u0001!\u0002\u0013\tY\u0001C\u0005\u0002N\u0001\u0011\r\u0011\"\u0001\u0002\n!A\u0011q\n\u0001!\u0002\u0013\tY\u0001C\u0005\u0002R\u0001\u0011\r\u0011\"\u0001\u0002T!A\u00111\f\u0001!\u0002\u0013\t)\u0006C\u0004\u0002^\u0001!\t&a\u0018\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z\u00191\u0011\u0011\u0012\u0001\t\u0003\u0017Ca!]\r\u0005\u0002\u0005\r\u0006\u0002CAU3\u0001\u0007I\u0011A@\t\u0013\u0005-\u0016\u00041A\u0005\u0002\u00055\u0006\u0002CAZ3\u0001\u0006K!!\u0001\t\u0011\u0005U\u0016\u00041A\u0005\u0002}D\u0011\"a.\u001a\u0001\u0004%\t!!/\t\u0011\u0005u\u0016\u0004)Q\u0005\u0003\u0003Aq!a0\u001a\t\u0003\t\t\rC\u0004\u0002Nf!\t!a4\t\u000f\u0005M\u0007\u0001\"\u0005\u0002V\"9!\u0011\u0001\u0001\u0005\u0012\t\r\u0001b\u0002B\u0019\u0001\u0011E!1\u0007\u0005\n\u0005C\u0002\u0011\u0013!C\t\u0005GB\u0011B!\u001f\u0001#\u0003%\tBa\u001f\t\u0013\t}\u0004!%A\u0005\u0012\t\u0005\u0005\"\u0003BC\u0001E\u0005I\u0011\u0003BD\u0011%\u0011Y\tAI\u0001\n#\u0011\u0019\u0007C\u0004\u0003\u000e\u0002!\tBa$\t\u0013\t5\u0007!%A\u0005\u0012\t=\u0007b\u0002Bk\u0001\u0011E!q\u001b\u0005\n\u0005{\u0004\u0011\u0013!C\t\u0005\u007fDqa!\u0003\u0001\t\u0003\u0019Y\u0001C\u0005\u0004V\u0002\t\n\u0011\"\u0001\u0004X\"911\u001c\u0001\u0005\u0002\ru\u0007\"CBv\u0001E\u0005I\u0011ABl\u0011\u001d\u0019i\u000f\u0001C\u0001\u0007_D\u0011ba@\u0001#\u0003%\t\u0001\"\u0001\t\u0013\u0011\u0015\u0001!%A\u0005\u0002\tm\u0004b\u0002C\u0004\u0001\u0011\u0005A\u0011\u0002\u0005\n\t#\u0001\u0011\u0013!C\u0001\t'Aq\u0001b\u0006\u0001\t#!I\u0002C\u0004\u00050\u0001!\t\u0002\"\r\u0007\r\u0011\u001d\u0003\u0001\u0003C%\u0011\u0019\t(\b\"\u0001\u0005R!AAQ\u000b\u001eA\u0002\u0013\u0005q\u0010C\u0005\u0005Xi\u0002\r\u0011\"\u0001\u0005Z!AAQ\f\u001e!B\u0013\t\t\u0001\u0003\u0005\u0005`i\u0002\r\u0011\"\u0001\u0000\u0011%!\tG\u000fa\u0001\n\u0003!\u0019\u0007\u0003\u0005\u0005hi\u0002\u000b\u0015BA\u0001\u0011%!IG\u000fa\u0001\n\u0003!Y\u0007C\u0005\u0005vi\u0002\r\u0011\"\u0001\u0005x!AA1\u0010\u001e!B\u0013!i\u0007C\u0004\u0005~i\"\t\u0005b \u0007\r\ru\u0001\u0001CB\u0010\u0011)\tIJ\u0012B\u0001B\u0003%!q\u0007\u0005\u000b\u0007[1%\u0011!Q\u0001\n\r=\u0002BCB\u001b\r\n\u0005\t\u0015!\u0003\u00048!1\u0011O\u0012C\u0001\u0007{Aa!\u001d$\u0005\u0002\r\u0015\u0003BB9G\t\u0003\u0019Y\u0005C\u0005\u0004R\u0019\u0003\r\u0011\"\u0001\u0004T!I1Q\f$A\u0002\u0013\u00051q\f\u0005\t\u0007G2\u0005\u0015)\u0003\u0004V!A1Q\u000e$A\u0002\u0013\u0005q\u0010C\u0005\u0004p\u0019\u0003\r\u0011\"\u0001\u0004r!A1Q\u000f$!B\u0013\t\t\u0001C\u0005\u0004z\u0019\u0003\r\u0011\"\u0003\u0004|!I1Q\u0010$A\u0002\u0013%1q\u0010\u0005\t\u0007\u00073\u0005\u0015)\u0003\u00048!I1q\u0011$A\u0002\u0013%1\u0011\u0012\u0005\n\u0007#3\u0005\u0019!C\u0005\u0007'C\u0001ba&GA\u0003&11\u0012\u0005\n\u000773\u0005\u0019!C\u0005\u0007;C\u0011ba(G\u0001\u0004%Ia!)\t\u0011\r\u0015f\t)Q\u0005\u0007_A\u0011ba*G\u0005\u0004%\ta!+\t\u0011\r-f\t)A\u0005\u0003'Cqa!,G\t\u0003\u0019y\u000bC\u0004\u00042\u001a#\taa-\t\u000f\ref\t\"\u0001\u0004\n\"911\u0018$\u0005B\ru\u0006bBB`\r\u0012\u0005\u0013\u0011\u0010\u0005\b\t\u001b\u0003A\u0011\u0001CH\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3ti*\u0011amZ\u0001\u0004CBL'\"\u00015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u001e\faa]3sm\u0016\u0014\u0018B\u00019n\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001t!\t!\b!D\u0001f\u0003\u001d)\u0007o]5m_:,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0002u\u0006)1oY1mC&\u0011A0\u001f\u0002\u0007\t>,(\r\\3\u0002\u0011\u0015\u00048/\u001b7p]\u0002\n1B\u0019:pW\u0016\u00148i\\;oiV\u0011\u0011\u0011\u0001\t\u0004q\u0006\r\u0011bAA\u0003s\n\u0019\u0011J\u001c;\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!\u0001/\u0019:u\u0003\u0015\u0001\u0018M\u001d;!\u0003\t!\b/\u0006\u0002\u0002&A!\u0011qEA\u001c\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012AB2p[6|gNC\u0002i\u0003_QA!!\r\u00024\u00051\u0011\r]1dQ\u0016T!!!\u000e\u0002\u0007=\u0014x-\u0003\u0003\u0002:\u0005%\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013!\u00029beR\u0014\u0014A\u00029beR\u0014\u0004%A\u0002uaJ\nA\u0001\u001e93A\u0005)qM]8va\u00061qM]8va\u0002\n\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0002#A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0007%\u0001\td_:\u001cX/\\3s\u00072LWM\u001c;JI\u0006\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\u00021\u001d\u0014x.\u001e9NCb\u001cVm]:j_:$\u0016.\\3pkRl5/\u0006\u0002\u0002VA\u0019\u00010a\u0016\n\u0007\u0005e\u0013P\u0001\u0003M_:<\u0017!G4s_V\u0004X*\u0019=TKN\u001c\u0018n\u001c8US6,w.\u001e;Ng\u0002\nqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\t\u0005\u0005\u0014q\r\t\u0004q\u0006\r\u0014bAA3s\n!QK\\5u\u0011\u001d\tIg\u0006a\u0001\u0003W\n!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\ti'a\u001d\u000e\u0005\u0005=$\u0002BA9\u0003'\tA!\u001e;jY&!\u0011QOA8\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003CB3\u0001GA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%\u0002BAB\u0003g\tQA[;oSRLA!a\"\u0002\u0002\n1!)\u001a4pe\u0016\u0014\u0001\u0005V3ti\u000e{gn];nKJ\u0014V-Y:tS\u001etW.\u001a8u\u0019&\u001cH/\u001a8feN)\u0011$!$\u0002\u0014B!\u0011QBAH\u0013\u0011\t\t*a\u0004\u0003\r=\u0013'.Z2u!\u0011\t)*a(\u000e\u0005\u0005]%\u0002BAM\u00037\u000b\u0001bY8ogVlWM\u001d\u0006\u0005\u0003;\u000bi#A\u0004dY&,g\u000e^:\n\t\u0005\u0005\u0016q\u0013\u0002\u001a\u0007>t7/^7feJ+'-\u00197b]\u000e,G*[:uK:,'\u000f\u0006\u0002\u0002&B\u0019\u0011qU\r\u000e\u0003\u0001\tqbY1mYN$v.Q:tS\u001etW\rZ\u0001\u0014G\u0006dGn\u001d+p\u0003N\u001c\u0018n\u001a8fI~#S-\u001d\u000b\u0005\u0003C\ny\u000bC\u0005\u00022r\t\t\u00111\u0001\u0002\u0002\u0005\u0019\u0001\u0010J\u0019\u0002!\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012\u0004\u0013AD2bY2\u001cHk\u001c*fm>\\W\rZ\u0001\u0013G\u0006dGn\u001d+p%\u00164xn[3e?\u0012*\u0017\u000f\u0006\u0003\u0002b\u0005m\u0006\"CAY?\u0005\u0005\t\u0019AA\u0001\u0003=\u0019\u0017\r\u001c7t)>\u0014VM^8lK\u0012\u0004\u0013\u0001F8o!\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\r\u0006\u0003\u0002b\u0005\r\u0007bBAcC\u0001\u0007\u0011qY\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBA7\u0003\u0013\f)#\u0003\u0003\u0002L\u0006=$AC\"pY2,7\r^5p]\u0006\u0019rN\u001c)beRLG/[8ogJ+go\\6fIR!\u0011\u0011MAi\u0011\u001d\t)M\ta\u0001\u0003\u000f\f\u0011d\u0019:fCR,7i\u001c8tk6,'oV5uQ\u001e\u0013x.\u001e9JIR!\u0011q[Au!!\t)*!7\u0002^\u0006u\u0017\u0002BAn\u0003/\u0013QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b#\u0002=\u0002`\u0006\r\u0018bAAqs\n)\u0011I\u001d:bsB\u0019\u00010!:\n\u0007\u0005\u001d\u0018P\u0001\u0003CsR,\u0007bBAvG\u0001\u0007\u0011Q^\u0001\bOJ|W\u000f]%e!\u0011\ty/!@\u000f\t\u0005E\u0018\u0011 \t\u0004\u0003gLXBAA{\u0015\r\t90[\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005m\u00180\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tyPC\u0002\u0002|f\f1b]3oIJ+7m\u001c:egRA!Q\u0001B\u0012\u0005W\u0011y\u0003\u0005\u0004\u0003\b\tE!q\u0003\b\u0005\u0005\u0013\u0011iA\u0004\u0003\u0002t\n-\u0011\"\u0001>\n\u0007\t=\u00110A\u0004qC\u000e\\\u0017mZ3\n\t\tM!Q\u0003\u0002\u0004'\u0016\f(b\u0001B\bsBA!\u0011\u0004B\u0010\u0003;\fi.\u0004\u0002\u0003\u001c)!!QDAN\u0003!\u0001(o\u001c3vG\u0016\u0014\u0018\u0002\u0002B\u0011\u00057\u0011a\u0002\u0015:pIV\u001cWM\u001d*fG>\u0014H\rC\u0004\u0003\u001e\u0011\u0002\rA!\n\u0011\u0011\te!qEAo\u0003;LAA!\u000b\u0003\u001c\ti1*\u00194lCB\u0013x\u000eZ;dKJDqA!\f%\u0001\u0004\t\t!\u0001\u0006ok6\u0014VmY8sINDq!!\t%\u0001\u0004\t)#A\fd_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:egR\u0011\u0012\u0011\rB\u001b\u0005{\u0011yDa\u0011\u0003H\t-#1\fB/\u0011\u001d\tI*\na\u0001\u0005o\u0001\u0002\"!&\u0003:\u0005u\u0017Q\\\u0005\u0005\u0005w\t9J\u0001\u0005D_:\u001cX/\\3s\u0011\u001d\u0011i#\na\u0001\u0003\u0003AqA!\u0011&\u0001\u0004\t\t!\u0001\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;\t\u0013\t\u0015S\u0005%AA\u0002\u0005\u0005\u0011\u0001G:uCJ$\u0018N\\4LKf\fe\u000e\u001a,bYV,\u0017J\u001c3fq\"I!\u0011J\u0013\u0011\u0002\u0003\u0007\u0011QK\u0001\u0012gR\f'\u000f^5oORKW.Z:uC6\u0004\b\"\u0003B'KA\u0005\t\u0019\u0001B(\u00035!\u0018.\\3ti\u0006l\u0007\u000fV=qKB!!\u0011\u000bB,\u001b\t\u0011\u0019F\u0003\u0003\u0003V\u0005%\u0012A\u0002:fG>\u0014H-\u0003\u0003\u0003Z\tM#!\u0004+j[\u0016\u001cH/Y7q)f\u0004X\rC\u0005\u0002\"\u0015\u0002\n\u00111\u0001\u0002&!I!qL\u0013\u0011\u0002\u0003\u0007\u0011\u0011A\u0001\u000f[\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011)G\u000b\u0003\u0002\u0002\t\u001d4F\u0001B5!\u0011\u0011YG!\u001e\u000e\u0005\t5$\u0002\u0002B8\u0005c\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tM\u00140\u0001\u0006b]:|G/\u0019;j_:LAAa\u001e\u0003n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\tu$\u0006BA+\u0005O\n\u0011eY8ogVlW-\u00118e-\u0016\u0014\u0018NZ=SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIY*\"Aa!+\t\t=#qM\u0001\"G>t7/^7f\u0003:$g+\u001a:jMf\u0014VmY8sIN$C-\u001a4bk2$HeN\u000b\u0003\u0005\u0013SC!!\n\u0003h\u0005\t3m\u001c8tk6,\u0017I\u001c3WKJLg-\u001f*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%q\u0005q1m\u001c8tk6,'+Z2pe\u0012\u001cXC\u0002BI\u0005[\u0013\t\r\u0006\u0005\u0003\u0014\n\u0015'\u0011\u001aBf!\u0019\u0011)Ja(\u0003$6\u0011!q\u0013\u0006\u0005\u00053\u0013Y*A\u0004nkR\f'\r\\3\u000b\u0007\tu\u00150\u0001\u0006d_2dWm\u0019;j_:LAA!)\u0003\u0018\nY\u0011I\u001d:bs\n+hMZ3s!!\t)J!*\u0003*\n}\u0016\u0002\u0002BT\u0003/\u0013abQ8ogVlWM\u001d*fG>\u0014H\r\u0005\u0003\u0003,\n5F\u0002\u0001\u0003\b\u0005_[#\u0019\u0001BY\u0005\u0005Y\u0015\u0003\u0002BZ\u0005s\u00032\u0001\u001fB[\u0013\r\u00119,\u001f\u0002\b\u001d>$\b.\u001b8h!\rA(1X\u0005\u0004\u0005{K(aA!osB!!1\u0016Ba\t\u001d\u0011\u0019m\u000bb\u0001\u0005c\u0013\u0011A\u0016\u0005\b\u00033[\u0003\u0019\u0001Bd!!\t)J!\u000f\u0003*\n}\u0006b\u0002B\u0017W\u0001\u0007\u0011\u0011\u0001\u0005\n\u0005?Z\u0003\u0013!a\u0001\u0003\u0003\t\u0001dY8ogVlWMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0011\u0019G!5\u0003T\u00129!q\u0016\u0017C\u0002\tEFa\u0002BbY\t\u0007!\u0011W\u0001\u0018g\u0016tG-\u00118e\u0003^\f\u0017\u000e^!ts:\u001c7i\\7nSR,bA!7\u0003b\n\u0015HCBA1\u00057\u00149\u000fC\u0004\u0002\u001a6\u0002\rA!8\u0011\u0011\u0005U%\u0011\bBp\u0005G\u0004BAa+\u0003b\u00129!qV\u0017C\u0002\tE\u0006\u0003\u0002BV\u0005K$qAa1.\u0005\u0004\u0011\t\fC\u0005\u0003j6\u0002\n\u00111\u0001\u0003l\u0006QqN\u001a4tKR\u001cx\n\u001d;\u0011\u000ba\u0014iO!=\n\u0007\t=\u0018P\u0001\u0004PaRLwN\u001c\t\t\u0003_\u0014\u00190!\n\u0003x&!!Q_A\u0000\u0005\ri\u0015\r\u001d\t\u0005\u0003+\u0013I0\u0003\u0003\u0003|\u0006]%!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\u0006\t3/\u001a8e\u0003:$\u0017i^1ji\u0006\u001b\u0018P\\2D_6l\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU11\u0011AB\u0003\u0007\u000f)\"aa\u0001+\t\t-(q\r\u0003\b\u0005_s#\u0019\u0001BY\t\u001d\u0011\u0019M\fb\u0001\u0005c\u000bA&\u00193e\u0007>t7/^7feN$vn\u0012:pkB\fe\u000eZ,bSR4uN]$s_V\u0004\u0018i]:jO:lWM\u001c;\u0015\u001d\r51\u0011YBc\u0007\u0013\u001cima4\u0004TB9\u0001pa\u0004\u0004\u0014\re\u0011bAB\ts\n1A+\u001e9mKJ\u0002bA!&\u0004\u0016\u0005]\u0017\u0002BB\f\u0005/\u0013aAQ;gM\u0016\u0014\bC\u0002BK\u0007+\u0019Y\u0002E\u0002\u0002(\u001a\u0013\u0001dQ8ogVlWM]!tg&<g.\\3oiB{G\u000e\\3s'\r15\u0011\u0005\t\u0005\u0007G\u0019I#\u0004\u0002\u0004&)\u00191qE4\u0002\u000bU$\u0018\u000e\\:\n\t\r-2Q\u0005\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-A\tu_BL7m\u001d+p'V\u00147o\u0019:jE\u0016\u0004bAa\u0002\u00042\u00055\u0018\u0002BB\u001a\u0005+\u0011A\u0001T5ti\u0006\u0011\u0002/\u0019:uSRLwN\\:U_\u0006\u001b8/[4o!\u0019\tyo!\u000f\u0002&%!11HA\u0000\u0005\r\u0019V\r\u001e\u000b\t\u00077\u0019yd!\u0011\u0004D!9\u0011\u0011\u0014&A\u0002\t]\u0002bBB\u0017\u0015\u0002\u00071q\u0006\u0005\b\u0007kQ\u0005\u0019AB\u001c)\u0019\u0019Yba\u0012\u0004J!9\u0011\u0011T&A\u0002\t]\u0002bBB\u0017\u0017\u0002\u00071q\u0006\u000b\u0007\u00077\u0019iea\u0014\t\u000f\u0005eE\n1\u0001\u00038!91Q\u0007'A\u0002\r]\u0012a\u0004;ie><h.\u0012=dKB$\u0018n\u001c8\u0016\u0005\rU\u0003#\u0002=\u0003n\u000e]\u0003\u0003\u0002B\u0004\u00073JAaa\u0017\u0003\u0016\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0014i\"\u0014xn\u001e8Fq\u000e,\u0007\u000f^5p]~#S-\u001d\u000b\u0005\u0003C\u001a\t\u0007C\u0005\u00022:\u000b\t\u00111\u0001\u0004V\u0005\u0001B\u000f\u001b:po:,\u0005pY3qi&|g\u000e\t\u0015\u0004\u001f\u000e\u001d\u0004c\u0001=\u0004j%\u001911N=\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001C]3dK&4X\rZ'fgN\fw-Z:\u0002)I,7-Z5wK\u0012lUm]:bO\u0016\u001cx\fJ3r)\u0011\t\tga\u001d\t\u0013\u0005E\u0016+!AA\u0002\u0005\u0005\u0011!\u0005:fG\u0016Lg/\u001a3NKN\u001c\u0018mZ3tA!\u001a!ka\u001a\u0002'A\f'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u0016\u0005\r]\u0012a\u00069beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$x\fJ3r)\u0011\t\tg!!\t\u0013\u0005EF+!AA\u0002\r]\u0012\u0001\u00069beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$\b\u0005K\u0002V\u0007O\n1c];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\u0005.\u00198hK\u0012,\"aa#\u0011\u0007a\u001ci)C\u0002\u0004\u0010f\u0014qAQ8pY\u0016\fg.A\ftk\n\u001c8M]5qi&|gn\u00115b]\u001e,Gm\u0018\u0013fcR!\u0011\u0011MBK\u0011%\t\tlVA\u0001\u0002\u0004\u0019Y)\u0001\u000btk\n\u001c8M]5qi&|gn\u00115b]\u001e,G\r\t\u0015\u00041\u000e\u001d\u0014A\u0005;pa&\u001c7oU;cg\u000e\u0014\u0018\u000e\u001d;j_:,\"aa\f\u0002-Q|\u0007/[2t'V\u00147o\u0019:jaRLwN\\0%KF$B!!\u0019\u0004$\"I\u0011\u0011\u0017.\u0002\u0002\u0003\u00071qF\u0001\u0014i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|g\u000eI\u0001\u0012e\u0016\u0014\u0017\r\\1oG\u0016d\u0015n\u001d;f]\u0016\u0014XCAAJ\u0003I\u0011XMY1mC:\u001cW\rT5ti\u0016tWM\u001d\u0011\u0002%\r|gn];nKJ\f5o]5h]6,g\u000e\u001e\u000b\u0003\u0007o\t\u0011b];cg\u000e\u0014\u0018NY3\u0015\t\u0005\u00054Q\u0017\u0005\b\u0007o{\u0006\u0019AB\u0018\u0003QqWm\u001e+pa&\u001c7\u000fV8Tk\n\u001c8M]5cK\u0006Y\u0012n]*vEN\u001c'/\u001b2f%\u0016\fX/Z:u!J|7-Z:tK\u0012\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\r-\u0015A\u00023p/>\u00148\u000eC\u0004\u0004D>\u0002\r!!\u0001\u0002'9,Xn\u00144D_:\u001cX/\\3sgR{\u0017\t\u001a3\t\u000f\r\u001dw\u00061\u0001\u0004\u0014\u0005i1m\u001c8tk6,'o\u0012:pkBDqaa30\u0001\u0004\u0019I\"A\bd_:\u001cX/\\3s!>dG.\u001a:t\u0011\u001d\u0019ic\fa\u0001\u0007_Aqa!50\u0001\u0004\u00199$A\u0007tk\n\u001c8M]5qi&|gn\u001d\u0005\n\u0003\u000bz\u0003\u0013!a\u0001\u0003[\fa'\u00193e\u0007>t7/^7feN$vn\u0012:pkB\fe\u000eZ,bSR4uN]$s_V\u0004\u0018i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIY*\"a!7+\t\u00055(qM\u0001\u0014C\u0012$7i\u001c8tk6,'o\u001d+p\u000fJ|W\u000f\u001d\u000b\u000f\u0007\u001b\u0019yn!9\u0004d\u000e\u00158q]Bu\u0011\u001d\u0019\u0019-\ra\u0001\u0003\u0003Aqaa22\u0001\u0004\u0019\u0019\u0002C\u0004\u0004LF\u0002\ra!\u0007\t\u000f\r5\u0012\u00071\u0001\u00040!91\u0011[\u0019A\u0002\r]\u0002\"CA#cA\u0005\t\u0019AAw\u0003u\tG\rZ\"p]N,X.\u001a:t)><%o\\;qI\u0011,g-Y;mi\u00122\u0014a\u0006<bY&$\u0017\r^3He>,\b/Q:tS\u001etW.\u001a8u))\t\tg!=\u0004t\u000eU81 \u0005\b\u0007\u0017\u001c\u0004\u0019AB\r\u0011\u001d\u0019\tn\ra\u0001\u0007oA\u0011ba>4!\u0003\u0005\ra!?\u0002\u00075\u001cx\rE\u0003y\u0005[\fi\u000fC\u0005\u0004~N\u0002\n\u00111\u0001\u0002V\u0005Aq/Y5u)&lW-A\u0011wC2LG-\u0019;f\u000fJ|W\u000f]!tg&<g.\\3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0005\u0004)\"1\u0011 B4\u0003\u00052\u0018\r\\5eCR,wI]8va\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003\u0001\u001aXOY:de&\u0014WmQ8ogVlWM]!oIN#\u0018M\u001d;Q_2d\u0017N\\4\u0015\u0011\rmA1\u0002C\u0007\t\u001fAq!!'7\u0001\u0004\u00119\u0004C\u0004\u0004.Y\u0002\raa\f\t\u0013\rUb\u0007%AA\u0002\r]\u0012AK:vEN\u001c'/\u001b2f\u0007>t7/^7fe\u0006sGm\u0015;beR\u0004v\u000e\u001c7j]\u001e$C-\u001a4bk2$HeM\u000b\u0003\t+QCaa\u000e\u0003h\u0005q\u0011m^1jiJ+'-\u00197b]\u000e,GCBA1\t7!i\u0003C\u0004\u0002\u001ab\u0002\r\u0001\"\b1\r\u0011}A1\u0005C\u0015!!\t)J!\u000f\u0005\"\u0011\u001d\u0002\u0003\u0002BV\tG!A\u0002\"\n\u0005\u001c\u0005\u0005\t\u0011!B\u0001\u0005c\u00131a\u0018\u00132!\u0011\u0011Y\u000b\"\u000b\u0005\u0019\u0011-B1DA\u0001\u0002\u0003\u0015\tA!-\u0003\u0007}##\u0007C\u0004\u0004(b\u0002\r!!*\u0002#\u0015t7/\u001e:f\u001d>\u0014VMY1mC:\u001cW\r\u0006\u0004\u0002b\u0011MBQ\t\u0005\b\u00033K\u0004\u0019\u0001C\u001ba\u0019!9\u0004b\u000f\u0005BAA\u0011Q\u0013B\u001d\ts!y\u0004\u0005\u0003\u0003,\u0012mB\u0001\u0004C\u001f\tg\t\t\u0011!A\u0003\u0002\tE&aA0%gA!!1\u0016C!\t1!\u0019\u0005b\r\u0002\u0002\u0003\u0005)\u0011\u0001BY\u0005\ryF\u0005\u000e\u0005\b\u0007OK\u0004\u0019AAS\u0005m\u0019u.\u001e8u\u0007>t7/^7fe\u000e{W.\\5u\u0007\u0006dGNY1dWN)!(!$\u0005LA!\u0011Q\u0013C'\u0013\u0011!y%a&\u0003)=3gm]3u\u0007>lW.\u001b;DC2d'-Y2l)\t!\u0019\u0006E\u0002\u0002(j\nAb];dG\u0016\u001c8oQ8v]R\f\u0001c];dG\u0016\u001c8oQ8v]R|F%Z9\u0015\t\u0005\u0005D1\f\u0005\n\u0003ck\u0014\u0011!a\u0001\u0003\u0003\tQb];dG\u0016\u001c8oQ8v]R\u0004\u0013!\u00034bS2\u001cu.\u001e8u\u000351\u0017-\u001b7D_VtGo\u0018\u0013fcR!\u0011\u0011\rC3\u0011%\t\t\fQA\u0001\u0002\u0004\t\t!\u0001\u0006gC&d7i\\;oi\u0002\n\u0011\u0002\\1ti\u0016\u0013(o\u001c:\u0016\u0005\u00115\u0004#\u0002=\u0003n\u0012=\u0004\u0003\u0002B\u0004\tcJA\u0001b\u001d\u0003\u0016\tIQ\t_2faRLwN\\\u0001\u000eY\u0006\u001cH/\u0012:s_J|F%Z9\u0015\t\u0005\u0005D\u0011\u0010\u0005\n\u0003c\u001b\u0015\u0011!a\u0001\t[\n!\u0002\\1ti\u0016\u0013(o\u001c:!\u0003)ygnQ8na2,G/\u001a\u000b\u0007\u0003C\"\t\t\"#\t\u000f\u0011\rU\t1\u0001\u0005\u0006\u00069qN\u001a4tKR\u001c\b\u0003CA7\t\u000f\u000b)Ca>\n\t\tU\u0018q\u000e\u0005\b\t\u0017+\u0005\u0019\u0001C8\u0003%)\u0007pY3qi&|g.\u0001\u000ejgB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;WC2LG\r\u0006\u0004\u0004\f\u0012EEq\u0013\u0005\b\t'\u001b\u0007\u0019\u0001CK\u0003-\t7o]5h]6,g\u000e^:\u0011\r\tU5QCB\u001c\u0011\u001d\t)m\u0019a\u0001\u0007o\u0001")
public abstract class AbstractConsumerTest
extends BaseRequestTest {
    private final double epsilon;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String group;
    private final String producerClientId;
    private final String consumerClientId;
    private final long groupMaxSessionTimeoutMs;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String group() {
        return this.group;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public long groupMaxSessionTimeoutMs() {
        return this.groupMaxSessionTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.groupMaxSessionTimeoutMs())).toString());
        properties.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
    }

    public KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        Properties groupOverrideConfig = new Properties();
        groupOverrideConfig.setProperty("group.id", groupId);
        Properties x$1 = groupOverrideConfig;
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        return this.createConsumer(x$2, x$3, x$1, x$4);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> AbstractConsumerTest.$anonfun$sendRecords$1(tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assert.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assert.assertEquals((long)tp.partition(), (long)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertEquals((Object)timestampType, (Object)record.timestampType());
                long timestamp = startingTimestamp + (long)i;
                Assert.assertEquals((long)timestamp, (long)record.timestamp());
            } else {
                Assert.assertTrue((String)new StringBuilder(60).append("Got unexpected timestamp ").append(record.timestamp()).append(". Timestamp should be between [").append(startingTimestamp).append(", ").append(now).append("}]").toString(), (record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assert.assertEquals((Object)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.key()));
            Assert.assertEquals((Object)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.value()));
            Assert.assertEquals((long)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString().length(), (long)record.serializedKeySize());
            Assert.assertEquals((long)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString().length(), (long)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        Consumer<K, V> x$1 = consumer;
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)AbstractConsumerTest.pollAction$1(polledRecords, maxPollRecords, records, numRecords));
        long x$3 = 60000L;
        Function0 & Serializable & scala.Serializable x$4 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Timed out before consuming expected ").append(numRecords).append(" records. ").append(new StringBuilder(25).append("The number consumed was ").append(records.size()).append(".").toString()).toString();
        TestUtils$.MODULE$.pollRecordsUntilTrue(x$1, x$2, (Function0<String>)x$4, x$3);
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        public class Kafka_api_AbstractConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final Option offsetsOpt$1;
            private final Consumer consumer$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                Exception exception2 = exception;
                if (exception2 instanceof RetriableCommitFailedException) {
                    AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(this, this.offsetsOpt$1, this.consumer$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.isComplete_$eq(true);
                    this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(AbstractConsumerTest $outer, Option offsetsOpt$1, Consumer consumer$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.consumer$1 = consumer$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_AbstractConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(this, offsetsOpt, consumer);
        AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(commitCallback, offsetsOpt, consumer);
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> commitCallback.isComplete(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to observe commit callback before timeout", 10000L);
        Assert.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, Set<TopicPartition> subscriptions, String group) {
        Assert.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        this.addConsumersToGroup(numOfConsumersToAdd, consumerGroup, consumerPollers, topicsToSubscribe, subscriptions, group);
        this.validateGroupAssignment(consumerPollers, subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4());
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroup(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, Set<TopicPartition> subscriptions, String group) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1 & Serializable & scala.Serializable)_ -> AbstractConsumerTest.$anonfun$addConsumersToGroup$1(this, group, consumerGroup, consumerPollers, topicsToSubscribe, BoxesRunTime.unboxToInt((Object)_)));
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public String addConsumersToGroupAndWaitForGroupAssignment$default$6() {
        return this.group();
    }

    public String addConsumersToGroup$default$6() {
        return this.group();
    }

    public void validateGroupAssignment(Buffer<ConsumerAssignmentPoller> consumerPollers, Set<TopicPartition> subscriptions, Option<String> msg, long waitTime) {
        Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            assignments.clear();
            consumerPollers.foreach((Function1 & Serializable & scala.Serializable)x$1 -> assignments.$plus$eq(x$1.consumerAssignment()));
            return this.isPartitionAssignmentValid((Buffer<Set<TopicPartition>>)assignments, subscriptions);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> (String)msg.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Did not get valid assignment for partitions ").append(subscriptions).append(". Instead, got ").append(assignments).toString()), waitTime, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public Option<String> validateGroupAssignment$default$3() {
        return None$.MODULE$;
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, Set<TopicPartition> partitionsToAssign) {
        Assert.assertEquals((long)0L, (long)consumer.assignment().size());
        ConsumerAssignmentPoller consumerPoller = topicsToSubscribe.nonEmpty() ? new ConsumerAssignmentPoller(this, consumer, topicsToSubscribe) : new ConsumerAssignmentPoller(this, consumer, partitionsToAssign);
        consumerPoller.start();
        return consumerPoller;
    }

    public Set<TopicPartition> subscribeConsumerAndStartPolling$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int numReassignments = rebalanceListener.callsToAssigned();
        TestUtils$.MODULE$.pollUntilTrue(consumer, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rebalanceListener.callsToAssigned() > numReassignments, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out before expected rebalance completed", TestUtils$.MODULE$.pollUntilTrue$default$4());
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assert.assertEquals((long)initialRevokeCalls, (long)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<Set<TopicPartition>> assignments, Set<TopicPartition> partitions) {
        Set uniqueAssignedPartitions;
        boolean allNonEmptyAssignments = assignments.forall((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()));
        if (!allNonEmptyAssignments) {
            return false;
        }
        int n = 0;
        int totalPartitionsInAssignments = BoxesRunTime.unboxToInt((Object)assignments.$div$colon((Object)BoxesRunTime.boxToInteger((int)n), (Function2 & Serializable & scala.Serializable)(x$3, x$4) -> BoxesRunTime.boxToInteger((int)AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$2(BoxesRunTime.unboxToInt((Object)x$3), x$4))));
        if (totalPartitionsInAssignments != partitions.size()) {
            return false;
        }
        Set set = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Set set2 = uniqueAssignedPartitions = (Set)assignments.$div$colon((Object)set, (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> (Set)x$6.$plus$plus((GenTraversableOnce)x$7));
        Set<TopicPartition> set3 = partitions;
        return !(set2 != null ? !set2.equals(set3) : set3 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(TopicPartition tp$1, KafkaProducer producer$1, int i) {
        void var3_3;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long((long)i), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$1.send(record);
        return var3_3;
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, int maxPollRecords$1, ArrayBuffer records$2, int numRecords$1) {
        Assert.assertTrue((((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala()).size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final void kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback, Option offsetsOpt$1, Consumer consumer$1) {
        Option option = offsetsOpt$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)some.value();
            consumer$1.commitAsync((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), callback);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            consumer$1.commitAsync(callback);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ Buffer $anonfun$addConsumersToGroup$1(AbstractConsumerTest $this, String group$1, Buffer consumerGroup$1, Buffer consumerPollers$1, List topicsToSubscribe$1, int _) {
        KafkaConsumer<byte[], byte[]> consumer = $this.createConsumerWithGroupId(group$1);
        consumerGroup$1.$plus$eq(consumer);
        return consumerPollers$1.$plus$eq((Object)$this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)topicsToSubscribe$1, $this.subscribeConsumerAndStartPolling$default$3()));
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$2(int x$3, Set x$4) {
        return x$3 + x$4.size();
    }

    public AbstractConsumerTest() {
        this.epsilon = 0.1;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.group = "my-test";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.groupMaxSessionTimeoutMs = 30000L;
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", this.group());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        public final Consumer<byte[], byte[]> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$consumer;
        private final Set<TopicPartition> partitionsToAssign;
        private volatile Option<Throwable> thrownException;
        private volatile int receivedMessages;
        private volatile Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private volatile boolean subscriptionChanged;
        private List<String> topicsSubscription;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ AbstractConsumerTest $outer;

        public Option<Throwable> thrownException() {
            return this.thrownException;
        }

        public void thrownException_$eq(Option<Throwable> x$1) {
            this.thrownException = x$1;
        }

        public int receivedMessages() {
            return this.receivedMessages;
        }

        public void receivedMessages_$eq(int x$1) {
            this.receivedMessages = x$1;
        }

        private Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        public void kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq(Set<TopicPartition> x$1) {
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = x$1;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            if (this.partitionsToAssign.nonEmpty()) {
                throw new IllegalStateException("Cannot call subscribe when configured to use manual partition assignment");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.receivedMessages_$eq(this.receivedMessages() + this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$consumer.poll(Duration.ofMillis(50L)).count());
            }
            catch (WakeupException wakeupException) {
            }
            catch (Throwable e) {
                this.thrownException_$eq((Option<Throwable>)new Some((Object)e));
                throw e;
            }
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, Set<TopicPartition> partitionsToAssign) {
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$consumer = consumer;
            this.partitionsToAssign = partitionsToAssign;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.thrownException = None$.MODULE$;
            this.receivedMessages = 0;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = partitionsToAssign;
            this.subscriptionChanged = false;
            this.topicsSubscription = topicsToSubscribe;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$consumer.assignment()).asScala()).toArray(ClassTag$.MODULE$.apply(TopicPartition.class))))));
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment_$eq((Set<TopicPartition>)Predef$.MODULE$.Set().empty());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            if (this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().isEmpty()) {
                consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
            } else {
                consumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment()).asJava());
            }
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this($outer, consumer, topicsToSubscribe, (Set<TopicPartition>)Predef$.MODULE$.Set().empty());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, Set<TopicPartition> partitionsToAssign) {
            this($outer, consumer, (List<String>)List$.MODULE$.empty(), partitionsToAssign);
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
            } else {
                this.failCount_$eq(this.failCount() + 1);
                this.lastError_$eq((Option<Exception>)new Some((Object)exception));
            }
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$CountConsumerCommitCallback$$$outer() {
            return AbstractConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return AbstractConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

