/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Authorizer;
import kafka.security.auth.ClusterAction$;
import kafka.security.auth.Create$;
import kafka.security.auth.Describe$;
import kafka.security.auth.Group$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.Topic$;
import kafka.security.auth.Write$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h!B*U\u0003\u0003I\u0006\"B1\u0001\t\u0003\u0011\u0007b\u00023\u0001\u0005\u0004%\t%\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011\u00024\t\u000b5\u0004A\u0011\t8\t\u000fI\u0004!\u0019!C\u0001K\"11\u000f\u0001Q\u0001\n\u0019Dq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA\u001e\u0005\t\u007f\u0002\u0011\r\u0011\"\u0001\u0002\u0002!A\u0011q\u0003\u0001!\u0002\u0013\t\u0019\u0001\u0003\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0001v\u0011\u001d\tY\u0002\u0001Q\u0001\nYD\u0011\"!\b\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u0007A\u0001\"!\t\u0001\u0005\u0004%\t!\u001e\u0005\b\u0003G\u0001\u0001\u0015!\u0003w\u0011!\t)\u0003\u0001b\u0001\n\u0003)\u0007bBA\u0014\u0001\u0001\u0006IA\u001a\u0005\n\u0003S\u0001!\u0019!C\u0001\u0003WA\u0001\"a\u0011\u0001A\u0003%\u0011Q\u0006\u0005\n\u0003\u000b\u0002!\u0019!D\u0001\u0003\u0003A\u0011\"a\u0012\u0001\u0005\u00045\t!!\u0001\t\u0015\u0005%\u0003\u0001#b\u0001\n#\nY\u0005C\u0005\u0002`\u0001\u0011\r\u0011\"\u0001\u0002b!A\u00111\u000f\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002v\u0001\u0011\r\u0011\"\u0001\u0002b!A\u0011q\u000f\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002z\u0001\u0011\r\u0011\"\u0001\u0002b!A\u00111\u0010\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002~\u0001\u0011\r\u0011\"\u0001\u0002b!A\u0011q\u0010\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002\u0002\u0002\u0011\r\u0011\"\u0001\u0002b!A\u00111\u0011\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0001\u0002b!A\u0011q\u0011\u0001!\u0002\u0013\t\u0019\u0007C\u0005\u0002\n\u0002\u0011\r\u0011\"\u0001\u0002b!A\u00111\u0012\u0001!\u0002\u0013\t\u0019\u0007C\u0004\u0002\u000e\u0002!\t!a$\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u0010\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0005bBAP\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003C\u0003A\u0011AAH\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003\u001fCq!!*\u0001\t\u0003\t9\u000bC\u0004\u0002,\u0002!\t!a$\t\u000f\u00055\u0006\u0001\"\u0001\u0002\u0010\"9\u0011q\u0016\u0001\u0005\u0002\u0005=\u0005bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003\u0017\u0004A\u0011AAZ\u0011\u001d\ti\r\u0001C\u0001\u0003gCq!a4\u0001\t\u0003\t\u0019\fC\u0004\u0002R\u0002!\t!a-\t\u000f\u0005M\u0007\u0001\"\u0001\u00024\"9\u0011Q\u001b\u0001\u0005\u0002\u0005M\u0006BBAl\u0001\u0011\u0005c\u000e\u0003\u0004\u0002h\u0002!\tE\u001c\u0005\u0007\u0003c\u0004A\u0011\u00018\t\r\u0005m\b\u0001\"\u0005o\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fDaAa\t\u0001\t\u0003q\u0007B\u0002B\u0014\u0001\u0011\u0005a\u000e\u0003\u0004\u0003,\u0001!\tA\u001c\u0005\u0007\u0005_\u0001A\u0011\u00018\t\r\tM\u0002\u0001\"\u0003o\u0011\u0019\u0011)\u0004\u0001C\u0005]\"9!q\u0007\u0001\u0005\u0012\te\u0002B\u0002B\u001f\u0001\u0011\u0005a\u000e\u0003\u0004\u0003R\u0001!\tA\u001c\u0005\u0007\u0005+\u0002A\u0011\u00018\t\r\t\u0005\u0004\u0001\"\u0001o\u0011\u0019\u0011)\u0007\u0001C\u0005]\"1!q\r\u0001\u0005\u00029DaAa\u001b\u0001\t\u0003q\u0007B\u0002B8\u0001\u0011%a\u000e\u0003\u0004\u0003r\u0001!\tA\u001c\u0005\b\u0005k\u0002AQ\u0003B<\u0011\u001d\u00119\n\u0001C\u000b\u00053C\u0011B!0\u0001#\u0003%)Ba0\t\u0013\tU\u0007!%A\u0005\u0016\t}\u0006\"\u0003Bl\u0001E\u0005IQ\u0003Bm\u0011%\u0011i\u000eAI\u0001\n+\u0011y\fC\u0005\u0003`\u0002\t\n\u0011\"\u0006\u0003b\nIRI\u001c3U_\u0016sG-Q;uQ>\u0014\u0018N_1uS>tG+Z:u\u0015\t)f+A\u0002ba&T\u0011aV\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!L\u0018\t\u00037rk\u0011\u0001V\u0005\u0003;R\u0013a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o\u001d\t\u00037~K!\u0001\u0019+\u0003\u0013M\u000b7\u000f\\*fiV\u0004\u0018A\u0002\u001fj]&$h\bF\u0001d!\tY\u0006!A\u0006ce>\\WM]\"pk:$X#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0003%\fQa]2bY\u0006L!a\u001b5\u0003\u0007%sG/\u0001\u0007ce>\\WM]\"pk:$\b%A\u0012d_:4\u0017nZ;sKN+7-\u001e:jif\u0014UMZ8sKN+'O^3sgN#\u0018M\u001d;\u0015\u0003=\u0004\"a\u001a9\n\u0005ED'\u0001B+oSR\f!B\\;n%\u0016\u001cwN\u001d3t\u0003-qW/\u001c*fG>\u0014Hm\u001d\u0011\u0002\u0017\u001d\u0014x.\u001e9Qe\u00164\u0017\u000e_\u000b\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0005Y\u0006twMC\u0001|\u0003\u0011Q\u0017M^1\n\u0005uD(AB*ue&tw-\u0001\u0007he>,\b\u000f\u0015:fM&D\b%A\u0003he>,\b/\u0006\u0002\u0002\u0004A!\u0011QAA\n\u001d\u0011\t9!a\u0004\u0011\u0007\u0005%\u0001.\u0004\u0002\u0002\f)\u0019\u0011Q\u0002-\u0002\rq\u0012xn\u001c;?\u0013\r\t\t\u0002[\u0001\u0007!J,G-\u001a4\n\u0007u\f)BC\u0002\u0002\u0012!\faa\u001a:pkB\u0004\u0013a\u0003;pa&\u001c\u0007K]3gSb\fA\u0002^8qS\u000e\u0004&/\u001a4jq\u0002\nQ\u0001^8qS\u000e\fa\u0001^8qS\u000e\u0004\u0013\u0001C<jY\u0012\u001c\u0017M\u001d3\u0002\u0013]LG\u000eZ2be\u0012\u0004\u0013\u0001\u00029beR\fQ\u0001]1si\u0002\n!\u0001\u001e9\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003\u007fi!!!\r\u000b\t\u0005M\u0012QG\u0001\u0007G>lWn\u001c8\u000b\u0007]\u000b9D\u0003\u0003\u0002:\u0005m\u0012AB1qC\u000eDWM\u0003\u0002\u0002>\u0005\u0019qN]4\n\t\u0005\u0005\u0013\u0011\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\r!\b\u000fI\u0001\u0010G2LWM\u001c;Qe&t7-\u001b9bY\u0006q1.\u00194lCB\u0013\u0018N\\2ja\u0006d\u0017A\u0004;skN$8\u000b^8sK\u001aKG.Z\u000b\u0003\u0003\u001b\u0002RaZA(\u0003'J1!!\u0015i\u0005\u0011\u0019v.\\3\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017{\u0003\tIw.\u0003\u0003\u0002^\u0005]#\u0001\u0002$jY\u0016\fQ\u0002^8qS\u000e\u0014Vm]8ve\u000e,WCAA2!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\nA!Y;uQ*\u0019\u0011Q\u000e,\u0002\u0011M,7-\u001e:jifLA!!\u001d\u0002h\tA!+Z:pkJ\u001cW-\u0001\bu_BL7MU3t_V\u00148-\u001a\u0011\u0002\u001b\u001d\u0014x.\u001e9SKN|WO]2f\u000399'o\\;q%\u0016\u001cx.\u001e:dK\u0002\nqb\u00197vgR,'OU3t_V\u00148-Z\u0001\u0011G2,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0002\nQ\u0003\u001d:fM&DX\r\u001a+pa&\u001c'+Z:pkJ\u001cW-\u0001\fqe\u00164\u0017\u000e_3e)>\u0004\u0018n\u0019*fg>,(oY3!\u0003U\u0001(/\u001a4jq\u0016$wI]8vaJ+7o\\;sG\u0016\fa\u0003\u001d:fM&DX\rZ$s_V\u0004(+Z:pkJ\u001cW\rI\u0001\u0016o&dGmY1sIR{\u0007/[2SKN|WO]2f\u0003Y9\u0018\u000e\u001c3dCJ$Gk\u001c9jGJ+7o\\;sG\u0016\u0004\u0013!F<jY\u0012\u001c\u0017M\u001d3He>,\bOU3t_V\u00148-Z\u0001\u0017o&dGmY1sI\u001e\u0013x.\u001e9SKN|WO]2fA\u0005\t2\r\\;ti\u0016\u0014\u0018i\u0019;j_:\f%oZ:\u0016\u0005\u0005E\u0005#B4\u0002\u0014\u0006\r\u0011bAAKQ\n)\u0011I\u001d:bs\u00061Bo\u001c9jG\n\u0013xn[3s%\u0016\fG-Q2m\u0003J<7/\u0001\bqe>$WoY3BG2\f%oZ:\u0015\t\u0005E\u0015Q\u0014\u0005\b\u0003;A\u0003\u0019AA\u0002\u0003=!Wm]2sS\n,\u0017i\u00197Be\u001e\u001c\u0018!\u00063fY\u0016$X\rR3tGJL'-Z!dY\u0006\u0013xm]\u0001\u0013I\u0016dW\r^3Xe&$X-Q2m\u0003J<7/\u0001\bd_:\u001cX/\\3BG2\f%oZ:\u0015\t\u0005E\u0015\u0011\u0016\u0005\b\u0003;a\u0003\u0019AA\u0002\u000319'o\\;q\u0003\u000ed\u0017I]4t\u0003u\u0001(o\u001c3vG\u0016\u001cuN\\:v[\u0016<\u0016\u000e\u001c3dCJ$\u0017i\u00197Be\u001e\u001c\u0018A\b9s_\u0012,8-Z\"p]N,X.\u001a)sK\u001aL\u00070\u001a3BG2\u001c\u0018I]4t\u0003A\u0019E.^:uKJ\f5\r^5p]\u0006\u001bG.\u0006\u0002\u00026B1\u0011qWAa\u0003\u000bl!!!/\u000b\t\u0005m\u0016QX\u0001\nS6lW\u000f^1cY\u0016T1!a0i\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0007\fILA\u0002TKR\u0004B!!\u001a\u0002H&!\u0011\u0011ZA4\u0005\r\t5\r\\\u0001\u0013)>\u0004\u0018n\u0019\"s_.,'OU3bI\u0006\u001bG.\u0001\u0007He>,\bOU3bI\u0006\u001bG.\u0001\u0007U_BL7MU3bI\u0006\u001bG.A\u0007U_BL7m\u0016:ji\u0016\f5\r\\\u0001\u0011)>\u0004\u0018n\u0019#fg\u000e\u0014\u0018NY3BG2\fa\u0002V8qS\u000e\u001c%/Z1uK\u0006\u001bG.A\u0003tKR,\u0006\u000fK\u00028\u00037\u0004B!!8\u0002d6\u0011\u0011q\u001c\u0006\u0005\u0003C\fY$A\u0003kk:LG/\u0003\u0003\u0002f\u0006}'A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\rA\u00141\u001e\t\u0005\u0003;\fi/\u0003\u0003\u0002p\u0006}'!B!gi\u0016\u0014\u0018a\u0007;fgR\u0004&o\u001c3vG\u0016\u001cuN\\:v[\u00164\u0016.Y!tg&<g\u000eK\u0002:\u0003k\u0004B!!8\u0002x&!\u0011\u0011`Ap\u0005\u0011!Vm\u001d;\u0002=\r|gNZ5s[J+\u0017-\u001e;iK:$\u0018nY1uS>tW*\u001a;sS\u000e\u001c\u0018\u0001C4fi\u001e\u000bWoZ3\u0015\t\t\u0005!q\u0004\t\u0007\u0005\u0007\u0011)B!\u0007\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0005\u0013\tAaY8sK*!!1\u0002B\u0007\u0003\u001diW\r\u001e:jGNTAAa\u0004\u0003\u0012\u00051\u00110Y7nKJT!Aa\u0005\u0002\u0007\r|W.\u0003\u0003\u0003\u0018\t\u0015!!B$bk\u001e,\u0007cA4\u0003\u001c%\u0019!Q\u00045\u0003\r\u0011{WO\u00197f\u0011\u001d\u0011\tc\u000fa\u0001\u0003\u0007\t!\"\\3ue&\u001cg*Y7f\u0003y!Xm\u001d;Qe>$WoY3D_:\u001cX/\\3WS\u0006\u001cVOY:de&\u0014W\rK\u0002=\u0003k\f!\u0005^3tiB\u0013x\u000eZ;dK\u000e{gn];nK^KG\u000f[,jY\u0012\u001c\u0017M\u001d3BG2\u001c\bfA\u001f\u0002v\u0006\u0011C/Z:u!J|G-^2f\u0007>t7/^7f/&$\b\u000e\u0015:fM&DX\rZ!dYND3APA{\u0003=\"Xm\u001d;Qe>$WoY3D_:\u001cX/\\3U_BL7-Q;u_\u000e\u0013X-\u0019;f)>\u0004\u0018nY\"sK\u0006$X-Q2mQ\ry\u0014Q_\u0001\u0018g\u0016$x+\u001b7eG\u0006\u0014HMU3t_V\u00148-Z!dYN\fqc]3u!J,g-\u001b=fIJ+7o\\;sG\u0016\f5\r\\:\u0002#M,G/Q2mg\u0006sG\r\u0015:pIV\u001cW\rF\u0002p\u0005wAq!!\u000bC\u0001\u0004\ti#A\u0010uKN$hj\u001c)s_\u0012,8-Z,ji\"|W\u000f\u001e#fg\u000e\u0014\u0018NY3BG2DsaQA{\u0005\u0003\u0012\u0019%\u0001\u0005fqB,7\r^3eG\t\u0011)\u0005\u0005\u0003\u0003H\t5SB\u0001B%\u0015\u0011\u0011Y%!\r\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\u0011yE!\u0013\u00037Q{\u0007/[2BkRDwN]5{CRLwN\\#yG\u0016\u0004H/[8o\u0003q!Xm\u001d;O_B\u0013x\u000eZ;dK^KG\u000f\u001b#fg\u000e\u0014\u0018NY3BG2D3\u0001RA{\u0003!\"Xm\u001d;O_\u000e{gn];nK^KG\u000f[8vi\u0012+7o\u0019:jE\u0016\f5\r\u001c,jC\u0006\u001b8/[4oQ\u001d)\u0015Q\u001fB!\u00053\u001a#Aa\u0017\u0011\t\u0005=\"QL\u0005\u0005\u0005?\n\tD\u0001\bLC\u001a\\\u0017-\u0012=dKB$\u0018n\u001c8\u0002WQ,7\u000f\u001e(p\u0007>t7/^7f/&$\bn\\;u\t\u0016\u001c8M]5cK\u0006\u001bGNV5b'V\u00147o\u0019:jE\u0016DsARA{\u0005\u0003\u0012\u0019%\u0001\u0011o_\u000e{gn];nK^KG\u000f[8vi\u0012+7o\u0019:jE\u0016\f5\r\\*fiV\u0004\u0018!\n;fgRtunQ8ogVlWmV5uQ\u0012+7o\u0019:jE\u0016\f5\r\u001c,jC\u0006\u001b8/[4oQ\rA\u0015Q_\u0001)i\u0016\u001cHOT8D_:\u001cX/\\3XSRDG)Z:de&\u0014W-Q2m-&\f7+\u001e2tGJL'-\u001a\u0015\u0004\u0013\u0006U\u0018!\b8p\u0007>t7/^7f/&$\b\u000eR3tGJL'-Z!dYN+G/\u001e9\u0002\u001dQ,7\u000f\u001e(p\u000fJ|W\u000f]!dY\"\u001a1*!>\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\b_\ne$1\u0013BK\u0011\u001d\u0011Y\b\u0014a\u0001\u0005{\n\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0005\u007f\u00129Ia#\u0003\f6\u0011!\u0011\u0011\u0006\u0005\u0005w\u0012\u0019I\u0003\u0003\u0003\u0006\u0006U\u0012aB2mS\u0016tGo]\u0005\u0005\u0005\u0013\u0013\tIA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0006O\u0006M%Q\u0012\t\u0004O\n=\u0015b\u0001BIQ\n!!)\u001f;f\u0011\u0015\u0011H\n1\u0001g\u0011\u001d\tI\u0003\u0014a\u0001\u0003[\tabY8ogVlWMU3d_J$7\u000fF\u0007p\u00057\u0013IKa+\u00030\nE&1\u0017\u0005\b\u0005;k\u0005\u0019\u0001BP\u0003!\u0019wN\\:v[\u0016\u0014\b\u0003\u0003BQ\u0005K\u0013YIa#\u000e\u0005\t\r&\u0002\u0002BO\u0005\u0007KAAa*\u0003$\nA1i\u001c8tk6,'\u000fC\u0004s\u001bB\u0005\t\u0019\u00014\t\u0011\t5V\n%AA\u0002\u0019\fab\u001d;beRLgnZ(gMN,G\u000fC\u0005\u0002\u001e5\u0003\n\u00111\u0001\u0002\u0004!A\u0011QE'\u0011\u0002\u0003\u0007a\rC\u0005\u000366\u0003\n\u00111\u0001\u00038\u00069A/[7f_V$\bcA4\u0003:&\u0019!1\u00185\u0003\t1{gnZ\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u0012TC\u0001BaU\r1'1Y\u0016\u0003\u0005\u000b\u0004BAa2\u0003R6\u0011!\u0011\u001a\u0006\u0005\u0005\u0017\u0014i-A\u0005v]\u000eDWmY6fI*\u0019!q\u001a5\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003T\n%'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006A2m\u001c8tk6,'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001a\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\\*\"\u00111\u0001Bb\u0003a\u0019wN\\:v[\u0016\u0014VmY8sIN$C-\u001a4bk2$H%N\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122TC\u0001BrU\u0011\u00119La1")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final int brokerCount;
    private final int numRecords;
    private final String groupPrefix;
    private final String group;
    private final String topicPrefix;
    private final String topic;
    private final String wildcard;
    private final int part;
    private final TopicPartition tp;
    private final Resource topicResource;
    private final Resource groupResource;
    private final Resource clusterResource;
    private final Resource prefixedTopicResource;
    private final Resource prefixedGroupResource;
    private final Resource wildcardTopicResource;
    private final Resource wildcardGroupResource;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterActionArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String groupPrefix() {
        return this.groupPrefix;
    }

    public String group() {
        return this.group;
    }

    public String topicPrefix() {
        return this.topicPrefix;
    }

    public String topic() {
        return this.topic;
    }

    public String wildcard() {
        return this.wildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public abstract String clientPrincipal();

    public abstract String kafkaPrincipal();

    private Some<File> trustStoreFile$lzycompute() {
        EndToEndAuthorizationTest endToEndAuthorizationTest = this;
        synchronized (endToEndAuthorizationTest) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        return !this.bitmap$0 ? this.trustStoreFile$lzycompute() : this.trustStoreFile;
    }

    public Resource topicResource() {
        return this.topicResource;
    }

    public Resource groupResource() {
        return this.groupResource;
    }

    public Resource clusterResource() {
        return this.clusterResource;
    }

    public Resource prefixedTopicResource() {
        return this.prefixedTopicResource;
    }

    public Resource prefixedGroupResource() {
        return this.prefixedGroupResource;
    }

    public Resource wildcardTopicResource() {
        return this.wildcardTopicResource;
    }

    public Resource wildcardGroupResource() {
        return this.wildcardGroupResource;
    }

    public String[] clusterActionArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", "--cluster", "--operation=ClusterAction", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.kafkaPrincipal()).toString()});
    }

    public String[] topicBrokerReadAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), "--operation=Read", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.kafkaPrincipal()).toString()});
    }

    public String[] produceAclArgs(String topic) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] describeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] deleteDescribeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] deleteWriteAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Write", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] consumeAclArgs(String topic) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), new StringBuilder(8).append("--group=").append(this.group()).toString(), "--consumer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] groupAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--group=").append(this.group()).toString(), "--operation=Read", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] produceConsumeWildcardAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), new StringBuilder(8).append("--group=").append(this.wildcard()).toString(), "--consumer", "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public String[] produceConsumePrefixedAclsArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topicPrefix()).toString(), new StringBuilder(8).append("--group=").append(this.groupPrefix()).toString(), "--resource-pattern-type=prefixed", "--consumer", "--producer", new StringBuilder(19).append("--allow-principal=").append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString()});
    }

    public scala.collection.immutable.Set<Acl> ClusterActionAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)ClusterAction$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicBrokerReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.kafkaPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> GroupReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Read$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicWriteAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Write$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicDescribeAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Describe$.MODULE$)}));
    }

    public scala.collection.immutable.Set<Acl> TopicCreateAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{new Acl(new KafkaPrincipal(this.kafkaPrincipalType(), this.clientPrincipal()), (PermissionType)Allow$.MODULE$, Acl$.MODULE$.WildCardHost(), (Operation)Create$.MODULE$)}));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setUp$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.createTopic(this.topic(), 1, 3, this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    public void confirmReauthenticationMetrics() {
        double expiredConnectionsKilledCountTotal = BoxesRunTime.unboxToDouble((Object)this.getGauge("ExpiredConnectionsKilledCount").value());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$1(expiredConnectionsKilledCountTotal, s);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Should have been zero expired connections killed total", (double)0.0, (double)expiredConnectionsKilledCountTotal, (double)0.0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$2(s);
            return BoxedUnit.UNIT;
        });
    }

    private Gauge<Object> getGauge(String metricName) {
        return (Gauge)((Tuple2)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.$anonfun$getGauge$1(metricName, k))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230))))._2();
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithWildcardAcls() {
        this.setWildcardResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithPrefixedAcls() {
        this.setPrefixedResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeTopicAutoCreateTopicCreateAcl() {
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        this.setAclsAndProduce(tp2);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$1 = consumer;
        int x$2 = this.numRecords();
        String x$3 = tp2.topic();
        int x$4 = this.consumeRecords$default$3();
        int x$5 = this.consumeRecords$default$5();
        long x$6 = this.consumeRecords$default$6();
        this.consumeRecords((Consumer<byte[], byte[]>)x$1, x$2, x$4, x$3, x$5, x$6);
        this.confirmReauthenticationMetrics();
    }

    private void setWildcardResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumeWildcardAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setWildcardResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setPrefixedResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumePrefixedAclsArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setPrefixedResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    public void setAclsAndProduce(TopicPartition tp) {
        AclCommand$.MODULE$.main(this.produceAclArgs(tp.topic()));
        AclCommand$.MODULE$.main(this.consumeAclArgs(tp.topic()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setAclsAndProduce$1(this, tp, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), tp);
    }

    @Test(expected=TopicAuthorizationException.class)
    public void testNoProduceWithoutDescribeAcl() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.TopicDescribeAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        try {
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            this.sendRecords(producer, this.numRecords(), this.tp());
            throw Assertions$.MODULE$.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test(expected=TopicAuthorizationException.class)
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        KafkaConsumer x$1 = consumer;
        long x$2 = 3000L;
        int x$3 = this.consumeRecords$default$2();
        int x$4 = this.consumeRecords$default$3();
        String x$5 = this.consumeRecords$default$4();
        int x$6 = this.consumeRecords$default$5();
        this.consumeRecords((Consumer<byte[], byte[]>)x$1, x$3, x$4, x$5, x$6, x$2);
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithoutDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)this.TopicWriteAcl().$plus$plus(this.TopicDescribeAcl()).$plus$plus(this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
        }
        catch (GroupAuthorizationException e) {
            Assert.assertEquals((Object)this.group(), (Object)e.groupId());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    public final void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> EndToEndAuthorizationTest.$anonfun$sendRecords$1(this, tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        try {
            futures.foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public final void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(consumer, numRecords, timeout);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assert.assertEquals((Object)topic, (Object)record.topic());
            Assert.assertEquals((long)part, (long)record.partition());
            Assert.assertEquals((long)offset, (long)record.offset());
        });
    }

    public final int consumeRecords$default$2() {
        return 1;
    }

    public final int consumeRecords$default$3() {
        return 0;
    }

    public final String consumeRecords$default$4() {
        return this.topic();
    }

    public final int consumeRecords$default$5() {
        return this.part();
    }

    public final long consumeRecords$default$6() {
        return 10000L;
    }

    public static final /* synthetic */ void $anonfun$setUp$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls($this.ClusterActionAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), Resource$.MODULE$.ClusterResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.TopicBrokerReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, "*", PatternType.LITERAL));
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$1(double expiredConnectionsKilledCountTotal$1, KafkaServer s) {
        long numExpiredKilled = TestUtils$.MODULE$.totalMetricValue(s, "expired-connections-killed-count");
        Assert.assertTrue((String)new StringBuilder(58).append("Should have been zero expired connections killed: ").append(numExpiredKilled).append("(total=").append(expiredConnectionsKilledCountTotal$1).append(")").toString(), (numExpiredKilled == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$2(KafkaServer s) {
        Assert.assertTrue((String)"failed re-authentications not 0", (TestUtils$.MODULE$.totalMetricValue(s, "failed-reauthentication-total") == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, MetricName k) {
        String string = k.getName();
        String string2 = metricName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$setWildcardResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl()).$plus$plus($this.TopicBrokerReadAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardTopicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardGroupResource());
    }

    public static final /* synthetic */ void $anonfun$setPrefixedResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedTopicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedGroupResource());
    }

    public static final /* synthetic */ void $anonfun$setAclsAndProduce$1(EndToEndAuthorizationTest $this, TopicPartition tp$1, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new Resource((ResourceType)Topic$.MODULE$, tp$1.topic(), PatternType.LITERAL));
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithoutDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<Acl>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(EndToEndAuthorizationTest $this, TopicPartition tp$2, KafkaProducer producer$1, int i) {
        ProducerRecord record = new ProducerRecord(tp$2.topic(), Predef$.MODULE$.int2Integer(tp$2.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    public EndToEndAuthorizationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 3;
        this.numRecords = 1;
        this.groupPrefix = "gr";
        this.group = new StringBuilder(3).append(this.groupPrefix()).append("oup").toString();
        this.topicPrefix = "e2e";
        this.topic = new StringBuilder(5).append(this.topicPrefix()).append("topic").toString();
        this.wildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicResource = new Resource((ResourceType)Topic$.MODULE$, this.topic(), PatternType.LITERAL);
        this.groupResource = new Resource((ResourceType)Group$.MODULE$, this.group(), PatternType.LITERAL);
        this.clusterResource = Resource$.MODULE$.ClusterResource();
        this.prefixedTopicResource = new Resource((ResourceType)Topic$.MODULE$, this.topicPrefix(), PatternType.PREFIXED);
        this.prefixedGroupResource = new Resource((ResourceType)Group$.MODULE$, this.groupPrefix(), PatternType.PREFIXED);
        this.wildcardTopicResource = new Resource((ResourceType)Topic$.MODULE$, this.wildcard(), PatternType.LITERAL);
        this.wildcardGroupResource = new Resource((ResourceType)Group$.MODULE$, this.wildcard(), PatternType.LITERAL);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), SimpleAclAuthorizer.class.getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp(), "1500");
        this.consumerConfig().setProperty("group.id", "group");
    }
}

