/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collections;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.api.IntegrationTestHarness;
import kafka.coordinator.group.GroupOverview;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001\u0002\u0012$\u0001!BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\b\u007f\u0001\u0011\r\u0011\"\u00018\u0011\u0019\u0001\u0005\u0001)A\u0005q!9\u0011\t\u0001b\u0001\n\u00039\u0004B\u0002\"\u0001A\u0003%\u0001\bC\u0004D\u0001\t\u0007I\u0011\u0001#\t\r5\u0003\u0001\u0015!\u0003F\u0011\u001dq\u0005A1A\u0005\u0002\u0011Caa\u0014\u0001!\u0002\u0013)\u0005b\u0002)\u0001\u0005\u0004%\t\u0001\u0012\u0005\u0007#\u0002\u0001\u000b\u0011B#\t\u000fI\u0003!\u0019!C\u0001o!11\u000b\u0001Q\u0001\naBq\u0001\u0016\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004b\u0001\u0001\u0006IA\u0016\u0005\bE\u0002\u0011\r\u0011\"\u00018\u0011\u0019\u0019\u0007\u0001)A\u0005q!9A\r\u0001b\u0001\n\u0003)\u0006BB3\u0001A\u0003%a\u000bC\u0004g\u0001\u0001\u0007I\u0011A4\t\u000f9\u0004\u0001\u0019!C\u0001_\"1Q\u000f\u0001Q!\n!DQA\u001e\u0001\u0005B]DQa \u0001\u0005B]Da!!\u0003\u0001\t\u00039\bBBA\n\u0001\u0011\u0005q\u000f\u0003\u0004\u0002\u0018\u0001!\ta\u001e\u0005\u0007\u00037\u0001A\u0011A<\t\r\u0005}\u0001\u0001\"\u0001x\u0011\u0019\t\u0019\u0003\u0001C\u0001o\"9\u0011q\u0005\u0001\u0005\n\u0005%\"!\u0006'fO\u0006\u001c\u00170\u00113nS:\u001cE.[3oiR+7\u000f\u001e\u0006\u0003I\u0015\n1!\u00199j\u0015\u00051\u0013!B6bM.\f7\u0001A\n\u0004\u0001%j\u0003C\u0001\u0016,\u001b\u0005\u0019\u0013B\u0001\u0017$\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bC\u0001\u00182\u001b\u0005y#B\u0001\u0019&\u0003\u0015)H/\u001b7t\u0013\t\u0011tFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005)\u0004C\u0001\u0016\u0001\u00035\u0001(o\u001c3vG\u0016\u00148i\\;oiV\t\u0001\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$HA\u0002J]R\fa\u0002\u001d:pIV\u001cWM]\"pk:$\b%A\u0007d_:\u001cX/\\3s\u0007>,h\u000e^\u0001\u000fG>t7/^7fe\u000e{WO\u001c;!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0002\u0019\t\u0014xn[3s\u0007>,h\u000e\u001e\u0011\u0002\u000f\u001d\u0014x.\u001e9JIV\tQ\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006!A.\u00198h\u0015\u0005Q\u0015\u0001\u00026bm\u0006L!\u0001T$\u0003\rM#(/\u001b8h\u0003!9'o\\;q\u0013\u0012\u0004\u0013\u0001C2mS\u0016tG/\u00133\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013!\u0002;pa&\u001c\u0017A\u0002;pa&\u001c\u0007%\u0001\u0003qCJ$\u0018!\u00029beR\u0004\u0013A\u0001;q+\u00051\u0006CA,`\u001b\u0005A&BA-[\u0003\u0019\u0019w.\\7p]*\u0011ae\u0017\u0006\u00039v\u000ba!\u00199bG\",'\"\u00010\u0002\u0007=\u0014x-\u0003\u0002a1\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005)\u0001/\u0019:ue\u00051\u0001/\u0019:ue\u0001\n1\u0001\u001e93\u0003\u0011!\bO\r\u0011\u0002\r\rd\u0017.\u001a8u+\u0005A\u0007CA5m\u001b\u0005Q'BA6&\u0003\u0015\tG-\\5o\u0013\ti'NA\u0006BI6Lgn\u00117jK:$\u0018AC2mS\u0016tGo\u0018\u0013fcR\u0011\u0001o\u001d\t\u0003sEL!A\u001d\u001e\u0003\tUs\u0017\u000e\u001e\u0005\bi^\t\t\u00111\u0001i\u0003\rAH%M\u0001\bG2LWM\u001c;!\u0003\u0015\u0019X\r^+q)\u0005\u0001\bFA\rz!\tQX0D\u0001|\u0015\taX,A\u0003kk:LG/\u0003\u0002\u007fw\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u00045\u0005\r\u0001c\u0001>\u0002\u0006%\u0019\u0011qA>\u0003\u000b\u00053G/\u001a:\u0002KQ,7\u000f^(gMN,Go\u001d$peRKW.Z:XQ\u0016twJ\u001a4tKRtu\u000e\u001e$pk:$\u0007fA\u000e\u0002\u000eA\u0019!0a\u0004\n\u0007\u0005E1P\u0001\u0003UKN$\u0018A\u0004;fgRd\u0015n\u001d;He>,\bo\u001d\u0015\u00049\u00055\u0011\u0001\b;fgRd\u0015n\u001d;BY2\u0014%o\\6feZ+'o]5p]&sgm\u001c\u0015\u0004;\u00055\u0011a\u0007;fgR<U\r^\"p]N,X.\u001a:He>,\boU;n[\u0006\u0014\u0018\u0010K\u0002\u001f\u0003\u001b\t\u0011\u0004^3ti\u0012+7o\u0019:jE\u0016\u001cuN\\:v[\u0016\u0014xI]8va\"\u001aq$!\u0004\u0002YQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3D_:\u001cX/\\3s\u000fJ|W\u000f\u001d$pe:{g.\u0012=jgR,g\u000e^$s_V\u0004\bf\u0001\u0011\u0002\u000e\u0005i2/\u001e2tGJL'-Z!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000fF\u0003q\u0003W\t\t\u0005\u0003\u0004QC\u0001\u0007\u0011Q\u0006\t\u0005\u0003_\tiD\u0004\u0003\u00022\u0005e\u0002cAA\u001au5\u0011\u0011Q\u0007\u0006\u0004\u0003o9\u0013A\u0002\u001fs_>$h(C\u0002\u0002<i\na\u0001\u0015:fI\u00164\u0017b\u0001'\u0002@)\u0019\u00111\b\u001e\t\u000f\u0005\r\u0013\u00051\u0001\u0002F\u0005A1m\u001c8tk6,'\u000f\u0005\u0005\u0002H\u0005=\u00131KA*\u001b\t\tIE\u0003\u0003\u0002D\u0005-#bAA'5\u000691\r\\5f]R\u001c\u0018\u0002BA)\u0003\u0013\u0012QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b#B\u001d\u0002V\u0005e\u0013bAA,u\t)\u0011I\u001d:bsB\u0019\u0011(a\u0017\n\u0007\u0005u#H\u0001\u0003CsR,\u0007f\u0002\u0001\u0002b\u0005\u001d\u00141\u000e\t\u0004s\u0005\r\u0014bAA3u\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005%\u0014!\u0019+iK\u0002\u001a6-\u00197bA\u0005#W.\u001b8DY&,g\u000e\u001e\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI5oA\u0019\fgo\\;sA=4\u0007e\u001c:h]\u0005\u0004\u0018m\u00195f]-\fgm[1/G2LWM\u001c;t]\u0005$W.\u001b8/\u0003\u0012l\u0017N\\\"mS\u0016tG/\t\u0002\u0002n\u00051\u0001GL\u00192]A\u0002")
public class LegacyAdminClientTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String groupId;
    private final String clientId;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private AdminClient client = null;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String groupId() {
        return this.groupId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.client_$eq(AdminClient$.MODULE$.createSimplePlaintext(this.brokerList()));
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        this.client().close();
        super.tearDown();
    }

    @Test
    public void testOffsetsForTimesWhenOffsetNotFound() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)0L)}))).asJava()).get(this.tp()));
    }

    @Test
    public void testListGroups() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        List groups = this.client().listAllGroupsFlattened();
        Assert.assertFalse((boolean)groups.isEmpty());
        GroupOverview group = (GroupOverview)groups.head();
        Assert.assertEquals((Object)this.groupId(), (Object)group.groupId());
        Assert.assertEquals((Object)"consumer", (Object)group.protocolType());
    }

    @Test
    public void testListAllBrokerVersionInfo() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        scala.collection.immutable.Map brokerVersionInfos = this.client().listAllBrokerVersionInfo();
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers)).size(), (long)brokerVersionInfos.size());
        brokerVersionInfos.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LegacyAdminClientTest.$anonfun$testListAllBrokerVersionInfo$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LegacyAdminClientTest.$anonfun$testListAllBrokerVersionInfo$2(brokers, x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGetConsumerGroupSummary() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        AdminClient qual$1 = this.client();
        String x$1 = this.groupId();
        long x$2 = qual$1.describeConsumerGroup$default$2();
        AdminClient.ConsumerGroupSummary group = qual$1.describeConsumerGroup(x$1, x$2);
        Assert.assertEquals((Object)"range", (Object)group.assignmentStrategy());
        Assert.assertEquals((Object)"Stable", (Object)group.state());
        Assert.assertFalse((boolean)group.consumers().isEmpty());
        AdminClient.ConsumerSummary member = (AdminClient.ConsumerSummary)((IterableLike)group.consumers().get()).head();
        Assert.assertEquals((Object)this.clientId(), (Object)member.clientId());
        Assert.assertFalse((boolean)member.host().isEmpty());
        Assert.assertFalse((boolean)member.consumerId().isEmpty());
    }

    @Test
    public void testDescribeConsumerGroup() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        AdminClient qual$1 = this.client();
        String x$1 = this.groupId();
        long x$22 = qual$1.describeConsumerGroup$default$2();
        AdminClient.ConsumerGroupSummary consumerGroupSummary = qual$1.describeConsumerGroup(x$1, x$22);
        Assert.assertEquals((long)1L, (long)((SeqLike)consumerGroupSummary.consumers().get()).size());
        Assert.assertEquals((Object)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)this.tp2(), (List)Nil$.MODULE$)), (Object)((List)consumerGroupSummary.consumers().get()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.assignment(), List$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDescribeConsumerGroupForNonExistentGroup() {
        String nonExistentGroup = new StringBuilder(3).append("non").append(this.groupId()).toString();
        AdminClient qual$1 = this.client();
        String x$1 = nonExistentGroup;
        long x$2 = qual$1.describeConsumerGroup$default$2();
        Assert.assertTrue((String)"Expected empty ConsumerSummary list", (boolean)((SeqLike)qual$1.describeConsumerGroup(x$1, x$2).consumers().get()).isEmpty());
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            consumer.poll(0L);
            return !consumer.assignment().isEmpty();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected non-empty assignment", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$testListAllBrokerVersionInfo$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testListAllBrokerVersionInfo$2(String[] brokers$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Node node = (Node)tuple2._1();
        Try tryBrokerVersionInfo = (Try)tuple2._2();
        String hostStr = new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString();
        Assert.assertTrue((String)new StringBuilder(45).append("Unknown host:port pair ").append(hostStr).append(" in brokerVersionInfos").toString(), (boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])brokers$1)).contains((Object)hostStr));
        NodeApiVersions brokerVersionInfo = (NodeApiVersions)tryBrokerVersionInfo.get();
        Assert.assertEquals((long)2L, (long)brokerVersionInfo.latestUsableVersion(ApiKeys.API_VERSIONS));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LegacyAdminClientTest() {
        this.producerCount = 1;
        this.consumerCount = 2;
        this.brokerCount = 3;
        this.groupId = "my-test";
        this.clientId = "consumer-498";
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        this.producerConfig().setProperty("acks", "all");
        this.consumerConfig().setProperty("group.id", this.groupId());
        this.consumerConfig().setProperty("client.id", this.clientId());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
    }
}

