/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControllerChannelManagerTest$MockControllerBrokerRequestBatch$;
import kafka.controller.ControllerChannelManagerTest$SentRequest$;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerEvent;
import kafka.controller.LeaderAndIsrResponseReceived;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionStopReplicaResponseReceived;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r]e\u0001B'O\u0001MCQA\u0017\u0001\u0005\u0002mCqA\u0018\u0001C\u0002\u0013%q\f\u0003\u0004d\u0001\u0001\u0006I\u0001\u0019\u0005\bI\u0002\u0011\r\u0011\"\u0003`\u0011\u0019)\u0007\u0001)A\u0005A\"9a\r\u0001b\u0001\n\u00139\u0007B\u00028\u0001A\u0003%\u0001\u000eC\u0004p\u0001\t\u0007I\u0011\u00029\t\rQ\u0004\u0001\u0015!\u0003r\u000b\u0011)\b\u0001\u0001<\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!9\u0011q\b\u0001\u0005\u0002\u0005%\u0002bBA\"\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003\u000f\u0002A\u0011AA\u0015\u0011\u001d\tY\u0005\u0001C\u0005\u0003\u001bBq!!\u001b\u0001\t\u0003\tI\u0003C\u0004\u0002n\u0001!\t!!\u000b\t\u000f\u0005E\u0004\u0001\"\u0001\u0002*!9\u0011Q\u000f\u0001\u0005\u0002\u0005%\u0002bBA=\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t9\t\u0001C\u0001\u0003SAq!a#\u0001\t\u0003\tI\u0003C\u0004\u0002\u0010\u0002!\t!!\u000b\t\u000f\u0005M\u0005\u0001\"\u0001\u0002*!9\u0011q\u0013\u0001\u0005\u0002\u0005%\u0002bBAN\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003?\u0003A\u0011AA\u0015\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!,\u0001\t\u0013\ty\u000bC\u0004\u0003\f\u0002!IA!$\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"9!1\u0014\u0001\u0005\n\tueABAq\u0001\u0011\u000b\u0019\u000f\u0003\u0006\u0002r\n\u0012)\u001a!C\u0001\u0003gD!\"a>#\u0005#\u0005\u000b\u0011BA{\u0011)\tIP\tBK\u0002\u0013\u0005\u00111 \u0005\u000b\u0005\u0013\u0011#\u0011#Q\u0001\n\u0005u\bB\u0002.#\t\u0003\u0011Y\u0001C\u0005\u0003\u0012\t\n\t\u0011\"\u0001\u0003\u0014!I!\u0011\u0004\u0012\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005K\u0011\u0013\u0013!C\u0001\u0005OA\u0011B!\u0010#\u0003\u0003%\tEa\u0010\t\u0011\tE#%!A\u0005\u0002}C\u0011Ba\u0015#\u0003\u0003%\tA!\u0016\t\u0013\t\u0005$%!A\u0005B\t\r\u0004\"\u0003B9E\u0005\u0005I\u0011\u0001B:\u0011%\u0011iHIA\u0001\n\u0003\u0012y\bC\u0005\u0003\u0002\n\n\t\u0011\"\u0011\u0003\u0004\"I!Q\u0011\u0012\u0002\u0002\u0013\u0005#qQ\u0004\n\u0005\u001f\u0004\u0011\u0011!E\u0005\u0005#4\u0011\"!9\u0001\u0003\u0003EIAa5\t\ri#D\u0011\u0001Bq\u0011%\u0011\t\tNA\u0001\n\u000b\u0012\u0019\tC\u0005\u0003dR\n\t\u0011\"!\u0003f\"I!1\u001e\u001b\u0002\u0002\u0013\u0005%Q\u001e\u0004\u0007\u0005\u007f\u0004Aa!\u0001\t\u0015\r%\u0011H!A!\u0002\u0013\u0011y\n\u0003\u0005gs\t\u0005\t\u0015!\u0003i\u0011\u0019Q\u0016\b\"\u0001\u0004\f!I11C\u001dC\u0002\u0013\u00051Q\u0003\u0005\t\u0007SI\u0004\u0015!\u0003\u0004\u0018!I\u00111Y\u001dC\u0002\u0013\u000511\u0006\u0005\t\u0007kI\u0004\u0015!\u0003\u0004.!91qG\u001d\u0005B\re\u0002bBB s\u0011\u00053\u0011\t\u0005\b\u0007\u001bJD\u0011AB(\u0011%\u0019y&OI\u0001\n\u0003\u0019\t\u0007C\u0004\u0004fe\"\taa\u001a\t\u0013\rU\u0014(%A\u0005\u0002\r\u0005\u0004bBB<s\u0011\u00051\u0011\u0010\u0005\n\u0007\u000fK\u0014\u0013!C\u0001\u0007C:\u0011b!#\u0001\u0003\u0003EIaa#\u0007\u0013\t}\b!!A\t\n\r5\u0005B\u0002.K\t\u0003\u0019y\tC\u0005\u0004\u0012*\u000b\n\u0011\"\u0001\u0004\u0014\na2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:UKN$(BA(Q\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002#\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001U!\t)\u0006,D\u0001W\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0018\t\u0003;\u0002i\u0011AT\u0001\rG>tGO]8mY\u0016\u0014\u0018\nZ\u000b\u0002AB\u0011Q+Y\u0005\u0003EZ\u00131!\u00138u\u00035\u0019wN\u001c;s_2dWM]%eA\u0005y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007.\u0001\td_:$(o\u001c7mKJ,\u0005o\\2iA\u000511m\u001c8gS\u001e,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003WB\u000baa]3sm\u0016\u0014\u0018BA7k\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00051An\\4hKJ,\u0012!\u001d\t\u0003;JL!a\u001d(\u0003#M#\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0003\u001d\r{g\u000e\u001e:pYJ+\u0017/^3tiB\u001aq/!\u0006\u0011\u000ba\fY!!\u0005\u000f\u0007e\f9!D\u0001{\u0015\tYH0\u0001\u0005sKF,Xm\u001d;t\u0015\tih0\u0001\u0004d_6lwN\u001c\u0006\u0003#~TA!!\u0001\u0002\u0004\u00051\u0011\r]1dQ\u0016T!!!\u0002\u0002\u0007=\u0014x-C\u0002\u0002\ni\fa#\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c*fcV,7\u000f^\u0005\u0005\u0003\u001b\tyAA\u0004Ck&dG-\u001a:\u000b\u0007\u0005%!\u0010\u0005\u0003\u0002\u0014\u0005UA\u0002\u0001\u0003\f\u0003/Q\u0011\u0011!A\u0001\u0006\u0003\tIBA\u0002`IE\nB!a\u0007\u0002\"A\u0019Q+!\b\n\u0007\u0005}aKA\u0004O_RD\u0017N\\4\u0011\u0007e\f\u0019#C\u0002\u0002&i\u0014a#\u00112tiJ\f7\r^\"p]R\u0014x\u000e\u001c*fcV,7\u000f^\u0001\u001ci\u0016\u001cH\u000fT3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgR\u001cVM\u001c;\u0015\u0005\u0005-\u0002cA+\u0002.%\u0019\u0011q\u0006,\u0003\tUs\u0017\u000e\u001e\u0015\u0004\u0017\u0005M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\t\u0005e\u00121A\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003{\t9D\u0001\u0003UKN$\u0018\u0001\b;fgRdU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\u0013NtUm\u001e\u0015\u0004\u0019\u0005M\u0012A\u000e;fgRdU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u'\u0016tG\u000fV8MSZ,wJ]*ikR$\u0018N\\4E_^t'I]8lKJ\u001c\bfA\u0007\u00024\u0005QC/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O]%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>t\u0007f\u0001\b\u00024\u0005AD/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d*fcV,7\u000f\u001e$pY2|wo]%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>tGCBA\u0016\u0003\u001f\ny\u0006C\u0004\u0002R=\u0001\r!a\u0015\u00025%tG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017Q\u0003\r\t\u0007/[\u0005\u0005\u0003;\n9F\u0001\u0006Ba&4VM]:j_:Dq!!\u0019\u0010\u0001\u0004\t\u0019'A\u000efqB,7\r^3e\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d,feNLwN\u001c\t\u0004+\u0006\u0015\u0014bAA4-\n)1\u000b[8si\u0006iB/Z:u+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u'\u0016tG\u000fK\u0002\u0011\u0003g\tQ\b^3tiV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uC\u0012{Wm\u001d(pi&s7\r\\;eKB\u000b'\u000f^5uS>t7oV5uQ>,H\u000fT3bI\u0016\u0014\u0018I\u001c3JgJD3!EA\u001a\u00031\"Xm\u001d;Va\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;EkJLgn\u001a+pa&\u001cG)\u001a7fi&|g\u000eK\u0002\u0013\u0003g\t1\u0007^3tiV\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uC&s7\r\\;eKNd\u0015N^3PeNCW\u000f\u001e;j]\u001e$un\u001e8Ce>\\WM]:)\u0007M\t\u0019$\u0001\u0017uKN$X\u000b\u001d3bi\u0016lU\r^1eCR\f\u0017J\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]\"\u001aA#a\r\u0002gQ,7\u000f^+qI\u0006$X-T3uC\u0012\fG/\u0019$pY2|wo]%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>tGCBA\u0016\u0003\u0003\u000b\u0019\tC\u0004\u0002RU\u0001\r!a\u0015\t\u000f\u0005\u0015U\u00031\u0001\u0002d\u0005iR\r\u001f9fGR,G-\u00169eCR,W*\u001a;bI\u0006$\u0018MV3sg&|g.\u0001\u000euKN$8\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u'\u0016tG\u000fK\u0002\u0017\u0003g\t!\u0007^3tiN#x\u000e\u001d*fa2L7-\u0019*fcV,7\u000f^:XQ&dW\rV8qS\u000e\fV/Z;fI\u001a{'\u000fR3mKRLwN\u001c\u0015\u0004/\u0005M\u0012\u0001\r;fgR\u001cFo\u001c9SKBd\u0017nY1SKF,Xm\u001d;t/\"LG.\u001a+pa&\u001cG)\u001a7fi&|gn\u0015;beR,G\rK\u0002\u0019\u0003g\ta\u0006^3ti6K\u00070\u001a3EK2,G/Z!oI:{G\u000fR3mKR,7\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:ug\"\u001a\u0011$a\r\u0002;Q,7\u000f^*u_B\u0014V\r\u001d7jG\u0006<%o\\;qg\nK(I]8lKJD3AGA\u001a\u0003M\"Xm\u001d;Ti>\u0004(+\u001a9mS\u000e\f7+\u001a8u\u001f:d\u0017\u0010V8MSZ,\u0017I\u001c3TQV$H/\u001b8h\t><hN\u0011:pW\u0016\u00148\u000fK\u0002\u001c\u0003g\t\u0011\u0006^3tiN#x\u000e\u001d*fa2L7-Y%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dg+\u001a:tS>t\u0007f\u0001\u000f\u00024\u0005\u0001D/Z:u'R|\u0007OU3qY&\u001c\u0017MR8mY><8/\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:$b!a\u000b\u0002(\u0006%\u0006bBA);\u0001\u0007\u00111\u000b\u0005\b\u0003Wk\u0002\u0019AA2\u0003\u0005*\u0007\u0010]3di\u0016$7\u000b^8q%\u0016\u0004H.[2b%\u0016\fX/Z:u-\u0016\u00148/[8o\u0003\u0005\n\u0007\u000f\u001d7z'R|\u0007OU3qY&\u001c\u0017MU3ta>t7/Z\"bY2\u0014\u0017mY6t)\u0019\tY#!-\u0002B\"9\u00111\u0017\u0010A\u0002\u0005U\u0016!B3se>\u0014\b\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005mF0\u0001\u0005qe>$xnY8m\u0013\u0011\ty,!/\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\t\u0019M\ba\u0001\u0003\u000b\fAb]3oiJ+\u0017/^3tiN\u0004b!a2\u0002X\u0006ug\u0002BAe\u0003'tA!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0004\u0003\u001f\u0014\u0016A\u0002\u001fs_>$h(C\u0001X\u0013\r\t)NV\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI.a7\u0003\t1K7\u000f\u001e\u0006\u0004\u0003+4\u0006cAApE5\t\u0001AA\u0006TK:$(+Z9vKN$8C\u0002\u0012U\u0003K\fY\u000fE\u0002V\u0003OL1!!;W\u0005\u001d\u0001&o\u001c3vGR\u00042!VAw\u0013\r\tyO\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\be\u0016\fX/Z:u+\t\t)\u0010E\u0002\u0002`*\t\u0001B]3rk\u0016\u001cH\u000fI\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.,\"!!@\u0011\u000fU\u000byPa\u0001\u0002,%\u0019!\u0011\u0001,\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA=\u0003\u0006%\u0019!q\u0001>\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0017!\u0005:fgB|gn]3DC2d'-Y2lAQ1\u0011Q\u001cB\u0007\u0005\u001fAq!!=(\u0001\u0004\t)\u0010C\u0004\u0002z\u001e\u0002\r!!@\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003;\u0014)Ba\u0006\t\u0013\u0005E\b\u0006%AA\u0002\u0005U\b\"CA}QA\u0005\t\u0019AA\u007f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\b1\t\t}!1\u0005\t\u0006q\u0006-!\u0011\u0005\t\u0005\u0003'\u0011\u0019\u0003B\u0006\u0002\u0018%\n\t\u0011!A\u0003\u0002\u0005e\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005SQC!!@\u0003,-\u0012!Q\u0006\t\u0005\u0005_\u0011I$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003%)hn\u00195fG.,GMC\u0002\u00038Y\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YD!\r\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0003\u0002BAa\u0011\u0003N5\u0011!Q\t\u0006\u0005\u0005\u000f\u0012I%\u0001\u0003mC:<'B\u0001B&\u0003\u0011Q\u0017M^1\n\t\t=#Q\t\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u000bB/!\r)&\u0011L\u0005\u0004\u000572&aA!os\"A!qL\u0017\u0002\u0002\u0003\u0007\u0001-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005K\u0002bAa\u001a\u0003n\t]SB\u0001B5\u0015\r\u0011YGV\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B8\u0005S\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\u000fB>!\r)&qO\u0005\u0004\u0005s2&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005?z\u0013\u0011!a\u0001\u0005/\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002A\u0006AAo\\*ue&tw\r\u0006\u0002\u0003B\u00051Q-];bYN$BA!\u001e\u0003\n\"I!q\f\u001a\u0002\u0002\u0003\u0007!qK\u0001#CB\u0004H.\u001f'fC\u0012,'/\u00118e\u0013N\u0014(+Z:q_:\u001cXmQ1mY\n\f7m[:\u0015\r\u0005-\"q\u0012BI\u0011\u001d\t\u0019l\ba\u0001\u0003kCq!a1 \u0001\u0004\t)-\u0001\u0007de\u0016\fG/Z\"p]\u001aLw\rF\u0002i\u0005/CqA!'!\u0001\u0004\t\u0019&\u0001\nj]R,'O\u0011:pW\u0016\u0014h+\u001a:tS>t\u0017aC5oSR\u001cuN\u001c;fqR$\"Ba(\u0003&\n=&q\u0019Bf!\ri&\u0011U\u0005\u0004\u0005Gs%!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"9!qU\u0011A\u0002\t%\u0016a\u00022s_.,'o\u001d\t\u0006\u0003\u000f\u0014Y\u000bY\u0005\u0005\u0005[\u000bYNA\u0002TKFDqA!-\"\u0001\u0004\u0011\u0019,\u0001\u0004u_BL7m\u001d\t\u0007\u0005k\u0013iLa1\u000f\t\t]&\u0011\u0018\t\u0004\u0003\u00174\u0016b\u0001B^-\u00061\u0001K]3eK\u001aLAAa0\u0003B\n\u00191+\u001a;\u000b\u0007\tmf\u000b\u0005\u0003\u00036\n\u0015\u0017\u0002\u0002B(\u0005\u0003DaA!3\"\u0001\u0004\u0001\u0017!\u00048v[B\u000b'\u000f^5uS>t7\u000f\u0003\u0004\u0003N\u0006\u0002\r\u0001Y\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\u0018aC*f]R\u0014V-];fgR\u00042!a85'\u0015!$Q[Av!)\u00119N!8\u0002v\u0006u\u0018Q\\\u0007\u0003\u00053T1Aa7W\u0003\u001d\u0011XO\u001c;j[\u0016LAAa8\u0003Z\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\tE\u0017!B1qa2LHCBAo\u0005O\u0014I\u000fC\u0004\u0002r^\u0002\r!!>\t\u000f\u0005ex\u00071\u0001\u0002~\u00069QO\\1qa2LH\u0003\u0002Bx\u0005w\u0004R!\u0016By\u0005kL1Aa=W\u0005\u0019y\u0005\u000f^5p]B9QKa>\u0002v\u0006u\u0018b\u0001B}-\n1A+\u001e9mKJB\u0011B!@9\u0003\u0003\u0005\r!!8\u0002\u0007a$\u0003G\u0001\u0011N_\u000e\\7i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD7cA\u001d\u0004\u0004A\u0019Ql!\u0002\n\u0007\r\u001daJ\u0001\u0013BEN$(/Y2u\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i\u0003\u001d\u0019wN\u001c;fqR$ba!\u0004\u0004\u0010\rE\u0001cAAps!91\u0011\u0002\u001fA\u0002\t}\u0005b\u00024=!\u0003\u0005\r\u0001[\u0001\u000bg\u0016tG/\u0012<f]R\u001cXCAB\f!\u0019\u0019Iba\b\u0004$5\u001111\u0004\u0006\u0005\u0007;\u0011I'A\u0004nkR\f'\r\\3\n\t\r\u000521\u0004\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bcA/\u0004&%\u00191q\u0005(\u0003\u001f\r{g\u000e\u001e:pY2,'/\u0012<f]R\f1b]3oi\u00163XM\u001c;tAU\u00111Q\u0006\t\b\u00073\u0019y\u0003YB\u001a\u0013\u0011\u0019\tda\u0007\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0004\u001a\r}\u0011Q\\\u0001\u000eg\u0016tGOU3rk\u0016\u001cHo\u001d\u0011\u0002\u0013M,g\u000eZ#wK:$H\u0003BA\u0016\u0007wAqa!\u0010B\u0001\u0004\u0019\u0019#A\u0003fm\u0016tG/A\u0006tK:$'+Z9vKN$H\u0003CA\u0016\u0007\u0007\u001a9e!\u0013\t\r\r\u0015#\t1\u0001a\u0003!\u0011'o\\6fe&#\u0007bBAy\u0005\u0002\u0007\u0011Q\u001f\u0005\n\u0007\u0017\u0012\u0005\u0013!a\u0001\u0003{\f\u0001bY1mY\n\f7m[\u0001\u001dG>dG.Z2u'R|\u0007OU3qY&\u001c'+Z9vKN$8OR8s)\u0019\u0019\tf!\u0017\u0004\\A1\u0011qYAl\u0007'\u00022!_B+\u0013\r\u00199F\u001f\u0002\u0013'R|\u0007OU3qY&\u001c\u0017MU3rk\u0016\u001cH\u000f\u0003\u0004\u0004F\r\u0003\r\u0001\u0019\u0005\n\u0007;\u001a\u0005\u0013!a\u0001\u0003G\nqA^3sg&|g.\u0001\u0014d_2dWm\u0019;Ti>\u0004(+\u001a9mS\u000e\u0014V-];fgR\u001chi\u001c:%I\u00164\u0017-\u001e7uII*\"aa\u0019+\t\u0005\r$1F\u0001!G>dG.Z2u+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:ug\u001a{'\u000f\u0006\u0004\u0004j\rE41\u000f\t\u0007\u0003\u000f\f9na\u001b\u0011\u0007e\u001ci'C\u0002\u0004pi\u0014Q#\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0003\u0004\u0004F\u0015\u0003\r\u0001\u0019\u0005\n\u0007;*\u0005\u0013!a\u0001\u0003G\n!fY8mY\u0016\u001cG/\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cHo\u001d$pe\u0012\"WMZ1vYR$#'\u0001\u0010d_2dWm\u0019;MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cHo\u001d$peR111PBB\u0007\u000b\u0003b!a2\u0002X\u000eu\u0004cA=\u0004\u0000%\u00191\u0011\u0011>\u0003'1+\u0017\rZ3s\u0003:$\u0017j\u001d:SKF,Xm\u001d;\t\r\r\u0015s\t1\u0001a\u0011%\u0019if\u0012I\u0001\u0002\u0004\t\u0019'\u0001\u0015d_2dWm\u0019;MK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cHo\u001d$pe\u0012\"WMZ1vYR$#'\u0001\u0011N_\u000e\\7i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007cAAp\u0015N\u0011!\n\u0016\u000b\u0003\u0007\u0017\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCABKU\rA'1\u0006")
public class ControllerChannelManagerTest {
    private volatile ControllerChannelManagerTest$SentRequest$ SentRequest$module;
    private volatile ControllerChannelManagerTest$MockControllerBrokerRequestBatch$ MockControllerBrokerRequestBatch$module;
    private final int controllerId;
    private final int controllerEpoch;
    private final KafkaConfig kafka$controller$ControllerChannelManagerTest$$config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.controllerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final StateChangeLogger kafka$controller$ControllerChannelManagerTest$$logger = new StateChangeLogger(this.controllerId(), true, (Option)None$.MODULE$);

    private ControllerChannelManagerTest$SentRequest$ SentRequest() {
        if (this.SentRequest$module == null) {
            this.SentRequest$lzycompute$1();
        }
        return this.SentRequest$module;
    }

    private ControllerChannelManagerTest$MockControllerBrokerRequestBatch$ MockControllerBrokerRequestBatch() {
        if (this.MockControllerBrokerRequestBatch$module == null) {
            this.MockControllerBrokerRequestBatch$lzycompute$1();
        }
        return this.MockControllerBrokerRequestBatch$module;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    public KafkaConfig kafka$controller$ControllerChannelManagerTest$$config() {
        return this.kafka$controller$ControllerChannelManagerTest$$config;
    }

    public StateChangeLogger kafka$controller$ControllerChannelManagerTest$$logger() {
        return this.kafka$controller$ControllerChannelManagerTest$$logger;
    }

    @Test
    public void testLeaderAndIsrRequestSent() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))))}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerChannelManagerTest.$anonfun$testLeaderAndIsrRequestSent$1(this, context, batch, x0$1);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2, batch.collectLeaderAndIsrRequestsFor$default$2());
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2, batch.collectUpdateMetadataRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
        Assert.assertEquals((long)this.controllerId(), (long)leaderAndIsrRequest.controllerId());
        Assert.assertEquals((long)this.controllerEpoch(), (long)leaderAndIsrRequest.controllerEpoch());
        Assert.assertEquals((Object)partitions.keySet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(leaderAndIsrRequest.partitionStates().keySet()).asScala());
        Assert.assertEquals((Object)partitions.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.leader())), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(leaderAndIsrRequest.partitionStates()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.basePartitionState.leader)));
        Assert.assertEquals((Object)partitions.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.isr()), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(leaderAndIsrRequest.partitionStates()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$4.basePartitionState.isr).asScala()));
        this.applyLeaderAndIsrResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)1L, (long)batch.sentEvents().size());
        ControllerEvent controllerEvent = (ControllerEvent)batch.sentEvents().head();
        if (!(controllerEvent instanceof LeaderAndIsrResponseReceived)) {
            throw new MatchError((Object)controllerEvent);
        }
        LeaderAndIsrResponseReceived leaderAndIsrResponseReceived = (LeaderAndIsrResponseReceived)controllerEvent;
        AbstractResponse response = leaderAndIsrResponseReceived.LeaderAndIsrResponseObj();
        int brokerId = leaderAndIsrResponseReceived.brokerId();
        Tuple2 tuple2 = new Tuple2((Object)response, (Object)BoxesRunTime.boxToInteger((int)brokerId));
        Tuple2 tuple22 = tuple2;
        AbstractResponse response2 = (AbstractResponse)tuple22._1();
        int brokerId2 = tuple22._2$mcI$sp();
        Assert.assertEquals((long)2L, (long)brokerId2);
        Assert.assertEquals((Object)partitions.keySet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(((LeaderAndIsrResponse)response2).responses().keySet()).asScala());
    }

    @Test
    public void testLeaderAndIsrRequestIsNew() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), true);
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2, batch.collectLeaderAndIsrRequestsFor$default$2());
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2, batch.collectUpdateMetadataRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(leaderAndIsrRequest.partitionStates().keySet()).asScala());
        Assert.assertTrue((boolean)((LeaderAndIsrRequest.PartitionState)leaderAndIsrRequest.partitionStates().get((Object)partition)).isNew);
    }

    @Test
    public void testLeaderAndIsrRequestSentToLiveOrShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), partition, leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)2L, (long)batch.sentRequests().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)batch.sentRequests().keySet());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(brokerId, batch.collectLeaderAndIsrRequestsFor$default$2());
            List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(brokerId, batch.collectUpdateMetadataRequestsFor$default$2());
            Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
            Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)leaderAndIsrRequests.head();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(leaderAndIsrRequest.partitionStates().keySet()).asScala());
        });
    }

    @Test
    public void testLeaderAndIsrInterBrokerProtocolVersion() {
        this.testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.LEADER_AND_ISR.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testLeaderAndIsrInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    private void testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedLeaderAndIsrVersion) {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
        TopicPartition partition = new TopicPartition("foo", 0);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        context.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch.newBatch();
        batch.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<LeaderAndIsrRequest> leaderAndIsrRequests = batch.collectLeaderAndIsrRequestsFor(2, expectedLeaderAndIsrVersion);
        Assert.assertEquals((long)1L, (long)leaderAndIsrRequests.size());
        Assert.assertEquals((long)expectedLeaderAndIsrVersion, (long)((AbstractRequest)leaderAndIsrRequests.head()).version());
    }

    @Test
    public void testUpdateMetadataRequestSent() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))))}));
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
            Option option = context.partitionLeadershipInfo().put((Object)partition, (Object)new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch()));
            return option;
        });
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions.keySet());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2, batch.collectUpdateMetadataRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.partitionStates().size());
        Assert.assertEquals((Object)partitions.mapValues((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.leader())), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.basePartitionState.leader)));
        Assert.assertEquals((Object)partitions.mapValues((Function1 & Serializable & scala.Serializable)x$8 -> x$8.isr()), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.basePartitionState.isr).asScala()));
        Assert.assertEquals((long)this.controllerId(), (long)updateMetadataRequest.controllerId());
        Assert.assertEquals((long)this.controllerEpoch(), (long)updateMetadataRequest.controllerEpoch());
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id), Set$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testUpdateMetadataDoesNotIncludePartitionsWithoutLeaderAndIsr() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2, batch.collectUpdateMetadataRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Assert.assertEquals((long)0L, (long)updateMetadataRequest.partitionStates().size());
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id), Set$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testUpdateMetadataRequestDuringTopicDeletion() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Map partitions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 1)), (Object)LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))))}));
        partitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition partition = (TopicPartition)tuple2._1();
            LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
            Option option = context.partitionLeadershipInfo().put((Object)partition, (Object)new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch()));
            return option;
        });
        context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)partitions.keySet());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(2, batch.collectUpdateMetadataRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.partitionStates().size());
        Assert.assertTrue((boolean)((IterableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$2(x$12))).values().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.basePartitionState.leader), Iterable$.MODULE$.canBuildFrom())).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)leaderId -> leaderId == LeaderAndIsr$.MODULE$.LeaderDuringDelete()));
        Assert.assertEquals((Object)partitions.filterKeys((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$5(x$14))).mapValues((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.leader())), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataRequestDuringTopicDeletion$7(x$16))).mapValues((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.basePartitionState.leader)));
        Assert.assertEquals((Object)partitions.mapValues((Function1 & Serializable & scala.Serializable)x$18 -> x$18.isr()), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(updateMetadataRequest.partitionStates()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)x$19 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$19.basePartitionState.isr).asScala()));
        Assert.assertEquals((long)3L, (long)updateMetadataRequest.liveBrokers().size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.id), Set$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testUpdateMetadataIncludesLiveOrShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Set)Predef$.MODULE$.Set().empty());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)batch.sentRequests().keySet());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<UpdateMetadataRequest> updateMetadataRequests = batch.collectUpdateMetadataRequestsFor(brokerId, batch.collectUpdateMetadataRequestsFor$default$2());
            Assert.assertEquals((long)1L, (long)updateMetadataRequests.size());
            UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)updateMetadataRequests.head();
            Assert.assertEquals((long)0L, (long)updateMetadataRequest.partitionStates().size());
            Assert.assertEquals((long)2L, (long)updateMetadataRequest.liveBrokers().size());
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(updateMetadataRequest.liveBrokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.id), Set$.MODULE$.canBuildFrom())).toSet());
        });
    }

    @Test
    public void testUpdateMetadataInterBrokerProtocolVersion() {
        this.testUpdateMetadataFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.UPDATE_METADATA.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testUpdateMetadataInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    private void testUpdateMetadataFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedUpdateMetadataVersion) {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
        batch.newBatch();
        batch.addUpdateMetadataRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Set)Predef$.MODULE$.Set().empty());
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        List<UpdateMetadataRequest> requests = batch.collectUpdateMetadataRequestsFor(2, expectedUpdateMetadataVersion);
        Assert.assertTrue((boolean)requests.forall((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testUpdateMetadataFollowsInterBrokerProtocolVersion$1(expectedUpdateMetadataVersion, x$22))));
    }

    @Test
    public void testStopReplicaRequestSent() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicRequestsFor(2, batch.collectStopReplicRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
        Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
    }

    @Test
    public void testStopReplicaRequestsWhileTopicQueuedForDeletion() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicRequestsFor(2, batch.collectStopReplicRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)sentStopReplicaRequests.flatMap((Function1 & Serializable & scala.Serializable)x$23 -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$23.partitions()).asScala(), List$.MODULE$.canBuildFrom())).toSet());
        Assert.assertTrue((boolean)sentStopReplicaRequests.forall((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.deletePartitions())));
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
    }

    @Test
    public void testStopReplicaRequestsWhileTopicDeletionStarted() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        context.queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        context.beginTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicRequestsFor(2, batch.collectStopReplicRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)sentStopReplicaRequests.flatMap((Function1 & Serializable & scala.Serializable)x$25 -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$25.partitions()).asScala(), List$.MODULE$.canBuildFrom())).toSet());
        Assert.assertTrue((boolean)sentStopReplicaRequests.forall((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)x$26.deletePartitions())));
        this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
        Assert.assertEquals((long)1L, (long)batch.sentEvents().size());
        scala.collection.immutable.Set includedPartitions = ((TraversableForwarder)batch.sentEvents().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerEvent controllerEvent = x0$1;
            if (!(controllerEvent instanceof TopicDeletionStopReplicaResponseReceived)) {
                throw Assertions$.MODULE$.fail(new StringBuilder(23).append("Unexpected sent event: ").append(controllerEvent).toString(), new Position("ControllerChannelManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
            }
            TopicDeletionStopReplicaResponseReceived topicDeletionStopReplicaResponseReceived = (TopicDeletionStopReplicaResponseReceived)controllerEvent;
            Set set = topicDeletionStopReplicaResponseReceived.partitionErrors().keySet();
            return set;
        }, ListBuffer$.MODULE$.canBuildFrom())).toSet();
        Assert.assertEquals((Object)partitions.filter((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testStopReplicaRequestsWhileTopicDeletionStarted$5(x$27))), (Object)includedPartitions);
    }

    @Test
    public void testMixedDeleteAndNotDeleteStopReplicaRequests() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set deletePartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1)}));
        scala.collection.immutable.Set nonDeletePartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("bar", 0), new TopicPartition("bar", 1)}));
        batch.newBatch();
        deletePartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, true);
            return BoxedUnit.UNIT;
        });
        nonDeletePartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)2L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicRequestsFor(2, batch.collectStopReplicRequestsFor$default$2());
        Assert.assertEquals((long)2L, (long)sentStopReplicaRequests.size());
        Tuple2 tuple2 = sentStopReplicaRequests.partition((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)x$28.deletePartitions()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List deleteRequests = (List)tuple2._1();
        List nonDeleteRequests = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)deleteRequests, (Object)nonDeleteRequests);
        Tuple2 tuple23 = tuple22;
        List deleteRequests2 = (List)tuple23._1();
        List nonDeleteRequests2 = (List)tuple23._2();
        Assert.assertEquals((long)1L, (long)deleteRequests2.size());
        Assert.assertEquals((Object)deletePartitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((StopReplicaRequest)deleteRequests2.head()).partitions()).asScala()).toSet());
        Assert.assertEquals((long)1L, (long)nonDeleteRequests2.size());
        Assert.assertEquals((Object)nonDeletePartitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((StopReplicaRequest)nonDeleteRequests2.head()).partitions()).asScala()).toSet());
    }

    @Test
    public void testStopReplicaGroupsByBroker() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)2L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)3)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicRequestsFor(brokerId, batch.collectStopReplicRequestsFor$default$2());
            Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
            StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
            Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
            Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
            this.applyStopReplicaResponseCallbacks(Errors.NONE, (List<SentRequest>)((ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2))).toList());
            Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        });
    }

    @Test
    public void testStopReplicaSentOnlyToLiveAndShuttingDownBrokers() {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), 2, 3);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, this.MockControllerBrokerRequestBatch().$lessinit$greater$default$2());
        context.shuttingDownBrokerIds().add((Object)BoxesRunTime.boxToInteger((int)2));
        context.removeLiveBrokers((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("foo", 1), new TopicPartition("bar", 1)}));
        batch.newBatch();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), partition, false);
            return BoxedUnit.UNIT;
        });
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        ListBuffer sentRequests = (ListBuffer)batch.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)2));
        Assert.assertEquals((long)1L, (long)sentRequests.size());
        List<StopReplicaRequest> sentStopReplicaRequests = batch.collectStopReplicRequestsFor(2, batch.collectStopReplicRequestsFor$default$2());
        Assert.assertEquals((long)1L, (long)sentStopReplicaRequests.size());
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentStopReplicaRequests.head();
        Assert.assertFalse((boolean)stopReplicaRequest.deletePartitions());
        Assert.assertEquals((Object)partitions, (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).toSet());
    }

    @Test
    public void testStopReplicaInterBrokerProtocolVersion() {
        this.testStopReplicaFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), ApiKeys.STOP_REPLICA.latestVersion());
        ApiVersion$.MODULE$.allVersions().foreach((Function1 & Serializable & scala.Serializable)apiVersion -> {
            ControllerChannelManagerTest.$anonfun$testStopReplicaInterBrokerProtocolVersion$1(this, apiVersion);
            return BoxedUnit.UNIT;
        });
    }

    private void testStopReplicaFollowsInterBrokerProtocolVersion(ApiVersion interBrokerProtocolVersion, short expectedStopReplicaRequestVersion) {
        ControllerContext context = this.initContext((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), 2, 3);
        KafkaConfig config = this.createConfig(interBrokerProtocolVersion);
        MockControllerBrokerRequestBatch batch = new MockControllerBrokerRequestBatch(context, config);
        TopicPartition partition = new TopicPartition("foo", 0);
        batch.newBatch();
        batch.addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, false);
        batch.sendRequestsToBrokers(this.controllerEpoch());
        Assert.assertEquals((long)0L, (long)batch.sentEvents().size());
        Assert.assertEquals((long)1L, (long)batch.sentRequests().size());
        Assert.assertTrue((boolean)batch.sentRequests().contains((Object)BoxesRunTime.boxToInteger((int)2)));
        List<StopReplicaRequest> requests = batch.collectStopReplicRequestsFor(2, expectedStopReplicaRequestVersion);
        Assert.assertTrue((boolean)requests.forall((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$testStopReplicaFollowsInterBrokerProtocolVersion$1(expectedStopReplicaRequestVersion, x$30))));
    }

    private void applyStopReplicaResponseCallbacks(Errors error, List<SentRequest> sentRequests) {
        ((List)sentRequests.filter((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyStopReplicaResponseCallbacks$1(x$31)))).foreach((Function1 & Serializable & scala.Serializable)sentRequest -> {
            ControllerChannelManagerTest.$anonfun$applyStopReplicaResponseCallbacks$2(error, sentRequest);
            return BoxedUnit.UNIT;
        });
    }

    private void applyLeaderAndIsrResponseCallbacks(Errors error, List<SentRequest> sentRequests) {
        ((List)((TraversableLike)sentRequests.filter((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$1(x$33)))).filter((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$2(x$34)))).foreach((Function1 & Serializable & scala.Serializable)sentRequest -> {
            ControllerChannelManagerTest.$anonfun$applyLeaderAndIsrResponseCallbacks$3(error, sentRequest);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaConfig createConfig(ApiVersion interBrokerVersion) {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.BrokerIdProp(), ((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).toString());
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), "zkConnect");
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ApiVersion$.MODULE$.latestVersion().version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private ControllerContext initContext(Seq<Object> brokers, scala.collection.immutable.Set<String> topics, int numPartitions, int replicationFactor) {
        ControllerContext context = new ControllerContext();
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)brokers.map((Function1 & Serializable & scala.Serializable)brokerId -> ControllerChannelManagerTest.$anonfun$initContext$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        context.setLiveBrokerAndEpochs(brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ControllerChannelManagerTest.$anonfun$initContext$2(numPartitions, replicationFactor, brokers, leaderIndex, context, topic);
            return BoxedUnit.UNIT;
        });
        return context;
    }

    private final void SentRequest$lzycompute$1() {
        ControllerChannelManagerTest controllerChannelManagerTest = this;
        synchronized (controllerChannelManagerTest) {
            if (this.SentRequest$module == null) {
                this.SentRequest$module = new ControllerChannelManagerTest$SentRequest$(this);
            }
        }
    }

    private final void MockControllerBrokerRequestBatch$lzycompute$1() {
        ControllerChannelManagerTest controllerChannelManagerTest = this;
        synchronized (controllerChannelManagerTest) {
            if (this.MockControllerBrokerRequestBatch$module == null) {
                this.MockControllerBrokerRequestBatch$module = new ControllerChannelManagerTest$MockControllerBrokerRequestBatch$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testLeaderAndIsrRequestSent$1(ControllerChannelManagerTest $this, ControllerContext context$1, MockControllerBrokerRequestBatch batch$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition partition = (TopicPartition)tuple2._1();
        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerEpoch());
        context$1.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
        batch$1.addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), partition, leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$testLeaderAndIsrInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        short leaderAndIsrRequestVersion = $this.kafka$controller$ControllerChannelManagerTest$$config().interBrokerProtocolVersion().$greater$eq((Object)KAFKA_2_2_IV0$.MODULE$) ? (short)2 : ($this.kafka$controller$ControllerChannelManagerTest$$config().interBrokerProtocolVersion().$greater$eq((Object)KAFKA_1_0_IV0$.MODULE$) ? (short)1 : 0);
        $this.testLeaderAndIsrRequestFollowsInterBrokerProtocolVersion(apiVersion, leaderAndIsrRequestVersion);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$2(TopicPartition x$12) {
        String string = x$12.topic();
        String string2 = "foo";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$5(TopicPartition x$14) {
        String string = x$14.topic();
        String string2 = "bar";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataRequestDuringTopicDeletion$7(TopicPartition x$16) {
        String string = x$16.topic();
        String string2 = "bar";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testUpdateMetadataInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        int updateMetadataRequestVersion = $this.kafka$controller$ControllerChannelManagerTest$$config().interBrokerProtocolVersion().$greater$eq((Object)KAFKA_2_2_IV0$.MODULE$) ? 5 : ($this.kafka$controller$ControllerChannelManagerTest$$config().interBrokerProtocolVersion().$greater$eq((Object)KAFKA_1_0_IV0$.MODULE$) ? 4 : ($this.kafka$controller$ControllerChannelManagerTest$$config().interBrokerProtocolVersion().$greater$eq((Object)KAFKA_0_10_2_IV0$.MODULE$) ? 3 : ($this.kafka$controller$ControllerChannelManagerTest$$config().interBrokerProtocolVersion().$greater$eq((Object)KAFKA_0_10_0_IV1$.MODULE$) ? 2 : ($this.kafka$controller$ControllerChannelManagerTest$$config().interBrokerProtocolVersion().$greater$eq((Object)KAFKA_0_9_0$.MODULE$) ? 1 : 0))));
        $this.testUpdateMetadataFollowsInterBrokerProtocolVersion(apiVersion, (short)updateMetadataRequestVersion);
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataFollowsInterBrokerProtocolVersion$1(short expectedUpdateMetadataVersion$1, UpdateMetadataRequest x$22) {
        return x$22.version() == expectedUpdateMetadataVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$testStopReplicaRequestsWhileTopicDeletionStarted$5(TopicPartition x$27) {
        String string = x$27.topic();
        String string2 = "foo";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$testStopReplicaInterBrokerProtocolVersion$1(ControllerChannelManagerTest $this, ApiVersion apiVersion) {
        if (apiVersion.$less((Object)KAFKA_2_2_IV0$.MODULE$)) {
            $this.testStopReplicaFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), (short)0);
        } else {
            $this.testStopReplicaFollowsInterBrokerProtocolVersion(ApiVersion$.MODULE$.latestVersion(), (short)1);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testStopReplicaFollowsInterBrokerProtocolVersion$1(short expectedStopReplicaRequestVersion$1, StopReplicaRequest x$30) {
        return x$30.version() == expectedStopReplicaRequestVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$applyStopReplicaResponseCallbacks$1(SentRequest x$31) {
        return x$31.responseCallback() != null;
    }

    public static final /* synthetic */ void $anonfun$applyStopReplicaResponseCallbacks$2(Errors error$1, SentRequest sentRequest) {
        StopReplicaRequest stopReplicaRequest = (StopReplicaRequest)sentRequest.request().build();
        java.util.Map partitionErrorMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(stopReplicaRequest.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)x$32 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$32), (Object)error$1), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        StopReplicaResponse stopReplicaResponse = new StopReplicaResponse(error$1, partitionErrorMap);
        sentRequest.responseCallback().apply((Object)stopReplicaResponse);
    }

    public static final /* synthetic */ boolean $anonfun$applyLeaderAndIsrResponseCallbacks$1(SentRequest x$33) {
        ApiKeys apiKeys = x$33.request().apiKey();
        ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
        return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$applyLeaderAndIsrResponseCallbacks$2(SentRequest x$34) {
        return x$34.responseCallback() != null;
    }

    public static final /* synthetic */ void $anonfun$applyLeaderAndIsrResponseCallbacks$3(Errors error$2, SentRequest sentRequest) {
        LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)sentRequest.request().build();
        java.util.Map partitionErrorMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(leaderAndIsrRequest.partitionStates()).asScala()).keySet().map((Function1 & Serializable & scala.Serializable)x$35 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$35), (Object)error$2), scala.collection.Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        LeaderAndIsrResponse leaderAndIsrResponse = new LeaderAndIsrResponse(error$2, partitionErrorMap);
        sentRequest.responseCallback().apply((Object)leaderAndIsrResponse);
    }

    public static final /* synthetic */ Tuple2 $anonfun$initContext$1(int brokerId) {
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(brokerId, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    public static final /* synthetic */ void $anonfun$initContext$2(int numPartitions$1, int replicationFactor$1, Seq brokers$1, IntRef leaderIndex$1, ControllerContext context$4, String topic) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
            TopicPartition partition = new TopicPartition(topic, partitionId);
            IndexedSeq replicas = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), replicationFactor$1).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> {
                void var3_3;
                int replica = BoxesRunTime.unboxToInt((Object)brokers$1.apply((i + leaderIndex$1.elem) % brokers$1.size()));
                return (int)var3_3;
            }, IndexedSeq$.MODULE$.canBuildFrom());
            context$4.updatePartitionReplicaAssignment(partition, (Seq)replicas);
            ++leaderIndex$1.elem;
        });
    }

    public ControllerChannelManagerTest() {
        this.controllerId = 1;
        this.controllerEpoch = 1;
    }

    public class MockControllerBrokerRequestBatch
    extends AbstractControllerBrokerRequestBatch {
        private final ListBuffer<ControllerEvent> sentEvents;
        private final scala.collection.mutable.Map<Object, ListBuffer<SentRequest>> sentRequests;

        public ListBuffer<ControllerEvent> sentEvents() {
            return this.sentEvents;
        }

        public scala.collection.mutable.Map<Object, ListBuffer<SentRequest>> sentRequests() {
            return this.sentRequests;
        }

        public void sendEvent(ControllerEvent event) {
            this.sentEvents().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ControllerEvent[]{event}));
        }

        public void sendRequest(int brokerId, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> callback) {
            this.sentRequests().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.empty());
            ((BufferLike)this.sentRequests().apply((Object)BoxesRunTime.boxToInteger((int)brokerId))).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SentRequest[]{new SentRequest(this.kafka$controller$ControllerChannelManagerTest$MockControllerBrokerRequestBatch$$$outer(), request, callback)}));
        }

        public List<StopReplicaRequest> collectStopReplicRequestsFor(int brokerId, short version) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                Some some = (Some)option;
                ListBuffer requests = (ListBuffer)some.value();
                list = ((ListBuffer)((TraversableLike)requests.filter((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectStopReplicRequestsFor$1(x$36)))).map((Function1 & Serializable & scala.Serializable)x$37 -> (StopReplicaRequest)x$37.request().build(version), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        public short collectStopReplicRequestsFor$default$2() {
            return ApiKeys.STOP_REPLICA.latestVersion();
        }

        public List<UpdateMetadataRequest> collectUpdateMetadataRequestsFor(int brokerId, short version) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                Some some = (Some)option;
                ListBuffer requests = (ListBuffer)some.value();
                list = ((ListBuffer)((TraversableLike)requests.filter((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectUpdateMetadataRequestsFor$1(x$38)))).map((Function1 & Serializable & scala.Serializable)x$39 -> (UpdateMetadataRequest)x$39.request().build(version), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        public short collectUpdateMetadataRequestsFor$default$2() {
            return ApiKeys.UPDATE_METADATA.latestVersion();
        }

        public List<LeaderAndIsrRequest> collectLeaderAndIsrRequestsFor(int brokerId, short version) {
            List list;
            Option option = this.sentRequests().get((Object)BoxesRunTime.boxToInteger((int)brokerId));
            if (option instanceof Some) {
                Some some = (Some)option;
                ListBuffer requests = (ListBuffer)some.value();
                list = ((ListBuffer)((TraversableLike)requests.filter((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)MockControllerBrokerRequestBatch.$anonfun$collectLeaderAndIsrRequestsFor$1(x$40)))).map((Function1 & Serializable & scala.Serializable)x$41 -> (LeaderAndIsrRequest)x$41.request().build(version), ListBuffer$.MODULE$.canBuildFrom())).toList();
            } else if (None$.MODULE$.equals(option)) {
                list = List$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return list;
        }

        public short collectLeaderAndIsrRequestsFor$default$2() {
            return ApiKeys.LEADER_AND_ISR.latestVersion();
        }

        public /* synthetic */ ControllerChannelManagerTest kafka$controller$ControllerChannelManagerTest$MockControllerBrokerRequestBatch$$$outer() {
            return ControllerChannelManagerTest.this;
        }

        public static final /* synthetic */ boolean $anonfun$collectStopReplicRequestsFor$1(SentRequest x$36) {
            ApiKeys apiKeys = x$36.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.STOP_REPLICA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public static final /* synthetic */ boolean $anonfun$collectUpdateMetadataRequestsFor$1(SentRequest x$38) {
            ApiKeys apiKeys = x$38.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.UPDATE_METADATA;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public static final /* synthetic */ boolean $anonfun$collectLeaderAndIsrRequestsFor$1(SentRequest x$40) {
            ApiKeys apiKeys = x$40.request().apiKey();
            ApiKeys apiKeys2 = ApiKeys.LEADER_AND_ISR;
            return !(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null);
        }

        public MockControllerBrokerRequestBatch(ControllerContext context, KafkaConfig config) {
            if (ControllerChannelManagerTest.this == null) {
                throw null;
            }
            super(config, context, ControllerChannelManagerTest.this.kafka$controller$ControllerChannelManagerTest$$logger());
            this.sentEvents = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.sentRequests = Map$.MODULE$.empty();
        }
    }

    public class SentRequest
    implements Product,
    scala.Serializable {
        private final AbstractControlRequest.Builder<? extends AbstractControlRequest> request;
        private final Function1<AbstractResponse, BoxedUnit> responseCallback;
        public final /* synthetic */ ControllerChannelManagerTest $outer;

        public AbstractControlRequest.Builder<? extends AbstractControlRequest> request() {
            return this.request;
        }

        public Function1<AbstractResponse, BoxedUnit> responseCallback() {
            return this.responseCallback;
        }

        public SentRequest copy(AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> responseCallback) {
            return new SentRequest(this.kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer(), request, responseCallback);
        }

        public AbstractControlRequest.Builder<? extends AbstractControlRequest> copy$default$1() {
            return this.request();
        }

        public Function1<AbstractResponse, BoxedUnit> copy$default$2() {
            return this.responseCallback();
        }

        public String productPrefix() {
            return "SentRequest";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            AbstractControlRequest.Builder<? extends AbstractControlRequest> builder;
            int n = x$1;
            switch (n) {
                case 0: {
                    builder = this.request();
                    break;
                }
                case 1: {
                    builder = this.responseCallback();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return builder;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SentRequest;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SentRequest)) return false;
            if (((SentRequest)object).kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer() != this.kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            SentRequest sentRequest = (SentRequest)x$1;
            AbstractControlRequest.Builder<? extends AbstractControlRequest> builder = this.request();
            AbstractControlRequest.Builder<? extends AbstractControlRequest> builder2 = sentRequest.request();
            if (builder == null) {
                if (builder2 != null) {
                    return false;
                }
            } else if (!builder.equals(builder2)) return false;
            Function1<AbstractResponse, BoxedUnit> function1 = this.responseCallback();
            Function1<AbstractResponse, BoxedUnit> function12 = sentRequest.responseCallback();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!sentRequest.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ControllerChannelManagerTest kafka$controller$ControllerChannelManagerTest$SentRequest$$$outer() {
            return this.$outer;
        }

        public SentRequest(ControllerChannelManagerTest $outer, AbstractControlRequest.Builder<? extends AbstractControlRequest> request, Function1<AbstractResponse, BoxedUnit> responseCallback) {
            this.request = request;
            this.responseCallback = responseCallback;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

