/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaTimer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-3Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;\u0019!!\u0006\u0001\u0003,\u0011\u0015A2\u0001\"\u00018\u0011\u001dQ4\u00011A\u0005\nmBqaP\u0002A\u0002\u0013%\u0001\t\u0003\u0004D\u0007\u0001\u0006K\u0001\u0010\u0005\u0006\t\u000e!\t%\u0012\u0005\u0006\r\u000e!\t%\u0012\u0005\u0006\u000f\u000e!\t\u0001\u0013\u0002\u000f\u0017\u000647.\u0019+j[\u0016\u0014H+Z:u\u0015\tia\"A\u0004nKR\u0014\u0018nY:\u000b\u0003=\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0007\u0002\u001dQ,7\u000f^&bM.\fG+[7feR\ta\u0004\u0005\u0002\u0014?%\u0011\u0001\u0005\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0003EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002O\u0005\u0019qN]4\n\u0005%\"#\u0001\u0002+fgR\u00141\"T1ok\u0006d7\t\\8dWN\u00111\u0001\f\t\u0003[Uj\u0011A\f\u0006\u0003_A\nAaY8sK*\u0011Q\"\r\u0006\u0003eM\na!_1n[\u0016\u0014(\"\u0001\u001b\u0002\u0007\r|W.\u0003\u00027]\t)1\t\\8dWR\t\u0001\b\u0005\u0002:\u00075\t\u0001!\u0001\u0007uS\u000e\\7/\u00138OC:|7/F\u0001=!\t\u0019R(\u0003\u0002?)\t!Aj\u001c8h\u0003A!\u0018nY6t\u0013:t\u0015M\\8t?\u0012*\u0017\u000f\u0006\u0002\u001f\u0003\"9!IBA\u0001\u0002\u0004a\u0014a\u0001=%c\u0005iA/[2lg&sg*\u00198pg\u0002\nA\u0001^5dWR\tA(\u0001\u0003uS6,\u0017!C1eI6KG\u000e\\5t)\tq\u0012\nC\u0003K\u0015\u0001\u0007A(\u0001\u0004nS2d\u0017n\u001d")
public class KafkaTimerTest {
    @Test
    public void testKafkaTimer() {
        ManualClock clock = new ManualClock();
        MetricsRegistry testRegistry = new MetricsRegistry((Clock)clock);
        Timer metric = testRegistry.newTimer(this.getClass(), "TestTimer");
        double Epsilon = Double.longBitsToDouble(4368491638549381120L);
        KafkaTimer timer = new KafkaTimer(metric);
        timer.time((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> clock.addMillis(1000L));
        Assert.assertEquals((long)1L, (long)metric.count());
        Assert.assertTrue((RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(metric.max() - (double)1000)) <= Epsilon ? 1 : 0) != 0);
        Assert.assertTrue((RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(metric.min() - (double)1000)) <= Epsilon ? 1 : 0) != 0);
    }

    public class ManualClock
    extends Clock {
        private long ticksInNanos;

        private long ticksInNanos() {
            return this.ticksInNanos;
        }

        private void ticksInNanos_$eq(long x$1) {
            this.ticksInNanos = x$1;
        }

        public long tick() {
            return this.ticksInNanos();
        }

        public long time() {
            return TimeUnit.NANOSECONDS.toMillis(this.ticksInNanos());
        }

        public void addMillis(long millis) {
            this.ticksInNanos_$eq(this.ticksInNanos() + TimeUnit.MILLISECONDS.toNanos(millis));
        }

        public /* synthetic */ KafkaTimerTest kafka$metrics$KafkaTimerTest$ManualClock$$$outer() {
            return KafkaTimerTest.this;
        }

        public ManualClock() {
            if (KafkaTimerTest.this == null) {
                throw null;
            }
            this.ticksInNanos = 0L;
        }
    }
}

