/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DelayedOperationTest;
import kafka.server.DelayedOperationTest$MockDelayedOperation$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001A\u0002\u0013\u0005\u0011\bC\u0004t\u0001\u0001\u0007I\u0011\u0001;\t\rY\u0004\u0001\u0015)\u0003;\u0011\u001d9\b\u00011A\u0005\u0002aDq! \u0001A\u0002\u0013\u0005a\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0015B=\t\r\u0005\r\u0001\u0001\"\u0001o\u0011\u0019\t9\u0002\u0001C\u0001]\"1\u0011\u0011\u0005\u0001\u0005\u00029Da!a\u000b\u0001\t\u0003q\u0007BBA\u0018\u0001\u0011\u0005a\u000e\u0003\u0004\u00024\u0001!\tA\u001c\u0005\u0007\u0003o\u0001A\u0011\u00018\t\r\u0005m\u0002\u0001\"\u0001o\u0011\u0019\ty\u0004\u0001C\u0001]\"1\u00111\t\u0001\u0005\u00029Da!a\u0012\u0001\t\u0003q\u0007bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003;\u0002A\u0011BA0\r\u0011y\u0004\u0001\u0001!\t\u0013\u0011+\"\u0011!Q\u0001\n\u0015C\u0005\u0002C%\u0016\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011e+\"Q1A\u0005\u0002iC\u0001bW\u000b\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006iU!\t\u0001\u0018\u0005\bAV\u0001\r\u0011\"\u0001b\u0011\u001d)W\u00031A\u0005\u0002\u0019Da\u0001\\\u000b!B\u0013\u0011\u0007\"B7\u0016\t\u0003q\u0007\"B8\u0016\t\u0003\u0002\b\"B9\u0016\t\u0003r\u0007\"\u0002:\u0016\t\u0003rw!CAE\u0001\u0005\u0005\t\u0012AAF\r!y\u0004!!A\t\u0002\u00055\u0005B\u0002\u001b$\t\u0003\ty\tC\u0005\u0002\u0012\u000e\n\n\u0011\"\u0001\u0002\u0014\"I\u0011\u0011V\u0012\u0012\u0002\u0013\u0005\u00111\u0013\u0002\u0015\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:$Vm\u001d;\u000b\u0005%R\u0013AB:feZ,'OC\u0001,\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\t\u0001&A\u0005qkJ<\u0017\r^8ssV\t!\bE\u00028wuJ!\u0001\u0010\u0015\u00033\u0011+G.Y=fI>\u0003XM]1uS>t\u0007+\u001e:hCR|'/\u001f\t\u0003}Ui\u0011\u0001\u0001\u0002\u0015\u001b>\u001c7\u000eR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8\u0014\u0005U\t\u0005CA\u001cC\u0013\t\u0019\u0005F\u0001\tEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]\u00069A-\u001a7bs6\u001b\bCA\u0018G\u0013\t9\u0005G\u0001\u0003M_:<\u0017B\u0001#C\u0003\u001dawnY6PaR\u00042aL&N\u0013\ta\u0005G\u0001\u0004PaRLwN\u001c\t\u0003\u001d^k\u0011a\u0014\u0006\u0003!F\u000bQ\u0001\\8dWNT!AU*\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002U+\u0006!Q\u000f^5m\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W(\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003=\u0011Xm\u001d9p]N,Gj\\2l\u001fB$X#\u0001&\u0002!I,7\u000f]8og\u0016dunY6PaR\u0004C\u0003B\u001f^=~CQ\u0001\u0012\u000eA\u0002\u0015Cq!\u0013\u000e\u0011\u0002\u0003\u0007!\nC\u0004Z5A\u0005\t\u0019\u0001&\u0002\u0017\r|W\u000e\u001d7fi\u0006\u0014G.Z\u000b\u0002EB\u0011qfY\u0005\u0003IB\u0012qAQ8pY\u0016\fg.A\bd_6\u0004H.\u001a;bE2,w\fJ3r)\t9'\u000e\u0005\u00020Q&\u0011\u0011\u000e\r\u0002\u0005+:LG\u000fC\u0004l9\u0005\u0005\t\u0019\u00012\u0002\u0007a$\u0013'\u0001\u0007d_6\u0004H.\u001a;bE2,\u0007%A\bbo\u0006LG/\u0012=qSJ\fG/[8o)\u00059\u0017a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\u0012AY\u0001\r_:,\u0005\u0010]5sCRLwN\\\u0001\u000b_:\u001cu.\u001c9mKR,\u0017!\u00049ve\u001e\fGo\u001c:z?\u0012*\u0017\u000f\u0006\u0002hk\"91nAA\u0001\u0002\u0004Q\u0014A\u00039ve\u001e\fGo\u001c:zA\u0005yQ\r_3dkR|'oU3sm&\u001cW-F\u0001z!\tQ80D\u0001R\u0013\ta\u0018KA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003M)\u00070Z2vi>\u00148+\u001a:wS\u000e,w\fJ3r)\t9w\u0010C\u0004l\r\u0005\u0005\t\u0019A=\u0002!\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013!B:fiV\u0003\bf\u0001\u0005\u0002\bA!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011!\u00026v]&$(BAA\t\u0003\ry'oZ\u0005\u0005\u0003+\tYA\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0011\"a\u0007\u0011\t\u0005%\u0011QD\u0005\u0005\u0003?\tYAA\u0003BMR,'/A\fuKN$(+Z9vKN$8+\u0019;jg\u001a\f7\r^5p]\"\u001a!\"!\n\u0011\t\u0005%\u0011qE\u0005\u0005\u0003S\tYA\u0001\u0003UKN$\u0018!\u0005;fgR\u0014V-];fgR,\u0005\u0010]5ss\"\u001a1\"!\n\u0002!Q,7\u000f\u001e*fcV,7\u000f\u001e)ve\u001e,\u0007f\u0001\u0007\u0002&\u0005q3\u000f[8vY\u0012\u001c\u0015M\\2fY\u001a{'oS3z%\u0016$XO\u001d8j]\u001e\u001c\u0015M\\2fY2,Gm\u00149fe\u0006$\u0018n\u001c8tQ\ri\u0011QE\u0001:g\"|W\u000f\u001c3SKR,(O\u001c(jY>\u0003XM]1uS>t7o\u00148DC:\u001cW\r\u001c$pe.+\u0017p\u00165f].+\u0017\u0010R8fg:$X\t_5ti\"\u001aa\"!\n\u0002;Q,7\u000f\u001e+ss\u000e{W\u000e\u001d7fi\u0016dunY6D_:$XM\u001c;j_:D3aDA\u0013\u0003\t\"Xm\u001d;Uef\u001cu.\u001c9mKR,w+\u001b;i\u001bVdG/\u001b9mKRC'/Z1eg\"\u001a\u0001#!\n\u00021Q,7\u000f\u001e#fY\u0006LX\rZ(qKJ\fG/[8o\u0019>\u001c7\u000eK\u0002\u0012\u0003K\t\u0001\u0005^3ti\u0012+G.Y=fI>\u0003XM]1uS>tGj\\2l\u001fZ,'O]5eK\"\u001a!#!\n\u00025Y,'/\u001b4z\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:dunY6\u0015\u000b\u001d\fy%!\u0017\t\u0011\u0005E3\u0003\"a\u0001\u0003'\nA#\\8dW\u0012+G.Y=fI>\u0003XM]1uS>t\u0007\u0003B\u0018\u0002VuJ1!a\u00161\u0005!a$-\u001f8b[\u0016t\u0004BBA.'\u0001\u0007!-A\bnSNl\u0017\r^2iK\u0012dunY6t\u0003I\u0011XO\\(o\u0003:|G\u000f[3s)\"\u0014X-\u00193\u0015\r\u0005\u0005\u0014qPACa\u0011\t\u0019'!\u001c\u0011\u000bi\f)'!\u001b\n\u0007\u0005\u001d\u0014K\u0001\u0004GkR,(/\u001a\t\u0005\u0003W\ni\u0007\u0004\u0001\u0005\u0017\u0005=D#!A\u0001\u0002\u000b\u0005\u0011\u0011\u000f\u0002\u0004?\u0012\u0012\u0014\u0003BA:\u0003s\u00022aLA;\u0013\r\t9\b\r\u0002\b\u001d>$\b.\u001b8h!\ry\u00131P\u0005\u0004\u0003{\u0002$aA!os\"A\u0011\u0011\u0011\u000b\u0005\u0002\u0004\t\u0019)A\u0002gk:\u0004BaLA+O\"1\u0011q\u0011\u000bA\u0002\t\fab\u001d5pk2$7i\\7qY\u0016$X-\u0001\u000bN_\u000e\\G)\u001a7bs\u0016$w\n]3sCRLwN\u001c\t\u0003}\r\u001a\"a\t\u0018\u0015\u0005\u0005-\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0016*\u001a!*a&,\u0005\u0005e\u0005\u0003BAN\u0003Kk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a)1\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\u000biJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004")
public class DelayedOperationTest {
    private volatile DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation$module;
    private DelayedOperationPurgatory<MockDelayedOperation> purgatory = null;
    private ExecutorService executorService = null;

    public DelayedOperationTest$MockDelayedOperation$ MockDelayedOperation() {
        if (this.MockDelayedOperation$module == null) {
            this.MockDelayedOperation$lzycompute$1();
        }
        return this.MockDelayedOperation$module;
    }

    public DelayedOperationPurgatory<MockDelayedOperation> purgatory() {
        return this.purgatory;
    }

    public void purgatory_$eq(DelayedOperationPurgatory<MockDelayedOperation> x$1) {
        this.purgatory = x$1;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public void executorService_$eq(ExecutorService x$1) {
        this.executorService = x$1;
    }

    @Before
    public void setUp() {
        this.purgatory_$eq((DelayedOperationPurgatory<MockDelayedOperation>)DelayedOperationPurgatory$.MODULE$.apply("mock", DelayedOperationPurgatory$.MODULE$.apply$default$2(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5()));
    }

    @After
    public void tearDown() {
        block0: {
            this.purgatory().shutdown();
            if (this.executorService() == null) break block0;
            this.executorService().shutdown();
        }
    }

    @Test
    public void testRequestSatisfaction() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertEquals((String)"With no waiting requests, nothing should be satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        Assert.assertEquals((String)"Still nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        r1.completable_$eq(true);
        Assert.assertEquals((String)"r1 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test1"));
        r2.completable_$eq(true);
        Assert.assertEquals((String)"r2 satisfied", (long)1L, (long)this.purgatory().checkAndComplete((Object)"test2"));
        Assert.assertEquals((String)"Nothing satisfied", (long)0L, (long)this.purgatory().checkAndComplete((Object)"test2"));
    }

    @Test
    public void testRequestExpiry() {
        long expiration = 20L;
        long start = Time.SYSTEM.hiResClockMs();
        MockDelayedOperation r1 = new MockDelayedOperation(this, expiration, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 200000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        Assert.assertFalse((String)"r1 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"})));
        Assert.assertFalse((String)"r2 not satisfied and hence watched", (boolean)this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test2"})));
        r1.awaitExpiration();
        long elapsed = Time.SYSTEM.hiResClockMs() - start;
        Assert.assertTrue((String)"r1 completed due to expiration", (boolean)r1.isCompleted());
        Assert.assertFalse((String)"r2 hasn't completed", (boolean)r2.isCompleted());
        Assert.assertTrue((String)new StringBuilder(37).append("Time for expiration ").append(elapsed).append(" should at least ").append(expiration).toString(), (elapsed >= expiration ? 1 : 0) != 0);
    }

    @Test
    public void testRequestPurge() {
        MockDelayedOperation r1 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r2 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        MockDelayedOperation r3 = new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3());
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2"}));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)r3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test1", "test2", "test3"}));
        Assert.assertEquals((String)"Purgatory should have 3 total delayed operations", (long)3L, (long)this.purgatory().delayed());
        Assert.assertEquals((String)"Purgatory should have 6 watched elements", (long)6L, (long)this.purgatory().watched());
        r2.completable_$eq(true);
        r2.tryComplete();
        Assert.assertEquals((String)new StringBuilder(60).append("Purgatory should have 2 total delayed operations instead of ").append(this.purgatory().delayed()).toString(), (long)2L, (long)this.purgatory().delayed());
        r3.completable_$eq(true);
        r3.tryComplete();
        Assert.assertEquals((String)new StringBuilder(60).append("Purgatory should have 1 total delayed operations instead of ").append(this.purgatory().delayed()).toString(), (long)1L, (long)this.purgatory().delayed());
        this.purgatory().checkAndComplete((Object)"test1");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 4 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)4L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test2");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 2 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)2L, (long)this.purgatory().watched());
        this.purgatory().checkAndComplete((Object)"test3");
        Assert.assertEquals((String)new StringBuilder(52).append("Purgatory should have 1 watched elements instead of ").append(this.purgatory().watched()).toString(), (long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldCancelForKeyReturningCancelledOperations() {
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})));
        this.purgatory().tryCompleteElseWatch((DelayedOperation)new MockDelayedOperation(this, 10000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key2"})));
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((long)2L, (long)cancelledOperations.size());
        Assert.assertEquals((long)1L, (long)this.purgatory().delayed());
        Assert.assertEquals((long)1L, (long)this.purgatory().watched());
    }

    @Test
    public void shouldReturnNilOperationsOnCancelForKeyWhenKeyDoesntExist() {
        List cancelledOperations = this.purgatory().cancelForKey((Object)"key");
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)cancelledOperations);
    }

    @Test
    public void testTryCompleteLockContention() {
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        AtomicInteger completionAttemptsRemaining = new AtomicInteger(Integer.MAX_VALUE);
        Semaphore tryCompleteSemaphore = new Semaphore(1);
        String key = "key";
        MockDelayedOperation op = new MockDelayedOperation(this, completionAttemptsRemaining, tryCompleteSemaphore){
            private final AtomicInteger completionAttemptsRemaining$1;
            private final Semaphore tryCompleteSemaphore$1;

            public boolean tryComplete() {
                boolean bl;
                boolean shouldComplete = this.completionAttemptsRemaining$1.decrementAndGet() <= 0;
                this.tryCompleteSemaphore$1.acquire();
                try {
                    bl = shouldComplete ? this.forceComplete() : false;
                }
                finally {
                    this.tryCompleteSemaphore$1.release();
                }
                return bl;
            }
            {
                this.completionAttemptsRemaining$1 = completionAttemptsRemaining$1;
                this.tryCompleteSemaphore$1 = tryCompleteSemaphore$1;
                super($outer, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)None$.MODULE$);
            }
        };
        this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key})));
        completionAttemptsRemaining.set(2);
        tryCompleteSemaphore.acquire();
        Future<?> future = this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.purgatory().checkAndComplete((Object)key), false);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> tryCompleteSemaphore.hasQueuedThreads(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Not attempting to complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.purgatory().checkAndComplete((Object)key);
        Assert.assertFalse((String)"Operation should not have completed", (boolean)op.isCompleted());
        tryCompleteSemaphore.release();
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    @Test
    public void testTryCompleteWithMultipleThreads() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(20);
        this.executorService_$eq(executor);
        Random random = new Random();
        int maxDelayMs = 10;
        int completionAttempts = 20;
        IndexedSeq ops = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)index -> {
            public class Kafka_server_DelayedOperationTest$TestDelayOperation$1
            extends MockDelayedOperation {
                private final String key;
                private final AtomicInteger completionAttemptsRemaining;
                private final Random random$1;
                private final int maxDelayMs$1;

                public String key() {
                    return this.key;
                }

                public AtomicInteger completionAttemptsRemaining() {
                    return this.completionAttemptsRemaining;
                }

                public boolean tryComplete() {
                    boolean shouldComplete = this.completable();
                    Thread.sleep(this.random$1.nextInt(this.maxDelayMs$1));
                    return shouldComplete ? this.forceComplete() : false;
                }

                public Kafka_server_DelayedOperationTest$TestDelayOperation$1(DelayedOperationTest $outer, int index, int completionAttempts$1, Random random$1, int maxDelayMs$1) {
                    this.random$1 = random$1;
                    this.maxDelayMs$1 = maxDelayMs$1;
                    super($outer, 10000L, $outer.MockDelayedOperation().$lessinit$greater$default$2(), $outer.MockDelayedOperation().$lessinit$greater$default$3());
                    this.key = new StringBuilder(3).append("key").append(index).toString();
                    this.completionAttemptsRemaining = new AtomicInteger(completionAttempts$1);
                }
            }
            return DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$1(this, completionAttempts, random, maxDelayMs, BoxesRunTime.unboxToInt((Object)index));
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), completionAttempts).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$2(this, ops, random, maxDelayMs, executor, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)future -> future.get());
        ops.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$testTryCompleteWithMultipleThreads$5(op);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDelayedOperationLock() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> new MockDelayedOperation(this, 100000L, this.MockDelayedOperation().$lessinit$greater$default$2(), this.MockDelayedOperation().$lessinit$greater$default$3()), false);
    }

    @Test
    public void testDelayedOperationLockOverride() {
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> this.newMockOperation$1(), false);
        this.verifyDelayedOperationLock((Function0<MockDelayedOperation>)(Function0 & Serializable & scala.Serializable)() -> new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)None$.MODULE$, (Option<ReentrantLock>)new Some((Object)new ReentrantLock())), true);
    }

    public void verifyDelayedOperationLock(Function0<MockDelayedOperation> mockDelayedOperation, boolean mismatchedLocks) {
        String key = "key";
        this.executorService_$eq(Executors.newSingleThreadExecutor());
        ObjectRef ops = ObjectRef.create((Object)this.createDelayedOperations$1(2, mockDelayedOperation, key));
        this.checkAndComplete$1((Seq)ops.elem, (Seq)ops.elem, key);
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        CoreUtils$.MODULE$.inLock(((DelayedOperation)((Seq)ops.elem).apply(1)).lock(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAndComplete$1((Seq)ops$2.elem, (Seq)ops$2.elem, key));
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().lock(), true);
        try {
            this.checkAndComplete$1((Seq)ops.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(1))})), key);
        }
        catch (Throwable throwable) {
            this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().unlock(), true);
            this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), key);
            throw throwable;
        }
        this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((DelayedOperation)((Seq)ops$2.elem).apply(0)).lock().unlock(), true);
        this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))})), key);
        ops.elem = this.createDelayedOperations$1(2, mockDelayedOperation, key);
        ((MockDelayedOperation)((Object)((Seq)ops.elem).apply(0))).responseLockOpt().foreach((Function1 & Serializable & scala.Serializable)lock -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$9(this, ops, mismatchedLocks, key, lock);
            return BoxedUnit.UNIT;
        });
        ops.elem = DelayedOperationTest.createCompletableOperations$1(2, mockDelayedOperation);
        ((Seq)ops.elem).foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$12(this, key, op);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Future<?> runOnAnotherThread(Function0<BoxedUnit> fun, boolean shouldComplete) {
        void var3_3;
        Object object;
        Future<?> future = this.executorService().submit(new Runnable(null, fun){
            private final Function0 fun$1;

            public void run() {
                this.fun$1.apply$mcV$sp();
            }
            {
                this.fun$1 = fun$1;
            }
        });
        if (shouldComplete) {
            object = future.get();
        } else {
            Assert.assertFalse((String)"Should not have completed", (boolean)future.isDone());
            object = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private final void MockDelayedOperation$lzycompute$1() {
        DelayedOperationTest delayedOperationTest = this;
        synchronized (delayedOperationTest) {
            if (this.MockDelayedOperation$module == null) {
                this.MockDelayedOperation$module = new DelayedOperationTest$MockDelayedOperation$(this);
            }
        }
    }

    public static final /* synthetic */ TestDelayOperation.1 $anonfun$testTryCompleteWithMultipleThreads$1(DelayedOperationTest $this, int completionAttempts$1, Random random$1, int maxDelayMs$1, int index) {
        Kafka_server_DelayedOperationTest$TestDelayOperation$1 op = new Kafka_server_DelayedOperationTest$TestDelayOperation$1($this, index, completionAttempts$1, random$1, maxDelayMs$1);
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{op.key()})));
        return op;
    }

    private final Future scheduleTryComplete$1(TestDelayOperation.1 op, long delayMs, ScheduledExecutorService executor$1) {
        return executor$1.schedule(new Runnable(this, op){
            private final /* synthetic */ DelayedOperationTest $outer;
            private final Kafka_server_DelayedOperationTest$TestDelayOperation$1 op$1;

            public void run() {
                if (this.op$1.completionAttemptsRemaining().decrementAndGet() == 0) {
                    this.op$1.completable_$eq(true);
                }
                this.$outer.purgatory().checkAndComplete((Object)this.op$1.key());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.op$1 = op$1;
            }
        }, delayMs, TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$testTryCompleteWithMultipleThreads$2(DelayedOperationTest $this, IndexedSeq ops$1, Random random$1, int maxDelayMs$1, ScheduledExecutorService executor$1, int x$1) {
        return (IndexedSeq)ops$1.map((Function1 & Serializable & scala.Serializable)op -> {
            return $this.scheduleTryComplete$1((Kafka_server_DelayedOperationTest$TestDelayOperation$1)((Object)op), random$1.nextInt(maxDelayMs$1), executor$1);
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$testTryCompleteWithMultipleThreads$5(TestDelayOperation.1 op) {
        Assert.assertTrue((String)"Operation should have completed", (boolean)op.isCompleted());
    }

    private final MockDelayedOperation newMockOperation$1() {
        ReentrantLock lock = new ReentrantLock();
        return new MockDelayedOperation(this, 100000L, (Option<ReentrantLock>)new Some((Object)lock), (Option<ReentrantLock>)new Some((Object)lock));
    }

    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$1(DelayedOperationTest $this, Function0 mockDelayedOperation$1, String key$2, int x$2) {
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        $this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key$2})));
        Assert.assertFalse((String)"Not completable", (boolean)op.isCompleted());
        return op;
    }

    private final Seq createDelayedOperations$1(int count, Function0 mockDelayedOperation$1, String key$2) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)x$2 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$1(this, mockDelayedOperation$1, key$2, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ MockDelayedOperation $anonfun$verifyDelayedOperationLock$2(Function0 mockDelayedOperation$1, int x$3) {
        void var2_2;
        MockDelayedOperation op = (MockDelayedOperation)((Object)mockDelayedOperation$1.apply());
        op.completable_$eq(true);
        return var2_2;
    }

    private static final Seq createCompletableOperations$1(int count, Function0 mockDelayedOperation$1) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)x$3 -> DelayedOperationTest.$anonfun$verifyDelayedOperationLock$2(mockDelayedOperation$1, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$4(MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$5(MockDelayedOperation op) {
        Assert.assertFalse((String)"Should not have completed", (boolean)op.isCompleted());
    }

    private final void checkAndComplete$1(Seq completableOps, Seq expectedComplete, String key$2) {
        completableOps.foreach((Function1 & Serializable & scala.Serializable)op -> {
            op.completable_$eq(true);
            return BoxedUnit.UNIT;
        });
        int completed = this.purgatory().checkAndComplete((Object)key$2);
        Assert.assertEquals((long)expectedComplete.size(), (long)completed);
        expectedComplete.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$4(op);
            return BoxedUnit.UNIT;
        });
        Set expectedNotComplete = (Set)completableOps.toSet().$minus$minus((GenTraversableOnce)expectedComplete);
        expectedNotComplete.foreach((Function1 & Serializable & scala.Serializable)op -> {
            DelayedOperationTest.$anonfun$verifyDelayedOperationLock$5(op);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$9(DelayedOperationTest $this, ObjectRef ops$2, boolean mismatchedLocks$1, String key$2, ReentrantLock lock) {
        $this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.lock(), true);
        try {
            try {
                $this.checkAndComplete$1((Seq)ops$2.elem, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(1))})), key$2);
                Assert.assertFalse((String)"Should have failed with mismatched locks", (boolean)mismatchedLocks$1);
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((String)"Should not have failed with valid locks", (boolean)mismatchedLocks$1);
            }
        }
        catch (Throwable throwable) {
            $this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.unlock(), true);
            $this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))})), key$2);
            throw throwable;
        }
        $this.runOnAnotherThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> lock.unlock(), true);
        $this.checkAndComplete$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockDelayedOperation[]{(MockDelayedOperation)((Object)((Seq)ops$2.elem).apply(0))})), key$2);
    }

    public static final /* synthetic */ void $anonfun$verifyDelayedOperationLock$12(DelayedOperationTest $this, String key$2, MockDelayedOperation op) {
        Assert.assertTrue((String)"Should have completed", (boolean)$this.purgatory().tryCompleteElseWatch((DelayedOperation)op, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{key$2}))));
        Assert.assertTrue((String)"Should have completed", (boolean)op.isCompleted());
    }

    public class MockDelayedOperation
    extends DelayedOperation {
        private final Option<ReentrantLock> responseLockOpt;
        private boolean completable;
        public final /* synthetic */ DelayedOperationTest $outer;

        public Option<ReentrantLock> responseLockOpt() {
            return this.responseLockOpt;
        }

        public boolean completable() {
            return this.completable;
        }

        public void completable_$eq(boolean x$1) {
            this.completable = x$1;
        }

        public synchronized void awaitExpiration() {
            this.wait();
        }

        public boolean tryComplete() {
            return this.completable() ? this.forceComplete() : false;
        }

        public void onExpiration() {
        }

        public void onComplete() {
            this.responseLockOpt().foreach((Function1 & Serializable & scala.Serializable)lock -> {
                MockDelayedOperation.$anonfun$onComplete$1(lock);
                return BoxedUnit.UNIT;
            });
            MockDelayedOperation mockDelayedOperation = this;
            synchronized (mockDelayedOperation) {
                this.notify();
            }
        }

        public /* synthetic */ DelayedOperationTest kafka$server$DelayedOperationTest$MockDelayedOperation$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onComplete$1(ReentrantLock lock) {
            if (!lock.tryLock()) {
                throw new IllegalStateException("Response callback lock could not be acquired in callback");
            }
        }

        public MockDelayedOperation(DelayedOperationTest $outer, long delayMs, Option<ReentrantLock> lockOpt, Option<ReentrantLock> responseLockOpt) {
            this.responseLockOpt = responseLockOpt;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(delayMs, lockOpt);
            this.completable = false;
        }
    }
}

