/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013\u0005Q\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0011\r\u0011\"\u0001.\u0011\u0019A\u0004\u0001)A\u0005]!9\u0011\b\u0001b\u0001\n\u0003Q\u0004BB!\u0001A\u0003%1\bC\u0004C\u0001\t\u0007I\u0011A\"\t\r9\u0003\u0001\u0015!\u0003E\u0011\u001dy\u0005A1A\u0005\u0002\rCa\u0001\u0015\u0001!\u0002\u0013!\u0005bB)\u0001\u0005\u0004%\ta\u0011\u0005\u0007%\u0002\u0001\u000b\u0011\u0002#\t\u000fM\u0003!\u0019!C\u0001)\"11\f\u0001Q\u0001\nUCq\u0001\u0018\u0001C\u0002\u0013\u0005Q\f\u0003\u0004}\u0001\u0001\u0006IA\u0018\u0005\n{\u0002\u0001\r\u00111A\u0005\u0002yD1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\f!Q\u0011q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015B@\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u00111\u0006\u0001\u0005\u0002\u0005m\u0001bBA\u001b\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003\u007f\u0001A\u0011AA\u000e\u0011\u001d\t\u0019\u0005\u0001C\u0001\u00037Aq!a\u0012\u0001\t\u0013\tIEA\nEk6\u0004Hj\\4TK\u001elWM\u001c;t)\u0016\u001cHO\u0003\u0002\u001e=\u0005)Ao\\8mg*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00029\u00051A/\u001c9ESJ,\u0012A\f\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\n!![8\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\n1b]3h[\u0016tGOT1nKV\t1\b\u0005\u0002=\u007f5\tQH\u0003\u0002?e\u0005!A.\u00198h\u0013\t\u0001UH\u0001\u0004TiJLgnZ\u0001\rg\u0016<W.\u001a8u\u001d\u0006lW\rI\u0001\fY><g)\u001b7f!\u0006$\b.F\u0001E!\t)EJ\u0004\u0002G\u0015B\u0011q\tJ\u0007\u0002\u0011*\u0011\u0011\nI\u0001\u0007yI|w\u000e\u001e \n\u0005-#\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u001b*\u00111\nJ\u0001\rY><g)\u001b7f!\u0006$\b\u000eI\u0001\u000eS:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5\u0002\u001d%tG-\u001a=GS2,\u0007+\u0019;iA\u0005\tB/[7f\u0013:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5\u0002%QLW.Z%oI\u0016Dh)\u001b7f!\u0006$\b\u000eI\u0001\u0005i&lW-F\u0001V!\t1\u0016,D\u0001X\u0015\tAf$A\u0003vi&d7/\u0003\u0002[/\nAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0004cCR\u001c\u0007.Z:\u0016\u0003y\u00032a\u00183g\u001b\u0005\u0001'BA1c\u0003\u001diW\u000f^1cY\u0016T!a\u0019\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002fA\nY\u0011I\u001d:bs\n+hMZ3s!\r9Gn\u001c\b\u0003Q*t!aR5\n\u0003\u0015J!a\u001b\u0013\u0002\u000fA\f7m[1hK&\u0011QN\u001c\u0002\u0004'\u0016\f(BA6%!\t\u0001(0D\u0001r\u0015\t\u00118/\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003iV\faaY8n[>t'BA\u0010w\u0015\t9\b0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0006\u0019qN]4\n\u0005m\f(\u0001D*j[BdWMU3d_J$\u0017\u0001\u00032bi\u000eDWm\u001d\u0011\u0002\u00071|w-F\u0001\u0000!\u0011\t\t!!\u0002\u000e\u0005\u0005\r!BA?\u001f\u0013\u0011\t9!a\u0001\u0003\u00071{w-A\u0004m_\u001e|F%Z9\u0015\t\u00055\u00111\u0003\t\u0004G\u0005=\u0011bAA\tI\t!QK\\5u\u0011!\t)bEA\u0001\u0002\u0004y\u0018a\u0001=%c\u0005!An\\4!\u0003\u0015\u0019X\r^+q)\t\ti\u0001K\u0002\u0016\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003KA\u0018!\u00026v]&$\u0018\u0002BA\u0015\u0003G\u0011aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007Y\ty\u0003\u0005\u0003\u0002\"\u0005E\u0012\u0002BA\u001a\u0003G\u0011Q!\u00114uKJ\f\u0001\u0003^3tiB\u0013\u0018N\u001c;ECR\fGj\\4)\u0007]\tI\u0004\u0005\u0003\u0002\"\u0005m\u0012\u0002BA\u001f\u0003G\u0011A\u0001V3ti\u00069B/Z:u\tVl\u0007/\u00138eKbl\u0015n]7bi\u000eDWm\u001d\u0015\u00041\u0005e\u0012a\u0006;fgR$U/\u001c9US6,\u0017J\u001c3fq\u0016\u0013(o\u001c:tQ\rI\u0012\u0011H\u0001\u0013eVtG)^7q\u0019><7+Z4nK:$8\u000fF\u0002E\u0003\u0017Bq!!\u0014\u001b\u0001\u0004\ty%\u0001\u0003be\u001e\u001c\b\u0003B\u0012\u0002R\u0011K1!a\u0015%\u0005\u0015\t%O]1z\u0001")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<Seq<SimpleRecord>> batches = new ArrayBuffer();
    private Log log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<Seq<SimpleRecord>> batches() {
        return this.batches;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    @Before
    public void setUp() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        this.log_$eq(Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10));
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$setUp$1(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)firstBatchRecords);
        Log qual$1 = this.log();
        MemoryRecords x$11 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])firstBatchRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        int x$12 = 0;
        boolean x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        qual$1.appendAsLeader(x$11, x$12, x$13, x$14);
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$setUp$2(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)secondBatchRecords);
        Log qual$2 = this.log();
        MemoryRecords x$15 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])secondBatchRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        int x$16 = 0;
        boolean x$17 = qual$2.appendAsLeader$default$3();
        ApiVersion x$18 = qual$2.appendAsLeader$default$4();
        qual$2.appendAsLeader(x$15, x$16, x$17, x$18);
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$setUp$3(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)thirdBatchRecords);
        Log qual$3 = this.log();
        MemoryRecords x$19 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])thirdBatchRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        int x$20 = 0;
        boolean x$21 = qual$3.appendAsLeader$default$3();
        ApiVersion x$22 = qual$3.appendAsLeader$default$4();
        qual$3.appendAsLeader(x$19, x$20, x$21, x$22);
        this.log().flush();
    }

    @After
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testPrintDataLog() {
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1((String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    public static final /* synthetic */ SimpleRecord $anonfun$setUp$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("hello there ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$setUp$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(18).append("hello there again ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$setUp$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), new StringBuilder(26).append("hello there one more time ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        Seq batch;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            batch = (Seq)tuple2._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
        } else {
            throw new MatchError((Object)tuple2);
        }
        batch.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)recordIndex -> {
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
            ++i$1.elem;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail(new StringBuilder(19).append("No match for index ").append(index).toString(), new Position("DumpLogSegmentsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return ex.value$mcZ$sp();
        }
    }

    private final void verifyRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assert.assertTrue((String)new StringBuilder(18).append("Data not printed: ").append(output).toString(), (lines.length > 2 ? 1 : 0) != 0);
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            String line = lines[lines.length - totalRecords - this.batches().size() + index];
            if (this.isBatch$1(index)) {
                Assert.assertTrue((String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString(), (boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()));
            } else {
                Assert.assertTrue((String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString(), (boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()));
                ++offset$1.elem;
            }
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assert.assertFalse((String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString(), (boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"));
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

