/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.api;

import integration.kafka.api.ConsumerTopicCreationTest$;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\n\u0014\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tU\u0001\u0011\t\u0011)A\u0005E!)1\u0006\u0001C\u0001Y!)\u0011\u0007\u0001C)e!9\u0011\b\u0001b\u0001\n\u0003Q\u0004B\u0002 \u0001A\u0003%1\bC\u0004@\u0001\t\u0007I\u0011\u0001\u001e\t\r\u0001\u0003\u0001\u0015!\u0003<\u0011\u001d\t\u0005A1A\u0005\u0002iBaA\u0011\u0001!\u0002\u0013Y\u0004bB\"\u0001\u0005\u0004%\tA\u000f\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001e\t\u000b\u0015\u0003A\u0011\u0001$\b\u000b\t\u001c\u0002\u0012A2\u0007\u000bI\u0019\u0002\u0012\u00013\t\u000b-zA\u0011\u00015\t\u000b%|A\u0011\u00016\u00033\r{gn];nKJ$v\u000e]5d\u0007J,\u0017\r^5p]R+7\u000f\u001e\u0006\u0003)U\t1!\u00199j\u0015\t1r#A\u0003lC\u001a\\\u0017MC\u0001\u0019\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0003)yQ\u0011AF\u0005\u0003Au\u0011a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u001eEJ|7.\u001a:BkR|Gk\u001c9jG\u000e\u0013X-\u0019;j_:,e.\u00192mKB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#a\u0002\"p_2,\u0017M\\\u0001\u001eG>t7/^7fe\u0006cGn\\<BkR|7I]3bi\u0016$v\u000e]5dg\u00061A(\u001b8jiz\"2!L\u00181!\tq\u0003!D\u0001\u0014\u0011\u0015\t3\u00011\u0001#\u0011\u0015Q3\u00011\u0001#\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u00121!\u00138u\u0003\u001d!x\u000e]5d?F*\u0012a\u000f\t\u0003GqJ!!\u0010\u0013\u0003\rM#(/\u001b8h\u0003!!x\u000e]5d?F\u0002\u0013a\u0002;pa&\u001cwLM\u0001\ti>\u0004\u0018nY03A\u0005\u0001\u0002O]8ek\u000e,'o\u00117jK:$\u0018\nZ\u0001\u0012aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012\u0004\u0013\u0001E2p]N,X.\u001a:DY&,g\u000e^%e\u0003E\u0019wN\\:v[\u0016\u00148\t\\5f]RLE\rI\u0001\u0016i\u0016\u001cH/Q;u_R{\u0007/[2De\u0016\fG/[8o)\u00059\u0005C\u0001\u001bI\u0013\tIUG\u0001\u0003V]&$\bFA\u0007L!\ta\u0015+D\u0001N\u0015\tqu*A\u0003kk:LGOC\u0001Q\u0003\ry'oZ\u0005\u0003%6\u0013A\u0001V3ti\"\"\u0001\u0001\u0016.\\!\t)\u0006,D\u0001W\u0015\t9V*\u0001\u0004sk:tWM]\u0005\u00033Z\u0013qAU;o/&$\b.A\u0003wC2,XmI\u0001]!\ti\u0006-D\u0001_\u0015\tyV*A\u0004sk:tWM]:\n\u0005\u0005t&!\u0004)be\u0006lW\r^3sSj,G-A\rD_:\u001cX/\\3s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8UKN$\bC\u0001\u0018\u0010'\tyQ\r\u0005\u00025M&\u0011q-\u000e\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\r\f!\u0002]1sC6,G/\u001a:t+\u0005Y\u0007c\u00017pc6\tQN\u0003\u0002oM\u0005!Q\u000f^5m\u0013\t\u0001XN\u0001\u0006D_2dWm\u0019;j_:\u00042\u0001\u000e:u\u0013\t\u0019XGA\u0003BeJ\f\u0017\u0010\u0005\u0002$k&\u0011a\u000f\n\u0002\u0007\u001f\nTWm\u0019;)\rEA\u0018\u0011CA\n!\rI\u00181\u0002\b\u0004u\u0006\u001dabA>\u0002\u00069\u0019A0a\u0001\u000f\u0007u\f\t!D\u0001\u007f\u0015\ty\u0018$\u0001\u0004=e>|GOP\u0005\u0002!&\u0011ajT\u0005\u0003?6K1!!\u0003_\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011QBA\b\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0004\u0003\u0013q\u0016\u0001\u00028b[\u0016\f#!!\u0006\u0002e\t\u0014xn[3s)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8>wBjH\u0006I2p]N,X.\u001a:U_BL7m\u0011:fCRLwN\\\u001f|cu\u0004")
public class ConsumerTopicCreationTest
extends IntegrationTestHarness {
    private final Boolean brokerAutoTopicCreationEnable;
    private final Boolean consumerAllowAutoCreateTopics;
    private final String topic_1;
    private final String topic_2;
    private final String producerClientId;
    private final String consumerClientId;

    @Parameterized.Parameters(name="brokerTopicCreation={0}, consumerTopicCreation={1}")
    public static Collection<Object[]> parameters() {
        return ConsumerTopicCreationTest$.MODULE$.parameters();
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public String topic_1() {
        return this.topic_1;
    }

    public String topic_2() {
        return this.topic_2;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    @Test
    public void testAutoTopicCreation() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AdminClient adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ProducerRecord record = new ProducerRecord(this.topic_1(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        adminClient.createTopics(Collections.singleton(new NewTopic(this.topic_1(), 1, 1))).all().get();
        producer.send(record).get();
        consumer.subscribe(Arrays.asList((Object[])new String[]{this.topic_1(), this.topic_2()}));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> consumer.poll(Duration.ofMillis(100L)).count() > 0, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Timed out waiting to consume", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        boolean topicCreated = this.zkClient().getAllTopicsInCluster().contains((Object)this.topic_2());
        if (Predef$.MODULE$.Boolean2boolean(this.brokerAutoTopicCreationEnable) && Predef$.MODULE$.Boolean2boolean(this.consumerAllowAutoCreateTopics)) {
            Assert.assertTrue((boolean)topicCreated);
        } else {
            Assert.assertFalse((boolean)topicCreated);
        }
    }

    public ConsumerTopicCreationTest(Boolean brokerAutoTopicCreationEnable, Boolean consumerAllowAutoCreateTopics) {
        this.brokerAutoTopicCreationEnable = brokerAutoTopicCreationEnable;
        this.consumerAllowAutoCreateTopics = consumerAllowAutoCreateTopics;
        this.topic_1 = "topic-1";
        this.topic_2 = "topic-2";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), brokerAutoTopicCreationEnable.toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", "my-test");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("allow.auto.create.topics", consumerAllowAutoCreateTopics.toString());
    }
}

