/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.AdminClientIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u000f\u001f\u0001\rBQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001A\u0002\u0013\u0005Q\u0007C\u0004D\u0001\u0001\u0007I\u0011\u0001#\t\r5\u0003\u0001\u0015)\u00037\u0011\u001dq\u0005A1A\u0005\u0002=Caa\u0015\u0001!\u0002\u0013\u0001\u0006\"\u0002+\u0001\t\u0003)\u0006\"B2\u0001\t\u0003\"\u0007\"B5\u0001\t\u0003\"\u0007\"\u00028\u0001\t\u0003y\u0007bBA\n\u0001\u0011\u0005\u0013Q\u0003\u0005\u0007\u0003k\u0001A\u0011\u00013\t\r\u0005}\u0002\u0001\"\u0001e\u0011\u0019\t\u0019\u0005\u0001C\u0001I\u001e9\u0011q\t\u0010\t\u0002\u0005%cAB\u000f\u001f\u0011\u0003\tY\u0005\u0003\u00041!\u0011\u0005\u00111\u000b\u0004\u0007\u0003+\u0002\u0002!a\u0016\t\rA\u0012B\u0011AA4\u0011-\tiG\u0005a\u0001\u0002\u0004%\t!a\u001c\t\u0017\u0005=%\u00031AA\u0002\u0013\u0005\u0011\u0011\u0013\u0005\f\u0003\u007f\u0012\u0002\u0019!A!B\u0013\t\t\bC\u0005\u0002\u001eJ\u0001\r\u0011\"\u0001\u0002 \"I\u0011q\u0015\nA\u0002\u0013\u0005\u0011\u0011\u0016\u0005\t\u0003[\u0013\u0002\u0015)\u0003\u0002\"\"9\u0011q\u0016\n\u0005\u0002\u0005E\u0006bBA`%\u0011\u0005\u0011\u0011\u0019\u0005\u0007\u0003+\u0014B\u0011\u00013\u0003M\u0005#W.\u001b8DY&,g\u000e^,ji\"\u0004v\u000e\\5dS\u0016\u001c\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002 A\u0005\u0019\u0011\r]5\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R!a\n\u0011\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003S\u0019\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[\u0001\nQ!\u001e;jYNL!a\f\u0017\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011AH\u0001\u0007G2LWM\u001c;\u0016\u0003Y\u0002\"aN!\u000e\u0003aR!!\u000f\u001e\u0002\u000b\u0005$W.\u001b8\u000b\u0005mb\u0014aB2mS\u0016tGo\u001d\u0006\u0003CuR!AP \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0015aA8sO&\u0011!\t\u000f\u0002\f\u0003\u0012l\u0017N\\\"mS\u0016tG/\u0001\u0006dY&,g\u000e^0%KF$\"!R&\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\tUs\u0017\u000e\u001e\u0005\b\u0019\u000e\t\t\u00111\u00017\u0003\rAH%M\u0001\bG2LWM\u001c;!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003A\u0003\"AR)\n\u0005I;%aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005iq\r\\8cC2$\u0016.\\3pkR,\u0012A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bQA];mKNT!aW \u0002\u000b),h.\u001b;\n\u0005uC&a\u0002+j[\u0016|W\u000f\u001e\u0015\u0003\u000f}\u0003\"\u0001Y1\u000e\u0003iK!A\u0019.\u0003\tI+H.Z\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u000b\"\u0012\u0001B\u001a\t\u0003A\u001eL!\u0001\u001b.\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007FA\u0005l!\t\u0001G.\u0003\u0002n5\n)\u0011I\u001a;fe\u0006a1M]3bi\u0016\u001cuN\u001c4jOV\t\u0001\u000fE\u0003rmb\f9!D\u0001s\u0015\t\u0019H/\u0001\u0003vi&d'\"A;\u0002\t)\fg/Y\u0005\u0003oJ\u00141!T1q!\rI\u0018\u0011\u0001\b\u0003uz\u0004\"a_$\u000e\u0003qT!! \u0012\u0002\rq\u0012xn\u001c;?\u0013\tyx)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f\u001e\u0003B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b!\u0018\u0001\u00027b]\u001eLA!!\u0005\u0002\f\t1qJ\u00196fGR\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0003\u0003/\u0001b!!\u0007\u0002$\u0005%b\u0002BA\u000e\u0003?q1a_A\u000f\u0013\u0005A\u0015bAA\u0011\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0013\u0003O\u00111aU3r\u0015\r\t\tc\u0012\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0011\u0002\rM,'O^3s\u0013\u0011\t\u0019$!\f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0016i\u0016\u001cHOV1mS\u0012\fE\u000e^3s\u0007>tg-[4tQ\ra\u0011\u0011\b\t\u0004A\u0006m\u0012bAA\u001f5\n!A+Z:u\u0003]!Xm\u001d;J]Z\fG.\u001b3BYR,'oQ8oM&<7\u000fK\u0002\u000e\u0003s\t!\u0005^3ti&sg/\u00197jI\u0006cG/\u001a:D_:4\u0017nZ:Ek\u0016$v\u000eU8mS\u000eL\bf\u0001\b\u0002:\u00051\u0013\tZ7j]\u000ec\u0017.\u001a8u/&$\b\u000eU8mS\u000eLWm]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0005M\u00022c\u0001\t\u0002NA\u0019a)a\u0014\n\u0007\u0005EsI\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u0013\u0012a\u0001U8mS\u000eL8#\u0002\n\u0002\b\u0005e\u0003\u0003BA.\u0003Gj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0007a>d\u0017nY=\u000b\u0007\u0005=B(\u0003\u0003\u0002f\u0005u#!E!mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5dsR\u0011\u0011\u0011\u000e\t\u0004\u0003W\u0012R\"\u0001\t\u0002\u000f\r|gNZ5hgV\u0011\u0011\u0011\u000f\u0019\u0005\u0003g\nY\b\u0005\u0004z\u0003kB\u0018qO\u0005\u0004o\u0006\u0015\u0001\u0003BA=\u0003wb\u0001\u0001B\u0006\u0002~Y\t\t\u0011!A\u0003\u0002\u0005\u0005%aA0%c\u0005A1m\u001c8gS\u001e\u001c\b%\u0005\u0003\u0002\u0004\u0006%\u0005c\u0001$\u0002\u0006&\u0019\u0011qQ$\u0003\u000f9{G\u000f[5oOB\u0019a)a#\n\u0007\u00055uIA\u0002B]f\f1bY8oM&<7o\u0018\u0013fcR\u0019Q)a%\t\u00111+\u0012\u0011!a\u0001\u0003+\u0003D!a&\u0002\u001cB1\u00110!\u001ey\u00033\u0003B!!\u001f\u0002\u001c\u0012a\u0011QPAJ\u0003\u0003\u0005\tQ!\u0001\u0002\u0002\u000611\r\\8tK\u0012,\"!!)\u0011\u0007\u0019\u000b\u0019+C\u0002\u0002&\u001e\u0013qAQ8pY\u0016\fg.\u0001\u0006dY>\u001cX\rZ0%KF$2!RAV\u0011!a\u0005$!AA\u0002\u0005\u0005\u0016aB2m_N,G\rI\u0001\nG>tg-[4ve\u0016$2!RAZ\u0011\u001d\tiG\u0007a\u0001\u0003k\u0003D!a.\u0002<B)\u0011O\u001e=\u0002:B!\u0011\u0011PA^\t1\ti,a-\u0002\u0002\u0003\u0005)\u0011AAA\u0005\ryFEM\u0001\tm\u0006d\u0017\u000eZ1uKR\u0019Q)a1\t\u000f\u0005\u00157\u00041\u0001\u0002H\u0006y!/Z9vKN$X*\u001a;bI\u0006$\u0018\r\u0005\u0003\u0002J\u0006=g\u0002BA.\u0003\u0017LA!!4\u0002^\u0005\t\u0012\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=\n\t\u0005E\u00171\u001b\u0002\u0010%\u0016\fX/Z:u\u001b\u0016$\u0018\rZ1uC*!\u0011QZA/\u0003\u0015\u0019Gn\\:f\u0001")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private AdminClient client = null;
    private final int brokerCount;

    public AdminClient client() {
        return this.client;
    }

    public void client_$eq(AdminClient x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.brokerList())}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14());
        configs.foreach((Function1 & Serializable & scala.Serializable)props -> props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class));
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        AdminClientIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        AdminClientIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq(AdminClient.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4());
        List topicConfigEntries1 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2")}))).asJava();
        List topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.8")}))).asJava();
        List topicConfigEntries3 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "-1")}))).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.boxToInteger((int)((KafkaServer)this.servers().head()).config().brokerId())).toString());
        List brokerConfigEntries = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313")}))).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136))).getCause() instanceof InvalidRequestException));
        DescribeConfigsResult describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        java.util.Map configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.7")}))).asJava();
        alterResult.elem = this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163))).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165))).getCause() instanceof InvalidRequestException));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Void)((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("AdminClientWithPoliciesIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166))).getCause() instanceof InvalidRequestException));
        describeResult = this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava());
        configs = (java.util.Map)describeResult.all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToDouble((double)Defaults$.MODULE$.LogCleanerMinCleanRatio())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.MinInSyncReplicas())).toString(), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assert.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this.configs_$eq(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(configs).asScala()).toMap(Predef$.MODULE$.$conforms()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable & scala.Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(!this.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(requestMetadata.resource().name())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "resource name should not be empty");
            Predef$.MODULE$.require(requestMetadata.resource().name().contains("topic"));
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

