/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.ConsumerBounceTest$;
import kafka.api.FixedPortTestUtils$;
import kafka.cluster.Replica;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001\u0002\u00180\u0001QBQa\u0010\u0001\u0005\u0002\u0001CqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u00021\u0001A\u0003%a\u000bC\u0004b\u0001\t\u0007I\u0011\u00012\t\r=\u0004\u0001\u0015!\u0003d\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017A\u0011\"a\b\u0001#\u0003%I!!\t\t\u000f\u0005]\u0002\u0001\"\u0011\u0002:!9\u00111\u000b\u0001\u0005\u0002\u0005e\u0002bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003[\u0002A\u0011AA\u001d\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!a\u001e\u0001\t\u0003\tI\u0004C\u0004\u0002|\u0001!\t!!\u000f\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\"9\u00111\u0012\u0001\u0005\n\u00055\u0005bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003C\u0003A\u0011BAR\u0011\u001d\ty\u000b\u0001C\u0001\u0003sAq!a-\u0001\t\u0003\tI\u0004C\u0004\u00028\u0002!\t!!\u000f\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011q\u001b\u0001\u0005\n\u0005e\u0007b\u0002B\u0003\u0001\u0011%!q\u0001\u0005\n\u0005#\u0001\u0011\u0013!C\u0005\u0005'AqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003<\u0001!IA!\u0010\u0007\r\t\u0015\u0003\u0001\u0002B$\u0011%\tY'\tBC\u0002\u0013\u00051\tC\u0005\u0003P\u0005\u0012\t\u0011)A\u0005\t\"1q(\tC\u0001\u0005#B\u0001Ba\u0016\"\u0001\u0004%\ta\u0011\u0005\n\u00053\n\u0003\u0019!C\u0001\u00057BqA!\u0019\"A\u0003&A\tC\u0004\u0003d\u0005\"\t%!\u000f\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!I!\u0011\u0013\u0001\u0012\u0002\u0013%!1\u0013\u0005\b\u0005/\u0003A\u0011\u0002BM\u0011%\u0011\t\fAI\u0001\n\u0013\t\t\u0003C\u0005\u00034\u0002\t\n\u0011\"\u0003\u00036\n\u00112i\u001c8tk6,'OQ8v]\u000e,G+Z:u\u0015\t\u0001\u0014'A\u0002ba&T\u0011AM\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001Q'\u000f\t\u0003m]j\u0011aL\u0005\u0003q=\u0012A#\u00112tiJ\f7\r^\"p]N,X.\u001a:UKN$\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f2\u0003\u0015)H/\u001b7t\u0013\tq4HA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\t\u0005C\u0001\u001c\u0001\u00031i\u0017\r_$s_V\u00048+\u001b>f+\u0005!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%aA%oi\u0006iQ.\u0019=He>,\boU5{K\u0002\n1c\u001a:bG\u00164W\u000f\\\"m_N,G+[7f\u001bN,\u0012!\u0014\t\u0004\u000b:\u0003\u0016BA(G\u0005\u0011\u0019v.\\3\u0011\u0005\u0015\u000b\u0016B\u0001*G\u0005\u0011auN\\4\u0002)\u001d\u0014\u0018mY3gk2\u001cEn\\:f)&lW-T:!\u0003!)\u00070Z2vi>\u0014X#\u0001,\u0011\u0005]sV\"\u0001-\u000b\u0005eS\u0016AC2p]\u000e,(O]3oi*\u00111\fX\u0001\u0005kRLGNC\u0001^\u0003\u0011Q\u0017M^1\n\u0005}C&\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006IQ\r_3dkR|'\u000fI\u0001\u0010G>t7/^7feB{G\u000e\\3sgV\t1\rE\u0002eS.l\u0011!\u001a\u0006\u0003M\u001e\fq!\\;uC\ndWM\u0003\u0002i\r\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005),'A\u0002\"vM\u001a,'\u000f\u0005\u0002m[6\t\u0001!\u0003\u0002oo\tA2i\u001c8tk6,'/Q:tS\u001etW.\u001a8u!>dG.\u001a:\u0002!\r|gn];nKJ\u0004v\u000e\u001c7feN\u0004\u0013aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003I\u00042a]>\u007f\u001d\t!\u0018P\u0004\u0002vq6\taO\u0003\u0002xg\u00051AH]8pizJ\u0011aR\u0005\u0003u\u001a\u000bq\u0001]1dW\u0006<W-\u0003\u0002}{\n\u00191+Z9\u000b\u0005i4\u0005cA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007\t\u0014AB:feZ,'/\u0003\u0003\u0002\b\u0005\u0005!aC&bM.\f7i\u001c8gS\u001e\fAcZ3oKJ\fG/Z&bM.\f7i\u001c8gS\u001e\u001cHc\u0001:\u0002\u000e!A!i\u0003I\u0001\u0002\u0004\ty\u0001\u0005\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003+\u0001\"!\u001e$\n\u0007\u0005]a)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/1\u0015AH4f]\u0016\u0014\u0018\r^3LC\u001a\\\u0017mQ8oM&<7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019C\u000b\u0003\u0002\u0010\u0005\u00152FAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Eb)\u0001\u0006b]:|G/\u0019;j_:LA!!\u000e\u0002,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0011Q,\u0017M\u001d#po:$\"!a\u000f\u0011\u0007\u0015\u000bi$C\u0002\u0002@\u0019\u0013A!\u00168ji\"\u001aQ\"a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005)!.\u001e8ji*\u0011\u0011QJ\u0001\u0004_J<\u0017\u0002BA)\u0003\u000f\u0012Q!\u00114uKJ\f\u0011\u0005^3ti\u000e{gn];naRLwN\\,ji\"\u0014%o\\6fe\u001a\u000b\u0017\u000e\\;sKND3ADA,!\u0011\t)%!\u0017\n\t\u0005m\u0013q\t\u0002\u0007\u0013\u001etwN]3)\u00079\ty\u0006\u0005\u0003\u0002F\u0005\u0005\u0014\u0002BA2\u0003\u000f\u0012A\u0001V3ti\u0006I2m\u001c8tk6,w+\u001b;i\u0005J|7.\u001a:GC&dWO]3t)\u0011\tY$!\u001b\t\r\u0005-t\u00021\u0001E\u0003!qW/\\%uKJ\u001c\u0018a\t;fgR\u001cV-Z6B]\u0012\u001cu.\\7ji^KG\u000f\u001b\"s_.,'OR1jYV\u0014Xm\u001d\u0015\u0004!\u0005}\u0013aH:fK.\fe\u000eZ\"p[6LGoV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fgR!\u00111HA;\u0011\u0019\tY'\u0005a\u0001\t\u0006\tC/Z:u'V\u00147o\u0019:jE\u0016<\u0006.\u001a8U_BL7-\u00168bm\u0006LG.\u00192mK\"\u001a!#a\u0018\u0002\u0013Q,7\u000f^\"m_N,\u0007fA\n\u0002`\u0005\u00112\r[3dW\u000ecwn]3H_>$\u0007+\u0019;i)\u0019\tY$a!\u0002\b\"1\u0011Q\u0011\u000bA\u0002\u0011\u000b!B\\;n%\u0016\u001cwN\u001d3t\u0011\u001d\tI\t\u0006a\u0001\u0003\u001f\tqa\u001a:pkBLE-\u0001\u0011dQ\u0016\u001c7n\u00117pg\u0016<\u0016\u000e\u001e5D_>\u0014H-\u001b8bi>\u0014h)Y5mkJ,G\u0003CA\u001e\u0003\u001f\u000b\t*!&\t\r\u0005\u0015U\u00031\u0001E\u0011\u001d\t\u0019*\u0006a\u0001\u0003\u001f\tA\u0002Z=oC6L7m\u0012:pkBDq!a&\u0016\u0001\u0004\ty!A\u0006nC:,\u0018\r\\$s_V\u0004\u0018a\u00044j]\u0012\u001cun\u001c:eS:\fGo\u001c:\u0015\u0007\u0011\u000bi\nC\u0004\u0002 Z\u0001\r!a\u0004\u0002\u000b\u001d\u0014x.\u001e9\u00029\rDWmY6DY>\u001cXmV5uQ\u000ecWo\u001d;fe\u001a\u000b\u0017\u000e\\;sKRA\u00111HAS\u0003O\u000bY\u000b\u0003\u0004\u0002\u0006^\u0001\r\u0001\u0012\u0005\b\u0003S;\u0002\u0019AA\b\u0003\u00199'o\\;qc!9\u0011QV\fA\u0002\u0005=\u0011AB4s_V\u0004('\u0001$uKN$(k\u001c7mS:<'I]8lKJ\u0014Vm\u001d;beR\u001cx+\u001b;i'6\fG\u000e\\3s\u001b\u0006DxI]8vaNK'0Z\"p]\u001aLw\rR5teV\u0004Ho\u001d\"jO\u001e\u0013x.\u001e9)\u0007a\ty&\u0001\u001duKN$8i\u001c8tk6,'OU3dK&4Xm\u001d$bi\u0006dW\t_2faRLwN\\,iK:<%o\\;q!\u0006\u001c8/Z:NCb\u001c\u0016N_3)\u0007e\ty&\u0001\ruKN$8\t\\8tK\u0012+(/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D3AGA0\u0003e\u0019\u0007.Z2l\u00072|7/\u001a#ve&twMU3cC2\fgnY3\u0015\u0015\u0005m\u0012qXAa\u0003\u000b\fi\rC\u0004\u0002\nn\u0001\r!a\u0004\t\u000f\u0005\r7\u00041\u0001\u0002\u0010\u0005)Ao\u001c9jG\"1Ak\u0007a\u0001\u0003\u000f\u00042aVAe\u0013\r\tY\r\u0017\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\"9\u0011qZ\u000eA\u0002\u0005E\u0017a\u00072s_.,'o]!wC&d\u0017M\u00197f\tV\u0014\u0018N\\4DY>\u001cX\rE\u0002F\u0003'L1!!6G\u0005\u001d\u0011un\u001c7fC:\f\u0001d\u0019:fCR,7i\u001c8tk6,'/\u00118e%\u0016\u001cW-\u001b<f)!\tY.!@\u0002\u0000\n\r\u0001\u0003CAo\u0003[\f\t0!=\u000e\u0005\u0005}'\u0002BAq\u0003G\f\u0001bY8ogVlWM\u001d\u0006\u0005\u0003K\f9/A\u0004dY&,g\u000e^:\u000b\u0007I\nIO\u0003\u0003\u0002l\u0006-\u0013AB1qC\u000eDW-\u0003\u0003\u0002p\u0006}'!D&bM.\f7i\u001c8tk6,'\u000fE\u0003F\u0003g\f90C\u0002\u0002v\u001a\u0013Q!\u0011:sCf\u00042!RA}\u0013\r\tYP\u0012\u0002\u0005\u0005f$X\rC\u0004\u0002\nr\u0001\r!a\u0004\t\u000f\t\u0005A\u00041\u0001\u0002R\u0006aQ.\u00198vC2\f5o]5h]\"1\u0011Q\u0011\u000fA\u0002\u0011\u000b1C]3dK&4X-\u0012=bGR\u0014VmY8sIN$\u0002\"a\u000f\u0003\n\t-!Q\u0002\u0005\u0007\u0003Cl\u0002\u0019A6\t\r\u0005\u0015U\u00041\u0001E\u0011!\u0011y!\bI\u0001\u0002\u0004\u0001\u0016!\u0003;j[\u0016|W\u000f^'t\u0003u\u0011XmY3jm\u0016,\u00050Y2u%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u000bU\r\u0001\u0016QE\u0001\u0017gV\u0014W.\u001b;DY>\u001cX-\u00118e-\u0006d\u0017\u000eZ1uKRQ!1\u0004B\u0014\u0005S\u0011iCa\u000e\u0011\u000b]\u0013iB!\t\n\u0007\t}\u0001L\u0001\u0004GkR,(/\u001a\t\u0004\u000b\n\r\u0012b\u0001B\u0013\r\n\u0019\u0011I\\=\t\u000f\u0005\u0005x\u00041\u0001\u0002\\\"1!1F\u0010A\u0002A\u000bab\u00197pg\u0016$\u0016.\\3pkRl5\u000fC\u0004\u00030}\u0001\rA!\r\u0002\u001d5Lgn\u00117pg\u0016$\u0016.\\3NgB!QIa\rQ\u0013\r\u0011)D\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\ter\u00041\u0001\u00032\u0005qQ.\u0019=DY>\u001cX\rV5nK6\u001b\u0018\u0001E2iK\u000e\\7\t\\8tK\u0012\u001cF/\u0019;f)\u0019\tYDa\u0010\u0003B!9\u0011\u0011\u0012\u0011A\u0002\u0005=\u0001B\u0002B\"A\u0001\u0007A)\u0001\td_6l\u0017\u000e\u001e;fIJ+7m\u001c:eg\n)\"i\\;oG\u0016\u0014%o\\6feN\u001b\u0007.\u001a3vY\u0016\u00148cA\u0011\u0003JA\u0019!Ha\u0013\n\u0007\t53H\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017!\u00038v[&#XM]:!)\u0011\u0011\u0019F!\u0016\u0011\u00051\f\u0003BBA6I\u0001\u0007A)\u0001\u0003ji\u0016\u0014\u0018\u0001C5uKJ|F%Z9\u0015\t\u0005m\"Q\f\u0005\t\u0005?2\u0013\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\u0002\u000b%$XM\u001d\u0011\u0002\r\u0011|wk\u001c:l\u0003U\u0019'/Z1uKR{\u0007/[2QCJ$\u0018\u000e^5p]N$\"B!\u001b\u0003|\tu$\u0011\u0011BC!\u0019\t\tBa\u001b\u0003p%!!QNA\u000f\u0005\r\u0019V\r\u001e\t\u0005\u0005c\u00129(\u0004\u0002\u0003t)!!QOAt\u0003\u0019\u0019w.\\7p]&!!\u0011\u0010B:\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a1*\u0001\u0004\ty\u0001\u0003\u0004\u0003\u0000%\u0002\r\u0001R\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\r\t\r\u0015\u00061\u0001E\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\n\u0005\u000fK\u0003\u0013!a\u0001\u0005\u0013\u000b1\u0002^8qS\u000e\u001cuN\u001c4jOB!!1\u0012BG\u001b\u0005Q\u0016b\u0001BH5\nQ\u0001K]8qKJ$\u0018.Z:\u0002?\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)beRLG/[8og\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u0016*\"!\u0011RA\u0013\u0003-\u0019XM\u001c3SK\u000e|'\u000fZ:\u0015\u0015\u0005m\"1\u0014BU\u0005W\u0013i\u000bC\u0004\u0003\u001e.\u0002\rAa(\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002B!)\u0003&\u0006E\u0018\u0011_\u0007\u0003\u0005GSAA!(\u0002d&!!q\u0015BR\u00055Y\u0015MZ6b!J|G-^2fe\"1\u0011QQ\u0016A\u0002\u0011C\u0011\"a1,!\u0003\u0005\r!a\u0004\t\u0013\t}4\u0006%AA\u0002\t=\u0006\u0003B#\u00034\u0011\u000bQc]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$3'A\u000btK:$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t]&\u0006\u0002BX\u0003K\u0001")
public class ConsumerBounceTest
extends AbstractConsumerTest {
    private final int maxGroupSize;
    private final Some<Object> gracefulCloseTimeMs = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public Some<Object> gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers() {
        return this.consumerPollers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.GroupMaxSizeProp(), maxGroupSize);
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), false, FixedPortTestUtils$.MODULE$.createBrokerConfigs$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, properties), Seq$.MODULE$.canBuildFrom());
    }

    private String generateKafkaConfigs$default$1() {
        return ((Object)BoxesRunTime.boxToInteger((int)this.maxGroupSize())).toString();
    }

    @Override
    @After
    public void tearDown() {
        try {
            this.consumerPollers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            this.executor().shutdownNow();
            Assert.assertTrue((String)"Executor did not terminate", (boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS));
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Ignore
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala());
            records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$1(consumed, record);
                return BoxedUnit.UNIT;
            });
            if (!records.nonEmpty()) continue;
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$2(this, numRecords, server))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for followers after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Seeking to end of log");
                consumer.seekToEnd(Collections.emptyList());
                Assert.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Seeking to ").append(pos).toString());
                consumer.seek(this.tp(), pos);
                Assert.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Committing offset.");
            consumer.commitSync();
            Assert.assertEquals((long)consumer.position(this.tp()), (long)consumer.committed(this.tp()).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.brokerCount(), this.$outer.brokerCount(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(Duration.ZERO);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AbstractConsumerTest.ConsumerAssignmentPoller poller = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        this.consumerPollers().$plus$eq((Object)poller);
        poller.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
        poller.shutdown();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers();
        AbstractConsumerTest.ConsumerAssignmentPoller poller2 = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)newtopic, (List)Nil$.MODULE$));
        this.consumerPollers().$plus$eq((Object)poller2);
        poller2.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, this.sendRecords$default$3(), this.sendRecords$default$4());
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        Future<Object> future = this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        future.get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        future1.get();
        future2.get();
        this.restartDeadBrokers();
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setKey(group)).build();
        IntRef nodeId = IntRef.create((int)-1);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer resp = this.connectAndSend((AbstractRequest)request, ApiKeys.FIND_COORDINATOR, this.connectAndSend$default$3(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
            FindCoordinatorResponse response = FindCoordinatorResponse.parse((ByteBuffer)resp, (short)ApiKeys.FIND_COORDINATOR.latestVersion());
            nodeId$1.elem = response.node().id();
            Errors errors = response.error();
            Errors errors2 = Errors.NONE;
            return !(errors != null ? !errors.equals(errors2) : errors2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Failed to find coordinator for group ").append(group).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        return nodeId.elem;
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)requestTimeout)).toString());
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup() {
        String group = "group-max-size-test";
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        int partitionCount = consumerCount * 2;
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        Set<TopicPartition> partitions = this.createTopicPartitions(topic, partitionCount, this.brokerCount(), this.createTopicPartitions$default$4());
        this.addConsumersToGroupAndWaitForGroupAssignment(consumerCount, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(((Object)BoxesRunTime.boxToInteger((int)maxGroupSize)).toString());
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)serverIdx -> {
            this.killBroker(serverIdx);
            KafkaConfig config = (KafkaConfig)newConfigs.apply(serverIdx);
            this.servers().update(serverIdx, (Object)TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId())));
            this.restartDeadBrokers();
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.raisedExceptions$1().nonEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The remaining consumers in the group could not fetch the expected records", 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertEquals((long)1L, (long)this.raisedExceptions$1().size());
        Assert.assertTrue((boolean)(this.raisedExceptions$1().head() instanceof GroupMaxSizeReachedException));
    }

    @Test
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize() {
        Buffer rejectedConsumerPollers;
        String group = "fatal-exception-test";
        String topic = "fatal-exception-test";
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        Set<TopicPartition> partitions = this.createTopicPartitions(topic, this.maxGroupSize(), this.brokerCount(), this.createTopicPartitions$default$4());
        this.addConsumersToGroupAndWaitForGroupAssignment(this.maxGroupSize(), (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.addConsumersToGroup(1, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)((Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$)), (List<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), partitions, group);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Buffer buffer = rejectedConsumerPollers = (Buffer)tuple2._2();
        Buffer rejectedConsumerPollers2 = buffer;
        AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer = (AbstractConsumerTest.ConsumerAssignmentPoller)((Object)rejectedConsumerPollers2.head());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rejectedConsumer.thrownException().isDefined(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Extra consumer did not throw an exception", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Assert.assertTrue((boolean)(rejectedConsumer.thrownException().get() instanceof GroupMaxSizeReachedException));
        this.sendRecords(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()), this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitions.size())));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.consumerPollers().forall((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(p))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The consumers in the group could not fetch the expected records", 10000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.brokerCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, ConsumerBounceTest.subscribeAndPoll$default$2$1(), executor, topic), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[0]));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, ConsumerBounceTest.subscribeAndPoll$default$2$1(), executor, topic), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, executor, topic);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, executor, topic);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller = manualAssign ? this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)Nil$.MODULE$, (Set<TopicPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})))) : this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$), this.subscribeConsumerAndStartPolling$default$3());
        this.receiveExactRecords(consumerPoller, numRecords, this.receiveExactRecords$default$3());
        consumerPoller.shutdown();
        return consumer;
    }

    private void receiveExactRecords(AbstractConsumerTest.ConsumerAssignmentPoller consumer, int numRecords, long timeoutMs) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> consumer.receivedMessages() == numRecords, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Consumer did not receive expected ").append(numRecords).append(". It received ").append(consumer.receivedMessages()).toString(), timeoutMs, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int closeGraceTimeMs = 2000;
            long startNanos = System.nanoTime();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Closing consumer with timeout ").append(closeTimeoutMs).append(" ms.").toString());
            consumer.close(Duration.ofMillis(closeTimeoutMs));
            long timeTakenMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            maxCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assert.assertTrue((String)new StringBuilder(20).append("Close took too long ").append(timeTakenMs).toString(), (timeTakenMs < ms + (long)closeGraceTimeMs ? 1 : 0) != 0));
            minCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)ms -> Assert.assertTrue((String)new StringBuilder(27).append("Close finished too quickly ").append(timeTakenMs).toString(), (timeTakenMs >= ms ? 1 : 0) != 0));
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("consumer.close() completed in ").append(timeTakenMs).append(" ms.").toString());
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        consumer.poll(Duration.ofSeconds(3L));
        Assert.assertTrue((String)"Assignment did not complete on time", (boolean)assignSemaphore.tryAcquire(1L, TimeUnit.SECONDS));
        if (committedRecords > 0) {
            Assert.assertEquals((long)committedRecords, (long)consumer.committed(this.tp()).offset());
        }
        consumer.close();
    }

    private Set<TopicPartition> createTopicPartitions(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        this.createTopic(topic, numPartitions, replicationFactor, topicConfig);
        return ((TraversableOnce)package$.MODULE$.Range().apply(0, numPartitions).map((Function1 & Serializable & scala.Serializable)part -> ConsumerBounceTest.$anonfun$createTopicPartitions$1(topic, BoxesRunTime.unboxToInt((Object)part)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
    }

    private Properties createTopicPartitions$default$4() {
        return new Properties();
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        IntRef partitionIndex = IntRef.create((int)0);
        IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.getPartition$1(numPartitions, partitionIndex)), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes())), IndexedSeq$.MODULE$.canBuildFrom());
        futures.map((Function1 & Serializable & scala.Serializable)x$4 -> (RecordMetadata)x$4.get(), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private String sendRecords$default$3() {
        return this.topic();
    }

    private Option<Object> sendRecords$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$1(LongRef consumed$1, ConsumerRecord record) {
        Assert.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$2(ConsumerBounceTest $this, int numRecords$1, KafkaServer server) {
        return ((Replica)server.replicaManager().localReplica($this.tp()).get()).highWatermark().messageOffset() == (long)numRecords$1;
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
        }
        catch (Exception exception) {}
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$1) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            IndexedSeq futures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1 & Serializable & scala.Serializable)i -> producer$1.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.part()), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes(), (Object)((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString().getBytes())), IndexedSeq$.MODULE$.canBuildFrom());
            futures.map((Function1 & Serializable & scala.Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            }, IndexedSeq$.MODULE$.canBuildFrom());
        }
        Assert.assertEquals((long)0L, (long)remainingRecords.elem);
    }

    private final Seq raisedExceptions$1() {
        return (Seq)this.consumerPollers().flatten((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(x$3.thrownException()));
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(AbstractConsumerTest.ConsumerAssignmentPoller p) {
        return p.receivedMessages() >= 100;
    }

    private static final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, ExecutorService executor$1, String topic$2) {
        return executor$1.submit(CoreUtils$.MODULE$.runnable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            consumer.subscribe(Collections.singletonList(topic$2), new ConsumerRebalanceListener(null, revokeSemaphore){
                private final Option revokeSemaphore$1;

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.revokeSemaphore$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
                        $anon$2.$anonfun$onPartitionsRevoked$1(s);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$onPartitionsRevoked$1(Semaphore s) {
                    s.release();
                }
                {
                    this.revokeSemaphore$1 = revokeSemaphore$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onPartitionsRevoked$1$adapted(java.util.concurrent.Semaphore )}, serializedLambda);
                }
            });
            consumer.poll(0L);
        }), BoxesRunTime.boxToInteger((int)0));
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable & scala.Serializable)consumer -> consumer.poll(Duration.ofMillis(100L)));
        }
        Assert.assertTrue((String)"Rebalance did not complete in time", (boolean)future.isDone());
    }

    private final Future createConsumerToRebalance$1(String groupId$1, ExecutorService executor$1, String topic$2) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), executor$1, topic$2);
        Assert.assertTrue((String)"Rebalance not triggered", (boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((String)"Rebalance completed too early", (boolean)future.isDone());
        return future;
    }

    public static final /* synthetic */ TopicPartition $anonfun$createTopicPartitions$1(String topic$3, int part) {
        return new TopicPartition(topic$3, part);
    }

    private final int getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        int n;
        Option option = numPartitions$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            int partitions = BoxesRunTime.unboxToInt((Object)some.value());
            int nextPart = partitionIndex$1.elem % partitions;
            ++partitionIndex$1.elem;
            n = nextPart;
        } else if (None$.MODULE$.equals(option)) {
            n = this.part();
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    public ConsumerBounceTest() {
        this.maxGroupSize = 5;
        this.consumerConfig().setProperty("enable.auto.commit", "true");
    }

    public class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers();
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
            } else {
                Thread.sleep(500L);
            }
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

