/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.ZkReplicaStateMachine;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001\u0002'N\u0001ICQ!\u0017\u0001\u0005\u0002iCq!\u0018\u0001A\u0002\u0013%a\fC\u0004c\u0001\u0001\u0007I\u0011B2\t\r%\u0004\u0001\u0015)\u0003`\u0011\u001dQ\u0007\u00011A\u0005\n-DqA\u001d\u0001A\u0002\u0013%1\u000f\u0003\u0004v\u0001\u0001\u0006K\u0001\u001c\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0011\u001dY\b\u00011A\u0005\nqDaA \u0001!B\u0013A\b\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u0013\u0005%\u0001\u00011A\u0005\n\u0005-\u0001\u0002CA\b\u0001\u0001\u0006K!a\u0001\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u000e\u0001\u0001\u0006I!!\u0006\t\u0013\u0005u\u0001A1A\u0005\n\u0005}\u0001\u0002CA\u0017\u0001\u0001\u0006I!!\t\t\u0013\u0005=\u0002A1A\u0005\n\u0005M\u0001\u0002CA\u0019\u0001\u0001\u0006I!!\u0006\t\u0013\u0005M\u0002A1A\u0005\n\u0005U\u0002\u0002CA'\u0001\u0001\u0006I!a\u000e\t\u0013\u0005=\u0003A1A\u0005\n\u0005E\u0003\u0002CA0\u0001\u0001\u0006I!a\u0015\t\u0013\u0005\u0005\u0004A1A\u0005\n\u0005\r\u0004\u0002CA6\u0001\u0001\u0006I!!\u001a\t\u0013\u00055\u0004A1A\u0005\n\u0005=\u0004\u0002CA:\u0001\u0001\u0006I!!\u001d\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011q\u0011\u0001\u0005\n\u0005%\u0005bBAJ\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003;\u0003A\u0011AA<\u0011\u001d\t\t\u000b\u0001C\u0001\u0003oBq!!*\u0001\t\u0003\t9\bC\u0004\u0002*\u0002!\t!a\u001e\t\u000f\u00055\u0006\u0001\"\u0001\u0002x!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005]\u0004bBA[\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003s\u0003A\u0011AA<\u0011\u001d\ti\f\u0001C\u0001\u0003oBq!!1\u0001\t\u0003\t9\bC\u0004\u0002F\u0002!\t!a\u001e\t\u000f\u0005%\u0007\u0001\"\u0001\u0002x!9\u0011Q\u001a\u0001\u0005\u0002\u0005]\u0004bBAi\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003+\u0004A\u0011AA<\u0011\u001d\tI\u000e\u0001C\u0001\u0003oBq!!8\u0001\t\u0003\t9\bC\u0004\u0002b\u0002!\t!a\u001e\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002x!9\u0011\u0011\u001e\u0001\u0005\u0002\u0005]\u0004bBAw\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003c\u0004A\u0011AA<\u0011\u001d\t)\u0010\u0001C\u0001\u0003oBq!!?\u0001\t\u0003\t9\bC\u0004\u0002~\u0002!\t!a\u001e\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002x!9!Q\u0001\u0001\u0005\u0002\u0005]\u0004b\u0002B\u0005\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0005\u001b\u0001A\u0011AA<\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003oBqA!\u0006\u0001\t\u0003\t9\bC\u0004\u0003\u001a\u0001!\t!a\u001e\t\u000f\tu\u0001\u0001\"\u0001\u0002x!9!\u0011\u0005\u0001\u0005\u0002\u0005]\u0004b\u0002B\u0013\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0005S\u0001A\u0011AA<\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003oBqA!\r\u0001\t\u0003\t9\bC\u0004\u00036\u0001!\t!a\u001e\t\u000f\te\u0002\u0001\"\u0001\u0002x!9!Q\b\u0001\u0005\u0002\u0005]\u0004b\u0002B!\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0005\u000b\u0002A\u0011AA<\u0011\u001d\u0011I\u0005\u0001C\u0001\u0003oBqA!\u0014\u0001\t\u0013\u0011yEA\fSKBd\u0017nY1Ti\u0006$X-T1dQ&tW\rV3ti*\u0011ajT\u0001\u000bG>tGO]8mY\u0016\u0014(\"\u0001)\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0015\t\u0003)^k\u0011!\u0016\u0006\u0002-\u0006)1oY1mC&\u0011\u0001,\u0016\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0006C\u0001/\u0001\u001b\u0005i\u0015!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiV\tq\f\u0005\u0002]A&\u0011\u0011-\u0014\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\u0018!F2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi~#S-\u001d\u000b\u0003I\u001e\u0004\"\u0001V3\n\u0005\u0019,&\u0001B+oSRDq\u0001[\u0002\u0002\u0002\u0003\u0007q,A\u0002yIE\n!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA\u0005aQn\\2l5.\u001cE.[3oiV\tA\u000e\u0005\u0002na6\taN\u0003\u0002p\u001f\u0006\u0011!p[\u0005\u0003c:\u0014QbS1gW\u0006T6n\u00117jK:$\u0018\u0001E7pG.T6n\u00117jK:$x\fJ3r)\t!G\u000fC\u0004i\r\u0005\u0005\t\u0019\u00017\u0002\u001b5|7m\u001b.l\u00072LWM\u001c;!\u0003\u0001jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\u0016\u0003a\u0004\"\u0001X=\n\u0005il%\u0001H\"p]R\u0014x\u000e\u001c7fe\n\u0013xn[3s%\u0016\fX/Z:u\u0005\u0006$8\r[\u0001%[>\u001c7nQ8oiJ|G\u000e\\3s\u0005J|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007n\u0018\u0013fcR\u0011A- \u0005\bQ&\t\t\u00111\u0001y\u0003\u0005jwnY6D_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195!\u0003M\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f+\t\t\u0019\u0001E\u0002]\u0003\u000bI1!a\u0002N\u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0003]\u0011X\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f?\u0012*\u0017\u000fF\u0002e\u0003\u001bA\u0001\u0002\u001b\u0007\u0002\u0002\u0003\u0007\u00111A\u0001\u0015e\u0016\u0004H.[2b'R\fG/Z'bG\"Lg.\u001a\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\"!!\u0006\u0011\u0007Q\u000b9\"C\u0002\u0002\u001aU\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003Oy\u0015AB:feZ,'/\u0003\u0003\u0002,\u0005\u0015\"aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0003A\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u0011q\u0007\t\u0005\u0003s\tI%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0019\u0019w.\\7p]*\u0019\u0001+!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u001d\u0013aA8sO&!\u00111JA\u001e\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f!\u0002]1si&$\u0018n\u001c8!\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003'\u0002b!!\u0016\u0002\\\u0005]RBAA,\u0015\r\tI&V\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA/\u0003/\u00121aU3r\u0003-\u0001\u0018M\u001d;ji&|gn\u001d\u0011\u0002\u000fI,\u0007\u000f\\5dCV\u0011\u0011Q\r\t\u00049\u0006\u001d\u0014bAA5\u001b\n\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\u0006A!/\u001a9mS\u000e\f\u0007%\u0001\u0005sKBd\u0017nY1t+\t\t\t\b\u0005\u0004\u0002V\u0005m\u0013QM\u0001\ne\u0016\u0004H.[2bg\u0002\nQa]3u+B$\u0012\u0001\u001a\u0015\u00049\u0005m\u0004\u0003BA?\u0003\u0007k!!a \u000b\t\u0005\u0005\u0015QI\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u000b\u000byH\u0001\u0004CK\u001a|'/Z\u0001\re\u0016\u0004H.[2b'R\fG/\u001a\u000b\u0005\u0003\u0017\u000b\t\nE\u0002]\u0003\u001bK1!a$N\u00051\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u0011\u001d\t\t'\ba\u0001\u0003K\n!\u0004^3tiN#\u0018M\u001d;va>sG.\u001b8f!\u0006\u0014H/\u001b;j_:D3AHAL!\u0011\ti(!'\n\t\u0005m\u0015q\u0010\u0002\u0005)\u0016\u001cH/A\u000euKN$8\u000b^1siV\u0004xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c\u0015\u0004?\u0005]\u0015a\t;fgR\u001cF/\u0019:ukB<\u0016\u000e\u001e5SKBd\u0017nY1XSRDw.\u001e;MK\u0006$WM\u001d\u0015\u0004A\u0005]\u0015\u0001\f;fgRtuN\\3ySN$XM\u001c;SKBd\u0017nY1U_:+wOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r\t\u0013qS\u00017i\u0016\u001cH/\u00138wC2LGMT8oKbL7\u000f^3oiJ+\u0007\u000f\\5dCR{wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004E\u0005]\u0015a\u000e;fgRLeN^1mS\u0012tuN\\3ySN$XM\u001c;SKBd\u0017nY1U_>3g\r\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002$\u0003/\u000bq\b^3ti&sg/\u00197jI:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR\u0013\u0018M\\:ji&|g\u000eK\u0002%\u0003/\u000b!\t^3ti&sg/\u00197jI:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\r\u0016:b]NLG/[8oQ\r)\u0013qS\u0001Ci\u0016\u001cH/\u00138wC2LGMT8oKbL7\u000f^3oiJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>t\u0007f\u0001\u0014\u0002\u0018\u0006\u0019D/Z:u\u0013:4\u0018\r\\5e\u001d\u0016<(+\u001a9mS\u000e\fGk\u001c(p]\u0016D\u0018n\u001d;f]R\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004O\u0005]\u0015a\n;fgRtUm\u001e*fa2L7-\u0019+p\u001f:d\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3\u0001KAL\u0003!\"Xm\u001d;OK^\u0014V\r\u001d7jG\u0006$vn\u00144gY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\rI\u0013qS\u00018i\u0016\u001cH/\u00138wC2LGMT3x%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$GK]1og&$\u0018n\u001c8)\u0007)\n9*\u0001\u001euKN$\u0018J\u001c<bY&$g*Z<SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:Le.\u001a7jO&\u0014G.\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a1&a&\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a(foJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>t\u0007f\u0001\u0017\u0002\u0018\u00061D/Z:u\u0013:4\u0018\r\\5e\u001f:d\u0017N\\3SKBd\u0017nY1U_:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001aQ&a&\u0002]Q,7\u000f^%om\u0006d\u0017\u000eZ(oY&tWMU3qY&\u001c\u0017\rV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004]\u0005]\u0015A\u000b;fgR|e\u000e\\5oKJ+\u0007\u000f\\5dCR{wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004_\u0005]\u0015a\u000b;fgR|e\u000e\\5oKJ+\u0007\u000f\\5dCR{wJ\u001a4mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007A\n9*\u0001\u001euKN$\u0018J\u001c<bY&$wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$vNU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011'a&\u0002{Q,7\u000f^%om\u0006d\u0017\u000eZ(oY&tWMU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,GK]1og&$\u0018n\u001c8)\u0007I\n9*A\u001fuKN$\u0018J\u001c<bY&$wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$vNU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000eK\u00024\u0003/\u000bq\u0007^3ti&sg/\u00197jI>3g\r\\5oKJ+\u0007\u000f\\5dCR{gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001\u001b\u0002\u0018\u0006yC/Z:u\u0013:4\u0018\r\\5e\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)>tUm\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001aQ'a&\u0002WQ,7\u000f^(gM2Lg.\u001a*fa2L7-\u0019+p\u001f:d\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3ANAL\u0003Q\"Xm\u001d;PM\u001ad\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$&/\u00198tSRLwN\u001c\u0015\u0004o\u0005]\u0015a\u000e;fgR|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$vNU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR\u0013\u0018M\\:ji&|g\u000eK\u00029\u0003/\u000ba\b^3ti&sg/\u00197jI>3g\r\\5oKJ+\u0007\u000f\\5dCR{'+\u001a9mS\u000e\fG)\u001a7fi&|gnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>t\u0007fA\u001d\u0002\u0018\u0006yD/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR{gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001\u001e\u0002\u0018\u00069D/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR{g*Z<SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3aOAL\u0003i\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)>|e\u000e\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u0002=\u0003/\u000b1\b^3ti&sg/\u00197jIJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cF/\u0019:uK\u0012$vn\u00144gY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\ri\u0014qS\u0001@i\u0016\u001cHOU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\r\u0016:b]NLG/[8oQ\rq\u0014qS\u0001@i\u0016\u001cHOU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N+8mY3tg\u001a,H\u000e\u0016:b]NLG/[8oQ\ry\u0014qS\u0001<i\u0016\u001cHOU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001!\u0002\u0018\u0006QD/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]N+8mY3tg\u001a,H\u000eV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004\u0003\u0006]\u0015!\u0010;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7U_>sG.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001\"\u0002\u0018\u0006qD/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]N+8mY3tg\u001a,H\u000eV8PM\u001ad\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3aQAL\u0003\u0019#Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3Ue\u0006t7/\u001b;j_:D3\u0001RAL\u0003%#Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'V\u001c7-Z:tMVdGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0004\u000b\u0006]\u0015A\u0011;fgRLeN^1mS\u0012\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3U_:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001aa)a&\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007fA$\u0002\u0018\u00061D/Z:u%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\rV8P]2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a\u0001*a&\u0002\rR,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$vNU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011*a&\u0002\u0013R,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$vNU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|g\u000eK\u0002K\u0003/\u000bQ\u0003^3ti&sg/\u00197jIR\u0013\u0018M\\:ji&|g\u000eF\u0003e\u0005#\u0012)\u0006C\u0004\u0003T-\u0003\r!a#\u0002\u0013\u0019\u0014x.\\*uCR,\u0007b\u0002B,\u0017\u0002\u0007\u00111R\u0001\bi>\u001cF/\u0019;f\u0001")
public class ReplicaStateMachineTest {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private ReplicaStateMachine replicaStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}));
    private final PartitionAndReplica replica = new PartitionAndReplica(this.partition(), this.brokerId());
    private final Seq<PartitionAndReplica> replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionAndReplica[]{this.replica()}));

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    private void replicaStateMachine_$eq(ReplicaStateMachine x$1) {
        this.replicaStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    private PartitionAndReplica replica() {
        return this.replica;
    }

    private Seq<PartitionAndReplica> replicas() {
        return this.replicas;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)EasyMock.createMock(ControllerBrokerRequestBatch.class));
        this.replicaStateMachine_$eq((ReplicaStateMachine)new ZkReplicaStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private ReplicaState replicaState(PartitionAndReplica replica) {
        return this.controllerContext().replicaState(replica);
    }

    @Test
    public void testStartupOnlinePartition() {
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map liveBrokerEpochs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(this.brokerId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint1})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokerAndEpochs(liveBrokerEpochs);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupOfflinePartition() {
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupWithReplicaWithoutLeader() {
        int shutdownBrokerId = 100;
        PartitionAndReplica offlineReplica = new PartitionAndReplica(this.partition(), shutdownBrokerId);
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map liveBrokerEpochs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(this.brokerId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint1})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokerAndEpochs(liveBrokerEpochs);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{shutdownBrokerId})));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)offlineReplica));
        this.replicaStateMachine().startup();
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(offlineReplica));
    }

    @Test
    public void testNonexistentReplicaToNewReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)NewReplica$.MODULE$);
        Assert.assertEquals((Object)NewReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOnlineReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOfflineReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionStartedTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionIneligibleTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionSuccessfulTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Assert.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testNewReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testNewReplicaToOfflineReplicaTransition() {
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        Map liveBrokerEpochs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Broker(this.brokerId(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint1})), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokerAndEpochs(liveBrokerEpochs);
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addUpdateMetadataRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (Set)EasyMock.eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}))));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOnlineReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOnlineReplicaToOfflineReplicaTransition() {
        int otherBrokerId = this.brokerId() + 1;
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}));
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)replicaIds);
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), replicaIds);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)EasyMock.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)EasyMock.eq((Object)this.partition()), EasyMock.eq((boolean)false));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        LeaderAndIsr adjustedLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = adjustedLeaderAndIsr.withZkVersion(adjustedLeaderAndIsr.zkVersion() + 1);
        LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch());
        EasyMock.expect((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GetDataResponse[]{new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L))})));
        EasyMock.expect((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)adjustedLeaderAndIsr)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).andReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)updatedLeaderAndIsr)})), (Seq)Seq$.MODULE$.empty(), Predef$.MODULE$.Map().empty()));
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), this.partition(), updatedLeaderIsrAndControllerEpoch, (Seq)replicaIds, false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)updatedLeaderIsrAndControllerEpoch, (Object)this.controllerContext().partitionLeadershipInfo().apply((Object)this.partition()));
        Assert.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOfflineReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionStartedTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), true);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)ReplicaDeletionStarted$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionSuccessfulTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Assert.assertEquals((Object)ReplicaDeletionSuccessful$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionSuccessfulToNonexistentReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)NonExistentReplica$.MODULE$);
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.controllerContext().partitionReplicaAssignment(this.partition()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionIneligibleToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        this.controllerContext().updatePartitionReplicaAssignment(this.partition(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().partitionLeadershipInfo().put((Object)this.partition(), (Object)leaderIsrAndControllerEpoch);
        this.mockControllerBrokerRequestBatch().newBatch();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), false);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.mockControllerBrokerRequestBatch().sendRequestsToBrokers(this.controllerEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        EasyMock.verify((Object[])new Object[]{this.mockZkClient(), this.mockControllerBrokerRequestBatch()});
        Assert.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    private void testInvalidTransition(ReplicaState fromState, ReplicaState toState) {
        this.controllerContext().putReplicaState(this.replica(), fromState);
        this.replicaStateMachine().handleStateChanges(this.replicas(), toState);
        Assert.assertEquals((Object)fromState, (Object)this.replicaState(this.replica()));
    }

    public ReplicaStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

