/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaType;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tmh\u0001\u0002 @\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004_\u0001\u0001\u0006I!\u0015\u0005\b?\u0002\u0011\r\u0011\"\u0003a\u0011\u0019!\u0007\u0001)A\u0005C\"9Q\r\u0001a\u0001\n\u00031\u0007b\u00026\u0001\u0001\u0004%\ta\u001b\u0005\u0007c\u0002\u0001\u000b\u0015B4\t\u000bI\u0004A\u0011A:\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u00111\u0003\u0001\u0005\n\u0005U\u0001\"CA1\u0001E\u0005I\u0011BA2\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!a-\u0001\t\u0013\t)\fC\u0004\u0002L\u0002!I!!4\t\u000f\t\u0005\u0005\u0001\"\u0001\u0002\u0004!9!1\u0012\u0001\u0005\u0002\u0005\r\u0001b\u0002BH\u0001\u0011\u0005\u00111\u0001\u0005\b\u0005'\u0003A\u0011AA\u0002\u0011\u001d\u00119\n\u0001C\u0001\u0003\u0007AqAa'\u0001\t\u0003\t\u0019\u0001C\u0004\u0003 \u0002!\t!a\u0001\t\u000f\t\r\u0006\u0001\"\u0001\u0002\u0004!9!q\u0015\u0001\u0005\u0002\u0005\r\u0001b\u0002BV\u0001\u0011\u0005\u00111\u0001\u0005\b\u0005_\u0003A\u0011AA\u0002\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005k3a!!7\u0001\t\u0006m\u0007BCAG9\tU\r\u0011\"\u0001\u0002j\"Q\u00111\u001e\u000f\u0003\u0012\u0003\u0006I!a$\t\u0015\u0005\u001dFD!f\u0001\n\u0003\tI\u000f\u0003\u0006\u0002nr\u0011\t\u0012)A\u0005\u0003\u001fC!\"a<\u001d\u0005+\u0007I\u0011AAy\u0011)\tI\u0010\bB\tB\u0003%\u00111\u001f\u0005\u000b\u0003wd\"Q3A\u0005\u0002\u0005E\bBCA\u007f9\tE\t\u0015!\u0003\u0002t\"11\n\bC\u0001\u0003\u007fDqA!\u0003\u001d\t\u0003\u0011Y\u0001C\u0005\u0003\u001eq\t\t\u0011\"\u0001\u0003 !I!\u0011\u0006\u000f\u0012\u0002\u0013\u0005!1\u0006\u0005\n\u0005_a\u0012\u0013!C\u0001\u0005WA\u0011B!\r\u001d#\u0003%\tAa\r\t\u0013\t]B$%A\u0005\u0002\tM\u0002\"\u0003B\u001d9\u0005\u0005I\u0011\tB\u001e\u0011!\u0011i\u0004HA\u0001\n\u00031\u0007\"\u0003B 9\u0005\u0005I\u0011\u0001B!\u0011%\u0011Y\u0005HA\u0001\n\u0003\u0012i\u0005C\u0005\u0003\\q\t\t\u0011\"\u0001\u0003^!I!q\r\u000f\u0002\u0002\u0013\u0005#\u0011\u000e\u0005\n\u0005Wb\u0012\u0011!C!\u0005[B\u0011Ba\u001c\u001d\u0003\u0003%\tE!\u001d\b\u0013\t\r\u0007!!A\t\n\t\u0015g!CAm\u0001\u0005\u0005\t\u0012\u0002Bd\u0011\u0019YU\u0007\"\u0001\u0003V\"I!1N\u001b\u0002\u0002\u0013\u0015#Q\u000e\u0005\n\u0005/,\u0014\u0011!CA\u00053D\u0011Ba96#\u0003%\tAa\r\t\u0013\t\u0015X'%A\u0005\u0002\tM\u0002\"\u0003Btk\u0005\u0005I\u0011\u0011Bu\u0011%\u001190NI\u0001\n\u0003\u0011\u0019\u0004C\u0005\u0003zV\n\n\u0011\"\u0001\u00034\t12\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002A\u0003\u000611/\u001a:wKJT\u0011AQ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\t\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0003\"A\u0014\u0001\u000e\u0003}\nA\u0001^5nKV\t\u0011\u000b\u0005\u0002S96\t1K\u0003\u0002U+\u0006)Q\u000f^5mg*\u0011akV\u0001\u0007G>lWn\u001c8\u000b\u0005\tC&BA-[\u0003\u0019\t\u0007/Y2iK*\t1,A\u0002pe\u001eL!!X*\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\naaY8oM&<W#A1\u0011\u00059\u0013\u0017BA2@\u0005a\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\bG>tg-[4!\u00031qW/\\\"bY2\u0014\u0017mY6t+\u00059\u0007C\u0001$i\u0013\tIwIA\u0002J]R\f\u0001C\\;n\u0007\u0006dGNY1dWN|F%Z9\u0015\u00051|\u0007C\u0001$n\u0013\tqwI\u0001\u0003V]&$\bb\u00029\b\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\n\u0014!\u00048v[\u000e\u000bG\u000e\u001c2bG.\u001c\b%\u0001\u0005dC2d'-Y2l)\taG\u000fC\u0003v\u0013\u0001\u0007a/\u0001\u0005sKN\u0004xN\\:f!\t9XP\u0004\u0002yw6\t\u0011P\u0003\u0002{\u0003\u00069a.\u001a;x_J\\\u0017B\u0001?z\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!A`@\u0003\u0011I+7\u000f]8og\u0016T!\u0001`=\u0002\u0019\t,gm\u001c:f\u001b\u0016$\bn\u001c3\u0015\u00031D3ACA\u0004!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u00075\u0006)!.\u001e8ji&!\u0011\u0011CA\u0006\u0005\u0019\u0011UMZ8sK\u0006a!-^5mIJ+\u0017/^3tiV!\u0011qCA\u0012)\u0019\tI\"!\u0011\u0002TA9a)a\u0007\u0002 \u0005m\u0012bAA\u000f\u000f\n1A+\u001e9mKJ\u0002B!!\t\u0002$1\u0001AaBA\u0013\u0017\t\u0007\u0011q\u0005\u0002\u0002)F!\u0011\u0011FA\u0018!\r1\u00151F\u0005\u0004\u0003[9%a\u0002(pi\"Lgn\u001a\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG+\u0002\u0011I,\u0017/^3tiNLA!!\u000f\u00024\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fE\u0002x\u0003{I1!a\u0010\u0000\u0005\u001d\u0011V-];fgRDq!a\u0011\f\u0001\u0004\t)%A\u0004ck&dG-\u001a:\u0011\r\u0005\u001d\u0013QJA\u0010\u001d\u0011\t\t$!\u0013\n\t\u0005-\u00131G\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!\u0011qJA)\u0005\u001d\u0011U/\u001b7eKJTA!a\u0013\u00024!I\u0011QK\u0006\u0011\u0002\u0003\u0007\u0011qK\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u00033\ni&\u0004\u0002\u0002\\)\u0011!0V\u0005\u0005\u0003?\nYF\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\fck&dGMU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0011\t)'a\u001f\u0016\u0005\u0005\u001d$\u0006BA,\u0003SZ#!a\u001b\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003k:\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011PA8\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\b\u0003Ka!\u0019AA\u0014\u0003-i\u0017-\u001f2f%\u0016\u001cwN\u001d3\u0015\u0013\u001d\f\t)a#\u0002&\u0006%\u0006bBAB\u001b\u0001\u0007\u0011QQ\u0001\rcV|G/Y'b]\u0006<WM\u001d\t\u0004\u001d\u0006\u001d\u0015bAAE\u007f\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u001d\ti)\u0004a\u0001\u0003\u001f\u000bA!^:feB!\u0011\u0011SAP\u001d\u0011\t\u0019*a'\u0011\u0007\u0005Uu)\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T\"\u0002\rq\u0012xn\u001c;?\u0013\r\tijR\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00161\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005uu\tC\u0004\u0002(6\u0001\r!a$\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dq!a+\u000e\u0001\u0004\ti+A\u0003wC2,X\rE\u0002G\u0003_K1!!-H\u0005\u0019!u.\u001e2mK\u0006AA\u000f\u001b:piRdW\rF\u0006m\u0003o\u000bI,a/\u0002>\u0006\u0005\u0007bBAB\u001d\u0001\u0007\u0011Q\u0011\u0005\b\u0003\u001bs\u0001\u0019AAH\u0011\u001d\t9K\u0004a\u0001\u0003\u001fCa!a0\u000f\u0001\u00049\u0017A\u0004;ie>$H\u000f\\3US6,Wj\u001d\u0005\b\u0003\u0007t\u0001\u0019AAc\u0003e\u0019\u0007.\u00198oK2$\u0006N]8ui2LgnZ\"bY2\u0014\u0017mY6\u0011\u000b\u0019\u000b9M\u001e7\n\u0007\u0005%wIA\u0005Gk:\u001cG/[8oc\u0005\u0001B/Z:u#V|G/\u0019)beNLgn\u001a\u000b\fY\u0006=\u0017\u0011\u001bB;\u0005s\u0012i\bC\u0003`\u001f\u0001\u0007\u0011\rC\u0004\u0002T>\u0001\r!!6\u0002\u000f\rd\u0017.\u001a8ucA\u0019\u0011q\u001b\u000f\u000e\u0003\u0001\u0011!\"V:fe\u000ec\u0017.\u001a8u'\u0019aR)!8\u0002dB\u0019a)a8\n\u0007\u0005\u0005xIA\u0004Qe>$Wo\u0019;\u0011\u0007\u0019\u000b)/C\u0002\u0002h\u001e\u0013AbU3sS\u0006d\u0017N_1cY\u0016,\"!a$\u0002\u000bU\u001cXM\u001d\u0011\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0013AC2p]\u001aLw-V:feV\u0011\u00111\u001f\t\u0006\r\u0006U\u0018qR\u0005\u0004\u0003o<%AB(qi&|g.A\u0006d_:4\u0017nZ+tKJ\u0004\u0013AD2p]\u001aLwm\u00117jK:$\u0018\nZ\u0001\u0010G>tg-[4DY&,g\u000e^%eAQQ\u0011Q\u001bB\u0001\u0005\u0007\u0011)Aa\u0002\t\u000f\u00055U\u00051\u0001\u0002\u0010\"9\u0011qU\u0013A\u0002\u0005=\u0005\"CAxKA\u0005\t\u0019AAz\u0011%\tY0\nI\u0001\u0002\u0004\t\u00190A\ftC:LG/\u001b>fI\u000e{gNZ5h\u00072LWM\u001c;JIV\u0011!Q\u0002\t\u0006\r\u0006U(q\u0002\t\u0005\u0005#\u0011Y\"\u0004\u0002\u0003\u0014)!!Q\u0003B\f\u0003\u0011a\u0017M\\4\u000b\u0005\te\u0011\u0001\u00026bm\u0006LA!!)\u0003\u0014\u0005!1m\u001c9z))\t)N!\t\u0003$\t\u0015\"q\u0005\u0005\n\u0003\u001b;\u0003\u0013!a\u0001\u0003\u001fC\u0011\"a*(!\u0003\u0005\r!a$\t\u0013\u0005=x\u0005%AA\u0002\u0005M\b\"CA~OA\u0005\t\u0019AAz\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\f+\t\u0005=\u0015\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!\u000e+\t\u0005M\u0018\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!qB\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\u0019E!\u0013\u0011\u0007\u0019\u0013)%C\u0002\u0003H\u001d\u00131!\u00118z\u0011\u001d\u0001h&!AA\u0002\u001d\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001f\u0002bA!\u0015\u0003X\t\rSB\u0001B*\u0015\r\u0011)fR\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B-\u0005'\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!q\fB3!\r1%\u0011M\u0005\u0004\u0005G:%a\u0002\"p_2,\u0017M\u001c\u0005\taB\n\t\u00111\u0001\u0003D\u0005A\u0001.Y:i\u0007>$W\rF\u0001h\u0003!!xn\u0015;sS:<GC\u0001B\b\u0003\u0019)\u0017/^1mgR!!q\fB:\u0011!\u00018'!AA\u0002\t\r\u0003b\u0002B<\u001f\u0001\u0007\u0011Q[\u0001\bG2LWM\u001c;3\u0011\u001d\u0011Yh\u0004a\u0001\u0003+\fAB]1oI>l7\t\\5f]RDqAa \u0010\u0001\u0004\t).A\neK\u001a\fW\u000f\u001c;D_:4\u0017nZ\"mS\u0016tG/\u0001\ruKN$8\t\\5f]RLE-U;pi\u0006\u0004\u0016M]:j]\u001eD3\u0001\u0005BC!\u0011\tIAa\"\n\t\t%\u00151\u0002\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$Xk]3s#V|G/\u0019)beNLgn\u001a\u0015\u0004#\t\u0015\u0015\u0001\b;fgR,6/\u001a:DY&,g\u000e^%e#V|G/\u0019)beNLgn\u001a\u0015\u0004%\t\u0015\u0015\u0001\f;fgR,6/\u001a:Rk>$\u0018\rU1sg&twmV5uQ\u0012+g-Y;mi\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;bQ\r\u0019\"QQ\u00015i\u0016\u001cH/V:fe\u000ec\u0017.\u001a8u#V|G/\u0019)beNLgnZ%e/&$\b\u000eR3gCVdGo\u00117jK:$\u0018\nZ)v_R\f\u0007f\u0001\u000b\u0003\u0006\u0006IB/Z:u#V|G/Y\"p]\u001aLw\r\u0015:fG\u0016$WM\\2fQ\r)\"QQ\u0001\u0013i\u0016\u001cH/U;pi\u00064\u0016n\u001c7bi&|g\u000eK\u0002\u0017\u0005\u000b\u000b1\u0005^3tiJ+\u0017/^3tiB+'oY3oi\u0006<W-U;pi\u00064\u0016n\u001c7bi&|g\u000eK\u0002\u0018\u0005\u000b\u000bA\u0004^3ti\u0016C\b/\u001b:f)\"\u0014x\u000e\u001e;mKRKW.Z*f]N|'\u000fK\u0002\u0019\u0005\u000b\u000ba\u0003^3ti\u0016C\b/\u001b:f#V|G/Y*f]N|'o\u001d\u0015\u00043\t\u0015\u0015\u0001\u0007;fgR\u001cE.[3oi&#gj\u001c;TC:LG/\u001b>fI\"\u001a!D!\"\u0002\u00159,w/T3ue&\u001c7/\u0006\u0002\u00038B!!\u0011\u0018B`\u001b\t\u0011YLC\u0002\u0003>V\u000bq!\\3ue&\u001c7/\u0003\u0003\u0003B\nm&aB'fiJL7m]\u0001\u000b+N,'o\u00117jK:$\bcAAlkM)QG!3\u0002dBq!1\u001aBi\u0003\u001f\u000by)a=\u0002t\u0006UWB\u0001Bg\u0015\r\u0011ymR\u0001\beVtG/[7f\u0013\u0011\u0011\u0019N!4\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0003F\u0006)\u0011\r\u001d9msRQ\u0011Q\u001bBn\u0005;\u0014yN!9\t\u000f\u00055\u0005\b1\u0001\u0002\u0010\"9\u0011q\u0015\u001dA\u0002\u0005=\u0005\"CAxqA\u0005\t\u0019AAz\u0011%\tY\u0010\u000fI\u0001\u0002\u0004\t\u00190A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005W\u0014\u0019\u0010E\u0003G\u0003k\u0014i\u000fE\u0006G\u0005_\fy)a$\u0002t\u0006M\u0018b\u0001By\u000f\n1A+\u001e9mKRB\u0011B!><\u0003\u0003\u0005\r!!6\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b")
public class ClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final MockTime time = new MockTime();
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(500L, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
    private int numCallbacks = 0;

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private MockTime time() {
        return this.time;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    public int numCallbacks() {
        return this.numCallbacks;
    }

    public void numCallbacks_$eq(int x$1) {
        this.numCallbacks = x$1;
    }

    public void callback(RequestChannel.Response response) {
        RequestChannel.Response response2 = response;
        if (response2 instanceof RequestChannel.StartThrottlingResponse) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (response2 instanceof RequestChannel.EndThrottlingResponse) {
            this.numCallbacks_$eq(this.numCallbacks() + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)response2);
        }
    }

    @Before
    public void beforeMethod() {
        this.numCallbacks_$eq(0);
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private int maybeRecord(ClientQuotaManager quotaManager, String user, String clientId, double value) {
        KafkaPrincipal principal = new KafkaPrincipal("User", user);
        return quotaManager.maybeRecordAndGetThrottleTimeMs(new RequestChannel.Session(principal, null), clientId, value, this.time().milliseconds());
    }

    private void throttle(ClientQuotaManager quotaManager, String user, String clientId, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        RequestChannel.Request request;
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        RequestChannel.Request request2 = request = (RequestChannel.Request)tuple2._2();
        RequestChannel.Request request3 = request2;
        quotaManager.throttle(request3, throttleTimeMs, channelThrottlingCallback);
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(config, this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientMetrics.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)new StringBuilder(33).append("Default producer quota should be ").append(config.quotaBytesPerSecondDefault()).toString(), (double)config.quotaBytesPerSecondDefault(), (double)clientMetrics.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (2000)", (double)2000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            Assert.assertEquals((String)"Should return the overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client2.user(), client2.clientId()).bound(), (double)0.0);
            int throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples());
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (3000)", (double)3000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assert.assertEquals((String)"Should return the default value (500)", (double)500.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 0.0);
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
            clientMetrics.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientMetrics.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assert.assertEquals((String)"Should return the newly overridden value (4000)", (double)4000.0, (double)clientMetrics.quota(client1.user(), client1.clientId()).bound(), (double)0.0);
            throttleTimeMs = this.maybeRecord(clientMetrics, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples());
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3());
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager quotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(Long.MAX_VALUE, ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3()), this.newMetrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(2000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(3000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            quotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota$1("userA", "client1", 5000, 4500, false, quotaManager);
            this.checkQuota$1("userA", "client2", 4000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client3", 4000, 0, true, quotaManager);
            this.checkQuota$1("userA", "client1", 5000, 0, false, quotaManager);
            this.checkQuota$1("userB", "client1", 7000, 8000, true, quotaManager);
            this.checkQuota$1("userB", "client2", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userB", "client3", 8000, 7000, false, quotaManager);
            this.checkQuota$1("userD", "client1", 3000, 3500, true, quotaManager);
            this.checkQuota$1("userD", "client2", 3000, 2500, false, quotaManager);
            this.checkQuota$1("userE", "client1", 3000, 2500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$);
            this.checkQuota$1("userD", "client1", 1000, 0, false, quotaManager);
            this.checkQuota$1("userE", "client4", 1000, 1500, true, quotaManager);
            this.checkQuota$1("userF", "client4", 1000, 800, false, quotaManager);
            this.checkQuota$1("userF", "client5", 1000, 800, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota$1("userF", "client4", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 0, false, quotaManager);
            this.checkQuota$1("userF", "client5", 2000, 2500, true, quotaManager);
            this.checkQuota$1("userG", "client5", 2000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota$1("userA", "client2", 8000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client2", 8000, 4500, true, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 0, false, quotaManager);
            this.checkQuota$1("userA", "client1", 10000, 6000, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 8000, 0, true, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota$1("userA", "client6", 11000, 8500, false, quotaManager);
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option)new Some((Object)new Quota(12000.0, true)));
            quotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota$1("userA", "client6", 12000, 4000, true, quotaManager);
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Produce", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assert.assertEquals((long)0L, (long)this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int sleepTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 2300.0);
            Assert.assertEquals((String)"Should be throttled", (long)2100L, (long)sleepTime);
            this.throttle(clientMetrics, "ANONYMOYUS", "unknown", sleepTime, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)sleepTime);
            clientMetrics.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord(clientMetrics, "ANONYMOUS", "unknown", 0.0));
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testRequestPercentageQuotaViolation() {
        Metrics metrics = this.newMetrics();
        ClientRequestQuotaManager quotaManager = new ClientRequestQuotaManager(this.config(), metrics, (Time)this.time(), "", (Option)None$.MODULE$);
        quotaManager.updateQuota((Option)new Some((Object)"ANONYMOUS"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)"test-client"), (Option)new Some((Object)Quota.upperBound((double)1.0)));
        KafkaMetric queueSizeMetric = (KafkaMetric)metrics.metrics().get(metrics.metricName("queue-size", "Request", ""));
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assert.assertEquals((long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0)));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(67.1));
            Assert.assertEquals((String)"Should be throttled", (long)210L, (long)throttleTime);
            this.throttle((ClientQuotaManager)quotaManager, "ANONYMOYUS", "test-client", throttleTime, (Function1<RequestChannel.Response, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                this.callback(response);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((long)1L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            quotaManager.throttledChannelReaper().doWork();
            Assert.assertEquals((long)0L, (long)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assert.assertEquals((long)1L, (long)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 11).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(4.0));
                this.time().sleep(1000L);
            });
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", ClientQuotaManagerTest.millisToPercent$1(500.0)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.time().sleep(1000L);
                Assert.assertEquals((long)1000L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
            });
            this.time().sleep(1000L);
            Assert.assertEquals((String)"Should be unthrottled since bursty sample has rolled over", (long)0L, (long)this.maybeRecord((ClientQuotaManager)quotaManager, "ANONYMOUS", "test-client", 0.0));
        }
        finally {
            quotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            metrics.removeSensor("ProduceThrottleTime-:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 100.0);
            metrics.removeSensor("ProduceThrottleTime-:client1");
            metrics.removeSensor("Produce-ANONYMOUS:client1");
            int throttleTime = this.maybeRecord(clientMetrics, "ANONYMOUS", "client1", 10000.0);
            Assert.assertTrue((String)"Should be throttled", (throttleTime > 0 ? 1 : 0) != 0);
            Sensor throttleTimeSensor = metrics.getSensor("ProduceThrottleTime-:client1");
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor("Produce-:client1");
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        Metrics metrics = this.newMetrics();
        ClientQuotaManager clientMetrics = new ClientQuotaManager(this.config(), metrics, (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        String clientId = "client@#$%";
        try {
            this.maybeRecord(clientMetrics, "ANONYMOUS", clientId, 100.0);
            Sensor throttleTimeSensor = metrics.getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString());
            Assert.assertTrue((String)"Throttle time sensor should exist", (throttleTimeSensor != null ? 1 : 0) != 0);
            Sensor byteRateSensor = metrics.getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString());
            Assert.assertTrue((String)"Byte rate sensor should exist", (byteRateSensor != null ? 1 : 0) != 0);
        }
        finally {
            clientMetrics.shutdown();
        }
    }

    public Metrics newMetrics() {
        return new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());
    }

    private final void UserClient$lzycompute$1() {
        ClientQuotaManagerTest clientQuotaManagerTest = this;
        synchronized (clientQuotaManagerTest) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
        }
    }

    private final void checkQuota$1(String user, String clientId, int expectedBound, int value, boolean expectThrottle, ClientQuotaManager quotaManager$1) {
        Assert.assertEquals((double)expectedBound, (double)quotaManager$1.quota(user, clientId).bound(), (double)0.0);
        int throttleTimeMs = this.maybeRecord(quotaManager$1, user, clientId, value * this.config().numQuotaSamples());
        if (expectThrottle) {
            Assert.assertTrue((String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString(), (throttleTimeMs > 0 ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString(), (long)0L, (long)throttleTimeMs);
        }
    }

    private static final double millisToPercent$1(double millis) {
        return millis * (double)1000 * (double)1000 * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable & scala.Serializable)x -> {
                String string = x;
                String string2 = ConfigEntityName$.MODULE$.Default();
                return !(string != null ? !string.equals(string2) : string2 != null) ? ConfigEntityName$.MODULE$.Default() : Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Option<String> option;
            int n = x$1;
            switch (n) {
                case 0: {
                    option = this.user();
                    break;
                }
                case 1: {
                    option = this.clientId();
                    break;
                }
                case 2: {
                    option = this.configUser();
                    break;
                }
                case 3: {
                    option = this.configClientId();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return option;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof UserClient)) return false;
            if (((UserClient)object).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() != this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            UserClient userClient = (UserClient)x$1;
            String string = this.user();
            String string2 = userClient.user();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.clientId();
            String string4 = userClient.clientId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.configUser();
            Option<String> option2 = userClient.configUser();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.configClientId();
            Option<String> option4 = userClient.configClientId();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!userClient.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

