/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004-\u0001\u0001\u0006Ia\t\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0011\u00199\u0004\u0001)A\u0005_!9\u0001\b\u0001b\u0001\n\u0003I\u0004B\u0002!\u0001A\u0003%!\bC\u0004B\u0001\t\u0007I\u0011\u0001\"\t\r)\u0003\u0001\u0015!\u0003D\u0011\u001dY\u0005A1A\u0005\u00021Ca!\u0015\u0001!\u0002\u0013i\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"\u00021\u0001\t\u0003\u0019\u0006\"B3\u0001\t\u0003\u0019\u0006\"B4\u0001\t\u0003A'\u0001\b%jO\"<\u0018\r^3s[\u0006\u00148\u000eU3sg&\u001cH/\u001a8dKR+7\u000f\u001e\u0006\u0003%M\taa]3sm\u0016\u0014(\"\u0001\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\t\u0012aB2p]\u001aLwm]\u000b\u0002GA\u0019AeJ\u0015\u000e\u0003\u0015R!AJ\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002)K\t\u00191+Z9\u0011\u0005\u0001R\u0013BA\u0016\u0012\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0011\r|gNZ5hg\u0002\nQ\u0001^8qS\u000e,\u0012a\f\t\u0003aUj\u0011!\r\u0006\u0003eM\nA\u0001\\1oO*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011QhE\u0001\u0003u.L!a\u0010\u001f\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%Q8n\u00117jK:$\b%A\u0006m_\u001el\u0015M\\1hKJ\u001cX#A\"\u0011\u0007\u0011:C\t\u0005\u0002F\u00116\taI\u0003\u0002H'\u0005\u0019An\\4\n\u0005%3%A\u0003'pO6\u000bg.Y4fe\u0006aAn\\4NC:\fw-\u001a:tA\u0005)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u001cX#A'\u0011\u0007\u0011:c\n\u0005\u0002!\u001f&\u0011\u0001+\u0005\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002-1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mg\u0002\n\u0001\u0002^3be\u0012|wO\u001c\u000b\u0002)B\u0011\u0001$V\u0005\u0003-f\u0011A!\u00168ji\"\u0012A\u0002\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bQA[;oSRT\u0011!X\u0001\u0004_J<\u0017BA0[\u0005\u0015\te\r^3s\u0003-\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016\u001c\u0016N\\4mKB\u000b'\u000f^5uS>t\u0007FA\u0007c!\tI6-\u0003\u0002e5\n!A+Z:u\u00039\"Xm\u001d;IS\u001eDw+\u0019;fe6\f'o\u001b)feNL7\u000f^3oG\u0016lU\u000f\u001c;ja2,\u0007+\u0019:uSRLwN\\:)\u00059\u0011\u0017A\u00025x[\u001a{'\u000f\u0006\u0003jYFd\bC\u0001\rk\u0013\tY\u0017D\u0001\u0003M_:<\u0007\"B7\u0010\u0001\u0004q\u0017A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003A=L!\u0001]\t\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\")Qf\u0004a\u0001eB\u00111O\u001f\b\u0003ib\u0004\"!^\r\u000e\u0003YT!a^\u000b\u0002\rq\u0012xn\u001c;?\u0013\tI\u0018$\u0001\u0004Qe\u0016$WMZ\u0005\u0003mmT!!_\r\t\u000bu|\u0001\u0019\u0001@\u0002\u0013A\f'\u000f^5uS>t\u0007C\u0001\r\u0000\u0013\r\t\t!\u0007\u0002\u0004\u0013:$\b")
public class HighwatermarkPersistenceTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    private final String topic;
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
    private final Seq<LogManager> logManagers = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> {
        Seq x$12 = (Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom());
        CleanerConfig x$2 = new CleanerConfig(CleanerConfig$.MODULE$.apply$default$1(), CleanerConfig$.MODULE$.apply$default$2(), CleanerConfig$.MODULE$.apply$default$3(), CleanerConfig$.MODULE$.apply$default$4(), CleanerConfig$.MODULE$.apply$default$5(), CleanerConfig$.MODULE$.apply$default$6(), CleanerConfig$.MODULE$.apply$default$7(), CleanerConfig$.MODULE$.apply$default$8(), CleanerConfig$.MODULE$.apply$default$9());
        LogConfig x$3 = TestUtils$.MODULE$.createLogManager$default$2();
        MockTime x$4 = TestUtils$.MODULE$.createLogManager$default$4();
        return TestUtils$.MODULE$.createLogManager((Seq<File>)x$12, x$3, x$2, x$4);
    }, Seq$.MODULE$.canBuildFrom());
    private final Seq<LogDirFailureChannel> logDirFailureChannels = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)config -> new LogDirFailureChannel(config.logDirs().size()), Seq$.MODULE$.canBuildFrom());

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public Seq<LogManager> logManagers() {
        return this.logManagers;
    }

    public Seq<LogDirFailureChannel> logDirFailureChannels() {
        return this.logDirFailureChannels;
    }

    @After
    public void teardown() {
        this.logManagers().foreach((Function1 & Serializable & scala.Serializable)manager -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$1(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testHighWatermarkPersistenceSinglePartition() {
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)0L, (long)fooPartition0Hw);
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            Partition partition0 = replicaManager.getOrCreatePartition(tp0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$1 = new TopicPartition(this.topic(), 0);
            LogConfig x$2 = LogConfig$.MODULE$.apply();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            Log log0 = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
            Replica leaderReplicaPartition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), tp0, (Time)time, 0L, (Option)new Some((Object)log0));
            partition0.addReplicaIfNotExists(leaderReplicaPartition0);
            Replica followerReplicaPartition0 = new Replica(((KafkaConfig)this.configs().last()).brokerId(), tp0, (Time)time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5());
            partition0.addReplicaIfNotExists(followerReplicaPartition0);
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            ((Replica)partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            fooPartition0Hw = this.hwmFor(replicaManager, this.topic(), 0);
            Assert.assertEquals((long)leaderReplicaPartition0.highWatermark().messageOffset(), (long)fooPartition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    @Test
    public void testHighWatermarkPersistenceMultiplePartitions() {
        String topic1 = "foo1";
        String topic2 = "foo2";
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaScheduler scheduler = new KafkaScheduler(2, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        Metrics metrics = new Metrics();
        MockTime time = new MockTime();
        ReplicaManager replicaManager = new ReplicaManager((KafkaConfig)this.configs().head(), metrics, (Time)time, this.zkClient(), (Scheduler)scheduler, (LogManager)this.logManagers().head(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), metrics, (Time)time, ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), (LogDirFailureChannel)this.logDirFailureChannels().head(), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        replicaManager.startup();
        try {
            replicaManager.checkpointHighWatermarks();
            long topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)0L, (long)topic1Partition0Hw);
            TopicPartition t1p0 = new TopicPartition(topic1, 0);
            Partition topic1Partition0 = replicaManager.getOrCreatePartition(t1p0);
            LogManager qual$1 = (LogManager)this.logManagers().head();
            TopicPartition x$1 = t1p0;
            LogConfig x$2 = LogConfig$.MODULE$.apply();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            Log topic1Log0 = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
            Replica leaderReplicaTopic1Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), t1p0, (Time)time, 0L, (Option)new Some((Object)topic1Log0));
            topic1Partition0.addReplicaIfNotExists(leaderReplicaTopic1Partition0);
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)leaderReplicaTopic1Partition0.highWatermark().messageOffset(), (long)topic1Partition0Hw);
            ((Replica)topic1Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            replicaManager.checkpointHighWatermarks();
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)5L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            Assert.assertEquals((long)5L, (long)topic1Partition0Hw);
            TopicPartition t2p0 = new TopicPartition(topic2, 0);
            Partition topic2Partition0 = replicaManager.getOrCreatePartition(t2p0);
            LogManager qual$2 = (LogManager)this.logManagers().head();
            TopicPartition x$5 = t2p0;
            LogConfig x$6 = LogConfig$.MODULE$.apply();
            boolean x$7 = qual$2.getOrCreateLog$default$3();
            boolean x$8 = qual$2.getOrCreateLog$default$4();
            Log topic2Log0 = qual$2.getOrCreateLog(x$5, x$6, x$7, x$8);
            Replica leaderReplicaTopic2Partition0 = new Replica(((KafkaConfig)this.configs().head()).brokerId(), t2p0, (Time)time, 0L, (Option)new Some((Object)topic2Log0));
            topic2Partition0.addReplicaIfNotExists(leaderReplicaTopic2Partition0);
            replicaManager.checkpointHighWatermarks();
            long topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)leaderReplicaTopic2Partition0.highWatermark().messageOffset(), (long)topic2Partition0Hw);
            ((Replica)topic2Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)15L, (long)leaderReplicaTopic2Partition0.highWatermark().messageOffset());
            ((Replica)topic1Partition0.localReplica().get()).highWatermark_$eq(new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            Assert.assertEquals((long)10L, (long)leaderReplicaTopic1Partition0.highWatermark().messageOffset());
            replicaManager.checkpointHighWatermarks();
            topic2Partition0Hw = this.hwmFor(replicaManager, topic2, 0);
            Assert.assertEquals((long)15L, (long)topic2Partition0Hw);
            topic1Partition0Hw = this.hwmFor(replicaManager, topic1, 0);
            Assert.assertEquals((long)10L, (long)topic1Partition0Hw);
            EasyMock.verify((Object[])new Object[]{this.zkClient()});
        }
        finally {
            replicaManager.shutdown(false);
            metrics.close();
            scheduler.shutdown();
        }
    }

    public long hwmFor(ReplicaManager replicaManager, String topic, int partition) {
        return BoxesRunTime.unboxToLong((Object)((OffsetCheckpointFile)replicaManager.highWatermarkCheckpoints().apply((Object)new File((String)replicaManager.config().logDirs().head()).getAbsolutePath())).read().getOrElse((Object)new TopicPartition(topic, partition), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$teardown$2(File dir) {
        Utils.delete((File)dir);
    }

    public static final /* synthetic */ void $anonfun$teardown$1(LogManager manager) {
        manager.liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)dir -> {
            HighwatermarkPersistenceTest.$anonfun$teardown$2(dir);
            return BoxedUnit.UNIT;
        });
    }

    public HighwatermarkPersistenceTest() {
        this.topic = "foo";
    }
}

