/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.security.auth.Authorizer;
import kafka.server.AdminManager;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.FetchManager;
import kafka.server.FetchPartitionData;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r=h\u0001\u0002*T\u0001aCQa\u0018\u0001\u0005\u0002\u0001Dqa\u0019\u0001C\u0002\u0013%A\r\u0003\u0004l\u0001\u0001\u0006I!\u001a\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019)\b\u0001)A\u0005]\"9a\u000f\u0001b\u0001\n\u00139\bBB>\u0001A\u0003%\u0001\u0010C\u0004}\u0001\t\u0007I\u0011B?\t\u000f\u00055\u0001\u0001)A\u0005}\"I\u0011q\u0002\u0001C\u0002\u0013%\u0011\u0011\u0003\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0014!I\u00111\u0004\u0001C\u0002\u0013%\u0011Q\u0004\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002 !I\u0011Q\u0006\u0001C\u0002\u0013%\u0011q\u0006\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u00022!I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002B!I\u0011q\n\u0001C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002T!I\u00111\u000e\u0001C\u0002\u0013%\u0011Q\u000e\u0005\t\u0003k\u0002\u0001\u0015!\u0003\u0002p!I\u0011q\u000f\u0001C\u0002\u0013%\u0011\u0011\u0010\u0005\t\u0003\u0003\u0003\u0001\u0015!\u0003\u0002|!I\u00111\u0011\u0001C\u0002\u0013%\u0011Q\u0011\u0005\t\u0003;\u0003\u0001\u0015!\u0003\u0002\b\"I\u0011q\u0014\u0001C\u0002\u0013%\u0011\u0011\u0015\u0005\t\u0003S\u0003\u0001\u0015!\u0003\u0002$\"I\u00111\u0016\u0001C\u0002\u0013%\u0011Q\u0016\u0005\t\u0003k\u0003\u0001\u0015!\u0003\u00020\"I\u0011q\u0017\u0001C\u0002\u0013%\u0011\u0011\u0018\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u0002<\"I\u00111\u0019\u0001C\u0002\u0013%\u0011Q\u0019\u0005\t\u0003G\u0004\u0001\u0015!\u0003\u0002H\"I\u0011Q\u001d\u0001C\u0002\u0013%\u0011q\u001d\u0005\t\u0003_\u0004\u0001\u0015!\u0003\u0002j\"I\u0011\u0011\u001f\u0001C\u0002\u0013%\u00111\u001f\u0005\t\u0003w\u0004\u0001\u0015!\u0003\u0002v\"I\u0011Q \u0001C\u0002\u0013%\u0011q \u0005\t\u0005#\u0001\u0001\u0015!\u0003\u0003\u0002!I!1\u0003\u0001C\u0002\u0013%!Q\u0003\u0005\t\u0005G\u0001\u0001\u0015!\u0003\u0003\u0018!9!Q\u0005\u0001\u0005\u0002\t\u001d\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\n\u0005/\u0002\u0011\u0013!C\u0001\u00053BqAa\u001c\u0001\t\u0003\u00119\u0003C\u0004\u0003z\u0001!\tAa\n\t\u000f\tu\u0004\u0001\"\u0001\u0003(!9!\u0011\u0011\u0001\u0005\u0002\t\u001d\u0002b\u0002BK\u0001\u0011\u0005!q\u0005\u0005\b\u00053\u0003A\u0011\u0001B\u0014\u0011\u001d\u0011i\n\u0001C\u0001\u0005OAqA!)\u0001\t\u0003\u00119\u0003C\u0004\u0003&\u0002!\tAa\n\t\u000f\t%\u0006\u0001\"\u0001\u0003(!9!Q\u0016\u0001\u0005\u0002\t\u001d\u0002b\u0002BY\u0001\u0011\u0005!q\u0005\u0005\b\u0005k\u0003A\u0011\u0001B\u0014\u0011\u001d\u0011I\f\u0001C\u0001\u0005OAqA!0\u0001\t\u0003\u00119\u0003C\u0004\u0003B\u0002!\tAa\n\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003(!9!\u0011\u001a\u0001\u0005\n\t-\u0007b\u0002Bo\u0001\u0011\u0005!q\u0005\u0005\b\u0005C\u0004A\u0011\u0001B\u0014\u0011\u001d\u0011)\u000f\u0001C\u0001\u0005OAqA!;\u0001\t\u0003\u00119\u0003C\u0004\u0003n\u0002!\tAa\n\t\u000f\tE\b\u0001\"\u0001\u0003t\"9!q\u001f\u0001\u0005\u0002\t\u001d\u0002b\u0002B~\u0001\u0011\u0005!q\u0005\u0005\b\u0005\u007f\u0004A\u0011\u0001B\u0014\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0005OAqaa\u0002\u0001\t\u0013\u0019I\u0001C\u0004\u0004\u001c\u0001!Ia!\b\t\u000f\r=\u0002\u0001\"\u0003\u00042!91Q\b\u0001\u0005\n\r}\u0002bBB4\u0001\u0011%1\u0011\u000e\u0005\n\u00077\u0003\u0011\u0013!C\u0005\u0007;Cqa!*\u0001\t\u0013\u00199\u000bC\u0004\u0004R\u0002!Iaa5\t\u000f\rU\u0007\u0001\"\u0003\u0004X\ni1*\u00194lC\u0006\u0003\u0018n\u001d+fgRT!\u0001V+\u0002\rM,'O^3s\u0015\u00051\u0016!B6bM.\f7\u0001A\n\u0003\u0001e\u0003\"AW/\u000e\u0003mS\u0011\u0001X\u0001\u0006g\u000e\fG.Y\u0005\u0003=n\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001b!\t\u0011\u0007!D\u0001T\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003QV\u000bqA\\3uo>\u00148.\u0003\u0002kO\nq!+Z9vKN$8\t[1o]\u0016d\u0017a\u0004:fcV,7\u000f^\"iC:tW\r\u001c\u0011\u0002+I,\u0017/^3ti\u000eC\u0017M\u001c8fY6+GO]5dgV\ta\u000e\u0005\u0002pe:\u0011a\r]\u0005\u0003c\u001e\faBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002ti\n9Q*\u001a;sS\u000e\u001c(BA9h\u0003Y\u0011X-];fgR\u001c\u0005.\u00198oK2lU\r\u001e:jGN\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002qB\u0011!-_\u0005\u0003uN\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'/F\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005)qM]8va*\u0019\u0011qA+\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0005\u0003\u0017\t\tA\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006\trM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u0019\u0005$W.\u001b8NC:\fw-\u001a:\u0016\u0005\u0005M\u0001c\u00012\u0002\u0016%\u0019\u0011qC*\u0003\u0019\u0005#W.\u001b8NC:\fw-\u001a:\u0002\u001b\u0005$W.\u001b8NC:\fw-\u001a:!\u00039!\bP\\\"p_J$\u0017N\\1u_J,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQA!!\n\u0002\u0006\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\tI#a\t\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\fq\u0002\u001e=o\u0007>|'\u000fZ5oCR|'\u000fI\u0001\u000bG>tGO]8mY\u0016\u0014XCAA\u0019!\u0011\t\u0019$a\u000e\u000e\u0005\u0005U\"bAA\u0017+&!\u0011\u0011HA\u001b\u0005=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018aC2p]R\u0014x\u000e\u001c7fe\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f*\u0016A\u0001>l\u0013\u0011\tY%!\u0012\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%Q8n\u00117jK:$\b%A\u0004nKR\u0014\u0018nY:\u0016\u0005\u0005M\u0003\u0003BA+\u0003Oj!!a\u0016\u000b\t\u0005=\u0013\u0011\f\u0006\u0005\u00037\ni&\u0001\u0004d_6lwN\u001c\u0006\u0004-\u0006}#\u0002BA1\u0003G\na!\u00199bG\",'BAA3\u0003\ry'oZ\u0005\u0004g\u0006]\u0013\u0001C7fiJL7m\u001d\u0011\u0002\u0011\t\u0014xn[3s\u0013\u0012,\"!a\u001c\u0011\u0007i\u000b\t(C\u0002\u0002tm\u00131!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003w\u00022AYA?\u0013\r\tyh\u0015\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0002\u001d5,G/\u00193bi\u0006\u001c\u0015m\u00195fA\u0005Q\u0011-\u001e;i_JL'0\u001a:\u0016\u0005\u0005\u001d\u0005#\u0002.\u0002\n\u00065\u0015bAAF7\n1q\n\u001d;j_:\u0004B!a$\u0002\u001a6\u0011\u0011\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0003bkRD'bAAL+\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002\u001c\u0006E%AC!vi\"|'/\u001b>fe\u0006Y\u0011-\u001e;i_JL'0\u001a:!\u0003I\u0019G.[3oiF+x\u000e^1NC:\fw-\u001a:\u0016\u0005\u0005\r\u0006c\u00012\u0002&&\u0019\u0011qU*\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\u0001\u0014G2LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fI\u0001\u001aG2LWM\u001c;SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u00020B\u0019!-!-\n\u0007\u0005M6KA\rDY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014\u0018AG2mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ\u0004\u0013a\u0005:fa2L7-Y)v_R\fW*\u00198bO\u0016\u0014XCAA^!\r\u0011\u0017QX\u0005\u0004\u0003\u007f\u001b&a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003Q\u0011X\r\u001d7jG\u0006\fVo\u001c;b\u001b\u0006t\u0017mZ3sA\u00051\u0011/^8uCN,\"!a2\u0011\t\u0005%\u0017Q\u001c\b\u0005\u0003\u0017\fIN\u0004\u0003\u0002N\u0006]g\u0002BAh\u0003+l!!!5\u000b\u0007\u0005Mw+\u0001\u0004=e>|GOP\u0005\u0002-&\u0011A+V\u0005\u0004\u00037\u001c\u0016\u0001D)v_R\fg)Y2u_JL\u0018\u0002BAp\u0003C\u0014Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(bAAn'\u00069\u0011/^8uCN\u0004\u0013\u0001\u00044fi\u000eDW*\u00198bO\u0016\u0014XCAAu!\r\u0011\u00171^\u0005\u0004\u0003[\u001c&\u0001\u0004$fi\u000eDW*\u00198bO\u0016\u0014\u0018!\u00044fi\u000eDW*\u00198bO\u0016\u0014\b%\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\u0011\u0011Q\u001f\t\u0004E\u0006]\u0018bAA}'\n\u0001\"I]8lKJ$v\u000e]5d'R\fGo]\u0001\u0012EJ|7.\u001a:U_BL7m\u0015;biN\u0004\u0013!C2mkN$XM]%e+\t\u0011\t\u0001\u0005\u0003\u0003\u0004\t5QB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0017\tAA[1wC&!!q\u0002B\u0003\u0005\u0019\u0019FO]5oO\u0006Q1\r\\;ti\u0016\u0014\u0018\n\u001a\u0011\u0002\tQLW.Z\u000b\u0003\u0005/\u0001BA!\u0007\u0003 5\u0011!1\u0004\u0006\u0004\u0005;)\u0016!B;uS2\u001c\u0018\u0002\u0002B\u0011\u00057\u0011\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\ti\u0016\f'\u000fR8x]R\u0011!\u0011\u0006\t\u00045\n-\u0012b\u0001B\u00177\n!QK\\5uQ\rQ#\u0011\u0007\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)!!qGA2\u0003\u0015QWO\\5u\u0013\u0011\u0011YD!\u000e\u0003\u000b\u00053G/\u001a:\u0002\u001f\r\u0014X-\u0019;f\u0017\u000647.Y!qSN$BA!\u0011\u0003HA\u0019!Ma\u0011\n\u0007\t\u00153KA\u0005LC\u001a\\\u0017-\u00119jg\"I!\u0011J\u0016\u0011\u0002\u0003\u0007!1J\u0001\u001bS:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\t\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)\u0019!\u0011K+\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003V\t=#AC!qSZ+'o]5p]\u0006I2M]3bi\u0016\\\u0015MZ6b\u0003BL7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YF\u000b\u0003\u0003L\tu3F\u0001B0!\u0011\u0011\tGa\u001b\u000e\u0005\t\r$\u0002\u0002B3\u0005O\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%4,\u0001\u0006b]:|G/\u0019;j_:LAA!\u001c\u0003d\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002IQ,7\u000f^(gMN,GoQ8n[&$x+\u001b;i\u0013:4\u0018\r\\5e!\u0006\u0014H/\u001b;j_:D3!\fB:!\u0011\u0011\u0019D!\u001e\n\t\t]$Q\u0007\u0002\u0005)\u0016\u001cH/A\u0014uKN$H\u000b\u001f8PM\u001a\u001cX\r^\"p[6LGoV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t\u0007f\u0001\u0018\u0003t\u0005QC/Z:u\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RChnV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t\u0007fA\u0018\u0003t\u000517\u000f[8vY\u0012$\u0006N]8x+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012=dKB$\u0018n\u001c8P]\"\u000bg\u000e\u001a7f\u0003\u0012$wJ\u001a4tKR$v\u000e\u0016=o%\u0016\fX/Z:u/\",g.\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2tu\u000e^*vaB|'\u000f^3eQ\u001d\u0001$1\u000fBC\u0005\u000f\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0005\u0013\u0003BAa#\u0003\u00126\u0011!Q\u0012\u0006\u0005\u0005\u001f\u000bI&\u0001\u0004feJ|'o]\u0005\u0005\u0005'\u0013iIA\u000eV]N,\b\u000f]8si\u0016$g+\u001a:tS>tW\t_2faRLwN\\\u0001kg\"|W\u000f\u001c3UQJ|w/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016C8-\u001a9uS>twJ\u001c%b]\u0012dW-\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]J+\u0017/^3ti^CWM\\%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>dgj\u001c;TkB\u0004xN\u001d;fI\":\u0011Ga\u001d\u0003\u0006\n\u001d\u0015aZ:i_VdG\r\u00165s_^,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]>s\u0007*\u00198eY\u0016$\u0006P\\(gMN,GoQ8n[&$(+Z9vKN$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+\b\u000f]8si\u0016$\u0007f\u0002\u001a\u0003t\t\u0015%qQ\u0001_g\"|W\u000f\u001c3UQJ|w/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016C8-\u001a9uS>twJ\u001c%b]\u0012dW-\u00128e)bt'+Z9vKN$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+\b\u000f]8si\u0016$\u0007fB\u001a\u0003t\t\u0015%qQ\u0001hg\"|W\u000f\u001c3UQJ|w/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016C8-\u001a9uS>twJ\u001c%b]\u0012dWm\u0016:ji\u0016$\u0006P\\'be.,'o\u001d*fcV,7\u000f^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u001d>$8+\u001e9q_J$X\r\u001a\u0015\bi\tM$Q\u0011BD\u0003u\u001b\bn\\;mIJ+7\u000f]8oI^KG\u000f[+ogV\u0004\bo\u001c:uK\u00124uN]'fgN\fw-\u001a$pe6\fGo\u00148IC:$G.Z,sSR,G\u000b\u001f8NCJ\\WM]:XQ\u0016tW*Y4jG2{w/\u001a:UQ\u0006t'+Z9vSJ,G\rK\u00026\u0005g\nQg\u001d5pk2$'+Z:q_:$w+\u001b;i+:\\gn\\<o)>\u0004\u0018nY,iK:\u0004\u0016M\u001d;ji&|g.S:O_RDun\u001d;fI\"\u001aaGa\u001d\u0002'NDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00168tkB\u0004xN\u001d;fI6+7o]1hK\u001a{'/\\1u\r>\u0014()\u00193QCJ$\u0018\u000e^5p]\u0006sGMT8FeJ|'o\u001d$pe\u001e{w\u000e\u001a)beRLG/[8oQ\r9$1O\u0001Sg\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRDWK\\6o_^tGk\u001c9jG>\u0013\b+\u0019:uSRLwN\u001c$pe\n\u000bG\rU1si&$\u0018n\u001c8B]\u0012tu.\u0012:s_J\u001chi\u001c:H_>$\u0007+\u0019:uSRLwN\u001c\u0015\u0004q\tM\u0014!O:i_VdG-\u00119qK:$Gk\u001c'pO>swK]5uKRCh.T1sW\u0016\u00148o\u00165f]\u000e{'O]3di6\u000bw-[2WKJ\u001c\u0018n\u001c8)\u0007e\u0012\u0019(A\u0018uKN$H*Z1eKJ\u0014V\r\u001d7jG\u0006Le\rT8dC2\u0014\u0016-[:fg\u001a+gnY3e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000eK\u0002;\u0005g\n\u0001\u0007^3ti2+\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u001adunY1m%\u0006L7/Z:V].twn\u001e8MK\u0006$WM]#q_\u000eD\u0007fA\u001e\u0003t\u0005\u0019D/Z:u\u0019\u0016\fG-\u001a:SKBd\u0017nY1JM2{7-\u00197SC&\u001cXm\u001d(pi2+\u0017\rZ3s\r>\u0014\b+\u0019:uSRLwN\u001c\u0015\u0004y\tM\u0014!\u000e;fgRdU-\u00193feJ+\u0007\u000f\\5dC&3Gj\\2bYJ\u000b\u0017n]3t+:\\gn\\<o)>\u0004\u0018nY(s!\u0006\u0014H/\u001b;j_:D3!\u0010B:\u0003\u0011\"Xm\u001d;MSN$xJ\u001a4tKR4\u0015-\u001b7fI\u001e+G\u000fT3bI\u0016\u0014(+\u001a9mS\u000e\fG\u0003\u0002B\u0015\u0005\u001bDqAa4?\u0001\u0004\u0011\t.A\u0003feJ|'\u000f\u0005\u0003\u0003T\neWB\u0001Bk\u0015\u0011\u00119.!\u0017\u0002\u0011A\u0014x\u000e^8d_2LAAa7\u0003V\n1QI\u001d:peN\f1\u0006^3tiJ+\u0017\rZ+oG>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H*[:u\u001f\u001a47/\u001a;MCR,7\u000f\u001e\u0015\u0004\u007f\tM\u0014!\u000b;fgR\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJd\u0015n\u001d;PM\u001a\u001cX\r\u001e'bi\u0016\u001cH\u000fK\u0002A\u0005g\n\u0011\n^3ti6+G/\u00193bi\u0006\u0014V-];fgR|en\u00155be\u0016$G*[:uK:,'oV5uQ&s7m\u001c8tSN$XM\u001c;MSN$XM\\3sg\u0006\u001b'o\\:t\u0005J|7.\u001a:tQ\r\t%1O\u0001Li\u0016\u001cH/T3uC\u0012\fG/\u0019*fcV,7\u000f^(o\t&\u001cH/\u001b8di2K7\u000f^3oKJ<\u0016\u000e\u001e5J]\u000e|gn]5ti\u0016tG\u000fT5ti\u0016tWM]:BGJ|7o\u001d\"s_.,'o\u001d\u0015\u0004\u0005\nM\u0014!\t;fgR4U\r^2i%\u0016\fX/Z:u-f:\u0016\u000e\u001e5O_2{wmQ8oM&<\u0007fA\"\u0003t\u0005YB/Z:u\u0015>Lgn\u0012:pkB\u0004&o\u001c;pG>d7o\u0014:eKJ,\"A!\u000b)\u0007\u0011\u0013\u0019(\u0001\u001csK*,7\r\u001e&pS:<%o\\;q%\u0016\fX/Z:u/\",gn\u0015;bi&\u001cW*Z7cKJ\u001c\b.\u001b9O_R\u001cV\u000f\u001d9peR,G\rK\u0002F\u0005g\naG]3kK\u000e$8+\u001f8d\u000fJ|W\u000f\u001d*fcV,7\u000f^,iK:\u001cF/\u0019;jG6+WNY3sg\"L\u0007OT8u'V\u0004\bo\u001c:uK\u0012D3A\u0012B:\u0003Y\u0012XM[3di\"+\u0017M\u001d;cK\u0006$(+Z9vKN$x\u000b[3o'R\fG/[2NK6\u0014WM]:iSBtu\u000e^*vaB|'\u000f^3eQ\r9%1O\u0001:e\u0016TWm\u0019;PM\u001a\u001cX\r^\"p[6LGOU3rk\u0016\u001cHo\u00165f]N#\u0018\r^5d\u001b\u0016l'-\u001a:tQ&\u0004hj\u001c;TkB\u0004xN\u001d;fI\"\u001a\u0001Ja\u001d\u0002YU\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3XSRD\u0017J\\2p]NL7\u000f^3oi2K7\u000f^3oKJ\u001cHCAB\u0006!\u001dQ6QBB\t\u0007#I1aa\u0004\\\u0005\u0019!V\u000f\u001d7feA!11CB\f\u001b\t\u0019)BC\u0002i\u00033JAa!\u0007\u0004\u0016\taA*[:uK:,'OT1nK\u0006a3/\u001a8e\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti^KG\u000f[%oG>t7/[:uK:$H*[:uK:,'o\u001d\u000b\u0005\u0007?\u0019Y\u0003\u0005\u0003\u0004\"\r\u001dRBAB\u0012\u0015\u0011\u0019)#!\u0017\u0002\u0011I,\u0017/^3tiNLAa!\u000b\u0004$\t\u0001R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a\u0005\b\u0007[Q\u0005\u0019AB\t\u0003=\u0011X-];fgRd\u0015n\u001d;f]\u0016\u0014\u0018\u0001\b;fgR\u001cuN\\:v[\u0016\u0014H*[:u\u001f\u001a47/\u001a;MCR,7\u000f\u001e\u000b\u0005\u0005S\u0019\u0019\u0004C\u0004\u00046-\u0003\raa\u000e\u0002\u001d%\u001cx\u000e\\1uS>tG*\u001a<fYB!1\u0011EB\u001d\u0013\u0011\u0019Yda\t\u0003\u001d%\u001bx\u000e\\1uS>tG*\u001a<fY\u0006a2M]3bi\u0016<&/\u001b;f)btW*\u0019:lKJ\u001c(+Z9vKN$H\u0003BB!\u0007\u001f\u0002rAWB\u0007\u0007\u0007\u001aI\u0005\u0005\u0003\u0004\"\r\u0015\u0013\u0002BB$\u0007G\u0011ac\u0016:ji\u0016$\u0006P\\'be.,'o\u001d*fcV,7\u000f\u001e\t\u0004_\u000e-\u0013bAB'i\n9!+Z9vKN$\bbBB)\u0019\u0002\u000711K\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBB+\u00077\u001ay&\u0004\u0002\u0004X)!1\u0011\fB\u0005\u0003\u0011)H/\u001b7\n\t\ru3q\u000b\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0004b\r\rTBAA-\u0013\u0011\u0019)'!\u0017\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006a!-^5mIJ+\u0017/^3tiV!11NB:)\u0019\u0019ig!\"\u0004\u0018B9!l!\u0004\u0004p\r%\u0003\u0003BB9\u0007gb\u0001\u0001B\u0004\u0004v5\u0013\raa\u001e\u0003\u0003Q\u000bBa!\u001f\u0004\u0000A\u0019!la\u001f\n\u0007\ru4LA\u0004O_RD\u0017N\\4\u0011\t\r\u00052\u0011Q\u0005\u0005\u0007\u0007\u001b\u0019CA\bBEN$(/Y2u%\u0016\fX/Z:u\u0011\u001d\u00199)\u0014a\u0001\u0007\u0013\u000bqAY;jY\u0012,'\u000f\u0005\u0004\u0004\f\u000eE5q\u000e\b\u0005\u0007C\u0019i)\u0003\u0003\u0004\u0010\u000e\r\u0012aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\n\t\rM5Q\u0013\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\u0019yia\t\t\u0013\reU\n%AA\u0002\rE\u0011\u0001\u00047jgR,g.\u001a:OC6,\u0017A\u00062vS2$'+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\r}51U\u000b\u0003\u0007CSCa!\u0005\u0003^\u001191Q\u000f(C\u0002\r]\u0014\u0001\u0004:fC\u0012\u0014Vm\u001d9p]N,G\u0003CBU\u0007_\u001b9la/\u0011\t\r\u000521V\u0005\u0005\u0007[\u001b\u0019C\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\"9!\u0011K(A\u0002\rE\u0006\u0003\u0002Bj\u0007gKAa!.\u0003V\n9\u0011\t]5LKf\u001c\bbBB]\u001f\u0002\u00071qP\u0001\be\u0016\fX/Z:u\u0011\u001d\u0019il\u0014a\u0001\u0007\u007f\u000b\u0001cY1qiV\u0014X\r\u001a*fgB|gn]3\u0011\r\r\u00057qYBf\u001b\t\u0019\u0019M\u0003\u0003\u0004F\u0006\r\u0014\u0001C3bgflwnY6\n\t\r%71\u0019\u0002\b\u0007\u0006\u0004H/\u001e:f!\ry7QZ\u0005\u0004\u0007\u001f$(\u0001\u0003*fgB|gn]3\u0002%\u0015D\b/Z2u\u001d>$\u0006N]8ui2Lgn\u001a\u000b\u0003\u0007\u007f\u000bqc]3ukB\u0014\u0015m]5d\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0015\r\t%2\u0011\\Bv\u0011\u001d\u0019Y.\u0015a\u0001\u0007;\fQ\u0001^8qS\u000e\u0004Baa8\u0004h:!1\u0011]Br!\r\tymW\u0005\u0004\u0007K\\\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0010\r%(bABs7\"91Q^)A\u0002\u0005=\u0014!\u00048v[B\u000b'\u000f^5uS>t7\u000f")
public class KafkaApisTest {
    private final RequestChannel requestChannel = (RequestChannel)EasyMock.createNiceMock(RequestChannel.class);
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)EasyMock.createNiceMock(GroupCoordinator.class);
    private final AdminManager adminManager = (AdminManager)EasyMock.createNiceMock(AdminManager.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)EasyMock.createNiceMock(TransactionCoordinator.class);
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final MetadataCache metadataCache = new MetadataCache(this.brokerId());
    private final Option<Authorizer> authorizer = None$.MODULE$;
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)EasyMock.createNiceMock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)EasyMock.createNiceMock(ClientRequestQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), (Option)None$.MODULE$);
    private final FetchManager fetchManager = (FetchManager)EasyMock.createNiceMock(FetchManager.class);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final String clusterId;
    private final MockTime time = new MockTime();

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private AdminManager adminManager() {
        return this.adminManager;
    }

    private TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private FetchManager fetchManager() {
        return this.fetchManager;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private String clusterId() {
        return this.clusterId;
    }

    private MockTime time() {
        return this.time;
    }

    @After
    public void tearDown() {
        this.quotas().shutdown();
        this.metrics().close();
    }

    public KafkaApis createKafkaApis(ApiVersion interBrokerProtocolVersion) {
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        properties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerProtocolVersion.toString());
        properties.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), interBrokerProtocolVersion.toString());
        return new KafkaApis(this.requestChannel(), this.replicaManager(), this.adminManager(), this.groupCoordinator(), this.txnCoordinator(), this.controller(), this.zkClient(), this.brokerId(), new KafkaConfig((java.util.Map)properties), this.metadataCache(), this.metrics(), this.authorizer(), this.quotas(), this.fetchManager(), this.brokerTopicStats(), this.clusterId(), (Time)this.time(), null);
    }

    public ApiVersion createKafkaApis$default$1() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    @Test
    public void testOffsetCommitWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$1(-1, topic);
        this.checkInvalidPartition$1(1, topic);
    }

    @Test
    public void testTxnOffsetCommitWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$2(-1, topic);
        this.checkInvalidPartition$2(1, topic);
    }

    @Test
    public void testAddPartitionsToTxnWithInvalidPartition() {
        String topic = "topic";
        this.setupBasicMetadataCache(topic, 1);
        this.checkInvalidPartition$3(-1, topic);
        this.checkInvalidPartition$3(1, topic);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddOffsetToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddOffsetsToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddPartitionsToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleTxnOffsetCommitRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleEndTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleEndTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleWriteTxnMarkersRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleWriteTxnMarkersRequest(null);
    }

    @Test
    public void shouldRespondWithUnsupportedForMessageFormatOnHandleWriteTxnMarkersWhenMagicLowerThanRequired() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnknownTopicWhenPartitionIsNotHosted() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)None$.MODULE$);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnsupportedMessageFormatForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, responseCallback, tp2){
            private final Capture responseCallback$1;
            private final TopicPartition tp2$1;

            public void answer() {
                ((Function1)this.responseCallback$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$1), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.responseCallback$1 = responseCallback$1;
                this.tp2$1 = tp2$1;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldRespondWithUnknownTopicOrPartitionForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)None$.MODULE$);
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, responseCallback, tp2){
            private final Capture responseCallback$2;
            private final TopicPartition tp2$2;

            public void answer() {
                ((Function1)this.responseCallback$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$2), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.responseCallback$2 = responseCallback$2;
                this.tp2$2 = tp2$2;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldAppendToLogOnWriteTxnMarkersWhenCorrectMagicVersion() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        RequestChannel.Request request = (RequestChannel.Request)this.createWriteTxnMarkersRequest(Arrays.asList((Object[])new TopicPartition[]{topicPartition}))._2();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesFencedLeaderEpoch() {
        this.testListOffsetFailedGetLeaderReplica(Errors.FENCED_LEADER_EPOCH);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesUnknownLeaderEpoch() {
        this.testListOffsetFailedGetLeaderReplica(Errors.UNKNOWN_LEADER_EPOCH);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesNotLeaderForPartition() {
        this.testListOffsetFailedGetLeaderReplica(Errors.NOT_LEADER_FOR_PARTITION);
    }

    @Test
    public void testLeaderReplicaIfLocalRaisesUnknownTopicOrPartition() {
        this.testListOffsetFailedGetLeaderReplica(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    private void testListOffsetFailedGetLeaderReplica(Errors error) {
        TopicPartition tp = new TopicPartition("foo", 0);
        IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        Optional<Integer> currentLeaderEpoch = Optional.of(Predef$.MODULE$.int2Integer(15));
        EasyMock.expect((Object)this.replicaManager().fetchOffsetForTimestamp((TopicPartition)EasyMock.eq((Object)tp), EasyMock.eq((long)-2L), (Option)EasyMock.eq((Object)new Some((Object)isolationLevel)), (Optional)EasyMock.eq(currentLeaderEpoch), EasyMock.eq((boolean)true))).andThrow((Throwable)error.exception());
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        Map targetTimes = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ListOffsetRequest.PartitionData(-2L, currentLeaderEpoch))}));
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(targetTimes).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)error, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    @Test
    public void testReadUncommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_COMMITTED);
    }

    @Test
    public void testMetadataRequestOnSharedListenerWithInconsistentListenersAcrossBrokers() {
        ListenerName plaintextListener;
        Tuple2<ListenerName, ListenerName> tuple2 = this.updateMetadataCacheWithInconsistentListeners();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = plaintextListener = (ListenerName)tuple2._1();
        ListenerName plaintextListener2 = listenerName;
        MetadataResponse response = this.sendMetadataRequestWithInconsistentListeners(plaintextListener2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testMetadataRequestOnDistinctListenerWithInconsistentListenersAcrossBrokers() {
        ListenerName anotherListener;
        Tuple2<ListenerName, ListenerName> tuple2 = this.updateMetadataCacheWithInconsistentListeners();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = anotherListener = (ListenerName)tuple2._2();
        ListenerName anotherListener2 = listenerName;
        MetadataResponse response = this.sendMetadataRequestWithInconsistentListeners(anotherListener2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testFetchRequestV9WithNoLogConfig() {
        TopicPartition tp = new TopicPartition("foo", 0);
        this.setupBasicMetadataCache(tp.topic(), 1);
        int hw = 3;
        int timestamp = 1000;
        EasyMock.expect((Object)this.replicaManager().getLogConfig((TopicPartition)EasyMock.eq((Object)tp))).andReturn((Object)None$.MODULE$);
        this.replicaManager().fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyBoolean(), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (IsolationLevel)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, timestamp, tp, hw){
            private final int timestamp$1;
            private final TopicPartition tp$1;
            private final int hw$1;

            public void answer() {
                Function1 callback = (Function1)EasyMock.getCurrentArguments()[7];
                MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)this.timestamp$1, "foo".getBytes(StandardCharsets.UTF_8))});
                callback.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp$1), (Object)new FetchPartitionData(Errors.NONE, (long)this.hw$1, 0L, (Records)records, (Option)None$.MODULE$, (Option)None$.MODULE$))})));
            }
            {
                this.timestamp$1 = timestamp$1;
                this.tp$1 = tp$1;
                this.hw$1 = hw$1;
            }
        });
        java.util.Map fetchData = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchRequest.PartitionData(0L, 0L, 1000, Optional.empty()))}))).asJava();
        FetchMetadata fetchMetadata = new FetchMetadata(0, 0);
        FullFetchContext fetchContext = new FullFetchContext((Time)this.time(), new FetchSessionCache(1000, 100L), fetchMetadata, fetchData, false);
        EasyMock.expect((Object)this.fetchManager().newContext((FetchMetadata)EasyMock.anyObject(), (java.util.Map)EasyMock.anyObject(), (java.util.List)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)fetchContext);
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.clientQuotaManager().maybeRecordAndGetThrottleTimeMs((RequestChannel.Request)EasyMock.anyObject(), EasyMock.anyDouble(), EasyMock.anyLong()))).andReturn((Object)BoxesRunTime.boxToInteger((int)0));
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.requestChannel(), this.fetchManager()});
        FetchRequest.Builder builder = new FetchRequest.Builder(9, 9, -1, 100, 0, fetchData);
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        FetchRequest fetchRequest = (FetchRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)fetchRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        FetchRequest fetchRequest2 = (FetchRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleFetchRequest(request2);
        FetchResponse response = (FetchResponse)this.readResponse(ApiKeys.FETCH, (AbstractRequest)fetchRequest2, capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        FetchResponse.PartitionData partitionData = (FetchResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertEquals((long)hw, (long)partitionData.highWatermark);
        Assert.assertEquals((long)-1L, (long)partitionData.lastStableOffset);
        Assert.assertEquals((long)0L, (long)partitionData.logStartOffset);
        Assert.assertEquals((long)timestamp, (long)((RecordBatch)((MemoryRecords)partitionData.records).batches().iterator().next()).maxTimestamp());
        Assert.assertNull((Object)partitionData.abortedTransactions);
    }

    @Test
    public void testJoinGroupProtocolsOrder() {
        .colon.colon protocols = new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("first").setMetadata("first".getBytes()), (List)new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName("second").setMetadata("second".getBytes()), (List)Nil$.MODULE$));
        this.groupCoordinator().handleJoinGroup(EasyMock.anyString(), EasyMock.anyString(), (Option)EasyMock.anyObject(Option.class), EasyMock.anyBoolean(), EasyMock.anyString(), EasyMock.anyString(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyString(), (List)EasyMock.eq((Object)protocols.map((Function1 & Serializable & scala.Serializable)protocol -> new Tuple2((Object)protocol.name(), (Object)protocol.metadata()), List$.MODULE$.canBuildFrom())), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.createKafkaApis(this.createKafkaApis$default$1()).handleJoinGroupRequest((RequestChannel.Request)this.buildRequest((AbstractRequest.Builder)new JoinGroupRequest.Builder(new JoinGroupRequestData().setGroupId("test").setMemberId("test").setProtocolType("consumer").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection((Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(protocols.iterator()).asJava()))), this.buildRequest$default$2())._2());
        EasyMock.replay((Object[])new Object[]{this.groupCoordinator()});
    }

    @Test
    public void rejectJoinGroupRequestWhenStaticMembershipNotSupported() {
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new JoinGroupRequest.Builder(new JoinGroupRequestData().setGroupId("test").setMemberId("test").setGroupInstanceId("instanceId").setProtocolType("consumer").setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection())), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        JoinGroupRequest joinGroupRequest = (JoinGroupRequest)tuple2._1();
        RequestChannel.Request requestChannelRequest = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)joinGroupRequest, (Object)requestChannelRequest);
        Tuple2 tuple23 = tuple22;
        JoinGroupRequest joinGroupRequest2 = (JoinGroupRequest)tuple23._1();
        RequestChannel.Request requestChannelRequest2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis((ApiVersion)KAFKA_2_2_IV1$.MODULE$).handleJoinGroupRequest(requestChannelRequest2);
        JoinGroupResponse response = (JoinGroupResponse)this.readResponse(ApiKeys.JOIN_GROUP, (AbstractRequest)joinGroupRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)response.error());
        EasyMock.replay((Object[])new Object[]{this.groupCoordinator()});
    }

    @Test
    public void rejectSyncGroupRequestWhenStaticMembershipNotSupported() {
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new SyncGroupRequest.Builder(new SyncGroupRequestData().setGroupId("test").setMemberId("test").setGroupInstanceId("instanceId").setGenerationId(1)), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SyncGroupRequest syncGroupRequest = (SyncGroupRequest)tuple2._1();
        RequestChannel.Request requestChannelRequest = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)syncGroupRequest, (Object)requestChannelRequest);
        Tuple2 tuple23 = tuple22;
        SyncGroupRequest syncGroupRequest2 = (SyncGroupRequest)tuple23._1();
        RequestChannel.Request requestChannelRequest2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis((ApiVersion)KAFKA_2_2_IV1$.MODULE$).handleSyncGroupRequest(requestChannelRequest2);
        SyncGroupResponse response = (SyncGroupResponse)this.readResponse(ApiKeys.SYNC_GROUP, (AbstractRequest)syncGroupRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)response.error());
        EasyMock.replay((Object[])new Object[]{this.groupCoordinator()});
    }

    @Test
    public void rejectHeartbeatRequestWhenStaticMembershipNotSupported() {
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new HeartbeatRequest.Builder(new HeartbeatRequestData().setGroupId("test").setMemberId("test").setGroupInstanceId("instanceId").setGenerationId(1)), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HeartbeatRequest heartbeatRequest = (HeartbeatRequest)tuple2._1();
        RequestChannel.Request requestChannelRequest = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)heartbeatRequest, (Object)requestChannelRequest);
        Tuple2 tuple23 = tuple22;
        HeartbeatRequest heartbeatRequest2 = (HeartbeatRequest)tuple23._1();
        RequestChannel.Request requestChannelRequest2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis((ApiVersion)KAFKA_2_2_IV1$.MODULE$).handleHeartbeatRequest(requestChannelRequest2);
        HeartbeatResponse response = (HeartbeatResponse)this.readResponse(ApiKeys.HEARTBEAT, (AbstractRequest)heartbeatRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)response.error());
        EasyMock.replay((Object[])new Object[]{this.groupCoordinator()});
    }

    @Test
    public void rejectOffsetCommitRequestWhenStaticMembershipNotSupported() {
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId("test").setMemberId("test").setGroupInstanceId("instanceId").setGenerationId(100).setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName("test").setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(0).setCommittedOffset(100L).setCommittedLeaderEpoch(-1).setCommittedMetadata("")))))), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)tuple2._1();
        RequestChannel.Request requestChannelRequest = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)offsetCommitRequest, (Object)requestChannelRequest);
        Tuple2 tuple23 = tuple22;
        OffsetCommitRequest offsetCommitRequest2 = (OffsetCommitRequest)tuple23._1();
        RequestChannel.Request requestChannelRequest2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis((ApiVersion)KAFKA_2_2_IV1$.MODULE$).handleOffsetCommitRequest(requestChannelRequest2);
        java.util.List<OffsetCommitResponseData.OffsetCommitResponseTopic> expectedTopicErrors = Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponseTopic().setName("test").setPartitions(Collections.singletonList(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(0).setErrorCode(Errors.UNSUPPORTED_VERSION.code()))));
        OffsetCommitResponse response = (OffsetCommitResponse)this.readResponse(ApiKeys.OFFSET_COMMIT, (AbstractRequest)offsetCommitRequest2, capturedResponse);
        Assert.assertEquals(expectedTopicErrors, (Object)response.data().topics());
        EasyMock.replay((Object[])new Object[]{this.groupCoordinator()});
    }

    private Tuple2<ListenerName, ListenerName> updateMetadataCacheWithInconsistentListeners() {
        ListenerName plaintextListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName anotherListener = new ListenerName("LISTENER2");
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker0", 9092, SecurityProtocol.PLAINTEXT, plaintextListener), new UpdateMetadataRequest.EndPoint("broker0", 9093, SecurityProtocol.PLAINTEXT, anotherListener)}))).asJava(), "rack"), new UpdateMetadataRequest.Broker(1, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker1", 9092, SecurityProtocol.PLAINTEXT, plaintextListener)}))).asJava(), "rack")}));
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        this.metadataCache().updateMetadata(0, updateMetadataRequest);
        return new Tuple2((Object)plaintextListener, (Object)anotherListener);
    }

    private MetadataResponse sendMetadataRequestWithInconsistentListeners(ListenerName requestListener) {
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)MetadataRequest.Builder.allTopics(), requestListener);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MetadataRequest metadataRequest = (MetadataRequest)tuple2._1();
        RequestChannel.Request requestChannelRequest = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metadataRequest, (Object)requestChannelRequest);
        Tuple2 tuple23 = tuple22;
        MetadataRequest metadataRequest2 = (MetadataRequest)tuple23._1();
        RequestChannel.Request requestChannelRequest2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleTopicMetadataRequest(requestChannelRequest2);
        return (MetadataResponse)this.readResponse(ApiKeys.METADATA, (AbstractRequest)metadataRequest2, capturedResponse);
    }

    private void testConsumerListOffsetLatest(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        long latestOffset = 15L;
        Optional currentLeaderEpoch = Optional.empty();
        EasyMock.expect((Object)this.replicaManager().fetchOffsetForTimestamp((TopicPartition)EasyMock.eq((Object)tp), EasyMock.eq((long)-1L), (Option)EasyMock.eq((Object)new Some((Object)isolationLevel)), (Optional)EasyMock.eq(currentLeaderEpoch), EasyMock.eq((boolean)true))).andReturn((Object)new Some((Object)new FileRecords.TimestampAndOffset(-1L, latestOffset, currentLeaderEpoch)));
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        Map targetTimes = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new ListOffsetRequest.PartitionData(-1L, currentLeaderEpoch))}));
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(targetTimes).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)latestOffset), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    private Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> createWriteTxnMarkersRequest(java.util.List<TopicPartition> partitions) {
        WriteTxnMarkersRequest.Builder requestBuilder = new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(1L, (short)1, 0, TransactionResult.COMMIT, partitions)}));
        return this.buildRequest((AbstractRequest.Builder)requestBuilder, this.buildRequest$default$2());
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics()));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private AbstractResponse readResponse(ApiKeys api, AbstractRequest request, Capture<RequestChannel.Response> capturedResponse) {
        RequestChannel.Response response = (RequestChannel.Response)capturedResponse.getValue();
        Assert.assertTrue((String)new StringBuilder(26).append("Unexpected response type: ").append(response.getClass()).toString(), (boolean)(response instanceof RequestChannel.SendResponse));
        RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)response;
        Send send = sendResponse.responseSend();
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        channel.buffer().getInt();
        ResponseHeader.parse((ByteBuffer)channel.buffer());
        Struct struct = api.responseSchema(request.version()).read(channel.buffer());
        return AbstractResponse.parseResponse((ApiKeys)api, (Struct)struct, (short)request.version());
    }

    /*
     * WARNING - void declaration
     */
    private Capture<RequestChannel.Response> expectNoThrottling() {
        void var1_1;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.clientRequestQuotaManager().maybeRecordAndGetThrottleTimeMs((RequestChannel.Request)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToInteger((int)0));
        this.clientRequestQuotaManager().throttle((RequestChannel.Request)EasyMock.anyObject(), EasyMock.eq((int)0), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        Capture capturedResponse = EasyMock.newCapture();
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        return var1_1;
    }

    private void setupBasicMetadataCache(String topic, int numPartitions) {
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)0), (List)Nil$.MODULE$)).asJava();
        UpdateMetadataRequest.PartitionState partitionState = new UpdateMetadataRequest.PartitionState(1, 0, 1, replicas, 0, replicas, Collections.emptyList());
        ListenerName plaintextListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        UpdateMetadataRequest.Broker broker = new UpdateMetadataRequest.Broker(0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker0", 9092, SecurityProtocol.PLAINTEXT, plaintextListener)}))).asJava(), "rack");
        scala.collection.immutable.Map partitions = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable & scala.Serializable)x$18 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)x$18))), (Object)partitionState), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitions).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{broker}))).asJava()).build();
        this.metadataCache().updateMetadata(0, updateMetadataRequest);
    }

    private final void checkInvalidPartition$1(int invalidPartitionId, String topic$1) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId("groupId").setTopics(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topic$1).setPartitions(Collections.singletonList(new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(invalidPartitionId).setCommittedOffset(15L).setCommittedLeaderEpoch(-1).setCommittedMetadata("")))))), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        OffsetCommitRequest offsetCommitRequest = (OffsetCommitRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)offsetCommitRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        OffsetCommitRequest offsetCommitRequest2 = (OffsetCommitRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleOffsetCommitRequest(request2);
        OffsetCommitResponse response = (OffsetCommitResponse)this.readResponse(ApiKeys.OFFSET_COMMIT, (AbstractRequest)offsetCommitRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)Errors.forCode((short)((OffsetCommitResponseData.OffsetCommitResponsePartition)((OffsetCommitResponseData.OffsetCommitResponseTopic)response.data().topics().get(0)).partitions().get(0)).errorCode()));
    }

    private final void checkInvalidPartition$2(int invalidPartitionId, String topic$2) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        TopicPartition invalidTopicPartition = new TopicPartition(topic$2, invalidPartitionId);
        TxnOffsetCommitRequest.CommittedOffset partitionOffsetCommitData = new TxnOffsetCommitRequest.CommittedOffset(15L, "", Optional.empty());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new TxnOffsetCommitRequest.Builder("txnlId", "groupId", 15L, (short)0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)invalidTopicPartition), (Object)partitionOffsetCommitData)}))).asJava()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TxnOffsetCommitRequest offsetCommitRequest = (TxnOffsetCommitRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)offsetCommitRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        TxnOffsetCommitRequest offsetCommitRequest2 = (TxnOffsetCommitRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleTxnOffsetCommitRequest(request2);
        TxnOffsetCommitResponse response = (TxnOffsetCommitResponse)this.readResponse(ApiKeys.TXN_OFFSET_COMMIT, (AbstractRequest)offsetCommitRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(invalidTopicPartition));
    }

    private final void checkInvalidPartition$3(int invalidPartitionId, String topic$3) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        TopicPartition invalidTopicPartition = new TopicPartition(topic$3, invalidPartitionId);
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)new AddPartitionsToTxnRequest.Builder("txnlId", 15L, (short)0, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)invalidTopicPartition, (List)Nil$.MODULE$)).asJava()), this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        AddPartitionsToTxnRequest addPartitionsToTxnRequest = (AddPartitionsToTxnRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)addPartitionsToTxnRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        AddPartitionsToTxnRequest addPartitionsToTxnRequest2 = (AddPartitionsToTxnRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        Capture<RequestChannel.Response> capturedResponse = this.expectNoThrottling();
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleAddPartitionToTxnRequest(request2);
        AddPartitionsToTxnResponse response = (AddPartitionsToTxnResponse)this.readResponse(ApiKeys.ADD_PARTITIONS_TO_TXN, (AbstractRequest)addPartitionsToTxnRequest2, capturedResponse);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(invalidTopicPartition));
    }

    public KafkaApisTest() {
        this.brokerId = 1;
        this.clusterId = "clusterId";
    }
}

